/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;

public class ResidueTermini
implements Serializable {
    public int state;
    public String lBound;
    public String uBound;

    public ResidueTermini(int state, String lBound, String uBound) {
        if (lBound.compareTo(uBound) > 0) {
            throw new RuntimeException("ERROR: lBound: " + lBound + " must be <= uBound: " + uBound);
        }
        this.state = state;
        this.lBound = lBound;
        this.uBound = uBound;
    }

    public boolean contains(Residue res) {
        return this.contains(res.getPDBResNumber());
    }

    public boolean contains(String pdbResNum) {
        return ResidueTermini.compareResNums(pdbResNum, this.lBound) > -1 && ResidueTermini.compareResNums(pdbResNum, this.uBound) < 1;
    }

    public static int compareResNums(String resNum1, String resNum2) {
        Character chainID1;
        int compareChainID;
        if (ResidueTermini.hasChainID(resNum1) && ResidueTermini.hasChainID(resNum2) && (compareChainID = (chainID1 = Character.valueOf(resNum1.charAt(0))).compareTo(Character.valueOf(resNum2.charAt(0)))) != 0) {
            return compareChainID;
        }
        int compareNumbers = ResidueTermini.extractPureNumber(resNum1).compareTo(ResidueTermini.extractPureNumber(resNum2));
        if (compareNumbers != 0) {
            return compareNumbers;
        }
        Character lastChar1 = Character.valueOf(resNum1.charAt(resNum1.length() - 1));
        Character lastChar2 = Character.valueOf(resNum2.charAt(resNum2.length() - 1));
        if (Character.isAlphabetic(lastChar1.charValue())) {
            return Character.isAlphabetic(lastChar2.charValue()) ? lastChar1.compareTo(lastChar2) : 1;
        }
        return Character.isAlphabetic(lastChar2.charValue()) ? -1 : 0;
    }

    private static boolean hasChainID(String resNum) {
        return Character.isAlphabetic(resNum.charAt(0));
    }

    private static Integer extractPureNumber(String resNum) {
        String fullResNum = resNum;
        if (ResidueTermini.hasChainID(resNum)) {
            resNum = resNum.substring(1);
        }
        if (Character.isAlphabetic(resNum.charAt(resNum.length() - 1))) {
            resNum = resNum.substring(0, resNum.length() - 1);
        }
        try {
            return Integer.parseInt(resNum);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("ERROR invalid residue number: " + fullResNum);
        }
    }

    public String[] toStringArray() {
        String[] ans = new String[]{this.lBound, this.uBound};
        return ans;
    }
}

