/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.multistatekstar.MSKStarNode;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.multistatekstar.ResidueOrder;
import java.util.ArrayList;

public class ResidueOrderStaticSequential
implements ResidueOrder {
    protected ArrayList<ArrayList<ArrayList<ArrayList<ResidueOrder.AAScore>>>> scores = null;

    public ResidueOrderStaticSequential(MSSearchProblem[][] objFcnSearch) {
        this.allocate(objFcnSearch);
        this.init(objFcnSearch);
    }

    private void allocate(MSSearchProblem[][] objFcnSearch) {
        this.scores = new ArrayList();
        for (int state = 0; state < objFcnSearch.length; ++state) {
            this.scores.add(new ArrayList());
            for (int subState = 0; subState < objFcnSearch[state].length; ++subState) {
                this.scores.get(state).add(new ArrayList());
                for (int residuePos = 0; residuePos < objFcnSearch[state][subState].settings.AATypeOptions.size(); ++residuePos) {
                    this.scores.get(state).get(subState).add(new ArrayList());
                }
                this.scores.get(state).get(subState).trimToSize();
            }
            this.scores.get(state).trimToSize();
        }
        this.scores.trimToSize();
    }

    protected void init(MSSearchProblem[][] objFcnSearch) {
        for (int state = 0; state < this.scores.size(); ++state) {
            int score = -1;
            for (int subState = 0; subState < this.scores.get(state).size(); ++subState) {
                ArrayList<ArrayList<String>> AATypeOptions = objFcnSearch[state][subState].settings.AATypeOptions;
                for (int residuePos = 0; residuePos < AATypeOptions.size(); ++residuePos) {
                    ArrayList<String> AATypes = AATypeOptions.get(residuePos);
                    for (int AATypePos = 0; AATypePos < AATypes.size(); ++AATypePos) {
                        this.scores.get(state).get(subState).get(residuePos).add(new ResidueOrder.AAScore(residuePos, AATypePos, ++score));
                    }
                }
            }
        }
    }

    @Override
    public ArrayList<ArrayList<ArrayList<ResidueOrder.AAScore>>> getNextAssignments(MSSearchProblem[][] objFcnSearch, int numMaxMut) {
        ArrayList<ArrayList<ArrayList<ResidueOrder.AAScore>>> ans = new ArrayList<ArrayList<ArrayList<ResidueOrder.AAScore>>>();
        int state = 0;
        int numSubStates = objFcnSearch[state].length;
        MSSearchProblem bound = objFcnSearch[state][numSubStates - 1];
        if (bound.getNumAssignedPos() == 0) {
            ArrayList<ArrayList<ResidueOrder.AAScore>> boundAssignments = this.getBoundStateAssignments(state, objFcnSearch[state], 0, numMaxMut);
            for (int subState = 0; subState < numSubStates - 1; ++subState) {
                MSSearchProblem unbound = objFcnSearch[state][subState];
                ans.add(this.getUnboundStateAssignments(bound, boundAssignments, unbound));
            }
            ans.add(boundAssignments);
        } else {
            ArrayList<Integer> splitPos = bound.getPosNums(false);
            if (splitPos.size() == 0) {
                throw new RuntimeException("ERROR: there are no positions to split");
            }
        }
        ans.trimToSize();
        return ans;
    }

    protected ArrayList<ArrayList<ResidueOrder.AAScore>> nextSplitPosAssignments(int splitPos) {
        return null;
    }

    private ArrayList<ArrayList<ResidueOrder.AAScore>> getUnboundStateAssignments(MSSearchProblem bound, ArrayList<ArrayList<ResidueOrder.AAScore>> assignments, MSSearchProblem unbound) {
        ArrayList<ArrayList<ResidueOrder.AAScore>> ans = new ArrayList<ArrayList<ResidueOrder.AAScore>>();
        for (ArrayList<ResidueOrder.AAScore> assignment : assignments) {
            ans.add(new ArrayList());
            for (ResidueOrder.AAScore aa : assignment) {
                int unboundPos = unbound.flexRes.indexOf(bound.flexRes.get(aa.residuePos));
                if (unboundPos == -1) continue;
                ans.get(ans.size() - 1).add(new ResidueOrder.AAScore(unboundPos, aa.AATypePos, -1.0));
            }
            ans.get(ans.size() - 1).trimToSize();
        }
        ans.trimToSize();
        return ans;
    }

    private ArrayList<ArrayList<ResidueOrder.AAScore>> getBoundStateAssignments(int state, MSSearchProblem[] search2, int splitPos, int numMaxMut) {
        ArrayList<Integer> complexPos = new ArrayList<Integer>();
        MSSearchProblem complex = search2[search2.length - 1];
        for (int subState = 0; subState < search2.length - 1; ++subState) {
            complexPos.add(complex.flexRes.indexOf(search2[subState].flexRes.get(splitPos)));
        }
        complexPos.trimToSize();
        ArrayList<ArrayList<ResidueOrder.AAScore>> ans = new ArrayList<ArrayList<ResidueOrder.AAScore>>();
        String[] wt = MSKStarNode.WT_SEQS.get(state);
        String[] buf = new String[wt.length];
        this.getBoundStateAssignmentsHelper(complex.allowedAAs, ans, complexPos, wt, buf, 0, 0, numMaxMut);
        ans.trimToSize();
        return ans;
    }

    private void getBoundStateAssignmentsHelper(ArrayList<ArrayList<String>> AATypeOptions, ArrayList<ArrayList<ResidueOrder.AAScore>> output, ArrayList<Integer> splitPos, String[] wt, String[] buf, int depth, int numMut, int numMaxMut) {
        if (depth == splitPos.size()) {
            ArrayList<ResidueOrder.AAScore> assignment = new ArrayList<ResidueOrder.AAScore>();
            for (int i = 0; i < depth; ++i) {
                int residuePos = splitPos.get(i);
                int AATypePos = AATypeOptions.get(residuePos).indexOf(buf[i]);
                if (AATypePos == -1) {
                    throw new RuntimeException("ERROR: AATypeOptions must contain AA");
                }
                assignment.add(new ResidueOrder.AAScore(residuePos, AATypePos, -1.0));
            }
            assignment.trimToSize();
            output.add(assignment);
            return;
        }
        int residuePos = splitPos.get(depth);
        for (int AATypePos = 0; AATypePos < AATypeOptions.get(residuePos).size(); ++AATypePos) {
            int count;
            buf[depth] = AATypeOptions.get(residuePos).get(AATypePos);
            int n = count = buf[depth].equalsIgnoreCase(wt[residuePos]) ? numMut : numMut + 1;
            if (count > numMaxMut) continue;
            this.getBoundStateAssignmentsHelper(AATypeOptions, output, splitPos, wt, buf, depth + 1, count, numMaxMut);
        }
    }
}

