/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.multistatekstar.KStarScore;
import edu.duke.cs.osprey.multistatekstar.LMB;
import edu.duke.cs.osprey.multistatekstar.MSConfigFileParser;
import edu.duke.cs.osprey.multistatekstar.MSKStarFactory;
import edu.duke.cs.osprey.multistatekstar.MSKStarNode;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.multistatekstar.MSSearchSettings;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;

public class MSKStarTree {
    int numTreeLevels;
    LMB objFcn;
    LMB[] msConstr;
    LMB[][] sConstr;
    ArrayList<ArrayList<ArrayList<Integer>>> mutable2StateResNums;
    ArrayList<ArrayList<ArrayList<ArrayList<String>>>> AATypeOptions;
    int numMaxMut;
    ArrayList<String[]> wtSeqs;
    int numStates;
    SearchProblem[][] searchCont;
    SearchProblem[][] searchDisc;
    GMECConfEnergyCalculator.Async[][] ecalcsCont;
    GMECConfEnergyCalculator.Async[][] ecalcsDisc;
    ParamSet msParams;
    MSConfigFileParser[] cfps;
    PriorityQueue<MSKStarNode> pq;
    int numSeqsWanted;
    int numSeqsReturned;
    int numExpanded;
    int numPruned;

    public MSKStarTree(int numTreeLevels, int numStates, int numMaxMut, int numSeqsWanted, LMB objFcn, LMB[] msConstr, LMB[][] sConstr, ArrayList<ArrayList<ArrayList<Integer>>> mutable2StateResNums, ArrayList<ArrayList<ArrayList<ArrayList<String>>>> AATypeOptions, ArrayList<String[]> wtSeqs, SearchProblem[][] searchCont, SearchProblem[][] searchDisc, GMECConfEnergyCalculator.Async[][] ecalcsCont, GMECConfEnergyCalculator.Async[][] ecalcsDisc, ParamSet msParams, MSConfigFileParser[] cfps) {
        this.numTreeLevels = numTreeLevels;
        this.objFcn = objFcn;
        this.msConstr = msConstr;
        this.sConstr = sConstr;
        this.AATypeOptions = AATypeOptions;
        this.numMaxMut = numMaxMut;
        this.numSeqsWanted = numSeqsWanted;
        this.wtSeqs = wtSeqs;
        this.numStates = numStates;
        this.searchCont = searchCont;
        this.searchDisc = searchDisc;
        this.ecalcsCont = ecalcsCont;
        this.ecalcsDisc = ecalcsDisc;
        this.mutable2StateResNums = mutable2StateResNums;
        this.cfps = cfps;
        this.msParams = msParams;
        this.numExpanded = 0;
        this.numPruned = 0;
        this.numSeqsReturned = 0;
        this.pq = null;
    }

    private void initQueue(MSKStarNode node) {
        this.pq = new PriorityQueue<MSKStarNode>(1024, new Comparator<MSKStarNode>(this){

            @Override
            public int compare(MSKStarNode m1, MSKStarNode m2) {
                return m1.getScore().compareTo(m2.getScore()) < 0 ? -1 : 1;
            }
        });
        this.pq.add(node);
    }

    private boolean canPrune(MSKStarNode curNode) {
        if (!curNode.constrSatisfied()) {
            return true;
        }
        for (LMB lmb : this.msConstr) {
            if (lmb.eval(curNode.getStateKStarScores(lmb)).compareTo(BigDecimal.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<MSKStarNode> getChildren(MSKStarNode curNode) {
        ArrayList<MSKStarNode> ans = new ArrayList<MSKStarNode>();
        if (!curNode.isFullyAssigned()) {
            ans.addAll(curNode.split(this.msParams));
        }
        ans.trimToSize();
        return ans;
    }

    private MSKStarNode getRootNode() {
        MSKStarNode.OBJ_FUNC = this.objFcn;
        MSKStarNode.WT_SEQS = this.wtSeqs;
        MSKStarNode.NUM_MAX_MUT = this.numMaxMut;
        KStarScore[] kssLB = new KStarScore[this.numStates];
        KStarScore[] kssUB = new KStarScore[this.numStates];
        KStarScore.KStarScoreType[] types2 = null;
        for (int state = 0; state < this.numStates; ++state) {
            boolean doMinimize = this.cfps[state].params.getBool("DOMINIMIZE");
            types2 = doMinimize ? new KStarScore.KStarScoreType[]{KStarScore.KStarScoreType.MinimizedLowerBound, KStarScore.KStarScoreType.MinimizedUpperBound} : new KStarScore.KStarScoreType[]{KStarScore.KStarScoreType.DiscreteLowerBound, KStarScore.KStarScoreType.DiscreteUpperBound};
            KStarScore[] scores = this.getRootKStarScores(state, types2);
            kssLB[state] = scores[0];
            kssUB[state] = scores[1];
        }
        MSKStarNode ans = new MSKStarNode(kssLB, kssUB);
        ans.setScore(this.objFcn);
        return ans;
    }

    private KStarScore[] getRootKStarScores(int state, KStarScore.KStarScoreType[] types2) {
        boolean doMinimize = this.cfps[state].params.getBool("DOMINIMIZE");
        KStarScore[] ans = new KStarScore[types2.length];
        ParamSet sParams = this.cfps[state].params;
        int numPartFuncs = sParams.getInt("NUMUBSTATES") + 1;
        for (int i = 0; i < types2.length; ++i) {
            KStarScore.KStarScoreType type = types2[i];
            if (type == null) continue;
            MSSearchProblem[] seqSearchCont = doMinimize ? new MSSearchProblem[numPartFuncs] : null;
            MSSearchProblem[] seqSearchDisc = new MSSearchProblem[numPartFuncs];
            for (int subState = 0; subState < numPartFuncs; ++subState) {
                MSSearchSettings spSet = new MSSearchSettings();
                spSet.AATypeOptions = this.AATypeOptions.get(state).get(subState);
                ArrayList<String> mutRes = new ArrayList<String>();
                for (int j = 0; j < this.mutable2StateResNums.get(state).get(subState).size(); ++j) {
                    mutRes.add("-1");
                }
                mutRes.trimToSize();
                spSet.mutRes = mutRes;
                spSet.stericThreshold = sParams.getDouble("STERICTHRESH");
                spSet.pruningWindow = sParams.getDouble("IVAL") + sParams.getDouble("EW");
                if (doMinimize) {
                    seqSearchCont[subState] = new MSSearchProblem(this.searchCont[state][subState], spSet);
                }
                seqSearchDisc[subState] = new MSSearchProblem(this.searchDisc[state][subState], (MSSearchSettings)ObjectIO.deepCopy(spSet));
            }
            ans[i] = MSKStarFactory.makeKStarScore(this.msParams, state, this.cfps[state], this.sConstr[state], seqSearchCont, seqSearchDisc, this.ecalcsCont[state], this.ecalcsDisc[state], type);
        }
        return ans;
    }

    public String nextSeq() {
        if (this.pq == null) {
            this.initQueue(this.getRootNode());
        }
        while (true) {
            MSKStarNode curNode;
            if ((curNode = this.pq.poll()) == null) {
                System.out.println("Multi-State K* tree empty...returning empty signal");
                return null;
            }
            if (this.canPrune(curNode)) {
                ++this.numPruned;
                continue;
            }
            if (curNode.isLeafNode()) {
                return curNode.toString();
            }
            ArrayList<MSKStarNode> children = this.getChildren(curNode);
            ++this.numExpanded;
            this.pq.addAll(children);
        }
    }
}

