/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.bbfree.BBFreeDOF;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.ParameterizedMoleculeCopy;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.EllipseCoordDOF;
import edu.duke.cs.osprey.dof.FreeDihedral;
import edu.duke.cs.osprey.dof.ResidueTypeDOF;
import edu.duke.cs.osprey.dof.StrandRotation;
import edu.duke.cs.osprey.dof.StrandTranslation;
import edu.duke.cs.osprey.dof.deeper.perts.Backrub;
import edu.duke.cs.osprey.dof.deeper.perts.Shear;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import edu.duke.cs.osprey.restypes.ResidueTemplate;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MoleculeModifierAndScorer
implements ObjectiveFunction {
    private static final long serialVersionUID = 3898313221157632380L;
    EnergyFunction efunc;
    Molecule molec;
    ArrayList<DegreeOfFreedom> DOFs;
    DoubleMatrix1D[] constraints;
    DoubleMatrix1D curDOFVals;
    List<EnergyFunction> partialEFuncs = null;

    @Deprecated
    public MoleculeModifierAndScorer(MoleculeObjectiveFunction mof) {
        this.molec = mof.pmol.mol;
        this.DOFs = new ArrayList<DegreeOfFreedom>(mof.pmol.dofs);
        this.constraints = mof.pmol.dofBounds.getBounds();
        this.efunc = mof.efunc;
        this.curDOFVals = mof.curDOFVals;
        this.partialEFuncs = mof.efuncsByDof;
    }

    public static boolean hasMinimizableDofs(ConfSpace confSpace, RCTuple tuple) {
        for (int i = 0; i < tuple.size(); ++i) {
            int pos = tuple.pos.get(i);
            int rc = tuple.RCs.get(i);
            RC rcObj = confSpace.posFlex.get((int)pos).RCs.get(rc);
            for (int d = 0; d < rcObj.DOFs.size(); ++d) {
                double xdmin = rcObj.DOFmin.get(d);
                double xdmax = rcObj.DOFmax.get(d);
                if (!(xdmax > xdmin)) continue;
                return true;
            }
        }
        return false;
    }

    public MoleculeModifierAndScorer(EnergyFunction ef, DoubleMatrix1D[] constr, Molecule m, ArrayList<DegreeOfFreedom> DOFList) {
        this.constraints = constr;
        this.molec = m;
        this.DOFs = DOFList;
        this.curDOFVals = DoubleFactory1D.dense.make(this.DOFs.size());
        this.setEfunc(ef);
    }

    public MoleculeModifierAndScorer(EnergyFunction ef, ConfSpace cSpace, RCTuple RCTup) {
        this(ef, cSpace, RCTup, null);
    }

    public MoleculeModifierAndScorer(EnergyFunction ef, ConfSpace cSpace, RCTuple RCTup, ParameterizedMoleculeCopy pmc) {
        this.molec = pmc == null ? cSpace.m : pmc.getCopiedMolecule();
        LinkedHashMap<DegreeOfFreedom, Object> DOFBounds = new LinkedHashMap<DegreeOfFreedom, double[]>();
        int numMinDOFs = 0;
        for (int indexInTup = 0; indexInTup < RCTup.RCs.size(); ++indexInTup) {
            int posNum = RCTup.pos.get(indexInTup);
            int RCNum = RCTup.RCs.get(indexInTup);
            RC rc = cSpace.posFlex.get((int)posNum).RCs.get(RCNum);
            Residue res = cSpace.posFlex.get((int)posNum).res;
            if (res.template.templateRes.coords != null) {
                ResidueTemplate desiredTemplate;
                ResidueTypeDOF mutDOF = cSpace.mutDOFs.get(posNum);
                if (pmc != null) {
                    mutDOF = (ResidueTypeDOF)pmc.getCopiedDOF(mutDOF);
                }
                if (mutDOF.isTemplate(desiredTemplate = rc.template != null ? rc.template : mutDOF.getLibraryTemplate(rc.AAType))) {
                    mutDOF.restoreCoordsFromTemplate();
                } else {
                    mutDOF.switchToTemplate(desiredTemplate);
                }
            }
            for (int dofIndexInRC = 0; dofIndexInRC < rc.DOFs.size(); ++dofIndexInRC) {
                double maxVal = rc.DOFmax.get(dofIndexInRC);
                double minVal = rc.DOFmin.get(dofIndexInRC);
                DegreeOfFreedom curDOF = rc.DOFs.get(dofIndexInRC);
                if (DOFBounds.containsKey(curDOF)) {
                    double[] prevBounds = (double[])DOFBounds.get(curDOF);
                    if (prevBounds[0] == minVal && prevBounds[1] == maxVal) continue;
                    throw new RuntimeException("ERROR: Disagreement in DOF bounds between RCs!");
                }
                DOFBounds.put(curDOF, new double[]{minVal, maxVal});
                ++numMinDOFs;
            }
        }
        if (pmc != null) {
            LinkedHashMap<DegreeOfFreedom, double[]> copiedDofs = new LinkedHashMap<DegreeOfFreedom, double[]>();
            for (Map.Entry<DegreeOfFreedom, double[]> entry : DOFBounds.entrySet()) {
                DegreeOfFreedom dof = entry.getKey();
                dof = pmc.getCopiedDOF(dof);
                copiedDofs.put(dof, entry.getValue());
            }
            DOFBounds = copiedDofs;
        }
        this.init(numMinDOFs, DOFBounds);
        this.setEfunc(ef);
    }

    public MoleculeModifierAndScorer(EnergyFunction efunc, ConfSpace confSpace) {
        this.molec = confSpace.m;
        int numMinDOFs = 0;
        LinkedHashMap<DegreeOfFreedom, double[]> DOFBounds = new LinkedHashMap<DegreeOfFreedom, double[]>();
        for (int i = 0; i < confSpace.posFlex.size(); ++i) {
            PositionConfSpace pos = confSpace.posFlex.get(i);
            for (int j = 0; j < pos.res.getNumDihedrals(); ++j) {
                DOFBounds.put(new FreeDihedral(pos.res, j), pos.makeDOFBounds(pos.res.getDihedralAngle(j)));
                ++numMinDOFs;
            }
        }
        this.init(numMinDOFs, DOFBounds);
        this.setEfunc(efunc);
    }

    private void init(int numMinDOFs, LinkedHashMap<DegreeOfFreedom, double[]> DOFBounds) {
        this.DOFs = new ArrayList();
        this.constraints = new DoubleMatrix1D[]{DoubleFactory1D.dense.make(numMinDOFs), DoubleFactory1D.dense.make(numMinDOFs)};
        int minDOFCount = 0;
        for (DegreeOfFreedom dof : DOFBounds.keySet()) {
            double[] bounds = DOFBounds.get(dof);
            if (bounds[0] == bounds[1]) {
                dof.apply(bounds[0]);
                continue;
            }
            this.constraints[0].set(minDOFCount, bounds[0]);
            this.constraints[1].set(minDOFCount, bounds[1]);
            this.DOFs.add(dof);
            ++minDOFCount;
        }
        this.curDOFVals = DoubleFactory1D.dense.make(this.DOFs.size());
    }

    @Override
    public int getNumDOFs() {
        return this.DOFs.size();
    }

    @Override
    public DoubleMatrix1D[] getConstraints() {
        return this.constraints;
    }

    @Override
    public void setDOFs(DoubleMatrix1D x) {
        this.curDOFVals.assign(x);
        if (x.size() != this.DOFs.size()) {
            throw new RuntimeException("ERROR: Trying to set " + this.DOFs.size() + " DOFs with " + x.size() + " values");
        }
        for (int dof = 0; dof < x.size(); ++dof) {
            this.DOFs.get(dof).apply(x.get(dof));
        }
    }

    @Override
    public void setDOF(int dof, double val) {
        this.curDOFVals.set(dof, val);
        this.DOFs.get(dof).apply(val);
    }

    @Override
    public double getValue(DoubleMatrix1D x) {
        this.setDOFs(x);
        return this.efunc.getEnergy();
    }

    @Override
    public double getValForDOF(int dof, double val) {
        this.setDOF(dof, val);
        if (this.partialEFuncs != null) {
            return this.partialEFuncs.get(dof).getEnergy();
        }
        return this.efunc.getEnergy();
    }

    public double getCurValueOfDOF(int dof) {
        return this.curDOFVals.get(dof);
    }

    @Override
    public double getInitStepSize(int dof) {
        return MoleculeModifierAndScorer.getInitStepSize(this.DOFs.get(dof));
    }

    public static double getInitStepSize(DegreeOfFreedom dof) {
        if (dof instanceof FreeDihedral) {
            return 0.25;
        }
        if (dof instanceof EllipseCoordDOF) {
            EllipseCoordDOF e = (EllipseCoordDOF)dof;
            return e.getIndex() == 0 ? 10.0 : 0.3;
        }
        if (dof instanceof StrandRotation) {
            return 0.0625;
        }
        if (dof instanceof StrandTranslation) {
            return 0.025;
        }
        if (dof instanceof Shear) {
            return 0.125;
        }
        if (dof instanceof Backrub) {
            return 0.125;
        }
        if (dof instanceof BBFreeDOF) {
            return 0.05;
        }
        throw new UnsupportedOperationException("ERROR: DOF type not recognized for step size purposes");
    }

    @Override
    public boolean isDOFAngle(int dof) {
        return MoleculeModifierAndScorer.isDOFAngle(this.DOFs.get(dof));
    }

    public static boolean isDOFAngle(DegreeOfFreedom dof) {
        if (dof instanceof FreeDihedral) {
            return true;
        }
        if (dof instanceof StrandRotation) {
            return true;
        }
        if (dof instanceof StrandTranslation) {
            return false;
        }
        if (dof instanceof Shear) {
            return true;
        }
        if (dof instanceof Backrub) {
            return true;
        }
        if (dof instanceof BBFreeDOF) {
            return false;
        }
        throw new UnsupportedOperationException("Degree of freedom type not support here yet: " + dof.toString());
    }

    public EnergyFunction getEfunc() {
        return this.efunc;
    }

    public EnergyFunction getEfunc(int dof) {
        if (this.partialEFuncs == null) {
            return null;
        }
        return this.partialEFuncs.get(dof);
    }

    public void setEfunc(EnergyFunction efunc) {
        this.efunc = efunc;
        if (efunc instanceof EnergyFunction.NeedsInit) {
            ((EnergyFunction.NeedsInit)efunc).init(this.molec, this.DOFs, this.curDOFVals);
        }
        this.partialEFuncs = efunc instanceof EnergyFunction.DecomposableByDof ? ((EnergyFunction.DecomposableByDof)efunc).decomposeByDof(this.molec, this.DOFs) : null;
        if (efunc instanceof EnergyFunction.ExplicitChemicalChanges) {
            ((EnergyFunction.ExplicitChemicalChanges)efunc).handleChemicalChanges();
        }
        if (this.partialEFuncs != null) {
            for (EnergyFunction dofEfunc : this.partialEFuncs) {
                if (!(dofEfunc instanceof EnergyFunction.ExplicitChemicalChanges)) continue;
                ((EnergyFunction.ExplicitChemicalChanges)dofEfunc).handleChemicalChanges();
            }
        }
    }

    public Molecule getMolec() {
        return this.molec;
    }

    public ArrayList<DegreeOfFreedom> getDOFs() {
        return this.DOFs;
    }

    public boolean isOutOfRange(DoubleMatrix1D x) {
        if (x.size() != this.DOFs.size()) {
            throw new RuntimeException("ERROR: Trying to check range on " + this.DOFs.size() + " DOFs with " + x.size() + " values");
        }
        for (int dof = 0; dof < this.DOFs.size(); ++dof) {
            if (x.get(dof) < this.constraints[0].get(dof) - 1.0E-6) {
                return true;
            }
            if (!(x.get(dof) > this.constraints[1].get(dof) + 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<Integer> getInitFixableDOFs() {
        ArrayList<Integer> fixableDOFs = new ArrayList<Integer>();
        for (int dof = 0; dof < this.DOFs.size(); ++dof) {
            if (!(this.DOFs.get(dof) instanceof BBFreeDOF)) continue;
            fixableDOFs.add(dof);
        }
        return fixableDOFs;
    }
}

