/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleMatrix1D;
import java.io.Serializable;

public class GenCoord
implements Serializable {
    int type;
    static final int REGULAR = 0;
    static final int SUMSQ = 1;
    static final int LINCOMB = 2;
    double[] coeffs = null;

    public GenCoord() {
        this.type = 0;
    }

    public GenCoord(double[] c) {
        this.type = 2;
        this.coeffs = c;
    }

    public double eval(DoubleMatrix1D x, int[] indices) {
        switch (this.type) {
            case 0: {
                return x.get(indices[0]);
            }
            case 1: {
                double sum = 0.0;
                for (int q : indices) {
                    sum += Math.pow(x.get(q), 2.0);
                }
                return Math.sqrt(sum);
            }
            case 2: {
                double ans = 0.0;
                for (int a = 0; a < this.coeffs.length; ++a) {
                    ans += this.coeffs[a] * x.get(indices[a]);
                }
                return ans;
            }
        }
        throw new Error("Unrecognized generalized coordinate type: " + this.type);
    }

    public double getNearestInRangeDOFVal(double startVal, double min, double max, DoubleMatrix1D x, int dof, int[] indices) {
        switch (this.type) {
            case 0: {
                if (startVal < min) {
                    return min;
                }
                if (startVal > max) {
                    return max;
                }
                return startVal;
            }
            case 1: {
                double sum = 0.0;
                for (int q : indices) {
                    sum += Math.pow(x.get(q), 2.0);
                }
                double minsq = Math.pow(min, 2.0);
                if (sum < minsq) {
                    double absAns = Math.sqrt(Math.pow(min, 2.0) - (sum - Math.pow(startVal, 2.0)));
                    if (startVal > 0.0) {
                        return absAns;
                    }
                    return -absAns;
                }
                double maxsq = Math.pow(max, 2.0);
                if (sum > maxsq) {
                    double absAns = Math.sqrt(Math.pow(max, 2.0) - (sum - Math.pow(startVal, 2.0)));
                    if (startVal > 0.0) {
                        return absAns;
                    }
                    return -absAns;
                }
                return startVal;
            }
            case 2: {
                double ans = 0.0;
                int DOFLocalInd = -1;
                for (int a = 0; a < this.coeffs.length; ++a) {
                    if (indices[a] == dof) {
                        ans += this.coeffs[a] * startVal;
                        DOFLocalInd = a;
                        continue;
                    }
                    ans += this.coeffs[a] * x.get(indices[a]);
                }
                if (ans < min) {
                    if (this.coeffs[DOFLocalInd] == 0.0) {
                        return Double.NaN;
                    }
                    return startVal + (min - ans) / this.coeffs[DOFLocalInd];
                }
                if (ans > max) {
                    if (this.coeffs[DOFLocalInd] == 0.0) {
                        return Double.NaN;
                    }
                    return startVal + (max - ans) / this.coeffs[DOFLocalInd];
                }
                return startVal;
            }
        }
        throw new Error("Unrecognized generalized coordinate type: " + this.type);
    }

    public double constrOpt(DoubleMatrix1D[] constraints, int[] indices, boolean useMin) {
        switch (this.type) {
            case 0: {
                if (useMin) {
                    return constraints[0].get(indices[0]);
                }
                return constraints[1].get(indices[0]);
            }
            case 1: {
                double sum = 0.0;
                for (int q : indices) {
                    double sq1 = Math.pow(constraints[0].get(q), 2.0);
                    double sq2 = Math.pow(constraints[1].get(q), 2.0);
                    if (useMin) {
                        sum += Math.min(sq1, sq2);
                        continue;
                    }
                    sum += Math.max(sq1, sq2);
                }
                return Math.sqrt(sum);
            }
            case 2: {
                double ans = 0.0;
                for (int a = 0; a < this.coeffs.length; ++a) {
                    double val1 = this.coeffs[a] * constraints[0].get(indices[a]);
                    double val2 = this.coeffs[a] * constraints[1].get(indices[a]);
                    if (useMin) {
                        ans += Math.min(val1, val2);
                        continue;
                    }
                    ans += Math.max(val1, val2);
                }
                return ans;
            }
        }
        throw new Error("Unrecognized generalized coordinate type: " + this.type);
    }

    public double getMeshWidth(double[] DOFMeshWidths) {
        switch (this.type) {
            case 0: {
                return DOFMeshWidths[0];
            }
            case 2: {
                double numerator = 0.0;
                double denominator = 0.0;
                for (int a = 0; a < this.coeffs.length; ++a) {
                    numerator += Math.abs(this.coeffs[a]) * DOFMeshWidths[a];
                    denominator += Math.abs(this.coeffs[a]);
                }
                return numerator / denominator;
            }
        }
        throw new Error("Unrecognized generalized coordinate type for getMeshWidth: " + this.type);
    }
}

