/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.math.Functions;
import edu.duke.cs.osprey.minimization.GenCoord;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class CCDMinimizer
implements Minimizer {
    ObjectiveFunction objFcn;
    DoubleMatrix1D x;
    int numDOFs;
    public static int numIter = 30;
    public static double EConvTol = 0.001;
    static double numTol = 1.0E-6;
    static double GCTol = 1.0E-10;
    double[] firstStep;
    double[] lastStep;
    boolean useCorners;
    DoubleMatrix1D DOFmin;
    DoubleMatrix1D DOFmax;
    DoubleMatrix1D singleInitVal = null;
    GenCoord[] nonBoxConstrGC = new GenCoord[0];
    int[][] nonBoxConstrIndices;
    double[] GCmin;
    double[] GCmax;
    int[][] nonBoxConstrAffectingDOF;
    GenCoord rescalingGC = null;
    int[] rescalingIndices = null;
    boolean banZero = false;
    boolean useRandMinCheck = false;
    boolean jumpOOR = false;
    double jumpOORDelta = 0.05;
    double jumpOORNumSteps = 126.0;
    double minTime;
    private static final boolean useInitFixableDOFs = false;
    public int GVCountEstmin = 0;
    public int GVCountEdge = 0;
    public int GVCountBigger = 0;
    public int GVCountSmaller = 0;
    private boolean preferUpRipple = false;

    public CCDMinimizer(ObjectiveFunction ofn, boolean useCorners) {
        this.objFcn = ofn;
        this.numDOFs = ofn.getNumDOFs();
        this.nonBoxConstrAffectingDOF = new int[this.numDOFs][0];
    }

    public void setPreferUpRipple(boolean val) {
        this.preferUpRipple = val;
    }

    @Override
    public Minimizer.Result minimizeFromCenter() {
        return this.minimizeFrom(null);
    }

    @Override
    public Minimizer.Result minimizeFrom(DoubleMatrix1D x) {
        this.singleInitVal = x;
        DoubleMatrix1D[] constr = this.objFcn.getConstraints();
        this.DOFmin = constr[0];
        this.DOFmax = constr[1];
        if (!this.compInitVals()) {
            return null;
        }
        this.minimizeFromCurPoint();
        return new Minimizer.Result(this.x, this.objFcn.getValue(this.x));
    }

    public void minimizeFromCurPoint() {
        long minStartTime = System.currentTimeMillis();
        this.firstStep = new double[this.numDOFs];
        this.lastStep = new double[this.numDOFs];
        Arrays.fill(this.firstStep, 1.0);
        Arrays.fill(this.lastStep, 1.0);
        double oldE = Double.POSITIVE_INFINITY;
        this.objFcn.setDOFs(this.x);
        for (int iter = 0; iter < numIter; ++iter) {
            double E = this.objFcn.getValue(this.x);
            if (Double.isInfinite(E) && Double.isInfinite(oldE)) {
                if (this.useRandMinCheck) {
                    E = this.doRandMinCheck(E);
                }
                if (Double.isInfinite(E)) break;
            }
            if (oldE - E < EConvTol) {
                if (this.useRandMinCheck) {
                    E = this.doRandMinCheck(E);
                }
                if (oldE - E < EConvTol) break;
            }
            oldE = E;
            for (int dof = 0; dof < this.numDOFs; ++dof) {
                double upRippleVal;
                double downRippleVal;
                double curVal;
                double dof_base;
                block23: {
                    if (this.DOFmax.get(dof) == this.DOFmin.get(dof)) continue;
                    dof_base = this.x.get(dof);
                    curVal = this.objFcn.getValForDOF(dof, dof_base);
                    double step = this.getStepSize(dof, iter);
                    while (this.isOutOfRange(dof_base - step, dof) && this.isOutOfRange(dof_base + step, dof)) {
                        step /= 2.0;
                    }
                    double upVal = Double.POSITIVE_INFINITY;
                    double downVal = Double.POSITIVE_INFINITY;
                    if (!this.isOutOfRange(dof_base + step, dof)) {
                        upVal = this.objFcn.getValForDOF(dof, dof_base + step);
                    }
                    if (!this.isOutOfRange(dof_base - step, dof)) {
                        downVal = this.objFcn.getValForDOF(dof, dof_base - step);
                    }
                    double estmin = 0.0;
                    double shape = upVal + downVal - 2.0 * curVal;
                    double ShapeEpsilon = 1.0E-12;
                    estmin = shape < -1.0E-12 || Double.isNaN(shape) || Double.isInfinite(shape) ? (upVal < downVal ? dof_base + step : dof_base - step) : (shape <= 1.0E-12 ? dof_base : dof_base + (downVal - upVal) * step / 2.0 / shape);
                    if (this.isOutOfRange(estmin, dof)) {
                        estmin = this.getEdgeDOFVal(estmin, dof);
                    }
                    double estminVal = this.objFcn.getValForDOF(dof, estmin);
                    double estminValOld = curVal;
                    ++this.GVCountEstmin;
                    if (estminVal < curVal) {
                        do {
                            if (this.isOutOfRange(estmin = dof_base + 2.0 * (estmin - dof_base), dof)) {
                                double edge = this.getEdgeDOFVal(estmin, dof);
                                double edgeVal = this.objFcn.getValForDOF(dof, edge);
                                ++this.GVCountEdge;
                                if (edgeVal < estminVal) {
                                    this.x.set(dof, edge);
                                } else {
                                    this.x.set(dof, dof_base + 0.5 * (estmin - dof_base));
                                }
                                break block23;
                            }
                            estminValOld = estminVal;
                            estminVal = this.objFcn.getValForDOF(dof, estmin);
                            ++this.GVCountBigger;
                        } while (estminVal < estminValOld - (tol = numTol * Math.max(1.0, Math.abs(estminVal))));
                        this.x.set(dof, dof_base + 0.5 * (estmin - dof_base));
                    } else if (estminVal > curVal + numTol) {
                        do {
                            estmin = dof_base + 0.5 * (estmin - dof_base);
                            estminValOld = estminVal;
                            estminVal = this.objFcn.getValForDOF(dof, estmin);
                            ++this.GVCountSmaller;
                        } while (!(estminValOld < estminVal + (tol = numTol * Math.max(1.0, Math.abs(estminVal)))));
                        if (estminValOld < curVal) {
                            this.x.set(dof, dof_base + 2.0 * (estmin - dof_base));
                        }
                    }
                }
                this.lastStep[dof] = this.x.get(dof) - dof_base;
                if (iter == 0) {
                    this.firstStep[dof] = this.lastStep[dof];
                }
                double downRipple = this.x.get(dof) - 1.0;
                double upRipple = this.x.get(dof) + 1.0;
                curVal = this.objFcn.getValForDOF(dof, this.x.get(dof));
                if (!this.isOutOfRange(downRipple, dof) && (downRippleVal = this.objFcn.getValForDOF(dof, downRipple)) < curVal) {
                    this.x.set(dof, downRipple);
                    if (!this.preferUpRipple) {
                        curVal = downRippleVal;
                    }
                }
                if (!this.isOutOfRange(upRipple, dof) && (upRippleVal = this.objFcn.getValForDOF(dof, upRipple)) < curVal) {
                    this.x.set(dof, upRipple);
                    curVal = upRippleVal;
                }
                this.objFcn.setDOF(dof, this.x.get(dof));
            }
            if (this.rescalingGC == null) continue;
            this.rescaleValues();
        }
        this.minTime = System.currentTimeMillis() - minStartTime;
    }

    public double getStepSize(int dof, int iter) {
        double initStepSize = this.objFcn.getInitStepSize(dof);
        if (Math.abs(this.lastStep[dof]) > numTol && Math.abs(this.firstStep[dof]) > numTol) {
            return initStepSize * Math.abs(this.lastStep[dof] / this.firstStep[dof]);
        }
        return initStepSize / Math.pow(iter + 1, 3.0);
    }

    public double getDOFTol(int dof, int iter) {
        return this.getStepSize(dof, iter) * 4.0;
    }

    protected boolean isOutOfRange(double val, int dof) {
        return this.isOutOfRange(val, dof, 0.0);
    }

    protected boolean isOutOfRange(double val, int dof, double boxConstrTol) {
        if (val < this.DOFmin.get(dof) - boxConstrTol || val > this.DOFmax.get(dof) + boxConstrTol) {
            return true;
        }
        if (this.nonBoxConstrAffectingDOF[dof].length > 0) {
            double curValForDOF = this.x.get(dof);
            this.x.set(dof, val);
            if (this.banZero && this.x.zDotProduct(this.x) == 0.0) {
                this.x.set(dof, curValForDOF);
                return true;
            }
            for (int nbc : this.nonBoxConstrAffectingDOF[dof]) {
                double GCVal = this.nonBoxConstrGC[nbc].eval(this.x, this.nonBoxConstrIndices[nbc]);
                if (!(GCVal > this.GCmax[nbc] + GCTol) && !(GCVal < this.GCmin[nbc] - GCTol)) continue;
                this.x.set(dof, curValForDOF);
                return true;
            }
            this.x.set(dof, curValForDOF);
        }
        return this.banZero && this.x.zDotProduct(this.x) == 0.0;
    }

    double getEdgeDOFVal(double oorVal, int dof) {
        return this.getEdgeDOFVal(oorVal, dof, true, 0);
    }

    double getEdgeDOFVal(double oorVal, int dof, boolean checkx) {
        return this.getEdgeDOFVal(oorVal, dof, checkx, 0);
    }

    double getEdgeDOFVal(double oorVal, int dof, boolean checkx, int numRecursions) {
        double edge = oorVal;
        if (checkx) {
            GCTol = 0.05;
            if (this.isOutOfRange(this.x.get(dof), dof, 1.0E-6)) {
                System.out.println("x=" + this.x.get(dof) + " out of range for getEdgeDOFVal.  DOF min: " + this.DOFmin.get(dof) + " max: " + this.DOFmax.get(dof));
            }
            GCTol = 1.0E-10;
        }
        if (this.banZero) {
            edge = this.enforceZeroBan(edge, dof);
        }
        if (this.nonBoxConstrAffectingDOF[dof].length > 0) {
            for (int nbc : this.nonBoxConstrAffectingDOF[dof]) {
                if (this.banZero) {
                    edge = this.enforceZeroBan(edge, dof);
                }
                edge = this.nonBoxConstrGC[nbc].getNearestInRangeDOFVal(edge, this.GCmin[nbc], this.GCmax[nbc], this.x, dof, this.nonBoxConstrIndices[nbc]);
            }
        }
        if (edge < this.DOFmin.get(dof)) {
            edge = this.DOFmin.get(dof);
        } else if (edge > this.DOFmax.get(dof)) {
            edge = this.DOFmax.get(dof);
        }
        if (checkx) {
            GCTol = 0.05;
            boolean stillOOR = this.isOutOfRange(edge, dof);
            GCTol = 1.0E-10;
            int maxNumRecursions = 10;
            if (stillOOR) {
                if (numRecursions < 10) {
                    edge = this.getEdgeDOFVal(edge, dof, checkx, numRecursions + 1);
                } else {
                    System.out.println("woah out of range edge value for CCDMinimizer, not fixed by " + maxNumRecursions + " recursions!!");
                    this.isOutOfRange(edge, dof);
                }
            }
        }
        if (this.banZero) {
            edge = this.enforceZeroBan(edge, dof);
        }
        if (this.jumpOOR && checkx) {
            double delta = this.jumpOORDelta;
            if (oorVal < edge) {
                delta *= -1.0;
            }
            int step = 0;
            while ((double)step < this.jumpOORNumSteps) {
                double DOFVal = oorVal + (double)step * delta;
                if (!this.isOutOfRange(DOFVal, dof) && this.objFcn.getValForDOF(dof, DOFVal) < this.objFcn.getValForDOF(dof, edge)) {
                    edge = DOFVal;
                    break;
                }
                if (DOFVal < this.DOFmin.get(dof) || DOFVal > this.DOFmax.get(dof)) break;
                ++step;
            }
        }
        return edge;
    }

    double enforceZeroBan(double edge, int dof) {
        if (edge == 0.0 && this.x.zDotProduct(this.x) == this.x.get(dof) * this.x.get(dof)) {
            edge = this.x.get(dof) > 0.0 ? 1.0E-10 : -1.0E-10;
        }
        return edge;
    }

    public boolean compInitVals() {
        if (this.singleInitVal != null) {
            this.x = this.getAnglesInRange(this.singleInitVal);
            for (int dof = 0; dof < this.numDOFs; ++dof) {
                if (!this.isOutOfRange(this.x.get(dof), dof)) continue;
                return false;
            }
            return true;
        }
        if (this.useCorners) {
            this.compInitValsCorners();
        } else {
            this.compInitValsMiddle();
        }
        return true;
    }

    public void compInitValsMiddle() {
        double[] initVals = new double[this.numDOFs];
        for (int a = 0; a < this.numDOFs; ++a) {
            initVals[a] = (this.DOFmin.get(a) + this.DOFmax.get(a)) / 2.0;
        }
        this.x = DoubleFactory1D.dense.make(initVals);
        boolean badInit = this.satisfyNonBoxConstr();
        if (badInit) {
            throw new Error("can't find feasible initial point for minimization.  GenCoord types:" + CCDMinimizer.getGenCoordTypes(this.nonBoxConstrGC));
        }
    }

    private static String getGenCoordTypes(GenCoord[] coords) {
        StringBuilder buf = new StringBuilder();
        for (GenCoord coord : coords) {
            buf.append("\n" + coord.type);
        }
        return buf.toString();
    }

    public void compInitValsCorners() {
        double[] firstCorner = new double[this.numDOFs];
        for (int a = 0; a < this.numDOFs; ++a) {
            firstCorner[a] = this.DOFmin.get(a);
        }
        this.x = DoubleFactory1D.dense.make(firstCorner);
        if (this.numDOFs == 0) {
            return;
        }
        boolean[] upDown = new boolean[this.numDOFs];
        DoubleMatrix1D bestInitVals = null;
        double bestCornerE = Double.POSITIVE_INFINITY;
        boolean done = false;
        while (!done) {
            double curE;
            boolean badInit = this.satisfyNonBoxConstr();
            if (!badInit && (curE = this.objFcn.getValue(this.x)) < bestCornerE) {
                bestCornerE = this.objFcn.getValue(this.x);
                bestInitVals = this.x.copy();
            }
            int DOFToUpdate = this.numDOFs - 1;
            while (upDown[DOFToUpdate]) {
                upDown[DOFToUpdate] = false;
                this.x.set(DOFToUpdate, this.DOFmin.get(DOFToUpdate));
                if (--DOFToUpdate != -1) continue;
                done = true;
                break;
            }
            if (done) continue;
            upDown[DOFToUpdate] = true;
            this.x.set(DOFToUpdate, this.DOFmax.get(DOFToUpdate));
        }
        if (Double.isInfinite(bestCornerE)) {
            throw new Error("can't find feasible initial point for minimization.  GenCoord types:" + CCDMinimizer.getGenCoordTypes(this.nonBoxConstrGC));
        }
        this.x = bestInitVals;
    }

    void initByPartialMin(ArrayList<Integer> initFixableDOFs) {
        DoubleMatrix1D DOFminSave = this.DOFmin.copy();
        DoubleMatrix1D DOFmaxSave = this.DOFmax.copy();
        for (int fixDOF : initFixableDOFs) {
            this.DOFmin.set(fixDOF, this.x.get(fixDOF));
            this.DOFmax.set(fixDOF, this.x.get(fixDOF));
        }
        this.minimizeFromCurPoint();
        this.DOFmin = DOFminSave;
        this.DOFmax = DOFmaxSave;
    }

    DoubleMatrix1D getAnglesInRange(DoubleMatrix1D u) {
        DoubleMatrix1D ans = u.copy();
        for (int dof = 0; dof < this.numDOFs; ++dof) {
            if (!this.objFcn.isDOFAngle(dof)) continue;
            if (ans.get(dof) < this.DOFmin.get(dof) - 0.001) {
                ans.set(dof, this.DOFmin.get(dof) + (ans.get(dof) - this.DOFmin.get(dof)) % 360.0 + 360.0);
                continue;
            }
            if (!(ans.get(dof) > this.DOFmax.get(dof) + 0.001)) continue;
            ans.set(dof, this.DOFmin.get(dof) + (ans.get(dof) - this.DOFmin.get(dof)) % 360.0);
        }
        return ans;
    }

    public void pickInitVals(ArrayList<DoubleMatrix1D> vecs) {
        DoubleMatrix1D bestInitVals = null;
        double bestE = Double.POSITIVE_INFINITY;
        for (DoubleMatrix1D vec : vecs) {
            double curE = this.objFcn.getValue(vec);
            if (!(curE < bestE)) continue;
            bestE = curE;
            bestInitVals = vec;
        }
        if (Double.isInfinite(bestE)) {
            throw new Error("can't find feasible initial point for minimization.  GenCoord types:" + CCDMinimizer.getGenCoordTypes(this.nonBoxConstrGC));
        }
        this.x = bestInitVals;
    }

    private boolean satisfyNonBoxConstr() {
        boolean badInit = false;
        if (this.nonBoxConstrGC.length != 0) {
            double val;
            int dof;
            for (dof = 0; dof < this.numDOFs; ++dof) {
                double edge;
                val = this.x.get(dof);
                if (!this.isOutOfRange(val, dof) || Double.isNaN(edge = this.getEdgeDOFVal(val, dof))) continue;
                this.x.set(dof, edge);
            }
            for (dof = 0; dof < this.numDOFs; ++dof) {
                val = this.x.get(dof);
                if (!this.isOutOfRange(val, dof)) continue;
                badInit = true;
                break;
            }
        }
        return badInit;
    }

    public void compNonBoxConstrAffectingDOF() {
        this.nonBoxConstrAffectingDOF = new int[this.numDOFs][];
        for (int dof = 0; dof < this.numDOFs; ++dof) {
            ArrayList<Integer> affecting = new ArrayList<Integer>();
            block1: for (int gcIndex = 0; gcIndex < this.nonBoxConstrIndices.length; ++gcIndex) {
                for (int index : this.nonBoxConstrIndices[gcIndex]) {
                    if (index != dof) continue;
                    affecting.add(gcIndex);
                    continue block1;
                }
            }
            this.nonBoxConstrAffectingDOF[dof] = new int[affecting.size()];
            for (int a = 0; a < affecting.size(); ++a) {
                this.nonBoxConstrAffectingDOF[dof][a] = (Integer)affecting.get(a);
            }
        }
    }

    void rescaleValues() {
        double beta = this.rescalingGC.eval(this.x, this.rescalingIndices);
        int iter = 0;
        while (beta == 0.0) {
            int randDOF = new Random().nextInt(this.numDOFs);
            double newVal = this.x.get(randDOF) + 1.0E-5 * Math.random();
            if (this.isOutOfRange(newVal, randDOF)) {
                newVal = this.getEdgeDOFVal(newVal, randDOF);
            }
            this.x.set(randDOF, newVal);
            beta = this.rescalingGC.eval(this.x, this.rescalingIndices);
            if (!((double)(++iter) > 10000.0)) continue;
            return;
        }
        if (iter > 0) {
            System.out.println("Warning: rescalingGC=0 for CCD minimizer rescaling.  Trying to salvage with random perturbation.  " + iter + " iterations until beta!=0");
        }
        if (beta == 0.0) {
            return;
        }
        this.x.assign(Functions.mult((double)beta));
    }

    double doRandMinCheck(double E) {
        int numCheckPts = 100;
        int maxConsideredPts = 1000;
        double rangeFac = 10.0;
        DoubleMatrix1D xCur = this.x.copy();
        int a = 0;
        for (int c = 0; c < maxConsideredPts && a < numCheckPts; ++c) {
            for (int dof = 0; dof < this.numDOFs; ++dof) {
                double r = 2.0 * Math.random() - 1.0;
                double change = rangeFac * this.objFcn.getInitStepSize(dof) * r;
                this.x.set(dof, xCur.get(dof) + change);
            }
            boolean oor = false;
            for (int dof = 0; dof < this.numDOFs; ++dof) {
                if (!this.isOutOfRange(this.x.get(dof), dof)) continue;
                oor = true;
                break;
            }
            if (oor) continue;
            double Ept = this.objFcn.getValue(this.x);
            if (Ept < E) {
                xCur = this.x.copy();
                E = Ept;
            }
            ++a;
        }
        this.x = xCur;
        this.objFcn.setDOFs(this.x);
        return E;
    }

    public void setInitVals(DoubleMatrix1D initVals) {
        this.singleInitVal = initVals;
    }
}

