/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.visualizer;

import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class KStarTreeNode
implements Comparable<KStarTreeNode> {
    public static final Pattern p = Pattern.compile("((~\\+)*)\\(([^)]+)\\)->\\((.*)\\)\\: ?\\[(.*)\\]->\\[(.*)\\](.*)");
    private static final boolean debug = false;
    private static Random[] colorSeeds;
    private BigDecimal overallUpperBound;
    int level = -1;
    private String[] assignments;
    private int[] confAssignments;
    private BigDecimal upperBound;
    private BigDecimal lowerBound;
    List<KStarTreeNode> children = new ArrayList<KStarTreeNode>();
    private KStarTreeNode parent;
    private boolean visible = false;
    private boolean expanded = false;
    private boolean childrenRendered = false;
    private static Text statText;
    private Group bandGroup;
    private Group rootGroup;
    BigDecimal epsilon;
    private double borderThickness = 0.5;
    private double centerX;
    private double centerY;
    private double innerRadius = 30.0;
    private double outerRadius = 60.0;
    private double startAngle;
    private double length;
    private long seedNumber = 10L;
    private double occupancy = -1.0;
    private double minLeafLower;
    private double overallLower;
    private double ratioToMaxLeaf;
    private double confLowerBound;
    private double confUpperBound;
    private Arc innerRing;
    private Arc outerRing;
    private List<Arc> bands;
    private static boolean drawTree;
    private ColorStyle colorStyle = ColorStyle.occupancy;
    private static List<Double> maxLevelOccupancies;
    double energyThreshold = 0.5;
    double ratioThreshold = 0.8;
    double redblueEnergyThreshold = 2.0;
    double occupancyThreshold = 0.5;
    double logOccupancyThreshold = 0.8;

    public void setColorStyle(ColorStyle style) {
        this.colorStyle = style;
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.setColorStyle(this.colorStyle);
        }
        this.recolor();
    }

    private void recolor() {
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        if (this.bands != null && this.bands.size() > 0) {
            for (int i = 0; i < this.bands.size(); ++i) {
                this.bands.get(i).setFill((Paint)this.children.get(i).getWeightedColor());
            }
        }
    }

    public static KStarTreeNode parseTree(File file, boolean render2, Map<Integer, BigDecimal> zCutoffsByLevel) {
        try {
            BufferedReader fileStream = new BufferedReader(new FileReader(file));
            Builder builder = new Builder();
            builder.setEpsilon(0.68);
            builder.setRender(render2);
            AtomicLong numNodes = new AtomicLong(0L);
            fileStream.lines().forEach(line -> {
                boolean addedNode = builder.addNode((String)line, zCutoffsByLevel);
                if (addedNode) {
                    numNodes.incrementAndGet();
                }
            });
            Log.log("added %d nodes from the tree", numNodes.get());
            return builder.assembleTree();
        }
        catch (Exception e) {
            System.err.println("Parse tree failed: ");
            e.printStackTrace();
            return null;
        }
    }

    public static KStarTreeNode parseTree(String fileName) {
        return KStarTreeNode.parseTree(new File(fileName), false, null);
    }

    public BigDecimal getLowerBound() {
        return this.lowerBound;
    }

    public BigDecimal getUpperBound() {
        return this.upperBound;
    }

    public KStarTreeNode(int level, String[] assignments, int[] confAssignments, BigDecimal lowerBound, BigDecimal upperBound, double confLowerBound, double confUpperBound, double epsilon) {
        this.level = level;
        this.assignments = assignments;
        this.confAssignments = confAssignments;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.epsilon = new BigDecimal(epsilon);
        this.bandGroup = new Group();
        this.confLowerBound = confLowerBound;
        this.confUpperBound = confUpperBound;
        colorSeeds = new Random[assignments.length];
        if (this.isRoot()) {
            this.overallUpperBound = upperBound;
        }
    }

    public KStarTreeNode assign(int pos, int rc, String assignment, BigDecimal lowerBound, BigDecimal upperBound, double confLowerBound, double confUpperBound) {
        String[] assignments = (String[])this.assignments.clone();
        assignments[pos] = assignment;
        int[] conf = (int[])this.confAssignments.clone();
        conf[pos] = rc;
        KStarTreeNode child = new KStarTreeNode(this.level + 1, assignments, conf, lowerBound, upperBound, confLowerBound, confUpperBound, this.epsilon.doubleValue());
        child.overallUpperBound = this.overallUpperBound;
        this.addChild(child);
        return child;
    }

    public void updateBoundsFromChildren(MathContext mathContext) {
        if (this.children.isEmpty()) {
            throw new IllegalStateException("no children from which to update bounds");
        }
        BigMath lower = new BigMath(mathContext).set(0L);
        BigMath upper = new BigMath(mathContext).set(0L);
        this.confLowerBound = Double.POSITIVE_INFINITY;
        this.confUpperBound = Double.NEGATIVE_INFINITY;
        for (KStarTreeNode child : this.children) {
            lower.add(child.lowerBound);
            upper.add(child.upperBound);
            this.confLowerBound = Math.min(this.confLowerBound, child.confLowerBound);
            this.confUpperBound = Math.max(this.confUpperBound, child.confUpperBound);
        }
        this.lowerBound = lower.get();
        this.upperBound = upper.get();
        this.occupancy = -1.0;
        this.computeOccupancy();
    }

    public int numStatesAtLevel(int level) {
        if (this.level == level || this.children == null || this.children.size() < 1) {
            return 1;
        }
        int subTreeSum = 0;
        for (KStarTreeNode child : this.children) {
            subTreeSum += child.numStatesAtLevel(level);
        }
        return subTreeSum;
    }

    public BigDecimal maxWeightedErrorBound() {
        if (this.children == null || this.children.size() < 1) {
            return this.upperBound.subtract(this.lowerBound);
        }
        BigDecimal maxChildError = BigDecimal.ZERO;
        for (KStarTreeNode child : this.children) {
            BigDecimal childError = child.maxWeightedErrorBound();
            if (!MathTools.isLessThanOrEqual(maxChildError, childError)) continue;
            maxChildError = childError;
        }
        return maxChildError;
    }

    public double maxConfErrorBound() {
        if (this.children == null || this.children.size() < 1) {
            return Math.min(0.0, this.confUpperBound) - this.confLowerBound;
        }
        double maxChildError = 0.0;
        for (KStarTreeNode child : this.children) {
            maxChildError = Math.max(maxChildError, child.maxConfErrorBound());
        }
        return maxChildError;
    }

    public double computeEntropy(int maxLevel) {
        if (this.level >= maxLevel || this.children == null || this.children.size() < 1) {
            this.computeOccupancy();
            if (this.occupancy == 0.0) {
                return 0.0;
            }
            return -0.0019891 * this.occupancy * Math.log(this.occupancy) * (double)this.numStatesAtLevel(maxLevel);
        }
        double subTreeSum = 0.0;
        double subTreeOccupancy = 0.0;
        boolean childCount = false;
        for (KStarTreeNode child : this.children) {
            subTreeOccupancy += child.occupancy;
            if (!Double.isNaN(subTreeSum += child.computeEntropy(maxLevel))) continue;
            System.out.println("wtf?");
        }
        return subTreeSum;
    }

    private void computeOccupancy() {
        if (this.occupancy < 0.0) {
            this.occupancy = this.upperBound.divide(this.overallUpperBound, 70, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public double computeEntropy() {
        return this.computeEntropy(Integer.MAX_VALUE);
    }

    public double computeEnthalpyWithEnergiesFrom(Map<String, Double> energyMap, int maxLevel) {
        if (this.level >= maxLevel || this.children == null || this.children.size() < 1) {
            this.computeOccupancy();
            String formattedAssignments = this.formatAssignmentsVisual(this.assignments);
            if (!energyMap.containsKey(formattedAssignments)) {
                return 0.0;
            }
            return this.occupancy * energyMap.get(formattedAssignments);
        }
        double subtreeSum = 0.0;
        for (KStarTreeNode child : this.children) {
            subtreeSum += child.computeEnthalpyWithEnergiesFrom(energyMap, maxLevel);
        }
        return subtreeSum;
    }

    public Map<String, Double> computeEnergyMap(int maxLevel) {
        HashMap<String, Double> outputMap = new HashMap<String, Double>();
        this.populateEnergyMap(outputMap, maxLevel);
        return outputMap;
    }

    private void populateEnergyMap(Map<String, Double> map, int maxLevel) {
        if (this.level >= maxLevel || this.children == null || this.children.size() < 1) {
            map.put(this.formatAssignmentsVisual(this.assignments), this.confLowerBound);
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.populateEnergyMap(map, maxLevel);
        }
    }

    public double computeEnthalpy(int maxLevel) {
        this.computeOccupancy();
        if (this.level >= maxLevel || this.children == null || this.children.size() < 1) {
            return this.confLowerBound * this.occupancy;
        }
        double subTreeSum = 0.0;
        for (KStarTreeNode child : this.children) {
            double childEnthalpy = child.computeEnthalpy(maxLevel);
            subTreeSum += childEnthalpy;
            if (!(this.occupancy > 0.0) || !(subTreeSum < this.confLowerBound)) continue;
            double subtreeOccupancy = 0.0;
            double subtreeEnthalpy = 0.0;
            for (KStarTreeNode child2 : this.children) {
                System.out.println(String.valueOf(child2) + ":" + child2.occupancy + "->" + child2.computeEnthalpy(maxLevel));
                subtreeEnthalpy += child2.computeEnthalpy(maxLevel);
                subtreeOccupancy += child2.occupancy;
            }
            System.out.println("Subtree occupancy:" + subtreeOccupancy);
            System.out.println("Subtree enthalpy:" + subtreeEnthalpy);
            System.err.println("???");
        }
        if (this.occupancy > 0.0 && subTreeSum < this.confLowerBound) {
            System.err.println("???");
        }
        return subTreeSum;
    }

    public double computeEnthalpy() {
        return this.computeEnthalpy(Integer.MAX_VALUE);
    }

    public void initStatText() {
        statText = new Text(this.toStringVisual());
        statText.setFill((Paint)Color.WHITE);
        statText.setStroke((Paint)Color.BLACK);
        statText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)18.0));
        statText.setVisible(false);
    }

    public void setRender(boolean render2) {
        drawTree = render2;
    }

    public void preprocess() {
        if (this.level != 0) {
            System.err.println("This is only run from the root for now.");
            System.exit(-1);
        }
        double minLeafLower = this.getMinLeafLower();
        this.ratioToMaxLeaf = 1.0;
        this.setMinLeafLower(minLeafLower);
        this.computeLevelMaxOccupancies();
    }

    private void setMinLeafLower(double treeLowerBound) {
        this.overallLower = treeLowerBound;
        this.minLeafLower = this.getMinLeafLower();
        double colorThreshhold = 2.0;
        this.ratioToMaxLeaf = (colorThreshhold - Math.min(colorThreshhold, this.minLeafLower - this.overallLower)) / colorThreshhold;
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.setMinLeafLower(treeLowerBound);
        }
    }

    private double getMinLeafLower() {
        if (this.children == null || this.children.size() < 1) {
            return this.confLowerBound;
        }
        double minLower = Double.POSITIVE_INFINITY;
        for (KStarTreeNode child : this.children) {
            double childMinLower = child.getMinLeafLower();
            if (!(childMinLower < minLower)) continue;
            minLower = childMinLower;
        }
        return minLower;
    }

    private Random getColorSeed() {
        if (colorSeeds[this.level] == null) {
            KStarTreeNode.colorSeeds[this.level] = new Random(this.seedNumber);
        }
        return colorSeeds[this.level];
    }

    private void setBand(double startAngle, double length) {
        this.startAngle = startAngle;
        this.length = length;
    }

    public void showRoot() {
        if (this.isRoot()) {
            this.visible = true;
        }
    }

    private void renderCircle() {
        this.renderBand(this.centerX, this.centerY, this.innerRadius, this.outerRadius, 0.0, 360.0, this.computeWeights());
    }

    public void setGroup(Group g) {
        this.rootGroup = g;
        if (this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.setGroup(g);
        }
    }

    private void renderBand(double centerX, double centerY, double innerRadius, double outerRadius, double arcStart, double arcLength, double[] weights) {
        if (this.children.size() < 1 || this.bandGroup.getChildren().size() > 0) {
            return;
        }
        this.bands = new ArrayList<Arc>();
        ArrayList<Line> separators = new ArrayList<Line>();
        this.outerRing = new Arc(centerX, centerY, outerRadius, outerRadius, arcStart, arcLength);
        this.outerRing.setType(ArcType.ROUND);
        this.outerRing.setFill((Paint)Color.WHITE);
        this.innerRing = new Arc(centerX, centerY, innerRadius + this.borderThickness, innerRadius + this.borderThickness, arcStart, arcLength);
        this.innerRing.setType(ArcType.ROUND);
        this.innerRing.setFill((Paint)Color.WHITE);
        double startAngle = arcStart;
        double arcLengthFinal = arcLength;
        for (int i = 0; i < weights.length; ++i) {
            double d = weights[i];
            double weightLength = arcLengthFinal * d;
            Arc arc = new Arc(centerX, centerY, outerRadius - this.borderThickness, outerRadius - this.borderThickness, startAngle, arcLengthFinal * d);
            KStarTreeNode child = this.children.get(i);
            Color arcColor = child.getWeightedColor();
            arc.setFill((Paint)arcColor);
            arc.setType(ArcType.ROUND);
            this.bands.add(arc);
            double s = Math.toRadians(startAngle + weightLength);
            Line separator = new Line(centerX, centerY, centerX + outerRadius * Math.cos(s), centerY - outerRadius * Math.sin(s));
            separator.setStroke((Paint)Color.gray((double)0.92));
            separator.setStrokeWidth(this.borderThickness);
            separators.add(separator);
            double finalStartAngle = startAngle;
            double finalLength = arcLengthFinal * d;
            child.setBand(finalStartAngle, finalLength);
            child.innerRadius = innerRadius;
            child.outerRadius = outerRadius;
            arc.setOnMouseClicked(e -> {
                if (e.isControlDown()) {
                    child.toggleBand();
                }
            });
            arc.setOnMouseEntered(e -> {
                arc.setFill((Paint)child.getWeightedColor().brighter().desaturate().desaturate());
                child.showConfInfo(e.getX() + 10.0, e.getY());
            });
            arc.setOnMouseMoved(e -> child.showConfInfo(e.getX() + 10.0, e.getY()));
            arc.setOnMouseExited(e -> {
                arc.setFill((Paint)child.getWeightedColor());
                child.hideConfInfo();
            });
            startAngle += d * arcLengthFinal;
        }
        this.bandGroup.getChildren().addAll((Object[])new Node[]{this.outerRing, this.innerRing});
        this.bandGroup.getChildren().addAll(this.bands);
        this.bandGroup.getChildren().addAll(separators);
        this.bandGroup.setVisible(true);
        this.rootGroup.getChildren().add((Object)this.bandGroup);
        this.innerRing.toBack();
        for (Node node : separators) {
            node.toBack();
        }
        for (Node node : this.bands) {
            node.toBack();
        }
        this.outerRing.toBack();
        this.bandGroup.toBack();
    }

    public void computeLevelMaxOccupancies() {
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        while (maxLevelOccupancies.size() <= this.level + 1) {
            maxLevelOccupancies.add(Double.NEGATIVE_INFINITY);
        }
        for (KStarTreeNode child : this.children) {
            maxLevelOccupancies.set(this.level + 1, Math.max(child.occupancy, maxLevelOccupancies.get(this.level + 1)));
            child.computeLevelMaxOccupancies();
        }
    }

    private Color getWeightedColor() {
        switch (this.colorStyle) {
            case differenceFromEnergy: {
                return this.getEnergyWeightedColor();
            }
            case occupancy: {
                return this.getOccupancyWeightedColor();
            }
            case logOccupancy: {
                return this.getLogOccupancyWeightedColor();
            }
        }
        return this.getOccupancyWeightedColor();
    }

    public int numConfsWithin(double diffFromGMEC) {
        if (this.children == null || this.children.size() < 1 && this.confLowerBound - this.overallLower < diffFromGMEC) {
            return 1;
        }
        int sum = 0;
        for (KStarTreeNode child : this.children) {
            sum += child.numConfsWithin(diffFromGMEC);
        }
        return sum;
    }

    public double[] computeEnergyErrorWithinEnergyRange(double diffFromGMEC) {
        double[] range = new double[2];
        this.computeEnergyErrorWithinEnergyRange(diffFromGMEC, range);
        return range;
    }

    private void computeEnergyErrorWithinEnergyRange(double diffFromGMEC, double[] range) {
        double diff;
        if ((this.children == null || this.children.size() < 1 && this.confLowerBound - this.overallLower < diffFromGMEC) && (this.confUpperBound - this.confLowerBound > (diff = range[1] - range[0]) || range[0] == 0.0)) {
            range[0] = this.confLowerBound;
            range[1] = this.confUpperBound;
        }
        for (KStarTreeNode child : this.children) {
            child.computeEnergyErrorWithinEnergyRange(diffFromGMEC, range);
        }
    }

    private Color getLogOccupancyWeightedColor() {
        double logOccupancy = Math.log(this.occupancy);
        double occupancy = Math.max(1.0E-26, 1.0 - logOccupancy / Math.log(0.001));
        if (occupancy < this.logOccupancyThreshold) {
            return this.redBlueGradient(occupancy / this.logOccupancyThreshold);
        }
        double weight = (occupancy - this.logOccupancyThreshold) / (1.0 - this.logOccupancyThreshold);
        return this.blueGreenGradient(weight);
    }

    private Color getOccupancyWeightedColor() {
        double levelMaxOccupancy = maxLevelOccupancies.get(this.level);
        double occupancy = this.occupancy / levelMaxOccupancy;
        if (occupancy < this.occupancyThreshold) {
            return this.redBlueGradient(occupancy / this.occupancyThreshold);
        }
        double weight = (occupancy - this.occupancyThreshold) / (1.0 - this.occupancyThreshold);
        return this.blueGreenGradient(weight);
    }

    private Color getEnergyWeightedColor() {
        if (this.minLeafLower - this.overallLower > this.energyThreshold) {
            return this.redBlueGradient((this.redblueEnergyThreshold - Math.min(this.minLeafLower - this.overallLower, this.redblueEnergyThreshold)) / this.redblueEnergyThreshold);
        }
        double energyWeight = (this.minLeafLower - this.overallLower) / 0.5;
        return this.blueGreenGradient(1.0 - energyWeight);
    }

    private Color redGreenGradient(double ratioToMaxLeaf) {
        double newRatio = ratioToMaxLeaf;
        return new Color(1.0 - newRatio, newRatio, 0.0, 1.0);
    }

    private Color blueGreenGradient(double ratioToMaxLeaf) {
        double newRatio = ratioToMaxLeaf;
        return new Color(0.15 * newRatio, newRatio, 0.5 * (1.0 - newRatio) + 0.2, 1.0);
    }

    private Color redBlueGradient(double ratioToMaxLeaf) {
        double newRatio = ratioToMaxLeaf;
        return new Color(1.0 * (1.0 - newRatio), 0.0, newRatio, 1.0);
    }

    private void hideConfInfo() {
        statText.setVisible(false);
    }

    private void showConfInfo(double mouseX, double mouseY) {
        statText.setTranslateX(mouseX);
        statText.setTranslateY(mouseY);
        statText.setText(this.toStringVisual());
        statText.setVisible(true);
    }

    private void toggleBand() {
        boolean bl = this.expanded = !this.expanded;
        if (this.hasChildren() && !this.childrenRendered) {
            this.expanded = true;
            this.renderBand(this.centerX, this.centerY, this.outerRadius - this.borderThickness, this.outerRadius + 20.0, this.startAngle, this.length, this.computeWeights());
            this.childrenRendered = true;
            this.expanded = true;
            this.setVisible(true);
        }
        this.setVisible(this.expanded);
    }

    private double[] computeWeights() {
        return this.normalizeWeights();
    }

    private double[] normalizeWeights() {
        if (this.children == null || this.children.size() < 1) {
            return new double[]{1.0};
        }
        double[] weights = new double[this.children.size()];
        IntStream.range(0, this.children.size()).forEach(i -> {
            weights[i] = this.children.get((int)i).upperBound.divide(this.upperBound, 5, RoundingMode.HALF_UP).doubleValue();
        });
        return weights;
    }

    private double[] threshold(double[] weights, double v) {
        int numAbovethreshold = 0;
        for (int i = 0; i < weights.length; ++i) {
            if (!(weights[i] > v)) continue;
            ++numAbovethreshold;
        }
        double[] out = new double[numAbovethreshold];
        double leftover = 1.0;
        for (int i = 0; i < out.length; ++i) {
            out[i] = weights[i];
            leftover -= weights[i];
        }
        return out;
    }

    private double[] toPrimitive(ObservableList<Double> source) {
        double[] output = new double[source.size()];
        IntStream.range(0, source.size()).forEach(i -> {
            output[i] = (Double)source.get(i);
        });
        return output;
    }

    private Double[] toObject(double[] source) {
        Double[] output = new Double[source.length];
        IntStream.range(0, source.length).forEach(i -> {
            output[i] = source[i];
        });
        return output;
    }

    public void recenter(double x, double y) {
        this.centerX = x;
        this.centerY = y;
        this.bandGroup.relocate(x, y);
        this.redraw();
    }

    private void redraw() {
    }

    public void autoExpand(double v) {
        this.autoExpand(v, Integer.MAX_VALUE);
    }

    public void autoExpand(double v, int maxLevel) {
        if (this.level >= maxLevel) {
            this.setChildrenVisible(false);
            return;
        }
        if (this.occupancy > v) {
            this.toggleBand();
        }
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.autoExpand(v, maxLevel);
        }
    }

    public Map<KStarTreeNode, List<KStarTreeNode>> getTopSamples(int numSamples, int levelThreshold) {
        HashMap<KStarTreeNode, List<KStarTreeNode>> samples = new HashMap<KStarTreeNode, List<KStarTreeNode>>();
        this.getTopSamples(numSamples, levelThreshold, samples);
        return samples;
    }

    public List<KStarTreeNode> getTopSamplesInSubtree(int numSubtreeSamples) {
        PriorityQueue<KStarTreeNode> queue = new PriorityQueue<KStarTreeNode>();
        ArrayList<KStarTreeNode> confs = new ArrayList<KStarTreeNode>();
        queue.add(this);
        while (!queue.isEmpty() && confs.size() < numSubtreeSamples) {
            KStarTreeNode node = (KStarTreeNode)queue.poll();
            if (node.fullyAssigned()) {
                confs.add(node);
                continue;
            }
            queue.addAll(node.children);
        }
        return confs;
    }

    public void getTopSamples(int numSamples, int levelThreshold, Map<KStarTreeNode, List<KStarTreeNode>> lists) {
        System.out.println("At " + String.valueOf(this) + ", looking for " + numSamples + " samples");
        if (numSamples < 1) {
            System.out.println("No samples needed here.");
            return;
        }
        if (this.children == null || this.children.size() < 1) {
            System.out.println("No children. Done here.");
            if (this.fullyAssigned()) {
                ArrayList<KStarTreeNode> thisList = new ArrayList<KStarTreeNode>();
                thisList.add(this);
                lists.put(this, thisList);
            }
            return;
        }
        if (this.level >= levelThreshold) {
            ArrayList subtreeList = new ArrayList();
            lists.put(this, this.getTopSamplesInSubtree(numSamples));
            return;
        }
        int numNonZeroChildren = 0;
        for (KStarTreeNode child : this.children) {
            double childOccupancy = child.getOccupancy();
            if (!(childOccupancy > 0.01)) continue;
            ++numNonZeroChildren;
        }
        if (numNonZeroChildren < 1) {
            return;
        }
        int samplesPerChild = numSamples / numNonZeroChildren;
        int leftovers = numSamples % numNonZeroChildren;
        for (int i = 0; i < numNonZeroChildren; ++i) {
            if (i < leftovers) {
                this.children.get(i).getTopSamples(samplesPerChild + 1, levelThreshold, lists);
                continue;
            }
            this.children.get(i).getTopSamples(samplesPerChild, levelThreshold, lists);
            if (samplesPerChild >= 1) continue;
            return;
        }
    }

    private double getOccupancy() {
        if (this.occupancy < 0.0) {
            this.computeOccupancy();
        }
        return this.occupancy;
    }

    private boolean fullyAssigned() {
        boolean fullyAssigned = true;
        for (String assignment : this.assignments) {
            if (!assignment.contains("*")) continue;
            fullyAssigned = false;
        }
        return fullyAssigned;
    }

    public String[] getAssignments() {
        return this.assignments;
    }

    public int[] getConfAssignments() {
        return this.confAssignments;
    }

    public double getConfLowerBound() {
        return this.confLowerBound;
    }

    public double getConfUpperBound() {
        return this.confUpperBound;
    }

    public String getEnsemblePDBName() {
        Object out = "";
        for (String i : this.assignments) {
            if ((i = i.replace(":", "-")).contains("*")) continue;
            out = (String)out + i + "-";
        }
        return out;
    }

    public void pieChart(int ... levels) {
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : levels) {
            levelSet.add(level);
        }
        this.setVisibleLevels(levelSet);
    }

    private void setVisibleLevels(Set<Integer> levelSet) {
        if (!levelSet.contains(this.level + 1)) {
            if (this.innerRing != null) {
                this.innerRing.setVisible(false);
            }
            if (this.outerRing != null) {
                this.outerRing.setVisible(false);
            }
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(false);
                }
            }
        }
        if (levelSet.contains(this.level + 1)) {
            this.visible = true;
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(true);
                }
            }
            if (this.innerRing != null) {
                this.innerRing.setVisible(false);
            }
            if (this.outerRing != null) {
                this.outerRing.setVisible(true);
            }
        }
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode kStarTreeNode : this.children) {
            kStarTreeNode.setVisibleLevels(levelSet);
        }
    }

    public void pieChart(int targetLevel) {
        if (this.level + 1 < targetLevel) {
            if (this.innerRing != null) {
                this.innerRing.setVisible(false);
            }
            if (this.outerRing != null) {
                this.outerRing.setVisible(false);
            }
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(false);
                }
            }
        }
        if (this.level + 1 == targetLevel) {
            this.visible = true;
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(true);
                }
            }
            if (this.innerRing != null) {
                this.innerRing.setVisible(true);
            }
            if (this.outerRing != null) {
                this.outerRing.setVisible(true);
            }
        }
        if (this.level + 1 > targetLevel) {
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(false);
                }
            }
            if (this.innerRing != null) {
                this.innerRing.setVisible(false);
            }
            if (this.outerRing != null) {
                this.outerRing.setVisible(false);
            }
        }
        if (this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode kStarTreeNode : this.children) {
            kStarTreeNode.pieChart(targetLevel);
        }
    }

    public void setTextRoot(Group textGroup) {
        this.initStatText();
        textGroup.getChildren().add((Object)statText);
        textGroup.setVisible(true);
    }

    public void toggleCenter() {
        if (this.innerRing != null) {
            this.innerRing.setVisible(!this.innerRing.isVisible());
        }
    }

    public Set<KStarTreeNode> getLevelNodes(int targetLevel) {
        HashSet<KStarTreeNode> nodes = new HashSet<KStarTreeNode>();
        this.getLevelNodes(targetLevel, nodes);
        return nodes;
    }

    private void getLevelNodes(int targetLevel, Set<KStarTreeNode> nodes) {
        if (this.level == targetLevel) {
            nodes.add(this);
        }
        if (this.level > targetLevel || this.children == null || this.children.size() < 1) {
            return;
        }
        for (KStarTreeNode child : this.children) {
            child.getLevelNodes(targetLevel, nodes);
        }
    }

    private void prepTree() {
        if (this.children == null) {
            return;
        }
        if (this.children != null && this.children.size() > 0) {
            Collections.sort(this.children);
            for (KStarTreeNode child : this.children) {
                child.prepTree();
            }
        }
    }

    public boolean isChildOf(KStarTreeNode otherNode) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == otherNode) {
            return true;
        }
        return this.parent.isChildOf(otherNode);
    }

    public boolean isParentOf(KStarTreeNode otherNode) {
        return otherNode.isChildOf(this);
    }

    protected void addChild(KStarTreeNode newNode) {
        if (newNode.parent != null) {
            throw new IllegalArgumentException("node already has a parent");
        }
        this.children.add(newNode);
        newNode.parent = this;
        newNode.overallUpperBound = this.overallUpperBound;
        newNode.computeOccupancy();
    }

    public KStarTreeNode parent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            boolean wasRemoved = this.parent.children.remove(this);
            if (!wasRemoved) {
                throw new IllegalStateException("node was not a child of its parent");
            }
            this.parent = null;
        }
    }

    public Integer getAssignmentIndex() {
        if (this.parent == null) {
            return null;
        }
        for (int i = 0; i < this.assignments.length; ++i) {
            int myrc = this.confAssignments[i];
            int parentrc = this.parent.confAssignments[i];
            if (myrc == -1 || parentrc != -1) continue;
            return i;
        }
        throw new Error("tree structure doesn't match assignment order. this is a bug.");
    }

    public String toString() {
        return this.formatAssignments(this.assignments) + ":[" + this.confLowerBound + "," + this.confUpperBound + "]->[" + this.formatBigDecimal(this.lowerBound) + ", " + this.formatBigDecimal(this.upperBound) + "]";
    }

    public String toStringVisual() {
        return this.formatAssignmentsVisual(this.assignments) + ":" + this.formatBigDecimal(this.lowerBound) + ", " + this.formatBigDecimal(this.upperBound);
    }

    private String formatBigDecimal(BigDecimal bd) {
        return KStarTreeNode.format(bd);
    }

    private String formatAssignmentsVisual(String[] assignments) {
        Object out = "[";
        for (String i : assignments) {
            if (i.contains("*")) continue;
            out = (String)out + i + ",\n";
        }
        return (String)out + "]";
    }

    private String formatAssignments(String[] assignments) {
        Object out = "[";
        for (String i : assignments) {
            out = !i.contains("*") ? (String)out + i + "," : (String)out + "*,";
        }
        return (String)out + "]";
    }

    private BigInteger numSignificantConfs() {
        if (this.children == null || this.children.size() < 1) {
            if (this.upperBound.compareTo(BigDecimal.ZERO) > 0 && this.upperBound.divide(this.overallUpperBound, 10, RoundingMode.HALF_UP).compareTo(this.epsilon) > 0) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        BigInteger sum = BigInteger.ZERO;
        for (KStarTreeNode child : this.children) {
            sum = sum.add(child.numSignificantConfs());
        }
        return sum;
    }

    private boolean isRoot() {
        return this.level == 0;
    }

    private String toRenderString() {
        Object output = this.formatAssignments(this.assignments);
        if (this.hasChildren()) {
            output = (String)output + this.numSignificantConfs().toString() + ":";
        }
        output = (String)output + this.formatBigDecimal(this.lowerBound) + "," + this.formatBigDecimal(this.upperBound);
        return output;
    }

    public void render() {
        if (this.isRoot()) {
            this.renderCircle();
        }
    }

    private static String format(BigDecimal x) {
        DecimalFormat formatter = new DecimalFormat("0.0E0");
        ((NumberFormat)formatter).setRoundingMode(RoundingMode.HALF_UP);
        ((NumberFormat)formatter).setMinimumFractionDigits(x.scale() > 0 ? x.precision() : x.scale());
        return formatter.format(x);
    }

    private void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (this.innerRing != null) {
                this.innerRing.setVisible(visible);
            }
            if (this.bands != null) {
                for (Node node : this.bands) {
                    node.setVisible(visible);
                }
            }
        }
        if (this.bandGroup != null) {
            this.bandGroup.setVisible(visible);
        }
        if (this.hasChildren()) {
            for (KStarTreeNode kStarTreeNode : this.children) {
                kStarTreeNode.setVisible(visible);
            }
        }
    }

    @Override
    public int compareTo(KStarTreeNode other) {
        return -this.upperBound.compareTo(other.upperBound);
    }

    private boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    private void setChildrenVisible(boolean visible) {
        this.expanded = visible;
        if (this.hasChildren()) {
            for (KStarTreeNode child : this.children) {
                child.setVisible(visible);
            }
        }
    }

    public void render(Group g) {
        this.render();
    }

    public void printTree(String prefix, FileWriter writer) {
        String confString = this.toString();
        String out = prefix + confString;
        if (writer != null) {
            try {
                writer.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.print(out);
        }
        if (this.children != null && !this.children.isEmpty()) {
            Collections.sort(this.children, (a, b) -> -a.upperBound.compareTo(b.upperBound));
            for (KStarTreeNode child : this.children) {
                child.printTree(prefix + "~+", writer);
            }
        }
    }

    public void printTree() {
        this.printTree("", null);
    }

    public void printTreeLikeMARKStar(Writer out) throws IOException {
        this.printTreeLikeMARKStar(out, "");
    }

    public void printTreeLikeMARKStar(Writer out, String prefix) throws IOException {
        out.append(prefix);
        out.append("(");
        for (int rc : this.confAssignments) {
            out.append(Integer.toString(rc));
            out.append(", ");
        }
        out.append(")");
        out.append("->");
        out.append("(");
        for (int i = 0; i < this.assignments.length; ++i) {
            if (i > 0) {
                out.append(",");
            }
            out.append(this.assignments[i]);
        }
        out.append(")");
        out.append(":");
        out.append("[");
        out.append(Double.toString(this.confLowerBound));
        out.append(",");
        out.append(Double.toString(this.confUpperBound));
        out.append("]");
        out.append("->");
        out.append("[");
        out.append(this.lowerBound.toString());
        out.append(",");
        out.append(this.upperBound.toString());
        out.append("]");
        out.append("\n");
        for (KStarTreeNode child : this.children) {
            child.printTreeLikeMARKStar(out, prefix + "~+");
        }
    }

    static {
        drawTree = false;
        maxLevelOccupancies = new ArrayList<Double>();
    }

    public static enum ColorStyle {
        differenceFromEnergy,
        logOccupancy,
        occupancy;

    }

    public static class Builder {
        private KStarTreeNode root;
        private Stack<KStarTreeNode> buildStack = new Stack();
        private int lastLevel = -1;
        private KStarTreeNode lastNode;
        private double epsilon = 0.0;
        private boolean render = false;

        public Builder setRender(boolean render2) {
            this.render = render2;
            return this;
        }

        public boolean addNode(String line, Map<Integer, BigDecimal> zCutoffsByLevel) {
            Matcher m = p.matcher(line);
            if (m.matches()) {
                // empty if block
            }
            int level = m.group(1).length() / 2;
            String[] bounds = m.group(6).split(",");
            int[] confAssignments = Arrays.stream(m.group(3).replaceAll(" ", "").split(",")).mapToInt(Integer::parseInt).toArray();
            String[] assignments = m.group(4).split(",");
            BigDecimal lowerBound = new BigDecimal(bounds[0]);
            BigDecimal upperBound = new BigDecimal(bounds[1]);
            String[] confBounds = m.group(5).split(",");
            double confLowerBound = Double.valueOf(confBounds[0]);
            double confUpperBound = Double.valueOf(confBounds[1]);
            if (zCutoffsByLevel != null) {
                if (upperBound.compareTo(zCutoffsByLevel.get(level)) < 0) {
                    return false;
                }
                if (level > this.lastLevel + 1) {
                    return false;
                }
            }
            if (level > this.lastLevel) {
                this.buildStack.push(this.lastNode);
            }
            while (level < this.lastLevel) {
                --this.lastLevel;
                this.buildStack.pop();
            }
            KStarTreeNode newNode = new KStarTreeNode(level, assignments, confAssignments, lowerBound, upperBound, confLowerBound, confUpperBound, this.epsilon);
            KStarTreeNode curParent = this.buildStack.peek();
            if (newNode.isRoot()) {
                this.root = newNode;
                if (this.render) {
                    this.root.initStatText();
                }
            } else {
                curParent.addChild(newNode);
            }
            this.lastLevel = level;
            this.lastNode = newNode;
            return true;
        }

        public Builder setEpsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public KStarTreeNode assembleTree() {
            this.root.prepTree();
            return this.root;
        }
    }
}

