/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.order.AStarOrder;
import edu.duke.cs.osprey.astar.conf.order.UpperLowerAStarOrder;
import edu.duke.cs.osprey.astar.conf.pruning.AStarPruner;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.astar.conf.scoring.MPLPPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.PairwiseGScorer;
import edu.duke.cs.osprey.astar.conf.scoring.TraditionalPairwiseHScorer;
import edu.duke.cs.osprey.astar.conf.scoring.mplp.EdgeUpdater;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupE;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.NegatedEnergyMatrix;
import edu.duke.cs.osprey.ematrix.UpdatingEnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueForcefieldBreakdown;
import edu.duke.cs.osprey.gmec.ConfAnalyzer;
import edu.duke.cs.osprey.kstar.BBKStar;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.markstar.MARKStarProgress;
import edu.duke.cs.osprey.markstar.framework.MARKStarBoundFastQueues;
import edu.duke.cs.osprey.markstar.framework.MARKStarNode;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.ObjectPool;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class MARKStarBoundAsync
implements PartitionFunction {
    private double targetEpsilon = 1.0;
    private BigDecimal targetEpsilonAsBD = new BigDecimal(this.targetEpsilon);
    public boolean debug = false;
    public boolean profileOutput = false;
    private PartitionFunction.Status status = null;
    private Values values = null;
    private int numConfsEnergied = 0;
    private int maxNumConfs = -1;
    private int numConfsScored = 0;
    private boolean printMinimizedConfs;
    private MARKStarProgress progress;
    public String stateName = String.format("%4f", Math.random());
    private int numPartialMinimizations;
    private ArrayList<Integer> minList;
    private double internalTimeAverage;
    private double leafTimeAverage;
    private double cleanupTime;
    private boolean nonZeroLower;
    private TaskExecutor loopTasks;
    private TaskExecutor correctionTasks;
    private MARKStarNode rootNode;
    private final Queue<MARKStarNode> queue;
    private double epsilonBound = Double.POSITIVE_INFINITY;
    private ConfIndex confIndex;
    public final AStarOrder order;
    public final AStarPruner pruner;
    private RCs RCs;
    private Parallelism parallelism;
    private TaskExecutor internalTasks;
    private TaskExecutor leafTasks;
    private TaskExecutor drillTasks;
    private ObjectPool<ScoreContext> contexts;
    private MARKStarNode.ScorerFactory gscorerFactory;
    private MARKStarNode.ScorerFactory hscorerFactory;
    public static final int MAX_CONFSPACE_FRACTION = 1000000;
    public static final double MINIMIZATION_FACTOR = 0.1;
    public boolean reduceMinimizations = true;
    private ConfAnalyzer confAnalyzer;
    EnergyMatrix minimizingEmat;
    EnergyMatrix rigidEmat;
    UpdatingEnergyMatrix correctionMatrix;
    ConfEnergyCalculator minimizingEcalc = null;
    private Stopwatch stopwatch = new Stopwatch().start();
    BigDecimal cumulativeZCorrection = BigDecimal.ZERO;
    BigDecimal ZReductionFromMin = BigDecimal.ZERO;
    BoltzmannCalculator bc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private boolean computedCorrections = false;
    private long loopPartialTime = 0L;
    private Set<String> correctedTuples = Collections.synchronizedSet(new HashSet());
    private State state;
    private BigDecimal stabilityThreshold;
    BlockingQueue<MARKStarNode> asyncQueue = new PriorityBlockingQueue<MARKStarNode>();
    private double leafTimeSum = 0.0;
    private double internalTimeSum = 0.0;
    private int numLeavesScored = 0;
    private int numInternalScored = 0;
    private double bias = 1.0;

    public void setCorrections(UpdatingEnergyMatrix cachedCorrections) {
        this.correctionMatrix = cachedCorrections;
    }

    public void setRCs(RCs rcs) {
        this.RCs = rcs;
    }

    @Override
    public void setReportProgress(boolean showPfuncProgress) {
        this.printMinimizedConfs = true;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
    }

    @Override
    public void setStabilityThreshold(BigDecimal threshhold) {
        this.stabilityThreshold = threshhold;
    }

    public void setMaxNumConfs(int maxNumConfs) {
        this.maxNumConfs = maxNumConfs;
    }

    @Override
    public void init(double targetEpsilon) {
        this.targetEpsilon = targetEpsilon;
        this.targetEpsilonAsBD = new BigDecimal(targetEpsilon);
        this.status = PartitionFunction.Status.Estimating;
        this.values = new Values();
        this.state = new State(this.RCs.getNumConformations());
    }

    public void init(double epsilon, BigDecimal stabilityThreshold) {
        this.targetEpsilon = epsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = new Values();
        this.state = new State(this.RCs.getNumConformations());
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getParallelism() {
        return 0;
    }

    @Override
    public int getNumConfsEvaluated() {
        return this.numConfsEnergied;
    }

    public int getNumConfsScored() {
        return this.numConfsScored;
    }

    @Override
    public void compute(int maxNumConfs) {
        this.debugPrint("Num conformations: " + String.valueOf(this.rootNode.getConfSearchNode().getNumConformations()));
        double lastEps = 1.0;
        int previousConfCount = this.numConfsEnergied + this.numConfsScored + this.numPartialMinimizations;
        if (!this.nonZeroLower) {
            this.runUntilNonZero();
            this.updateBound();
        }
        while (this.epsilonBound > this.targetEpsilon && (maxNumConfs < 0 || this.numConfsEnergied + this.numConfsScored + this.numPartialMinimizations - previousConfCount < maxNumConfs)) {
            this.debugPrint("Tightening from epsilon of " + this.epsilonBound);
            this.tightenBoundAsyncDirect();
            this.debugPrint("Errorbound is now " + this.epsilonBound);
            if (lastEps < this.epsilonBound && this.epsilonBound - lastEps > 0.01) {
                System.err.println("Error. Bounds got looser.");
            }
            lastEps = this.epsilonBound;
        }
        if (this.epsilonBound > this.targetEpsilon) {
            this.loopTasks.waitForFinish();
            this.minimizingEcalc.tasks.waitForFinish();
        }
        BigDecimal averageReduction = BigDecimal.ZERO;
        int totalMinimizations = this.numConfsEnergied + this.numPartialMinimizations;
        if (totalMinimizations > 0) {
            averageReduction = this.cumulativeZCorrection.divide(new BigDecimal(totalMinimizations), new MathContext(4));
        }
        this.debugPrint(String.format("Average Z reduction per minimization: %12.6e", averageReduction));
        if (this.epsilonBound < this.targetEpsilon) {
            this.status = PartitionFunction.Status.Estimated;
        }
        this.values.qstar = this.rootNode.getLowerBound();
        this.values.pstar = this.rootNode.getUpperBound();
        this.values.qprime = this.rootNode.getUpperBound();
    }

    private void debugPrint(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }

    private void profilePrint(String s) {
        if (this.profileOutput) {
            System.out.println(s);
        }
    }

    @Override
    public void compute() {
        this.compute(Integer.MAX_VALUE);
    }

    @Override
    public PartitionFunction.Result makeResult() {
        PartitionFunction.Result result = new PartitionFunction.Result(this.getStatus(), this.getValues(), this.getNumConfsEvaluated());
        return result;
    }

    public static MARKStarBoundFastQueues makeFromConfSpaceInfo(BBKStar.ConfSpaceInfo info2, RCs rcs) {
        throw new UnsupportedOperationException("MARK* is not yet integrated into BBK*. Coming soon!");
    }

    public MARKStarBoundAsync(SimpleConfSpace confSpace, EnergyMatrix rigidEmat, EnergyMatrix minimizingEmat, ConfEnergyCalculator minimizingConfEcalc, RCs rcs, Parallelism parallelism, BigInteger numConfsBeforePruning) {
        this.state = new State(numConfsBeforePruning);
        this.queue = new PriorityQueue<MARKStarNode>();
        this.minimizingEcalc = minimizingConfEcalc;
        this.gscorerFactory = emats -> new PairwiseGScorer(emats);
        EdgeUpdater updater = new EdgeUpdater();
        this.hscorerFactory = emats -> new MPLPPairwiseHScorer(updater, emats, 50, 0.03);
        this.rootNode = MARKStarNode.makeRoot(confSpace, rigidEmat, minimizingEmat, rcs, this.gscorerFactory.make(minimizingEmat), this.hscorerFactory.make(minimizingEmat), this.gscorerFactory.make(rigidEmat), new TraditionalPairwiseHScorer(new NegatedEnergyMatrix(confSpace, rigidEmat), rcs), true);
        this.confIndex = new ConfIndex(rcs.getNumPos());
        this.minimizingEmat = minimizingEmat;
        this.rigidEmat = rigidEmat;
        this.RCs = rcs;
        this.order = new UpperLowerAStarOrder();
        this.order.setScorers(this.gscorerFactory.make(minimizingEmat), this.hscorerFactory.make(minimizingEmat));
        this.pruner = null;
        this.contexts = new ObjectPool<ScoreContext>(lingored -> {
            ScoreContext context = new ScoreContext();
            context.index = new ConfIndex(rcs.getNumPos());
            context.gscorer = this.gscorerFactory.make(minimizingEmat);
            context.hscorer = this.hscorerFactory.make(minimizingEmat);
            context.rigidscorer = this.gscorerFactory.make(rigidEmat);
            context.negatedhscorer = this.hscorerFactory.make(new NegatedEnergyMatrix(confSpace, rigidEmat));
            context.ecalc = minimizingConfEcalc;
            return context;
        });
        this.progress = new MARKStarProgress(this.RCs.getNumPos());
        this.confAnalyzer = new ConfAnalyzer(minimizingConfEcalc);
        this.setParallelism(parallelism);
        this.updateBound();
        this.minList = new ArrayList<Integer>(Collections.nCopies(rcs.getNumPos(), 0));
    }

    public void setParallelism(Parallelism val) {
        if (val == null) {
            val = Parallelism.makeCpu(1);
        }
        this.parallelism = val;
        this.loopTasks = this.parallelism.makeTaskExecutor(10000);
        this.correctionTasks = this.parallelism.makeTaskExecutor(10000);
        this.contexts.allocate(this.parallelism.getParallelism());
    }

    private void debugEpsilon(double curEpsilon) {
        if (this.debug && curEpsilon < this.epsilonBound) {
            System.err.println("Epsilon just got bigger.");
        }
    }

    private boolean shouldMinimize(MARKStarNode.Node node) {
        return node.getLevel() == this.RCs.getNumPos() && !node.isMinimized();
    }

    private void recordCorrection(double lowerBound, double correction) {
        BigDecimal upper = this.bc.calc(lowerBound);
        BigDecimal corrected = this.bc.calc(lowerBound + correction);
        this.cumulativeZCorrection = this.cumulativeZCorrection.add(upper.subtract(corrected));
    }

    private void recordReduction(double score, double energy) {
        BigDecimal scoreWeight = this.bc.calc(score);
        BigDecimal energyWeight = this.bc.calc(energy);
        this.ZReductionFromMin = this.ZReductionFromMin.add(scoreWeight.subtract(energyWeight));
    }

    private void runUntilNonZero() {
        System.out.println("Running until leaf is found...");
        double bestConfUpper = Double.POSITIVE_INFINITY;
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        ArrayList leafNodes = new ArrayList();
        boolean numNodes = false;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        this.boundLowestBoundConfUnderNode(this.rootNode, newNodes);
        this.queue.addAll(newNodes);
        this.asyncQueue.addAll(newNodes);
        newNodes.clear();
        System.out.println("Found a leaf!");
        this.nonZeroLower = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tightenBoundAsyncDirect() {
        System.out.println(String.format("Current overall error bound: %12.10f, spread of [%12.6e, %12.6e]", this.epsilonBound, this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        List<MARKStarNode> internalNodes = this.state.internalNodes;
        List<MARKStarNode> leafNodes = this.state.leafNodes;
        ArrayList newNodes = new ArrayList();
        BigDecimal internalZ = BigDecimal.ONE;
        BigDecimal leafZ = BigDecimal.ONE;
        int numNodes = 0;
        Stopwatch loopWatch = new Stopwatch();
        loopWatch.start();
        while (!this.asyncQueue.isEmpty() && !((MARKStarNode)this.asyncQueue.peek()).getConfSearchNode().isLeaf()) {
            MARKStarNode internalNode = (MARKStarNode)this.asyncQueue.poll();
            Stopwatch internalTime = new Stopwatch();
            if (!MathTools.isGreaterThan(internalNode.getLowerBound(), BigDecimal.ZERO) && MathTools.isGreaterThan(MathTools.bigDivide(internalNode.getUpperBound(), this.rootNode.getUpperBound(), PartitionFunction.decimalPrecision), new BigDecimal(1.0 - this.targetEpsilon))) {
                this.loopTasks.submit(() -> {
                    internalTime.start();
                    this.boundLowestBoundConfUnderNodeAsync(internalNode);
                    internalTime.stop();
                    return internalTime.getTimeS();
                }, timeS -> {
                    internalNode.markUpdated();
                    this.asyncQueue.addAll(newNodes);
                    this.onFinishedInternal((Double)timeS);
                });
                continue;
            }
            this.loopTasks.submit(() -> {
                internalTime.start();
                this.processPartialConfNodeAsync(internalNode, internalNode.getConfSearchNode());
                internalTime.stop();
                return internalTime.getTimeS();
            }, timeS -> {
                internalNode.markUpdated();
                this.onFinishedInternal((Double)timeS);
            });
        }
        int maxNodes = 1000;
        if (this.leafTimeAverage > 0.0) {
            maxNodes = Math.max(maxNodes, (int)Math.floor(this.leafTimeAverage / this.internalTimeAverage));
        }
        System.out.println("Max nodes is now " + maxNodes);
        this.populateQueuesAsync(this.asyncQueue, maxNodes, 1);
        if (this.epsilonBound <= this.targetEpsilon) {
            return;
        }
        this.debugPrint(String.format("After corrections, bounds are now [%12.6e,%12.6e]", this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        internalZ = this.state.internalZ.multiply(new BigDecimal(this.bias));
        leafZ = this.state.leafZ;
        System.out.println(String.format("Z Comparison: %12.6e, %12.6e, dscore %4.4e, denergy %4.4e", internalZ, leafZ, this.state.dScore, this.state.dEnergy));
        System.out.println("Number of ongoing background corrections: " + this.state.correctingLeaves);
        if (internalNodes.size() >= maxNodes && MathTools.isLessThan(internalZ, leafZ) && this.state.dScore > this.state.dEnergy) {
            numNodes = leafNodes.size();
            System.out.println("Processing " + numNodes + " leaf nodes...");
            int maxLeaves = 1;
            int numLeaves = 0;
            for (MARKStarNode leafNode : leafNodes) {
                if (this.correctedNodeAsync(leafNode, leafNode.getConfSearchNode())) {
                    System.out.println("Corrected node. Not minimizing it this round.");
                    continue;
                }
                if (numLeaves >= maxLeaves) break;
                this.loopTasks.submit(() -> this.processFullConfNodeAsync(leafNode, leafNode.getConfSearchNode()), leafResult -> {
                    leafNode.markUpdated();
                    this.onFinishedLeaf((LeafResult)leafResult);
                });
                leafNode.markUpdated();
                ++numLeaves;
                this.debugPrint("Processing Node: " + leafNode.getConfSearchNode().toString());
            }
            this.state.leafNodes.clear();
            this.state.leafZ = BigDecimal.ZERO;
            this.state.dScore *= 2.0;
            MARKStarBoundAsync mARKStarBoundAsync = this;
            synchronized (mARKStarBoundAsync) {
                this.bias = this.bias < 1.0 ? 1.0 : (this.bias *= 2.0);
                System.out.println("Biasing internal nodes by a factor of " + this.bias);
            }
        }
        numNodes = internalNodes.size();
        if (internalNodes.size() > 1) {
            System.out.println("Processing " + numNodes + " internal nodes...");
            for (MARKStarNode internalNode : internalNodes) {
                RCTuple tuple;
                Stopwatch internalTime = new Stopwatch();
                if (!MathTools.isGreaterThan(internalNode.getLowerBound(), BigDecimal.ZERO) && MathTools.isGreaterThan(MathTools.bigDivide(internalNode.getUpperBound(), this.rootNode.getUpperBound(), PartitionFunction.decimalPrecision), new BigDecimal(1.0 - this.targetEpsilon))) {
                    this.loopTasks.submit(() -> {
                        internalTime.start();
                        this.boundLowestBoundConfUnderNodeAsync(internalNode);
                        internalTime.stop();
                        return internalTime.getTimeS();
                    }, timeS -> {
                        internalNode.markUpdated();
                        this.onFinishedInternal((Double)timeS);
                    });
                } else {
                    this.loopTasks.submit(() -> {
                        internalTime.start();
                        this.processPartialConfNodeAsync(internalNode, internalNode.getConfSearchNode());
                        internalTime.stop();
                        return internalTime.getTimeS();
                    }, timeS -> {
                        internalNode.markUpdated();
                        this.onFinishedInternal((Double)timeS);
                    });
                }
                internalNode.markUpdated();
                if (this.state.corrections.isEmpty() || (tuple = this.state.corrections.poll()) == null) continue;
                this.correctionTasks.submit(() -> {
                    System.out.println("Submit correction for " + tuple.stringListing());
                    this.computeDifference(tuple, this.minimizingEcalc);
                    return null;
                }, ignored -> {});
            }
        }
        MARKStarBoundAsync mARKStarBoundAsync = this;
        synchronized (mARKStarBoundAsync) {
            this.bias = this.bias > 1.0 ? 1.0 : (this.bias /= 2.0);
            System.out.println("Biasing internal nodes by a factor of " + this.bias);
        }
        internalNodes.clear();
        this.state.internalZ = BigDecimal.ZERO;
        this.state.dEnergy *= 2.0;
        if (this.epsilonBound <= this.targetEpsilon) {
            return;
        }
        this.loopCleanupAsync(loopWatch, numNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishedLeaf(LeafResult result) {
        MARKStarBoundAsync mARKStarBoundAsync = this;
        synchronized (mARKStarBoundAsync) {
            ConfSearch.ScoredConf conf = result.conf;
            double energy = result.energy;
            MARKStarNode.Node node = result.node;
            double timeS = result.timeS;
            double newConfLower = result.newConfLower;
            double oldgscore = result.oldgscore;
            ++this.numConfsEnergied;
            this.minList.set(conf.getAssignments().length - 1, this.minList.get(conf.getAssignments().length - 1) + 1);
            this.recordReduction(conf.getScore(), energy);
            this.leafTimeSum += timeS;
            ++this.numLeavesScored;
            this.leafTimeAverage = this.leafTimeSum / (double)this.numLeavesScored;
            System.out.println("Processed leaf in " + timeS + " seconds.");
            this.profilePrint("Leaf time average is now " + this.leafTimeAverage);
            double delta = this.epsilonBound;
            this.updateBound();
            this.printMinimizationOutput(node, newConfLower, oldgscore);
            this.state.dEnergy = this.epsilonBound - delta;
            if (this.state.dEnergy == 0.0) {
                this.state.dEnergy = this.state.dScore / 10.0;
            }
            System.out.println("dEnergy set to " + this.state.dEnergy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFinishedInternal(Double timeS) {
        MARKStarBoundAsync mARKStarBoundAsync = this;
        synchronized (mARKStarBoundAsync) {
            double curDelta = this.epsilonBound;
            this.updateBound();
            this.state.dScore = this.epsilonBound - curDelta;
            ++this.numInternalScored;
            this.internalTimeSum += timeS.doubleValue();
            this.internalTimeAverage = this.internalTimeSum / (double)this.numInternalScored;
        }
    }

    private boolean correctedNodeAsync(MARKStarNode curNode, MARKStarNode.Node node) {
        assert (curNode != null && node != null);
        double confCorrection = this.correctionMatrix.confE(node.assignments);
        if (node.getConfLowerBound() < confCorrection || node.gscore < confCorrection) {
            double oldg = node.gscore;
            node.gscore = confCorrection;
            this.recordCorrection(oldg, confCorrection - oldg);
            node.setBoundsFromConfLowerAndUpper(confCorrection, node.rigidScore);
            curNode.markUpdated();
            this.asyncQueue.add(curNode);
            return true;
        }
        return false;
    }

    private void populateQueuesAsync(BlockingQueue<MARKStarNode> queue, int maxNodes, int maxMinimizations) {
        ArrayList<MARKStarNode> leftoverLeaves = new ArrayList<MARKStarNode>();
        List<MARKStarNode> internalNodes = this.state.internalNodes;
        List<MARKStarNode> leafNodes = this.state.leafNodes;
        while (!(queue.isEmpty() || internalNodes.size() >= maxNodes && leafNodes.size() >= maxMinimizations)) {
            MARKStarNode curNode = (MARKStarNode)queue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.RCs.getNumPos());
            node.index(index);
            double correctgscore = this.correctionMatrix.confE(node.assignments);
            double hscore = node.getConfLowerBound() - node.gscore;
            double confCorrection = Math.min(correctgscore, node.rigidScore) + hscore;
            if (!node.isMinimized() && node.getConfLowerBound() - confCorrection > 1.0E-5) {
                this.recordCorrection(node.getConfLowerBound(), correctgscore - node.gscore);
                node.gscore = correctgscore;
                if (confCorrection > node.rigidScore) {
                    System.out.println("Overcorrected" + SimpleConfSpace.formatConfRCs(node.assignments) + ": " + confCorrection + " > " + node.rigidScore);
                    node.gscore = node.rigidScore;
                    confCorrection = node.rigidScore + hscore;
                }
                node.setBoundsFromConfLowerAndUpper(confCorrection, node.getConfUpperBound());
                curNode.markUpdated();
                leftoverLeaves.add(curNode);
                continue;
            }
            BigDecimal diff = curNode.getUpperBound().subtract(curNode.getLowerBound());
            if (node.getLevel() < this.RCs.getNumPos() && internalNodes.size() < maxNodes) {
                if (internalNodes.size() < maxNodes) {
                    internalNodes.add(curNode);
                    this.state.internalZ = this.state.internalZ.add(diff);
                    continue;
                }
                leftoverLeaves.add(curNode);
                continue;
            }
            if (!this.shouldMinimize(node) || this.correctedNode(leftoverLeaves, curNode, node)) continue;
            if (leafNodes.size() < maxMinimizations) {
                leafNodes.add(curNode);
                this.state.leafZ = this.state.leafZ.add(diff);
                continue;
            }
            leftoverLeaves.add(curNode);
        }
        queue.addAll(leftoverLeaves);
    }

    private void boundLowestBoundConfUnderNodeAsync(MARKStarNode startNode) {
        Comparator<MARKStarNode> confBoundComparator = Comparator.comparingDouble(o -> o.getConfSearchNode().getConfLowerBound());
        PriorityQueue<MARKStarNode> drillQueue = new PriorityQueue<MARKStarNode>(confBoundComparator);
        drillQueue.add(startNode);
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        int numNodes = 0;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        while (!drillQueue.isEmpty()) {
            ++numNodes;
            MARKStarNode curNode = drillQueue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.RCs.getNumPos());
            node.index(index);
            if (node.getLevel() < this.RCs.getNumPos()) {
                MARKStarNode nextNode = this.drillDown(newNodes, curNode, node);
                newNodes.remove(nextNode);
                drillQueue.add(nextNode);
            } else {
                newNodes.add(curNode);
            }
            if (!(leafLoop.getTimeS() > 10.0)) continue;
            leafLoop.stop();
            leafLoop.reset();
            leafLoop.start();
            System.out.println(String.format("Processed %d, %s so far. Bounds are now [%12.6e,%12.6e]", numNodes, overallLoop.getTime(2), this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        }
        this.asyncQueue.addAll(newNodes);
    }

    private void preminimizePartialAsync(MARKStarNode startNode) {
        if (MathTools.isGreaterThan(MathTools.bigDivide(startNode.getUpperBound(), this.rootNode.getUpperBound(), PartitionFunction.decimalPrecision), new BigDecimal((1.0 - this.targetEpsilon) / 100000.0))) {
            double lower;
            RCTuple confTuple = startNode.toTuple();
            if (confTuple.size() + 1 < this.RCs.getNumPos()) {
                return;
            }
            double threshhold = 0.5;
            double rigid = this.rigidEmat.getInternalEnergy(confTuple);
            if (rigid - (lower = this.minimizingEmat.getInternalEnergy(confTuple)) > threshhold) {
                this.computeTupleCorrection(this.minimizingEcalc, startNode.toTuple());
            }
        }
    }

    private void loopCleanupAsync(Stopwatch loopWatch, int numNodes) {
        loopWatch.stop();
        double loopTime = loopWatch.getTimeS();
        loopWatch.reset();
        loopWatch.start();
        double curEpsilon = this.epsilonBound;
        loopWatch.stop();
        this.cleanupTime = loopWatch.getTimeS();
    }

    private void processPartialConfNodeAsync(MARKStarNode curNode, MARKStarNode.Node node) {
        try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
            ScoreContext context = checkout.get();
            ConfIndex confIndex = context.index;
            node.index(confIndex);
            int nextPos = this.order.getNextPos(confIndex, this.RCs);
            assert (!confIndex.isDefined(nextPos));
            assert (confIndex.isUndefined(nextPos));
            ArrayList<MARKStarNode> children = new ArrayList<MARKStarNode>();
            for (int nextRc : this.RCs.get(nextPos)) {
                MARKStarNode MARKStarNodeChild;
                if (this.hasPrunedPair(confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
                Stopwatch partialTime = new Stopwatch().start();
                node.index(context.index);
                MARKStarNode.Node child = node.assign(nextPos, nextRc);
                if (child.getLevel() < this.RCs.getNumPos()) {
                    double confCorrection;
                    double diff = confCorrection = this.correctionMatrix.confE(child.assignments);
                    double rigiddiff = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double hdiff = context.hscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double maxhdiff = -context.negatedhscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    child.gscore = diff;
                    child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                    double confLowerBound = child.gscore + hdiff;
                    double confUpperbound = rigiddiff + maxhdiff;
                    child.computeNumConformations(this.RCs);
                    double lowerbound = this.minimizingEmat.confE(child.assignments);
                    if (diff < confCorrection) {
                        this.recordCorrection(confLowerBound, confCorrection - diff);
                        confLowerBound = confCorrection + hdiff;
                    }
                    child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                    this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.epsilonBound);
                }
                if (child.getLevel() == this.RCs.getNumPos()) {
                    double confRigid = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    confRigid = confRigid - node.gscore + node.rigidScore;
                    child.computeNumConformations(this.RCs);
                    double confCorrection = this.correctionMatrix.confE(child.assignments);
                    double lowerbound = this.minimizingEmat.confE(child.assignments);
                    if (lowerbound < confCorrection) {
                        this.recordCorrection(lowerbound, confCorrection - lowerbound);
                    }
                    this.checkBounds(confCorrection, confRigid);
                    child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                    child.gscore = child.getConfLowerBound();
                    child.rigidScore = confRigid;
                    ++this.numConfsScored;
                    this.progress.reportLeafNode(child.gscore, this.queue.size(), this.epsilonBound);
                }
                partialTime.stop();
                this.loopPartialTime = (long)((double)this.loopPartialTime + partialTime.getTimeS());
                if (Double.isNaN(child.rigidScore)) {
                    System.out.println("Huh!?");
                }
                if ((MARKStarNodeChild = curNode.makeChild(child)).getConfSearchNode().getConfLowerBound() < 0.0) {
                    children.add(MARKStarNodeChild);
                }
                if (!child.isMinimized()) {
                    this.asyncQueue.add(MARKStarNodeChild);
                    continue;
                }
                MARKStarNodeChild.computeEpsilonErrorBounds();
            }
            curNode.markUpdated();
        }
    }

    private LeafResult processFullConfNodeAsync(MARKStarNode curNode, MARKStarNode.Node node) {
        double leafTime = 0.0;
        LeafResult result = new LeafResult(this);
        try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
            double energy;
            ScoreContext context = checkout.get();
            node.index(context.index);
            Stopwatch leafTimer = new Stopwatch().start();
            ConfSearch.ScoredConf conf = new ConfSearch.ScoredConf(node.assignments, node.getConfLowerBound());
            ConfAnalyzer.ConfAnalysis analysis = this.confAnalyzer.analyze(conf);
            Stopwatch correctionTimer = new Stopwatch().start();
            double newConfUpper = energy = analysis.epmol.energy;
            double newConfLower = energy;
            this.checkConfLowerBound(node, energy);
            if (energy > node.getConfUpperBound()) {
                System.err.println("Upper bounds got worse after minimization:" + energy + " > " + node.getConfUpperBound() + ". Rejecting minimized energy.");
                System.err.println("Node info: " + String.valueOf(node));
                newConfUpper = node.getConfUpperBound();
                newConfLower = node.getConfUpperBound();
            }
            curNode.setBoundsFromConfLowerAndUpper(newConfLower, newConfUpper);
            double oldgscore = node.gscore;
            node.gscore = newConfLower;
            String out = "Energy = " + String.format("%6.3e", energy) + ", [" + node.getConfLowerBound() + "," + node.getConfUpperBound() + "]";
            this.debugPrint(out);
            leafTimer.stop();
            this.computeEnergyCorrection(analysis, conf);
            curNode.markUpdated();
            leafTime = leafTimer.getTimeS();
            result.conf = conf;
            result.node = node;
            result.newConfLower = newConfLower;
            result.oldgscore = oldgscore;
            result.energy = energy;
            result.timeS = leafTime;
        }
        this.progress.reportLeafNode(node.gscore, this.queue.size(), this.epsilonBound);
        if (!node.isMinimized()) {
            this.asyncQueue.add(curNode);
        }
        return result;
    }

    private boolean correctedNode(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        assert (curNode != null && node != null);
        double confCorrection = this.correctionMatrix.confE(node.assignments);
        if (node.getConfLowerBound() < confCorrection || node.gscore < confCorrection) {
            double oldg = node.gscore;
            node.gscore = confCorrection;
            this.recordCorrection(oldg, confCorrection - oldg);
            node.setBoundsFromConfLowerAndUpper(confCorrection, node.rigidScore);
            curNode.markUpdated();
            newNodes.add(curNode);
            return true;
        }
        return false;
    }

    private MARKStarNode drillDown(List<MARKStarNode> newNodes, MARKStarNode curNode, MARKStarNode.Node node) {
        try (ObjectPool.Checkout<ScoreContext> checkout = this.contexts.autoCheckout();){
            ScoreContext context = checkout.get();
            ConfIndex confIndex = context.index;
            node.index(confIndex);
            int nextPos = this.order.getNextPos(confIndex, this.RCs);
            assert (!confIndex.isDefined(nextPos));
            assert (confIndex.isUndefined(nextPos));
            ArrayList<MARKStarNode> children = new ArrayList<MARKStarNode>();
            double bestChildLower = Double.POSITIVE_INFINITY;
            MARKStarNode bestChild = null;
            for (int nextRc : this.RCs.get(nextPos)) {
                if (this.hasPrunedPair(confIndex, nextPos, nextRc) || this.pruner != null && this.pruner.isPruned(node, nextPos, nextRc)) continue;
                Stopwatch partialTime = new Stopwatch().start();
                MARKStarNode.Node child = node.assign(nextPos, nextRc);
                double confLowerBound = Double.POSITIVE_INFINITY;
                if (child.getLevel() < this.RCs.getNumPos()) {
                    double confCorrection;
                    double diff = confCorrection = this.correctionMatrix.confE(child.assignments);
                    double rigiddiff = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double hdiff = context.hscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    double maxhdiff = -context.negatedhscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    child.gscore = diff;
                    child.rigidScore = rigiddiff = rigiddiff - node.gscore + node.rigidScore;
                    confLowerBound = child.gscore + hdiff;
                    double confUpperbound = rigiddiff + maxhdiff;
                    child.computeNumConformations(this.RCs);
                    double lowerbound = this.minimizingEmat.confE(child.assignments);
                    if (diff < confCorrection) {
                        this.recordCorrection(confLowerBound, confCorrection - diff);
                        confLowerBound = confCorrection + hdiff;
                    }
                    child.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperbound);
                    this.progress.reportInternalNode(child.level, child.gscore, child.getHScore(), this.queue.size(), children.size(), this.epsilonBound);
                }
                if (child.getLevel() == this.RCs.getNumPos()) {
                    double confRigid = context.rigidscorer.calcDifferential(context.index, this.RCs, nextPos, nextRc);
                    confRigid = confRigid - node.gscore + node.rigidScore;
                    child.computeNumConformations(this.RCs);
                    double confCorrection = this.correctionMatrix.confE(child.assignments);
                    double lowerbound = this.minimizingEmat.confE(child.assignments);
                    if (lowerbound < confCorrection) {
                        this.recordCorrection(lowerbound, confCorrection - lowerbound);
                    }
                    this.checkBounds(confCorrection, confRigid);
                    child.setBoundsFromConfLowerAndUpper(confCorrection, confRigid);
                    child.gscore = child.getConfLowerBound();
                    confLowerBound = lowerbound;
                    child.rigidScore = confRigid;
                    ++this.numConfsScored;
                    this.progress.reportLeafNode(child.gscore, this.queue.size(), this.epsilonBound);
                }
                partialTime.stop();
                this.loopPartialTime = (long)((double)this.loopPartialTime + partialTime.getTimeS());
                if (Double.isNaN(child.rigidScore)) {
                    System.out.println("Huh!?");
                }
                MARKStarNode MARKStarNodeChild = curNode.makeChild(child);
                MARKStarNodeChild.markUpdated();
                if (confLowerBound < bestChildLower) {
                    bestChild = MARKStarNodeChild;
                }
                if (MARKStarNodeChild.getConfSearchNode().getConfLowerBound() < 0.0) {
                    children.add(MARKStarNodeChild);
                }
                newNodes.add(MARKStarNodeChild);
            }
            int[] nArray = bestChild;
            return nArray;
        }
    }

    private void boundLowestBoundConfUnderNode(MARKStarNode startNode, List<MARKStarNode> generatedNodes) {
        Comparator<MARKStarNode> confBoundComparator = Comparator.comparingDouble(o -> o.getConfSearchNode().getConfLowerBound());
        PriorityQueue<MARKStarNode> drillQueue = new PriorityQueue<MARKStarNode>(confBoundComparator);
        drillQueue.add(startNode);
        ArrayList<MARKStarNode> newNodes = new ArrayList<MARKStarNode>();
        int numNodes = 0;
        Stopwatch leafLoop = new Stopwatch().start();
        Stopwatch overallLoop = new Stopwatch().start();
        while (!drillQueue.isEmpty()) {
            ++numNodes;
            MARKStarNode curNode = drillQueue.poll();
            MARKStarNode.Node node = curNode.getConfSearchNode();
            ConfIndex index = new ConfIndex(this.RCs.getNumPos());
            node.index(index);
            if (node.getLevel() < this.RCs.getNumPos()) {
                MARKStarNode nextNode = this.drillDown(newNodes, curNode, node);
                newNodes.remove(nextNode);
                drillQueue.add(nextNode);
            } else {
                newNodes.add(curNode);
            }
            if (!(leafLoop.getTimeS() > 10.0)) continue;
            leafLoop.stop();
            leafLoop.reset();
            leafLoop.start();
            System.out.println(String.format("Processed %d, %s so far. Bounds are now [%12.6e,%12.6e]", numNodes, overallLoop.getTime(2), this.rootNode.getLowerBound(), this.rootNode.getUpperBound()));
        }
        generatedNodes.addAll(newNodes);
    }

    private void printMinimizationOutput(MARKStarNode.Node node, double newConfLower, double oldgscore) {
        if (this.printMinimizedConfs) {
            System.out.println("[" + SimpleConfSpace.formatConfRCs(node.assignments) + "]" + String.format("conf:%4d, score:%12.6f, lower:%12.6f, corrected:%12.6f energy:%12.6f, bounds:[%12e, %12e], delta:%12.6f, time:%10s", this.numConfsEnergied, oldgscore, this.minimizingEmat.confE(node.assignments), this.correctionMatrix.confE(node.assignments), newConfLower, this.rootNode.getConfSearchNode().getSubtreeLowerBound(), this.rootNode.getConfSearchNode().getSubtreeUpperBound(), this.epsilonBound, this.stopwatch.getTime(2)));
        }
    }

    private void checkConfLowerBound(MARKStarNode.Node node, double energy) {
        if (energy < node.getConfLowerBound()) {
            System.err.println("Bounds are incorrect:" + node.getConfLowerBound() + " > " + energy);
            if (energy < 10.0) {
                System.err.println("The bounds are probably wrong.");
            }
        }
    }

    private void checkBounds(double lower, double upper) {
        if (upper < lower && upper - lower > 1.0E-5 && upper < 10.0) {
            this.debugPrint("Bounds incorrect.");
        }
    }

    private void computeEnergyCorrection(ConfAnalyzer.ConfAnalysis analysis, ConfSearch.ScoredConf conf) {
        if (conf.getAssignments().length < 3) {
            return;
        }
        EnergyMatrix energyAnalysis = analysis.breakdownEnergyByPosition(ResidueForcefieldBreakdown.Type.All);
        EnergyMatrix scoreAnalysis = analysis.breakdownScoreByPosition(this.minimizingEmat);
        Stopwatch correctionTime = new Stopwatch().start();
        EnergyMatrix diff = energyAnalysis.diff(scoreAnalysis);
        ArrayList<TupE> sortedPairwiseTerms2 = new ArrayList<TupE>();
        for (int pos = 0; pos < diff.getNumPos(); ++pos) {
            for (int rc = 0; rc < diff.getNumConfAtPos(pos); ++rc) {
                for (int pos2 = 0; pos2 < diff.getNumPos(); ++pos2) {
                    for (int rc2 = 0; rc2 < diff.getNumConfAtPos(pos2); ++rc2) {
                        if (pos >= pos2) continue;
                        double sum = 0.0;
                        sum += diff.getOneBody(pos, rc).doubleValue();
                        sum += diff.getPairwise(pos, rc, pos2, rc2).doubleValue();
                        TupE tupe = new TupE(new RCTuple(pos, rc, pos2, rc2), sum += diff.getOneBody(pos2, rc2).doubleValue());
                        sortedPairwiseTerms2.add(tupe);
                    }
                }
            }
        }
        Collections.sort(sortedPairwiseTerms2);
        double threshhold = 0.1;
        double minDifference = 0.9;
        double maxDiff = ((TupE)sortedPairwiseTerms2.get((int)0)).E;
        for (int i = 0; i < sortedPairwiseTerms2.size(); ++i) {
            TupE tupe = (TupE)sortedPairwiseTerms2.get(i);
            double pairDiff = tupe.E;
            if (pairDiff < minDifference || maxDiff - pairDiff > threshhold) continue;
            maxDiff = Math.max(maxDiff, tupe.E);
            int pos1 = tupe.tup.pos.get(0);
            int pos2 = tupe.tup.pos.get(1);
            int localMinimizations = 0;
            for (int pos3 = 0; pos3 < diff.getNumPos(); ++pos3) {
                if (pos3 == pos2 || pos3 == pos1) continue;
                RCTuple tuple = this.makeTuple(conf, pos1, pos2, pos3);
                double tupleBounds = this.rigidEmat.getInternalEnergy(tuple) - this.minimizingEmat.getInternalEnergy(tuple);
                if (tupleBounds < minDifference) continue;
                this.computeDifference(tuple, this.minimizingEcalc);
                this.minList.set(tuple.size() - 1, this.minList.get(tuple.size() - 1) + 1);
                ++localMinimizations;
            }
            this.numPartialMinimizations += localMinimizations;
            this.progress.reportPartialMinimization(localMinimizations, this.epsilonBound);
        }
        correctionTime.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDifference(RCTuple tuple, ConfEnergyCalculator ecalc) {
        this.computedCorrections = true;
        if (this.correctedTuples.contains(tuple.stringListing())) {
            return;
        }
        this.correctedTuples.add(tuple.stringListing());
        if (this.correctionMatrix.hasHigherOrderTermFor(tuple)) {
            return;
        }
        MARKStarBoundAsync mARKStarBoundAsync = this;
        synchronized (mARKStarBoundAsync) {
            ++this.state.correctingLeaves;
        }
        double tripleEnergy = this.minimizingEcalc.calcEnergy((RCTuple)tuple).energy;
        double lowerbound = this.minimizingEmat.getInternalEnergy(tuple);
        if (tripleEnergy - lowerbound > 0.0) {
            double correction = tripleEnergy - lowerbound;
            this.correctionMatrix.setHigherOrder(tuple, correction);
        } else {
            System.err.println("Negative correction for " + tuple.stringListing());
        }
        MARKStarBoundAsync mARKStarBoundAsync2 = this;
        synchronized (mARKStarBoundAsync2) {
            --this.state.correctingLeaves;
        }
    }

    private RCTuple makeTuple(ConfSearch.ScoredConf conf, int ... positions) {
        RCTuple out = new RCTuple();
        for (int pos : positions) {
            out = out.addRC(pos, conf.getAssignments()[pos]);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeTupleCorrection(ConfEnergyCalculator ecalc, RCTuple overlap) {
        if (this.correctionMatrix.hasHigherOrderTermFor(overlap)) {
            return;
        }
        double pairwiseLower = this.minimizingEmat.getInternalEnergy(overlap);
        double partiallyMinimizedLower = ecalc.calcEnergy((RCTuple)overlap).energy;
        System.out.println("Computing correction for " + overlap.stringListing() + " penalty of " + (partiallyMinimizedLower - pairwiseLower));
        this.progress.reportPartialMinimization(1, this.epsilonBound);
        if (partiallyMinimizedLower > pairwiseLower) {
            UpdatingEnergyMatrix updatingEnergyMatrix = this.correctionMatrix;
            synchronized (updatingEnergyMatrix) {
                this.correctionMatrix.setHigherOrder(overlap, partiallyMinimizedLower - pairwiseLower);
            }
        }
        this.progress.reportPartialMinimization(1, this.epsilonBound);
    }

    private List<MARKStarNode> getTopConfs(int numConfs) {
        ArrayList<MARKStarNode> topConfs = new ArrayList<MARKStarNode>();
        while (topConfs.size() < numConfs && !this.queue.isEmpty()) {
            MARKStarNode nextLowestConf = this.queue.poll();
            topConfs.add(nextLowestConf);
        }
        return topConfs;
    }

    private RCTuple findLargestOverlap(RCTuple conf, List<MARKStarNode> otherConfs, int minResidues) {
        MARKStarNode other;
        RCTuple overlap = conf;
        Iterator<MARKStarNode> iterator2 = otherConfs.iterator();
        while (iterator2.hasNext() && (overlap = overlap.intersect((other = iterator2.next()).toTuple())).size() >= minResidues) {
        }
        return overlap;
    }

    private void updateBound() {
        double curEpsilon = this.epsilonBound;
        Stopwatch time = new Stopwatch().start();
        this.epsilonBound = this.rootNode.computeEpsilonErrorBounds();
        time.stop();
        this.debugEpsilon(curEpsilon);
    }

    private boolean hasPrunedPair(ConfIndex confIndex, int nextPos, int nextRc) {
        PruningMatrix pmat = this.RCs.getPruneMat();
        if (pmat == null) {
            return false;
        }
        for (int i = 0; i < confIndex.numDefined; ++i) {
            int pos = confIndex.definedPos[i];
            int rc = confIndex.definedRCs[i];
            assert (pos != nextPos || rc != nextRc);
            if (!pmat.getPairwise(pos, rc, nextPos, nextRc).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static class Values
    extends PartitionFunction.Values {
        public Values() {
            this.pstar = MathTools.BigPositiveInfinity;
        }

        @Override
        public BigDecimal calcUpperBound() {
            return this.pstar;
        }

        @Override
        public BigDecimal calcLowerBound() {
            return this.qstar;
        }

        @Override
        public double getEffectiveEpsilon() {
            return MathTools.bigDivide(this.pstar.subtract(this.qstar), this.pstar, PartitionFunction.decimalPrecision).doubleValue();
        }
    }

    private static class State {
        public Queue<RCTuple> corrections = new LinkedBlockingQueue<RCTuple>();
        int correctingLeaves;
        BigDecimal numConfs;
        long numScoredConfs = 0L;
        BigDecimal upperScoreWeightSum = BigDecimal.ZERO;
        BigDecimal minUpperScoreWeight = MathTools.BigPositiveInfinity;
        long numEnergiedConfs = 0L;
        BigDecimal lowerScoreWeightSum = BigDecimal.ZERO;
        BigDecimal energyWeightSum = BigDecimal.ZERO;
        BigDecimal minLowerScoreWeight = MathTools.BigPositiveInfinity;
        BigDecimal cumulativeZReduction = BigDecimal.ZERO;
        ArrayList<Integer> minList = new ArrayList();
        List<MARKStarNode> internalNodes = new ArrayList<MARKStarNode>();
        List<MARKStarNode> leafNodes = new ArrayList<MARKStarNode>();
        BigDecimal internalZ = BigDecimal.ZERO;
        BigDecimal leafZ = BigDecimal.ZERO;
        double scoreOps = 100.0;
        double energyOps = 1.0;
        double prevDelta = 1.0;
        double dEnergy = -1.0;
        double dScore = -1.0;

        State(BigInteger numConfs) {
            this.numConfs = new BigDecimal(numConfs);
        }

        double calcDelta() {
            BigDecimal upperBound = this.getUpperBound();
            if (MathTools.isZero(upperBound) || MathTools.isInf(upperBound)) {
                return 1.0;
            }
            return new BigMath(PartitionFunction.decimalPrecision).set(upperBound).sub(this.getLowerBound()).div(upperBound).get().doubleValue();
        }

        public BigDecimal getLowerBound() {
            return this.lowerScoreWeightSum;
        }

        public void printBoundStats() {
            System.out.println("Num confs: " + String.format("%12e", this.numConfs));
            System.out.println("Num Scored confs: " + String.format("%4d", this.numScoredConfs));
            String upperScoreString = this.minUpperScoreWeight.toString();
            String upperSumString = this.upperScoreWeightSum.toString();
            if (!MathTools.isInf(this.minUpperScoreWeight)) {
                upperScoreString = String.format("%12e", this.minUpperScoreWeight);
            }
            if (!MathTools.isInf(this.upperScoreWeightSum)) {
                upperSumString = String.format("%12e", this.upperScoreWeightSum);
            }
            System.out.println("Conf bound: " + upperScoreString);
            System.out.println("Scored weight bound:" + upperSumString);
        }

        public BigDecimal getUpperBound() {
            return this.upperScoreWeightSum;
        }

        boolean epsilonReached(double targetEpsilon) {
            return this.calcDelta() <= targetEpsilon;
        }

        boolean isStable(BigDecimal stabilityThreshold) {
            return this.numEnergiedConfs <= 0L || stabilityThreshold == null || MathTools.isGreaterThanOrEqual(this.getUpperBound(), stabilityThreshold);
        }

        boolean hasLowEnergies() {
            return MathTools.isGreaterThan(this.minLowerScoreWeight, BigDecimal.ZERO);
        }

        public String toString() {
            return String.format("upper: count %d  sum %e  min %e     lower: count %d  score sum %e  energy sum %e", this.numScoredConfs, this.upperScoreWeightSum, this.minUpperScoreWeight, this.numEnergiedConfs, this.lowerScoreWeightSum, this.energyWeightSum);
        }
    }

    private class LeafResult {
        public ConfSearch.ScoredConf conf;
        public double oldgscore;
        public double energy;
        public MARKStarNode.Node node;
        public double newConfLower;
        public double timeS;

        private LeafResult(MARKStarBoundAsync mARKStarBoundAsync) {
        }
    }

    private static class ScoreContext {
        public ConfIndex index;
        public AStarScorer gscorer;
        public AStarScorer hscorer;
        public AStarScorer negatedhscorer;
        public AStarScorer rigidscorer;
        public ConfEnergyCalculator ecalc;

        private ScoreContext() {
        }
    }

    private static class CorrectionData {
        ConfAnalyzer.ConfAnalysis analysis;
        ConfSearch.ScoredConf conf;

        private CorrectionData() {
        }
    }
}

