/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimplerEnergyMatrixCalculator;
import edu.duke.cs.osprey.ematrix.UpdatingEnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.KStarScoreWriter;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.markstar.framework.MARKStarBoundFastQueues;
import edu.duke.cs.osprey.parallelism.Parallelism;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MARKStar {
    public final ConfSpaceInfo protein;
    public final ConfSpaceInfo ligand;
    public final ConfSpaceInfo complex;
    public final EnergyCalculator rigidEcalc;
    public final EnergyCalculator minimizingEcalc;
    public final ConfEnergyCalculatorFactory confEcalcFactory;
    public final Settings settings;
    private List<Sequence> sequences;

    public MARKStar(SimpleConfSpace protein, SimpleConfSpace ligand, SimpleConfSpace complex, EnergyCalculator rigidEcalc, EnergyCalculator minimizingEcalc, ConfEnergyCalculatorFactory confEcalcFactory, Settings settings) {
        this.protein = new ConfSpaceInfo(ConfSpaceType.Protein, protein, confEcalcFactory.make(protein, rigidEcalc), confEcalcFactory.make(protein, minimizingEcalc));
        this.ligand = new ConfSpaceInfo(ConfSpaceType.Ligand, ligand, confEcalcFactory.make(ligand, rigidEcalc), confEcalcFactory.make(ligand, minimizingEcalc));
        this.complex = new ConfSpaceInfo(ConfSpaceType.Complex, complex, confEcalcFactory.make(complex, rigidEcalc), confEcalcFactory.make(complex, minimizingEcalc));
        this.rigidEcalc = rigidEcalc;
        this.minimizingEcalc = minimizingEcalc;
        this.confEcalcFactory = confEcalcFactory;
        this.settings = settings;
        this.sequences = new ArrayList<Sequence>();
    }

    public void precalcEmats() {
        this.protein.calcEmats();
        this.ligand.calcEmats();
        this.complex.calcEmats();
    }

    public List<ScoredSequence> run() {
        ArrayList<ScoredSequence> scores = new ArrayList<ScoredSequence>();
        this.protein.calcEmats();
        this.ligand.calcEmats();
        this.complex.calcEmats();
        if (this.complex.confSpace.seqSpace.containsWildTypeSequence()) {
            this.sequences.add(this.complex.confSpace.seqSpace.makeWildTypeSequence());
        }
        this.sequences.addAll(this.complex.confSpace.seqSpace.getMutants(this.settings.maxSimultaneousMutations, true));
        int n = this.sequences.size();
        Scorer scorer = (sequenceNumber, proteinResult, ligandResult, complexResult) -> {
            KStarScore kstarScore = new KStarScore(proteinResult, ligandResult, complexResult);
            Sequence sequence = this.sequences.get(sequenceNumber);
            scores.add(new ScoredSequence(sequence, kstarScore));
            this.settings.scoreWriters.writeScore(new KStarScoreWriter.ScoreInfo(sequenceNumber, n, sequence, kstarScore));
            return kstarScore;
        };
        System.out.println("computing K* scores for " + this.sequences.size() + " sequences to epsilon = " + this.settings.epsilon + " ...");
        this.settings.scoreWriters.writeHeader();
        KStarScore wildTypeScore = scorer.score(0, this.protein.calcPfunc(0, BigDecimal.ZERO), this.ligand.calcPfunc(0, BigDecimal.ZERO), this.complex.calcPfunc(0, BigDecimal.ZERO));
        BigDecimal proteinStabilityThreshold = null;
        BigDecimal ligandStabilityThreshold = null;
        if (this.settings.stabilityThreshold != null) {
            BigDecimal stabilityThresholdFactor = new BoltzmannCalculator(PartitionFunction.decimalPrecision).calc(this.settings.stabilityThreshold);
            proteinStabilityThreshold = wildTypeScore.protein.values.calcLowerBound().multiply(stabilityThresholdFactor);
            ligandStabilityThreshold = wildTypeScore.ligand.values.calcLowerBound().multiply(stabilityThresholdFactor);
        }
        for (int i = 1; i < n; ++i) {
            PartitionFunction.Result complexResult2;
            PartitionFunction.Result ligandResult2;
            PartitionFunction.Result proteinResult2 = this.protein.calcPfunc(i, proteinStabilityThreshold);
            if (!KStarScore.isLigandComplexUseful(proteinResult2)) {
                ligandResult2 = PartitionFunction.Result.makeAborted();
                complexResult2 = PartitionFunction.Result.makeAborted();
            } else {
                ligandResult2 = this.ligand.calcPfunc(i, ligandStabilityThreshold);
                complexResult2 = !KStarScore.isComplexUseful(proteinResult2, ligandResult2) ? PartitionFunction.Result.makeAborted() : this.complex.calcPfunc(i, BigDecimal.ZERO);
            }
            scorer.score(i, proteinResult2, ligandResult2, complexResult2);
        }
        return scores;
    }

    public Iterable<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein, this.ligand, this.complex);
    }

    public class ConfSpaceInfo {
        public final ConfSpaceType type;
        public final SimpleConfSpace confSpace;
        public final ConfEnergyCalculator rigidConfEcalc;
        public final ConfEnergyCalculator minimizingConfEcalc;
        public UpdatingEnergyMatrix correctionEmat;
        public ConfSearchFactory confSearchFactory = null;
        public File confDBFile = null;
        public EnergyMatrix rigidEmat = null;
        public EnergyMatrix minimizingEmat = null;
        public final Map<Sequence, PartitionFunction.Result> pfuncResults = new HashMap<Sequence, PartitionFunction.Result>();

        public ConfSpaceInfo(ConfSpaceType type, SimpleConfSpace confSpace, ConfEnergyCalculator rigidConfEcalc, ConfEnergyCalculator minimizingConfEcalc) {
            this.type = type;
            this.confSpace = confSpace;
            this.rigidConfEcalc = rigidConfEcalc;
            this.minimizingConfEcalc = minimizingConfEcalc;
        }

        private void check() {
            if (this.rigidConfEcalc == null) {
                throw new InitException(this.type, "rigidConfEcalc");
            }
            if (this.minimizingConfEcalc == null) {
                throw new InitException(this.type, "minimizingConfEcalc");
            }
            if (this.confSearchFactory == null) {
                throw new InitException(this.type, "confSearchFactory");
            }
        }

        public void clear() {
            this.pfuncResults.clear();
        }

        public void calcEmats() {
            SimplerEnergyMatrixCalculator.Builder rigidBuilder = new SimplerEnergyMatrixCalculator.Builder(this.rigidConfEcalc);
            if (MARKStar.this.settings.energyMatrixCachePattern != null) {
                rigidBuilder.setCacheFile(new File(MARKStar.this.settings.applyEnergyMatrixCachePattern(this.type.name().toLowerCase() + ".rigid")));
            }
            SimplerEnergyMatrixCalculator.Builder minimizingBuilder = new SimplerEnergyMatrixCalculator.Builder(this.minimizingConfEcalc);
            if (MARKStar.this.settings.energyMatrixCachePattern != null) {
                minimizingBuilder.setCacheFile(new File(MARKStar.this.settings.applyEnergyMatrixCachePattern(this.type.name().toLowerCase() + ".minimizing")));
            }
            this.rigidEmat = rigidBuilder.build().calcEnergyMatrix();
            this.minimizingEmat = minimizingBuilder.build().calcEnergyMatrix();
            this.correctionEmat = new UpdatingEnergyMatrix(this.confSpace, this.minimizingEmat);
        }

        public PartitionFunction.Result calcPfunc(int sequenceIndex, BigDecimal stabilityThreshold) {
            Sequence sequence = MARKStar.this.sequences.get(sequenceIndex);
            PartitionFunction.Result result = this.pfuncResults.get(sequence);
            if (result != null) {
                return result;
            }
            MARKStarBoundFastQueues pfunc = new MARKStarBoundFastQueues(this.confSpace, this.rigidEmat, this.minimizingEmat, this.minimizingConfEcalc, sequence.makeRCs(this.confSpace), MARKStar.this.settings.parallelism);
            this.confSearchFactory = (emat, rcs) -> {
                ConfAStarTree.Builder builder = new ConfAStarTree.Builder(emat, rcs).setTraditional();
                return builder.build();
            };
            RCs rcs2 = sequence.makeRCs(this.confSpace);
            pfunc.reduceMinimizations = MARKStar.this.settings.reduceMinimizations;
            pfunc.stateName = this.type.name();
            if (MARKStar.this.settings.maxNumConfs > 0) {
                pfunc.setMaxNumConfs(MARKStar.this.settings.maxNumConfs);
            }
            pfunc.setReportProgress(MARKStar.this.settings.showPfuncProgress);
            pfunc.setCorrections(this.correctionEmat);
            if (MARKStar.this.settings.showPfuncProgress) {
                System.out.println("Computing " + String.valueOf((Object)this.type) + ":");
            }
            pfunc.init(MARKStar.this.settings.epsilon);
            Stopwatch computeTimer = new Stopwatch().start();
            pfunc.compute();
            computeTimer.stop();
            System.out.println("Computation for " + sequence.toString() + ":" + computeTimer.getTime(2));
            result = pfunc.makeResult();
            this.pfuncResults.put(sequence, result);
            return result;
        }
    }

    public static enum ConfSpaceType {
        Protein,
        Ligand,
        Complex;

    }

    public static interface ConfEnergyCalculatorFactory {
        public ConfEnergyCalculator make(SimpleConfSpace var1, EnergyCalculator var2);
    }

    public static class Settings {
        public final double epsilon;
        public final Double stabilityThreshold;
        public final int maxSimultaneousMutations;
        public final KStarScoreWriter.Writers scoreWriters;
        public final boolean showPfuncProgress;
        public final String energyMatrixCachePattern;
        public final Parallelism parallelism;
        public final int maxNumConfs;
        public final boolean reduceMinimizations;

        public Settings(double epsilon, Double stabilityThreshold, int maxSimultaneousMutations, KStarScoreWriter.Writers scoreWriters, boolean dumpPfuncConfs, String energyMatrixCachePattern, Parallelism parallelism, int maxNumConfs, boolean reduceMinimizations) {
            this.epsilon = epsilon;
            this.stabilityThreshold = stabilityThreshold;
            this.maxSimultaneousMutations = maxSimultaneousMutations;
            this.scoreWriters = scoreWriters;
            this.showPfuncProgress = dumpPfuncConfs;
            this.energyMatrixCachePattern = energyMatrixCachePattern;
            this.parallelism = parallelism;
            this.maxNumConfs = maxNumConfs;
            this.reduceMinimizations = reduceMinimizations;
        }

        public String applyEnergyMatrixCachePattern(String type) {
            if (this.energyMatrixCachePattern.indexOf(42) < 0) {
                throw new IllegalArgumentException("energyMatrixCachePattern (which is '" + this.energyMatrixCachePattern + "') has no wildcard character (which is *)");
            }
            return this.energyMatrixCachePattern.replace("*", type);
        }

        public static class Builder {
            private double epsilon = 0.683;
            private Double stabilityThreshold = 5.0;
            private int maxSimultaneousMutations = 1;
            private KStarScoreWriter.Writers scoreWriters = new KStarScoreWriter.Writers();
            private boolean showPfuncProgress = false;
            private String energyMatrixCachePattern = null;
            private Parallelism parallelism = null;
            private int maxNumConfs = -1;
            private boolean reduceMinimizations = true;

            public Builder setEpsilon(double val) {
                this.epsilon = val;
                return this;
            }

            public Builder setStabilityThreshold(Double val) {
                if (val != null && val.isInfinite()) {
                    throw new IllegalArgumentException("only finite values allowed. To turn off the filter, pass null");
                }
                this.stabilityThreshold = val;
                return this;
            }

            public Builder setMaxSimultaneousMutations(int val) {
                this.maxSimultaneousMutations = val;
                return this;
            }

            public Builder addScoreWriter(KStarScoreWriter val) {
                this.scoreWriters.add(val);
                return this;
            }

            public Builder addScoreConsoleWriter(KStarScoreWriter.Formatter val) {
                return this.addScoreWriter(new KStarScoreWriter.ToConsole(val));
            }

            public Builder addScoreConsoleWriter() {
                return this.addScoreConsoleWriter(new KStarScoreWriter.Formatter.SequenceKStarPfuncs());
            }

            public Builder addScoreFileWriter(File file, KStarScoreWriter.Formatter val) {
                return this.addScoreWriter(new KStarScoreWriter.ToFile(file, val));
            }

            public Builder addScoreFileWriter(File file) {
                return this.addScoreFileWriter(file, new KStarScoreWriter.Formatter.Log());
            }

            public Builder setShowPfuncProgress(boolean val) {
                this.showPfuncProgress = val;
                return this;
            }

            public Builder setEnergyMatrixCachePattern(String val) {
                this.energyMatrixCachePattern = val;
                return this;
            }

            public Builder setParallelism(Parallelism p) {
                this.parallelism = p;
                return this;
            }

            public Builder setMaxNumConfs(int maxNumConfs) {
                this.maxNumConfs = maxNumConfs;
                return this;
            }

            public Settings build() {
                return new Settings(this.epsilon, this.stabilityThreshold, this.maxSimultaneousMutations, this.scoreWriters, this.showPfuncProgress, this.energyMatrixCachePattern, this.parallelism, this.maxNumConfs, this.reduceMinimizations);
            }

            public Builder setReduceMinimizations(boolean reudceMinimizations) {
                this.reduceMinimizations = reudceMinimizations;
                return this;
            }
        }
    }

    private static interface Scorer {
        public KStarScore score(int var1, PartitionFunction.Result var2, PartitionFunction.Result var3, PartitionFunction.Result var4);
    }

    public static class ScoredSequence {
        public final Sequence sequence;
        public final KStarScore score;

        public ScoredSequence(Sequence sequence, KStarScore score) {
            this.sequence = sequence;
            this.score = score;
        }

        public String toString() {
            return "sequence: " + String.valueOf(this.sequence) + "   K*(log10): " + String.valueOf(this.score);
        }

        public String toString(Sequence wildtype) {
            return "sequence: " + this.sequence.toString(Sequence.Renderer.AssignmentMutations) + "   K*(log10): " + String.valueOf(this.score);
        }
    }

    public static class InitException
    extends RuntimeException {
        public InitException(ConfSpaceType type, String name) {
            super(String.format("set %s for the %s conf space info before running", name, type.name()));
        }
    }

    public static interface ConfSearchFactory {
        public ConfSearch make(EnergyMatrix var1, RCs var2);
    }
}

