/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.lute.LUTEConfEnergyCalculator;

public class LUTEHScorer
implements AStarScorer {
    public final LUTEConfEnergyCalculator ecalc;

    public LUTEHScorer(LUTEConfEnergyCalculator ecalc) {
        this.ecalc = ecalc;
    }

    @Override
    public AStarScorer make() {
        return new LUTEHScorer(this.ecalc);
    }

    @Override
    public double calc(ConfIndex index, RCs rcs) {
        double hscore = 0.0;
        for (int i = 0; i < index.numUndefined; ++i) {
            int pos1 = index.undefinedPos[i];
            double pos1Energy = Double.POSITIVE_INFINITY;
            for (int rc1 : rcs.get(pos1)) {
                int pos2;
                int j;
                double rc1Energy = this.ecalc.getEnergy(pos1, rc1);
                for (j = 0; j < index.numDefined; ++j) {
                    pos2 = index.definedPos[j];
                    int rc2 = index.definedRCs[j];
                    rc1Energy += this.ecalc.getEnergy(pos1, rc1, pos2, rc2);
                    for (int k = 0; k < j; ++k) {
                        int pos3 = index.definedPos[k];
                        int rc3 = index.definedRCs[k];
                        rc1Energy += this.ecalc.getEnergy(pos1, rc1, pos2, rc2, pos3, rc3);
                    }
                }
                for (j = 0; j < i; ++j) {
                    pos2 = index.undefinedPos[j];
                    double minrc2Energy = Double.POSITIVE_INFINITY;
                    for (int rc2 : rcs.get(pos2)) {
                        int pos3;
                        int k;
                        double rc2Energy = this.ecalc.getEnergy(pos1, rc1, pos2, rc2);
                        for (k = 0; k < index.numDefined; ++k) {
                            pos3 = index.definedPos[k];
                            int rc3 = index.definedRCs[k];
                            rc2Energy += this.ecalc.getEnergy(pos1, rc1, pos2, rc2, pos3, rc3);
                        }
                        for (k = 0; k < j; ++k) {
                            pos3 = index.undefinedPos[k];
                            double minrc3Energy = Double.POSITIVE_INFINITY;
                            for (int rc3 : rcs.get(pos3)) {
                                double rc3Energy = this.ecalc.getEnergy(pos1, rc1, pos2, rc2, pos3, rc3);
                                minrc3Energy = Math.min(minrc3Energy, rc3Energy);
                            }
                            rc2Energy += minrc3Energy;
                        }
                        minrc2Energy = Math.min(minrc2Energy, rc2Energy);
                    }
                    rc1Energy += minrc2Energy;
                }
                pos1Energy = Math.min(pos1Energy, rc1Energy);
            }
            hscore += pos1Energy;
        }
        return hscore;
    }
}

