/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import cern.colt.Arrays;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.RCEnergyContribs;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class PFTraditional
extends PFAbstract
implements Serializable {
    protected ConfSearch confSearch = null;

    public PFTraditional() {
    }

    public PFTraditional(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
    }

    @Override
    public void start() {
        this.setRunState(PFAbstract.RunState.STARTED);
        if (this.canUseHotByManualSelection()) {
            this.createHotsFromCFG();
        }
        this.initTradPStar();
        this.confSearch = this.getConfTree(false);
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void iterate() {
        ConfSearch.ScoredConf conf = this.confSearch.nextConf();
        if (conf != null) {
            if (this.processedConfsSet.contains(conf.getAssignments())) {
                return;
            }
            KSConf ksConf = new KSConf(conf.getAssignments(), this.getConfBound(this.confSearch, conf.getAssignments()));
            this.accumulate(ksConf);
        } else if (this.eAppx == PFAbstract.EApproxReached.FALSE) {
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
        }
        this.exitIfTimeOut();
    }

    @Override
    protected void computeSlice() {
        this.iterate();
    }

    @Override
    protected void compute() {
        while (this.eAppx == PFAbstract.EApproxReached.FALSE) {
            this.iterate();
        }
    }

    protected void createHotsFromCFG() {
        if (this.HOTs == null) {
            this.HOTs = new ArrayList();
        }
        ArrayList<String> flexRes = KSAllowedSeqs.getFlexResFromSeq(this.getSequence());
        ArrayList<ArrayList<String>> hots = this.cfp.getHighOrderTuplesByStrand(this.strand);
        for (ArrayList<String> hot : hots) {
            String res;
            int pos;
            ArrayList<Integer> hotIndexes = new ArrayList<Integer>();
            Iterator<String> iterator2 = hot.iterator();
            while (iterator2.hasNext() && !this.HOTsContains(pos = flexRes.indexOf(res = iterator2.next()))) {
                hotIndexes.add(pos);
            }
            if (hotIndexes.size() <= 2) continue;
            Collections.sort(hotIndexes);
            this.combineResidues(KSConf.list2Array(hotIndexes));
        }
    }

    protected void combineResidues(int[] pos) {
        System.out.print("Combining residues: ");
        for (int i : pos) {
            System.out.print(this.getSequence().get(i) + " ");
        }
        System.out.print("... ");
        long start = System.currentTimeMillis();
        this.reducedSP.mergeResiduePositions(pos);
        this.memoizePosInHot(pos);
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("done in " + duration + "s");
    }

    protected void combineResidues(KSConf conf, double pbe, double tpbe, int[] tpce) {
        System.out.print("% bound error: " + pbe + ". ");
        System.out.print("% bound error from top " + PFTraditional.getHotNumRes() + " RCs: " + tpbe + ". positions: " + Arrays.toString((int[])tpce));
        System.out.print(". ");
        this.combineResidues(tpce);
        this.partialQLB = this.reComputePartialQLB(null);
        this.confSearch = this.getConfTree(false);
        conf.setEnergyBound(this.getConfBound(null, conf.getConfArray()));
    }

    protected void tryHotForConf(KSConf conf, MultiTermEnergyFunction mef) {
        double pbe = 0.0;
        double tpbe = 0.0;
        int[] tpce = null;
        RCEnergyContribs rce = new RCEnergyContribs(this, mef, conf.getConfArray());
        pbe = rce.getPercentBoundError();
        if (pbe >= PFTraditional.getHotBoundPct() && (tpbe = rce.getPercentErrorForTopPos(PFTraditional.getHotNumRes())) >= PFTraditional.getHotTopRotsPct()) {
            tpce = rce.getTopPosCausingError(PFTraditional.getHotNumRes());
            this.combineResidues(conf, pbe, tpbe, tpce);
        }
    }

    protected void accumulate(KSConf conf) {
        double d;
        double energy = 0.0;
        double boundError = 0.0;
        MultiTermEnergyFunction mef = null;
        if (this.isContinuous() && this.isFullyDefined()) {
            mef = this.reducedSP.decompMinimizedEnergy(conf.getConfArray());
            energy = mef.getPreCompE();
        } else {
            energy = conf.getEnergyBound();
        }
        conf.setEnergy(energy);
        boundError = conf.getEnergyBound() - conf.getEnergy();
        this.updateQStar(conf);
        this.Et = conf.getEnergyBound();
        this.updateQPrime();
        this.effectiveEpsilon = this.computeEffectiveEpsilon();
        if (d < 0.0) {
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (!PFAbstract.suppressOutput) {
            if (!this.printedHeader) {
                this.printHeader();
            }
            System.out.println(this.numberFormat.format(boundError) + "\t" + this.numberFormat.format(energy) + "\t" + this.numberFormat.format(this.effectiveEpsilon) + "\t" + String.valueOf(this.getNumProcessed()) + "\t" + String.valueOf(this.getNumUnEnumerated()) + "\t" + (currentTime - this.startTime) / 1000L);
        }
        this.eAppx = this.effectiveEpsilon <= targetEpsilon || this.maxKSConfsReached() ? PFAbstract.EApproxReached.TRUE : PFAbstract.EApproxReached.FALSE;
        double peb = (conf.getEnergyBound() - conf.getEnergy()) / conf.getEnergy();
        if (this.canUseHotByConfError(peb)) {
            this.tryHotForConf(conf, mef);
        }
        if (!this.isFullyDefined() && this.eAppx == PFAbstract.EApproxReached.TRUE) {
            this.adjustQStar();
        }
    }

    @Override
    protected void printHeader() {
        System.out.println("error\tenergy\tepsilon\t#processed\t#un-enum\ttime(sec)");
        this.printedHeader = true;
    }

    @Override
    public String getImpl() {
        return "Traditional";
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.confSearch = null;
    }
}

