/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfQ;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSPStarCalculator;
import edu.duke.cs.osprey.kstar.KSQPrimeCalculator;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.impl.PFParallel1;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public class PFParallel2
extends PFParallel1
implements Serializable {
    protected static HashMap<Integer, ArrayList<KSSearchProblem>> strand2SPs = new HashMap();
    private ArrayList<Integer> indexes = new ArrayList(PFAbstract.getNumThreads());
    private ArrayList<KSSearchProblem> sps = null;
    private ArrayList<KSConf> partialQConfs = new ArrayList(PFAbstract.getNumThreads());

    public PFParallel2() {
    }

    public PFParallel2(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.resetSPs();
    }

    protected ArrayList<KSSearchProblem> parallelCreateSPs(KSSearchProblem sp, int replicates) {
        ArrayList<KSSearchProblem> ans = new ArrayList<KSSearchProblem>(replicates);
        ArrayList<Integer> indexes = new ArrayList<Integer>(replicates);
        for (int i2 = 0; i2 < replicates; ++i2) {
            indexes.add(i2);
            ans.add(null);
        }
        indexes.parallelStream().forEach(i -> {
            ans.set((int)i, (KSSearchProblem)ObjectIO.deepCopy(sp));
            ((KSSearchProblem)ans.get((int)i.intValue())).emat = sp.emat;
            ((KSSearchProblem)ans.get((int)i.intValue())).pruneMat = sp.pruneMat;
            ((KSSearchProblem)ans.get((int)i.intValue())).inverseMat = sp.inverseMat;
        });
        return ans;
    }

    protected void appendSPs(ArrayList<KSSearchProblem> sps, KSSearchProblem sp, int target) {
        while (sps.size() < target) {
            KSSearchProblem newSP = (KSSearchProblem)ObjectIO.deepCopy(sp);
            newSP.emat = sp.emat;
            newSP.pruneMat = sp.pruneMat;
            newSP.inverseMat = sp.inverseMat;
            sps.add(newSP);
        }
        sps.trimToSize();
    }

    protected void getSPs() {
        if (!strand2SPs.containsKey(this.strand)) {
            strand2SPs.put(this.strand, this.parallelCreateSPs(this.panSP, PFAbstract.getNumThreads()));
        }
        this.sps = strand2SPs.get(this.strand);
        if (this.sps.size() < PFAbstract.getNumThreads()) {
            this.appendSPs(this.sps, this.panSP, PFAbstract.getNumThreads());
            strand2SPs.put(this.strand, this.sps);
        }
    }

    protected void resetSPs() {
        this.sps = null;
    }

    @Override
    public void start() {
        try {
            int it;
            this.setRunState(PFAbstract.RunState.STARTED);
            if (this.canUseHotByManualSelection()) {
                this.createHotsFromCFG();
            }
            this.pStarCalculator = null;
            if (this.prunedConfs.compareTo(BigInteger.ZERO) == 0) {
                this.pStar = BigDecimal.ZERO;
            } else {
                System.out.println("using p* calculator");
                this.pStarCalculator = new KSPStarCalculator(this);
                this.pStarCalculator.setPriority(10);
            }
            this.getSPs();
            this.indexes.clear();
            for (it = 0; it < PFAbstract.getNumThreads(); ++it) {
                this.indexes.add(it);
            }
            this.indexes.trimToSize();
            this.partialQConfs.clear();
            for (it = 0; it < this.indexes.size(); ++it) {
                this.partialQConfs.add(null);
            }
            this.partialQConfs.trimToSize();
            this.confsQ = new KSConfQ(this, this.indexes.size(), this.partialQLB);
            this.qPrimeCalculator = new KSQPrimeCalculator(this);
            this.qPrimeCalculator.setPriority(10);
            if (this.pStarCalculator != null) {
                this.pStarCalculator.start();
            }
            this.qPrimeCalculator.start();
            this.confsQ.start();
            if (!this.isContinuous() && this.isFullyDefined()) {
                Thread.sleep(this.initSleepTime);
            }
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function", ex);
        }
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void iterate() {
        try {
            this.getSPs();
            String string = this.confsQ.lock;
            synchronized (string) {
                int request = this.partialQConfs.size();
                int granted = 0;
                granted = this.canSatisfy(request);
                if (granted == 0) {
                    return;
                }
                while (this.partialQConfs.size() > granted) {
                    this.partialQConfs.remove(this.partialQConfs.size() - 1);
                    this.indexes.remove(this.indexes.size() - 1);
                }
                for (int i = 0; i < Math.min(granted, this.partialQConfs.size()); ++i) {
                    this.partialQConfs.set(i, this.confsQ.deQueue());
                }
                this.processingConfs = this.processingConfs.add(BigInteger.valueOf(this.partialQConfs.size()));
                if (this.confsQ.getState() == Thread.State.WAITING) {
                    this.confsQ.lock.notify();
                }
            }
            this.accumulate(this.partialQConfs, false);
            if (this.eAppx != PFAbstract.EApproxReached.FALSE) {
                this.confsQ.cleanUp(true);
                this.qPrimeCalculator.cleanUp(true);
                if (this.pStarCalculator != null) {
                    this.pStarCalculator.cleanUp(true);
                }
            }
            this.resetSPs();
            this.exitIfTimeOut();
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    protected void tryHotForConfs(ArrayList<MultiTermEnergyFunction> mefs) {
        for (int index : this.indexes) {
            KSConf conf = this.partialQConfs.get(index);
            conf.setEnergyBound(this.getConfBound(null, conf.getConfArray()));
            double peb = (conf.getEnergyBound() - conf.getEnergy()) / conf.getEnergy();
            if (!this.canUseHotByConfError(peb)) continue;
            this.tryHotForConf(this.partialQConfs.get(index), mefs.get(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accumulate(ArrayList<KSConf> partialQConfs, boolean energiesEvaluated) {
        ArrayList<MultiTermEnergyFunction> mefs = new ArrayList<MultiTermEnergyFunction>(partialQConfs.size());
        for (int i2 = 0; i2 < partialQConfs.size(); ++i2) {
            mefs.add(null);
        }
        if (!energiesEvaluated) {
            this.indexes.parallelStream().forEach(i -> {
                double energy = 0.0;
                KSConf conf = (KSConf)partialQConfs.get((int)i);
                if (this.isContinuous() && this.isFullyDefined()) {
                    MultiTermEnergyFunction mef = this.sps.get((int)i).decompMinimizedEnergy(conf.getConfArray());
                    mefs.set((int)i, mef);
                    energy = mef.getPreCompE();
                } else {
                    energy = conf.getEnergyBound();
                }
                conf.setEnergy(energy);
            });
        }
        double energy = 0.0;
        double boundError = 0.0;
        for (KSConf conf : partialQConfs) {
            double d;
            this.processingConfs = this.processingConfs.subtract(BigInteger.ONE);
            energy = conf.getEnergy();
            boundError = conf.getEnergyBound() - conf.getEnergy();
            this.updateQStar(conf);
            this.updateQPrime();
            this.updatePStar();
            this.effectiveEpsilon = this.computeEffectiveEpsilon();
            if (d < 0.0) {
                this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
                return;
            }
            if (!(this.effectiveEpsilon <= targetEpsilon) && !this.maxKSConfsReached()) continue;
            break;
        }
        long currentTime = System.currentTimeMillis();
        String string = this.confsQ.lock;
        synchronized (string) {
            if (!PFAbstract.suppressOutput) {
                if (!this.printedHeader) {
                    this.printHeader();
                }
                System.out.println(this.numberFormat.format(boundError) + "\t" + this.numberFormat.format(energy) + "\t" + this.numberFormat.format(this.effectiveEpsilon) + "\t" + String.valueOf(this.getNumProcessed()) + "\t" + String.valueOf(this.getNumUnEnumerated()) + "\t" + this.confsQ.size() + "\t" + (currentTime - this.startTime) / 1000L);
            }
        }
        PFAbstract.EApproxReached eApproxReached = this.eAppx = this.effectiveEpsilon <= targetEpsilon || this.maxKSConfsReached() ? PFAbstract.EApproxReached.TRUE : PFAbstract.EApproxReached.FALSE;
        if (this.canUseHotByConfError()) {
            this.tryHotForConfs(mefs);
        }
        if (!this.isFullyDefined() && this.eAppx == PFAbstract.EApproxReached.TRUE) {
            this.adjustQStar();
        }
    }

    @Override
    public String getImpl() {
        return "Parallel2";
    }
}

