/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSPStarCalculator;
import edu.duke.cs.osprey.kstar.KSQPrimeCalculator;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.impl.PFParallel1;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class PFParallel0
extends PFParallel1
implements Serializable {
    public PFParallel0() {
    }

    public PFParallel0(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
    }

    @Override
    public void start() {
        try {
            this.setRunState(PFAbstract.RunState.STARTED);
            if (this.canUseHotByManualSelection()) {
                this.createHotsFromCFG();
            }
            this.confSearch = this.getConfTree(false);
            this.pStarCalculator = null;
            if (this.prunedConfs.compareTo(BigInteger.ZERO) == 0) {
                this.pStar = BigDecimal.ZERO;
            } else {
                System.out.println("using p* calculator");
                this.pStarCalculator = new KSPStarCalculator(this);
                this.pStarCalculator.setPriority(10);
            }
            this.qPrimeCalculator = new KSQPrimeCalculator(this);
            this.qPrimeCalculator.setPriority(10);
            if (this.pStarCalculator != null) {
                this.pStarCalculator.start();
            }
            this.qPrimeCalculator.start();
            if (!this.isContinuous() && this.isFullyDefined()) {
                Thread.sleep(this.initSleepTime);
            }
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function", ex);
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void iterate() {
        try {
            ConfSearch.ScoredConf conf = this.confSearch.nextConf();
            if (conf != null) {
                if (this.processedConfsSet.contains(conf)) {
                    return;
                }
                KSConf ksConf = new KSConf(conf.getAssignments(), this.getConfBound(this.confSearch, conf.getAssignments()));
                this.accumulate(ksConf);
                if (this.eAppx != PFAbstract.EApproxReached.FALSE) {
                    this.qPrimeCalculator.cleanUp(true);
                    if (this.pStarCalculator != null) {
                        this.pStarCalculator.cleanUp(true);
                    }
                }
            }
            this.exitIfTimeOut();
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    @Override
    protected void accumulate(KSConf conf) {
        double d;
        double energy = 0.0;
        double boundError = 0.0;
        MultiTermEnergyFunction mef = null;
        if (this.isContinuous() && this.isFullyDefined()) {
            mef = this.reducedSP.decompMinimizedEnergy(conf.getConfArray());
            energy = mef.getPreCompE();
        } else {
            energy = conf.getEnergyBound();
        }
        conf.setEnergy(energy);
        boundError = conf.getEnergyBound() - conf.getEnergy();
        this.updateQStar(conf);
        this.Et = conf.getEnergyBound();
        this.updateQPrime();
        this.effectiveEpsilon = this.computeEffectiveEpsilon();
        if (d < 0.0) {
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (!PFAbstract.suppressOutput) {
            if (!this.printedHeader) {
                this.printHeader();
            }
            System.out.println(this.numberFormat.format(boundError) + "\t" + this.numberFormat.format(energy) + "\t" + this.numberFormat.format(this.effectiveEpsilon) + "\t" + String.valueOf(this.getNumProcessed()) + "\t" + String.valueOf(this.getNumUnEnumerated()) + "\t" + (currentTime - this.startTime) / 1000L);
        }
        this.eAppx = this.effectiveEpsilon <= targetEpsilon || this.maxKSConfsReached() ? PFAbstract.EApproxReached.TRUE : PFAbstract.EApproxReached.FALSE;
        double peb = (conf.getEnergyBound() - conf.getEnergy()) / conf.getEnergy();
        if (this.canUseHotByConfError(peb)) {
            this.tryHotForConf(conf, mef);
        }
        if (!this.isFullyDefined() && this.eAppx == PFAbstract.EApproxReached.TRUE) {
            this.adjustQStar();
        }
    }

    @Override
    protected void printHeader() {
        System.out.println("error\tenergy\tepsilon\t#processed\t#un-enum\ttime(sec)");
        this.printedHeader = true;
    }

    @Override
    public String getImpl() {
        return "Parallel0";
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    protected BigInteger getNumUnEnumerated() {
        BigInteger ans = this.unPrunedConfs.subtract(this.getNumProcessed());
        if (ans.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("ERROR: the number of un-enumerated conformations must be >= 0");
        }
        return ans;
    }
}

