/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.gmec.ConfSearchFactory;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.pruning.InvertedPruningMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.math.BigDecimal;
import java.math.BigInteger;

@Deprecated
public class ParallelConfPartitionFunction
implements PartitionFunction {
    protected EnergyMatrix emat;
    protected PruningMatrix pmat;
    protected ConfSearchFactory confSearchFactory;
    protected GMECConfEnergyCalculator.Async ecalc;
    protected double targetEpsilon;
    protected PartitionFunction.Status status;
    protected PartitionFunction.Values values;
    protected BoltzmannCalculator boltzmann;
    protected ConfSearch.MultiSplitter.Stream scoreConfs;
    protected ConfSearch.MultiSplitter.Stream energyConfs;
    protected int numConfsEvaluated;
    protected BigInteger numConfsToScore;
    protected BigDecimal qprimeUnevaluated;
    protected BigDecimal qprimeUnscored;
    protected Stopwatch stopwatch;
    protected boolean isReportingProgress;
    protected PartitionFunction.ConfListener confListener;

    public ParallelConfPartitionFunction(EnergyMatrix emat, PruningMatrix pmat, ConfSearchFactory confSearchFactory, GMECConfEnergyCalculator.Async ecalc) {
        this.emat = emat;
        this.pmat = pmat;
        this.confSearchFactory = confSearchFactory;
        this.ecalc = ecalc;
        this.targetEpsilon = Double.NaN;
        this.status = null;
        this.values = null;
        this.boltzmann = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
        this.scoreConfs = null;
        this.energyConfs = null;
        this.numConfsEvaluated = 0;
        this.numConfsToScore = null;
        this.qprimeUnevaluated = null;
        this.qprimeUnscored = null;
        this.stopwatch = null;
        this.isReportingProgress = true;
        this.confListener = null;
    }

    @Override
    public void setReportProgress(boolean val) {
        this.isReportingProgress = val;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
        this.confListener = val;
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getNumConfsEvaluated() {
        return this.numConfsEvaluated;
    }

    @Override
    public int getParallelism() {
        return this.ecalc.getTasks().getParallelism();
    }

    @Override
    public void init(double targetEpsilon) {
        this.targetEpsilon = targetEpsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = new PartitionFunction.Values();
        this.values.pstar = this.calcWeightSumUpperBound(this.confSearchFactory.make(this.emat, new InvertedPruningMatrix(this.pmat)));
        ConfSearch tree = this.confSearchFactory.make(this.emat, this.pmat);
        ConfSearch.MultiSplitter confsSplitter = new ConfSearch.MultiSplitter(tree);
        this.scoreConfs = confsSplitter.makeStream();
        this.energyConfs = confsSplitter.makeStream();
        this.numConfsEvaluated = 0;
        this.numConfsToScore = tree.getNumConformations();
        this.qprimeUnevaluated = BigDecimal.ZERO;
        this.qprimeUnscored = BigDecimal.ZERO;
        this.stopwatch = new Stopwatch().start();
    }

    protected BigDecimal calcWeightSumUpperBound(ConfSearch tree) {
        BigDecimal weight;
        ConfSearch.ScoredConf conf;
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal boundOnAll = BigDecimal.ZERO;
        BigInteger numConfsRemaining = tree.getNumConformations();
        while ((conf = tree.nextConf()) != null && (weight = this.boltzmann.calc(conf.getScore())).compareTo(BigDecimal.ZERO) != 0) {
            sum = sum.add(weight);
            BigDecimal boundOnRemaining = weight.multiply(new BigDecimal(numConfsRemaining = numConfsRemaining.subtract(BigInteger.ONE)));
            double effectiveEpsilon = boundOnRemaining.divide(boundOnAll = sum.add(boundOnRemaining), PartitionFunction.decimalPrecision).doubleValue();
            if (!(effectiveEpsilon <= 0.01)) continue;
            break;
        }
        return boundOnAll;
    }

    @Override
    public void compute() {
        this.compute(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compute(int maxNumConfs) {
        if (!this.status.canContinue()) {
            throw new IllegalStateException("can't continue from status " + String.valueOf((Object)this.status));
        }
        int stopAtConf = this.numConfsEvaluated + maxNumConfs;
        while (true) {
            ConfSearch.ScoredConf conf;
            ParallelConfPartitionFunction parallelConfPartitionFunction = this;
            synchronized (parallelConfPartitionFunction) {
                boolean hitEpsilonTarget;
                boolean bl = hitEpsilonTarget = this.values.getEffectiveEpsilon() <= this.targetEpsilon;
                if (hitEpsilonTarget) {
                    this.status = PartitionFunction.Status.Estimated;
                    break;
                }
                if (!this.status.canContinue() || this.numConfsEvaluated >= stopAtConf) {
                    break;
                }
                conf = this.energyConfs.nextConf();
                this.status = conf == null ? PartitionFunction.Status.OutOfConformations : (Double.isInfinite(conf.getScore()) ? PartitionFunction.Status.OutOfLowEnergies : PartitionFunction.Status.Estimating);
            }
            if (!this.status.canContinue()) {
                this.ecalc.getTasks().waitForFinish();
                continue;
            }
            this.ecalc.calcEnergyAsync(conf, econf -> {
                ParallelConfPartitionFunction parallelConfPartitionFunction = this;
                synchronized (parallelConfPartitionFunction) {
                    if (Double.isInfinite(econf.getEnergy())) {
                        return;
                    }
                    this.values.qstar = this.values.qstar.add(this.boltzmann.calc(econf.getEnergy()));
                    this.values.qprime = this.updateQprime((ConfSearch.EnergiedConf)econf);
                    if (this.isReportingProgress) {
                        System.out.println(String.format("conf:%4d, score:%06f, energy:%.6f, q*:%12e, q':%12e, epsilon:%.6f, time:%10s, heapMem:%s", this.numConfsEvaluated, econf.getScore(), econf.getEnergy(), this.values.qstar, this.values.qprime, this.values.getEffectiveEpsilon(), this.stopwatch.getTime(2), JvmMem.getOldPool()));
                    }
                    if (this.confListener != null) {
                        this.confListener.onConf((ConfSearch.ScoredConf)econf);
                    }
                    ++this.numConfsEvaluated;
                }
            });
        }
        this.ecalc.getTasks().waitForFinish();
    }

    protected BigDecimal updateQprime(ConfSearch.EnergiedConf econf) {
        BigDecimal scoreWeight;
        ConfSearch.ScoredConf conf;
        while ((conf = this.scoreConfs.nextConf()) != null && (scoreWeight = this.boltzmann.calc(conf.getScore())).compareTo(BigDecimal.ZERO) != 0) {
            this.numConfsToScore = this.numConfsToScore.subtract(BigInteger.ONE);
            this.qprimeUnevaluated = this.qprimeUnevaluated.add(scoreWeight);
            this.qprimeUnscored = scoreWeight.multiply(new BigDecimal(this.numConfsToScore));
            double tightness = this.qprimeUnscored.divide(this.qprimeUnevaluated.add(this.qprimeUnscored), PartitionFunction.decimalPrecision).doubleValue();
            if (!(tightness <= 0.01)) continue;
            break;
        }
        this.qprimeUnevaluated = this.qprimeUnevaluated.subtract(this.boltzmann.calc(econf.getScore()));
        return this.qprimeUnevaluated.add(this.qprimeUnscored);
    }
}

