/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.astar.ConfTree;
import edu.duke.cs.osprey.astar.FullAStarNode;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.kstar.KAStarConfTree;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pruning.ReducedPruningMatrix;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.ExpFunction;
import edu.duke.cs.osprey.tools.ObjectIO;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;

public abstract class PFAbstract
implements Serializable {
    protected long startTime;
    protected DecimalFormat numberFormat = new DecimalFormat("0.0000");
    protected EApproxReached eAppx = EApproxReached.FALSE;
    protected final double EPSILON_NEVER_POSSIBLE = -1.0;
    protected final double EPSILON_PHASE_2 = -2.0;
    protected RunState runState = RunState.NOTSTARTED;
    protected ArrayList<String> sequence;
    protected static String pFuncCFGImpl = null;
    protected static int threadConfsBuffer = 8;
    public static int qCapacity = 1024000;
    protected static int numThreads = 1;
    public static boolean suppressOutput = false;
    protected boolean printedHeader = false;
    protected boolean doingPhase2 = false;
    public static boolean saveTopConfsAsPDB = false;
    protected static int numTopConfsToSave = 10;
    public static boolean useMaxKSConfs = false;
    protected static long maxKSConfs = 100000L;
    protected static String hotMethod = "none";
    protected static double hotBoundPct = 0.2;
    protected static int hotNumRes = 3;
    protected static double hotTopRotsPct = 0.2;
    protected ArrayList<ArrayList<Integer>> HOTs = null;
    protected String checkPointPath = null;
    protected String reducedSPName = null;
    protected static BigDecimal stabilityThresh = BigDecimal.ONE;
    public static final double RT = 0.593050165;
    public static double targetEpsilon = 0.03;
    protected double effectiveEpsilon = 1.0;
    protected static String phase2Method = "fast";
    protected int strand = -1;
    protected KSConfigFileParser cfp = null;
    protected KSSearchProblem reducedSP = null;
    private boolean isContinuous = true;
    protected ArrayList<Integer> absolutePos = null;
    protected KSSearchProblem panSP = null;
    private boolean isFullyDefined = true;
    protected BigDecimal qStar = BigDecimal.ZERO;
    protected BigDecimal qPrime = BigDecimal.ZERO;
    protected BigDecimal pStar = BigDecimal.ZERO;
    protected ExpFunction e = new ExpFunction();
    protected double Et = 0.0;
    protected double E0 = 0.0;
    protected BigInteger prunedConfs = BigInteger.ZERO;
    protected BigInteger unPrunedConfs = BigInteger.ZERO;
    protected HashSet<ArrayList<Integer>> processedConfsSet = new HashSet();
    protected BigDecimal partialQLB = BigDecimal.ZERO;
    protected BigInteger processedConfsDuringInterval = BigInteger.ZERO;
    protected BigInteger processedConfs = BigInteger.ZERO;
    protected BigInteger processingConfs = BigInteger.ZERO;
    protected PriorityQueue<KSConf> topConfsPQ = null;

    protected PFAbstract() {
    }

    protected PFAbstract(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        this.sequence = sequence;
        this.sequence.trimToSize();
        this.absolutePos = absolutePos;
        this.absolutePos.trimToSize();
        this.checkPointPath = checkPointPath;
        this.reducedSPName = reducedSPName;
        this.panSP = panSP;
        this.strand = strand;
        this.isFullyDefined = sequence.size() == panSP.confSpace.numPos;
        this.isContinuous = panSP.contSCFlex;
        this.reducedSP = this.createReducedSP(panSP.contSCFlex, strand, sequence, absolutePos);
        this.cfp = cfp;
        KSConf.KSConfMinEComparator comparator = new KSConf.KSConfMinEComparator(new KSConf(new ArrayList<Integer>(), 0.0));
        this.topConfsPQ = new PriorityQueue<KSConf>(PFAbstract.getNumTopConfsToSave(), comparator);
    }

    public static void setPhase2Method(String in) {
        ArrayList<String> allowedMethods = new ArrayList<String>(Arrays.asList("fast", "slow"));
        if (!allowedMethods.contains(in = in.toLowerCase())) {
            throw new RuntimeException("ERROR: allowed values of parameter kStarPhase2Method are 'fast' and 'slow'");
        }
        phase2Method = in;
    }

    public static String getPhase2Method() {
        return phase2Method;
    }

    public PruningMatrix getReducedPruningMatrix() {
        return this.reducedSP.reducedMat;
    }

    public PruningMatrix getPanPruningMatrix() {
        return this.panSP.pruneMat;
    }

    public PruningMatrix getReducedInversePruningMatrix() {
        return this.reducedSP.inverseMat;
    }

    public PruningMatrix getPanInversePruningMatrix() {
        return this.panSP.inverseMat;
    }

    public ArrayList<Integer> getAbsolutePos() {
        return this.absolutePos;
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public String getFlexibility() {
        return this.isContinuous ? "(continuous)" : "(discrete)";
    }

    protected BigDecimal reComputePartialQLB(ConfSearch confSearch) {
        this.partialQLB = BigDecimal.ZERO;
        for (ArrayList<Integer> conf : this.processedConfsSet) {
            int[] confArray = KSConf.list2Array(conf);
            this.partialQLB = this.partialQLB.add(this.getBoltzmannWeight(this.getConfBound(confSearch, confArray)));
        }
        return this.partialQLB;
    }

    protected boolean canUseHotByManualSelection() {
        if (!this.isContinuous()) {
            return false;
        }
        if (!PFAbstract.getHotMethod().equalsIgnoreCase("manual")) {
            return false;
        }
        if (!this.isFullyDefined()) {
            return false;
        }
        return this.reducedSP.contSCFlex;
    }

    protected boolean canUseHotByConfError(double boundError) {
        if (!this.canUseHotByConfError()) {
            return false;
        }
        return !(boundError < PFAbstract.getHotBoundPct());
    }

    protected boolean canUseHotByConfError() {
        if (!PFAbstract.getHotMethod().equalsIgnoreCase("error")) {
            return false;
        }
        if (this.reducedSP.confSpace.numPos - this.getNumPosInHOTs() < PFAbstract.getHotNumRes()) {
            return false;
        }
        if (!this.isFullyDefined()) {
            return false;
        }
        return this.reducedSP.contSCFlex;
    }

    public boolean HOTsContains(Integer pos) {
        for (ArrayList<Integer> hot : this.HOTs) {
            if (!hot.contains(pos)) continue;
            return true;
        }
        return false;
    }

    protected int getMaxHOTSize(boolean max) {
        int ans = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ArrayList<Integer> hot : this.HOTs) {
            if (max) {
                ans = Math.max(ans, hot.size());
                continue;
            }
            ans = Math.min(ans, hot.size());
        }
        return ans;
    }

    protected int getNumPosInHOTs() {
        int ans = 0;
        for (ArrayList<Integer> hot : this.HOTs) {
            ans += hot.size();
        }
        return ans;
    }

    protected void memoizePosInHot(int ... pos) {
        ArrayList<Integer> hot = new ArrayList<Integer>();
        for (int i : pos) {
            hot.add(i);
        }
        this.HOTs.add(hot);
    }

    public boolean isFullyDefined() {
        return this.isFullyDefined;
    }

    protected BigDecimal productUndefinedRots() {
        BigDecimal ans = BigDecimal.ONE;
        int numPos = this.panSP.confSpace.numPos;
        ArrayList<Integer> undefinedPos = new ArrayList<Integer>(numPos);
        for (int pos = 0; pos < numPos; ++pos) {
            undefinedPos.add(pos);
        }
        undefinedPos.removeAll(this.absolutePos);
        boolean minimizeProduct = !this.isContinuous();
        Iterator iterator2 = undefinedPos.iterator();
        while (iterator2.hasNext()) {
            int pos = (Integer)iterator2.next();
            long unprunedSize = minimizeProduct ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            long prunedSize = minimizeProduct ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            ArrayList<String> aasAtPos = this.panSP.getAAsAtPos(this.panSP.pruneMat, pos);
            for (String aa : aasAtPos) {
                ArrayList<Integer> aaUnprunedRCNums = this.panSP.rcsAtPos(this.panSP.pruneMat, pos, aa, false);
                long l = unprunedSize = minimizeProduct ? Math.min(unprunedSize, (long)aaUnprunedRCNums.size()) : Math.max(unprunedSize, (long)aaUnprunedRCNums.size());
                if (minimizeProduct) continue;
                ArrayList<Integer> aaPrunedRCNums = this.panSP.rcsAtPos(this.panSP.pruneMat, pos, aa, true);
                prunedSize = Math.max(prunedSize, (long)aaPrunedRCNums.size());
            }
            if (minimizeProduct) {
                prunedSize = 0L;
            }
            ans = ans.multiply(BigDecimal.valueOf(unprunedSize + prunedSize));
        }
        return ans;
    }

    protected void adjustQStar() {
        if (this.eAppx != EApproxReached.TRUE) {
            return;
        }
        if (this.isFullyDefined()) {
            return;
        }
        BigDecimal product = this.productUndefinedRots();
        if (product.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.qStar = this.qStar.multiply(product);
    }

    public ConfSearch getConfTree(boolean invertPruneMat) {
        PruningMatrix panPmat;
        ReducedPruningMatrix reducedPmat;
        ReducedPruningMatrix reducedPruningMatrix = reducedPmat = invertPruneMat ? this.reducedSP.inverseMat : this.reducedSP.reducedMat;
        if (this.isFullyDefined()) {
            if (reducedPmat != null) {
                return new ConfTree<FullAStarNode>(new FullAStarNode.Factory(this.reducedSP.posNums.size()), this.reducedSP, reducedPmat);
            }
            return null;
        }
        PruningMatrix pruningMatrix = panPmat = invertPruneMat ? this.panSP.inverseMat : this.panSP.pruneMat;
        if (reducedPmat != null && panPmat != null) {
            return new KAStarConfTree(this.reducedSP, reducedPmat, panPmat);
        }
        return null;
    }

    public double getConfBound(ConfSearch confSearch, int[] conf) {
        double bound = 0.0;
        bound = this.isFullyDefined() ? this.reducedSP.lowerBound(conf) : ((KAStarConfTree)confSearch).confEnergyBound(conf);
        return bound;
    }

    public String getReducedSearchProblemName() {
        return this.reducedSPName;
    }

    public int getStrand() {
        return this.strand;
    }

    public void setPanSeqSP(KSSearchProblem other) {
        this.panSP = other;
    }

    public HashSet<ArrayList<Integer>> getProcessedConfsSet() {
        return this.processedConfsSet;
    }

    public BigInteger getNumProcessed() {
        return this.processedConfs;
    }

    protected abstract void printHeader();

    public static void setNumTopConfsToSave(int n) {
        numTopConfsToSave = n;
    }

    public static int getNumTopConfsToSave() {
        return numTopConfsToSave;
    }

    public int getNumTopSavedConfs() {
        return this.topConfsPQ.size();
    }

    protected void saveTopConf(KSConf conf) {
        if (this.getNumTopSavedConfs() >= PFAbstract.getNumTopConfsToSave()) {
            if (this.topConfsPQ.peek().getEnergy() > conf.getEnergy()) {
                this.topConfsPQ.poll();
            } else {
                return;
            }
        }
        this.topConfsPQ.add(conf);
    }

    public void writeTopConfs() {
        if (this.getNumTopSavedConfs() == 0) {
            return;
        }
        System.out.println("\nWriting top " + this.getNumTopSavedConfs() + " conformation(s) for sequence: " + KSAbstract.list1D2String(this.sequence, " "));
        System.out.println();
        PriorityQueue tmp = (PriorityQueue)ObjectIO.deepCopy(this.topConfsPQ);
        String dir = "topConfs" + File.separator + KSAbstract.list1D2String(this.sequence, ".");
        ObjectIO.makeDir(dir, false);
        String pdbName = null;
        for (int i = this.getNumTopSavedConfs() - 1; i > -1; --i) {
            System.out.println("Saving: " + i + ".pdb\tminE:" + ((KSConf)tmp.peek()).getEnergy());
            pdbName = dir + File.separator + String.valueOf(i) + ".pdb";
            this.reducedSP.outputMinimizedStruct(((KSConf)tmp.poll()).getConfArray(), pdbName);
        }
        System.out.println();
    }

    public ArrayList<String> getSequence() {
        return this.sequence;
    }

    public EApproxReached getEpsilonStatus() {
        return this.eAppx;
    }

    public void setEpsilonStatus(EApproxReached in) {
        this.eAppx = in;
    }

    protected boolean epsilonPossible() {
        if (this.eAppx == EApproxReached.FALSE || this.eAppx == EApproxReached.NOT_POSSIBLE) {
            this.eAppx = EApproxReached.NOT_POSSIBLE;
            return false;
        }
        return true;
    }

    public void abort(boolean nullify) {
    }

    public BigDecimal getQStar() {
        return this.qStar;
    }

    public BigDecimal getQPrime() {
        return this.qPrime;
    }

    public BigDecimal getPStar() {
        return this.pStar;
    }

    public BigDecimal getQDagger() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getQStarLowerBound() {
        return this.getQStar();
    }

    public BigDecimal getQStarUpperBound() {
        if (this.eAppx != EApproxReached.FALSE) {
            return this.getQStar();
        }
        this.updateQPrime();
        return this.qStar.add(this.qPrime).add(this.pStar);
    }

    public void setNumUnPruned() {
        this.unPrunedConfs = this.reducedSP.numConfs(this.getReducedPruningMatrix());
    }

    public void setNumPruned() {
        this.prunedConfs = this.reducedSP.numConfs(this.getReducedInversePruningMatrix());
    }

    protected double computeEffectiveEpsilon() {
        BigDecimal dividend = this.qPrime.add(this.pStar);
        BigDecimal divisor = this.qStar.add(dividend);
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            return -1.0;
        }
        return dividend.divide(divisor, 4).doubleValue();
    }

    public double getEffectiveEpsilon() {
        return this.effectiveEpsilon;
    }

    protected void initTradPStar() {
        ConfSearch confSearch = this.getConfTree(true);
        if (confSearch == null) {
            this.setPStar(Double.POSITIVE_INFINITY);
            return;
        }
        ConfSearch.ScoredConf conf = confSearch.nextConf();
        if (conf != null) {
            this.setPStar(this.getConfBound(confSearch, conf.getAssignments()));
        } else {
            this.setPStar(Double.POSITIVE_INFINITY);
        }
    }

    private void setPStar(double eLB) {
        this.E0 = eLB;
        this.pStar = this.getBoltzmannWeight(this.E0).multiply(new BigDecimal(this.prunedConfs));
    }

    protected void updateQPrime() {
        this.qPrime = this.getBoltzmannWeight(this.Et).multiply(new BigDecimal(this.getNumUnEnumerated()));
    }

    protected void updateQStar(KSConf conf) {
        if (this.processedConfsSet.contains(conf.getConf())) {
            return;
        }
        this.processedConfsSet.add(conf.getConf());
        this.qStar = this.qStar.add(this.getBoltzmannWeight(conf.getEnergy()));
        if (this.getImpl().toLowerCase().contains("parallel")) {
            this.partialQLB = this.partialQLB.add(this.getBoltzmannWeight(conf.getEnergyBound()));
        }
        if (this.isFullyDefined() && saveTopConfsAsPDB) {
            this.saveTopConf(conf);
        }
        this.processedConfs = this.processedConfs.add(BigInteger.ONE);
        this.processedConfsDuringInterval = this.processedConfsDuringInterval.add(BigInteger.ONE);
    }

    public BigDecimal getBoltzmannWeight(double E) {
        return this.e.exp(-E / 0.593050165);
    }

    protected void exitIfTimeOut() {
        if (KSAbstract.runTimeout != 0L && System.currentTimeMillis() - this.startTime > KSAbstract.runTimeout * 86400000L) {
            throw new RuntimeException("ERROR: running time exceeds " + KSAbstract.runTimeout + " days!");
        }
    }

    public abstract void start();

    public void runSlice(long target) {
        while (this.eAppx == EApproxReached.FALSE && this.getProcessedDuringInterval().longValue() < target) {
            this.computeSlice();
            if (!this.doingPhase2 && this.eAppx == EApproxReached.NOT_POSSIBLE) {
                this.phase2();
                continue;
            }
            if (!this.doingPhase2 || this.eAppx != EApproxReached.NOT_POSSIBLE) continue;
            System.out.println("\nCan never reach target epsilon approximation of " + targetEpsilon + " for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
        }
        if (this.isFullyDefined() && saveTopConfsAsPDB && this.eAppx == EApproxReached.TRUE) {
            this.writeTopConfs();
        }
        if (this.eAppx != EApproxReached.FALSE) {
            this.cleanup();
        }
        this.resetProcessedDuringInterval();
    }

    public void runToCompletion() {
        this.compute();
        if (this.eAppx == EApproxReached.NOT_POSSIBLE) {
            this.phase2();
            if (this.eAppx == EApproxReached.FALSE) {
                this.compute();
                if (this.eAppx != EApproxReached.TRUE) {
                    System.out.println("\nCan never reach target epsilon approximation of " + targetEpsilon + " for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
                }
            }
        }
        if (this.isFullyDefined() && saveTopConfsAsPDB) {
            this.writeTopConfs();
        }
        this.cleanup();
    }

    protected abstract void computeSlice();

    protected abstract void compute();

    protected abstract void iterate() throws Exception;

    protected void restart() {
        this.eAppx = EApproxReached.FALSE;
        this.printedHeader = false;
        this.processingConfs = BigInteger.ZERO;
        this.resetProcessedDuringInterval();
        this.start();
    }

    protected void phase2() {
        System.out.println("\nCould not reach target epsilon approximation of " + targetEpsilon + " for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
        this.doingPhase2 = true;
        if (this.getEffectiveEpsilon() == -1.0) {
            System.out.println("\nCan never reach target epsilon approximation of " + targetEpsilon + " for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
            return;
        }
        System.out.println("Attempting Phase 2...\n");
        if (this.HOTs != null && this.HOTs.size() > 0) {
            this.HOTs.clear();
        }
        double maxPruningInterval = this.cfp.params.getDouble("StericThresh");
        this.rePruneReducedSP(maxPruningInterval);
        this.setNumUnPruned();
        this.setNumPruned();
        if (!phase2Method.equalsIgnoreCase("fast") || !this.isFullyDefined()) {
            this.restart();
            return;
        }
        this.qPrime = BigDecimal.ZERO;
        this.initTradPStar();
        double effectiveEpsilon = this.computeEffectiveEpsilon();
        if (this.getQStar().compareTo(BigDecimal.ZERO) > 0 && effectiveEpsilon != -1.0 && effectiveEpsilon <= targetEpsilon) {
            this.setEpsilonStatus(EApproxReached.TRUE);
            System.out.println("\nReached target epsilon approximation of " + targetEpsilon + " for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
            return;
        }
        System.out.println("\nRe-starting K* for sequence: " + KSAbstract.list1D2String(this.sequence, " ") + " " + this.getFlexibility());
        this.restart();
    }

    public void cleanup() {
        this.e = null;
        this.HOTs = null;
        this.cfp = null;
        this.panSP = null;
        this.reducedSP = null;
        this.processedConfsSet = null;
    }

    public KSSearchProblem getReducedSearchProblem() {
        return this.reducedSP;
    }

    public KSSearchProblem getPanSeqSearchProblem() {
        return this.panSP;
    }

    public BigInteger getNumPruned() {
        return this.prunedConfs;
    }

    protected BigInteger getNumUnEnumerated() {
        return this.unPrunedConfs.subtract(this.getNumProcessed());
    }

    public BigInteger getNumUnPruned() {
        return this.unPrunedConfs;
    }

    protected BigInteger getProcessedDuringInterval() {
        return this.processedConfsDuringInterval;
    }

    protected void resetProcessedDuringInterval() {
        this.processedConfsDuringInterval = BigInteger.ZERO;
    }

    private static int setNumPEs(int requested) {
        if (requested < 1) {
            requested = 1;
        } else if (requested > Runtime.getRuntime().availableProcessors()) {
            requested = Runtime.getRuntime().availableProcessors();
        }
        return requested;
    }

    public static void setNumThreads(int threads) {
        numThreads = PFAbstract.setNumPEs(threads);
    }

    public static int getNumThreads() {
        return numThreads;
    }

    public static int getConfsThreadBuffer() {
        return threadConfsBuffer;
    }

    public static void setConfsThreadBuffer(int confsBuffer) {
        if (confsBuffer > 0) {
            threadConfsBuffer = confsBuffer;
        }
    }

    public static double getMaxInterval() {
        return Double.MAX_VALUE;
    }

    public void setRunState(RunState newState) {
        this.runState = newState;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public static void setStabilityThresh(double threshold) {
        threshold = threshold < 0.0 ? 0.0 : threshold;
        stabilityThresh = new BigDecimal(threshold);
    }

    public static BigDecimal getStabilityThresh() {
        return stabilityThresh;
    }

    public static void setHotBoundPct(String param, double value2) {
        if (value2 < 0.0 || value2 > 1.0) {
            throw new RuntimeException("ERROR: value of " + param + " must be in the range [0.0, 1.0]");
        }
        hotBoundPct = value2;
    }

    public static double getHotBoundPct() {
        return hotBoundPct;
    }

    public static void setHotTopRotsPct(String param, double value2) {
        if (value2 < 0.0 || value2 > 1.0) {
            throw new RuntimeException("ERROR: " + param + " must be in the range [0.0, 1.0]");
        }
        hotTopRotsPct = value2;
    }

    public static double getHotTopRotsPct() {
        return hotTopRotsPct;
    }

    public static void setHotNumRes(String param, int value2) {
        if (value2 < 3 || value2 > 4) {
            throw new RuntimeException("ERROR: allowed values of " + param + " are [3, 4]");
        }
        hotNumRes = value2;
    }

    public static int getHotNumRes() {
        return hotNumRes;
    }

    public static void setHotMethod(String param, String value2) {
        switch (value2) {
            case "none": 
            case "error": 
            case "manual": {
                hotMethod = value2;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: allowed values of " + param + " are {none|error|manual}");
            }
        }
    }

    public static String getHotMethod() {
        return hotMethod;
    }

    public static void setMaxKSconfs(long in) {
        if (in < 1L) {
            in = 1L;
        }
        maxKSConfs = in;
    }

    public boolean maxKSConfsReached() {
        return useMaxKSConfs && this.getNumProcessed().longValue() >= maxKSConfs;
    }

    public String getCheckPointPath() {
        return this.checkPointPath;
    }

    public boolean checkPointExists() {
        return new File(this.getCheckPointPath()).exists();
    }

    public abstract String getImpl();

    public static String getCFGImpl() {
        return pFuncCFGImpl;
    }

    public static void setCFGImpl(String implementation) {
        switch (implementation.toLowerCase()) {
            case "traditional": 
            case "ub": 
            case "parallel0": 
            case "parallel1": 
            case "parallel2": 
            case "parallelconf": {
                pFuncCFGImpl = implementation;
                break;
            }
            default: {
                throw new RuntimeException("ERROR: specified value of implementation " + implementation.toLowerCase() + " is invalid");
            }
        }
    }

    protected KSSearchProblem createReducedSP(boolean contSCFlex, int strand, ArrayList<String> seq, ArrayList<Integer> absolutePos) {
        KSSearchProblem reducedSP = this.panSP.getReducedSearchProblem(this.reducedSPName, KSAbstract.list1D2ListOfLists(KSAllowedSeqs.getAAsFromSeq(seq)), KSAllowedSeqs.getFlexResFromSeq(seq), absolutePos);
        return reducedSP;
    }

    public void rePruneReducedSP(double pruningInterval) {
        this.panSP = (KSSearchProblem)ObjectIO.deepCopy(this.panSP);
        if (this.panSP.emat == null) {
            this.panSP.emat = (EnergyMatrix)ObjectIO.readObject(this.panSP.getMatrixFileName(this.panSP.getMatrixType()), false);
        }
        this.cfp.setupPruning(this.panSP, pruningInterval, this.panSP.useEPIC, this.panSP.useTupExpForSearch).prune();
        this.reducedSP = this.createReducedSP(this.panSP.contSCFlex, this.strand, this.sequence, this.absolutePos);
    }

    public static enum EApproxReached {
        TRUE,
        FALSE,
        NOT_POSSIBLE,
        NOT_STABLE;

    }

    public static enum RunState {
        NOTSTARTED,
        STARTED;

    }
}

