/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergy;
import edu.duke.cs.osprey.energy.forcefield.SingleResEnergy;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class RCEnergyContribs {
    private PFAbstract pf = null;
    private HashMap<Integer, Double> flexResMinEContribs = null;
    private HashMap<Integer, Double> flexResPWLBContribs = null;
    private double flexResMinE = Double.POSITIVE_INFINITY;
    private double flexResPWLB = Double.POSITIVE_INFINITY;
    private ArrayList<BoundErrorByPos> boundErrorByPos = null;
    private HashMap<String, String> resNum2AA = null;
    private double minE = 0.0;
    private double pwLB = 0.0;

    public RCEnergyContribs(PFAbstract pf, MultiTermEnergyFunction mef, int[] conf) {
        this.pf = pf;
        this.resNum2AA = this.makeResNum2AA();
        this.minE = mef.getPreCompE();
        this.pwLB = pf.getConfBound(null, conf);
        this.computeEContrib(mef, conf);
        this.boundErrorByPos = this.getBoundErrorByPos();
    }

    private HashMap<String, String> makeResNum2AA() {
        HashMap<String, String> ans = new HashMap<String, String>(this.pf.getSequence().size());
        for (String res : this.pf.getSequence()) {
            String aa = res.split("-")[0];
            String resNum = res.split("-")[1];
            ans.put(resNum, aa);
        }
        return ans;
    }

    protected boolean isRes(Residue res, String resNum, String aa) {
        return res.getPDBResNumber().compareTo(resNum) == 0 && res.fullName.contains(aa);
    }

    protected boolean inFlexRes(Residue res) {
        String aa = this.resNum2AA.get(res.getPDBResNumber());
        if (aa == null) {
            return false;
        }
        return res.fullName.contains(aa);
    }

    protected ArrayList<BoundErrorByPos> getBoundErrorByPos() {
        if (this.boundErrorByPos != null) {
            return this.boundErrorByPos;
        }
        int numPos = this.pf.getReducedSearchProblem().confSpace.numPos;
        ArrayList<BoundErrorByPos> boundErrors = new ArrayList<BoundErrorByPos>(numPos);
        for (int pos = 0; pos < numPos; ++pos) {
            boundErrors.add(new BoundErrorByPos(this, pos, this.flexResPWLBContribs.get(pos) - this.flexResMinEContribs.get(pos)));
        }
        Iterator iterator2 = boundErrors.iterator();
        while (iterator2.hasNext()) {
            BoundErrorByPos errorAtPos = (BoundErrorByPos)iterator2.next();
            if (!this.pf.HOTsContains(errorAtPos.pos)) continue;
            iterator2.remove();
        }
        Collections.sort(boundErrors, new BoundErrorByPosComparator(this));
        return boundErrors;
    }

    public double getPercentErrorForTopPos(int num) {
        if (num < 3) {
            throw new RuntimeException("ERROR: num must be >= 3");
        }
        if (num > this.boundErrorByPos.size()) {
            return 0.0;
        }
        double percentErrorByNum = 0.0;
        for (int pos = 0; pos < num; ++pos) {
            percentErrorByNum += this.boundErrorByPos.get((int)pos).boundError;
        }
        double allFlexResBoundError = this.getReComputedBoundError();
        return percentErrorByNum /= allFlexResBoundError;
    }

    public int[] getTopPosCausingError(int num) {
        if (num < 3) {
            throw new RuntimeException("ERROR: num must be >= 3");
        }
        int[] ans = new int[num];
        if (num > this.boundErrorByPos.size()) {
            return ans;
        }
        for (int i = 0; i < num; ++i) {
            ans[i] = this.boundErrorByPos.get((int)i).pos;
        }
        Arrays.sort(ans);
        return ans;
    }

    public double getReComputedBoundError() {
        return this.flexResPWLB - this.flexResMinE;
    }

    public double getPercentBoundError() {
        return this.getReComputedBoundError() / this.flexResMinE;
    }

    public double getBoundError() {
        return this.pwLB - this.minE;
    }

    protected void computeEContrib(MultiTermEnergyFunction mef, int[] conf) {
        this.flexResMinE = this.getFlexResMinE(mef, true);
        this.flexResPWLB = this.getFlexResPWLB(conf, true);
        if (this.flexResMinE < this.flexResPWLB) {
            throw new RuntimeException("ERROR: flexResMinE: " + this.flexResMinE + " must be >= flexResPairWiseLB: " + this.flexResPWLB);
        }
        if (Math.abs(this.flexResPWLB - this.pwLB) > 1.0E-4) {
            throw new RuntimeException("ERROR: re-computed pwLB: " + this.flexResPWLB + " != actual pwLB: " + this.pwLB);
        }
        if (Math.abs(this.flexResMinE - this.minE) > 1.0E-4) {
            throw new RuntimeException("ERROR: re-computed minE: " + this.flexResPWLB + " != actual minE: " + this.minE);
        }
    }

    public double getFlexResMinE(MultiTermEnergyFunction mef, boolean addTemplateSelfE) {
        if (this.flexResMinE != Double.POSITIVE_INFINITY) {
            return this.flexResMinE;
        }
        this.flexResMinEContribs = this.getFlexResMinEContribs(mef);
        this.flexResMinE = this.sumETerms(this.flexResMinEContribs);
        if (addTemplateSelfE) {
            this.flexResMinE += this.getConstTerm();
        }
        return this.flexResMinE;
    }

    public double getFlexResPWLB(int[] conf, boolean addTemplateSelfE) {
        if (this.flexResPWLB != Double.POSITIVE_INFINITY) {
            return this.flexResPWLB;
        }
        this.flexResPWLBContribs = this.getFlexResPWLBContribs(conf);
        this.flexResPWLB = this.sumETerms(this.flexResPWLBContribs);
        if (addTemplateSelfE) {
            this.flexResPWLB += this.getConstTerm();
        }
        return this.flexResPWLB;
    }

    private double getConstTerm() {
        return this.pf.getReducedSearchProblem().getEnergyMatrix().getConstTerm();
    }

    private double sumETerms(HashMap<Integer, Double> map) {
        double E = 0.0;
        for (double partialE : map.values()) {
            E += partialE;
        }
        return E;
    }

    private HashMap<Integer, Double> getFlexResMinEContribs(MultiTermEnergyFunction mef) {
        int numPos = this.pf.getReducedSearchProblem().confSpace.numPos;
        HashMap<Integer, Double> ans = new HashMap<Integer, Double>(numPos);
        for (int pos = 0; pos < numPos; ++pos) {
            double intra = 0.0;
            double pairwise = 0.0;
            String aa = this.pf.getSequence().get(pos).split("-")[0];
            String resNum = this.pf.getSequence().get(pos).split("-")[1];
            for (int j = 0; j < mef.getTerms().size(); ++j) {
                if (mef.getTerms().get(j) instanceof SingleResEnergy) {
                    Residue res = ((SingleResEnergy)mef.getTerms().get(j)).getRes();
                    if (!this.isRes(res, resNum, aa)) continue;
                    intra += mef.getCoeffs().get(j) * mef.getTerms().get(j).getEnergy();
                    continue;
                }
                if (!(mef.getTerms().get(j) instanceof ResPairEnergy)) continue;
                Residue res1 = ((ResPairEnergy)mef.getTerms().get(j)).getRes1();
                Residue res2 = ((ResPairEnergy)mef.getTerms().get(j)).getRes2();
                if (this.isRes(res1, resNum, aa) && this.inFlexRes(res2) || this.isRes(res2, resNum, aa) && this.inFlexRes(res1)) {
                    double partialPW = mef.getCoeffs().get(j) * mef.getTerms().get(j).getEnergy();
                    pairwise += 0.5 * partialPW;
                    continue;
                }
                if ((!this.isRes(res1, resNum, aa) || this.inFlexRes(res2)) && (!this.isRes(res2, resNum, aa) || this.inFlexRes(res1))) continue;
                intra += mef.getCoeffs().get(j) * mef.getTerms().get(j).getEnergy();
            }
            ans.put(pos, intra + pairwise);
        }
        return ans;
    }

    private HashMap<Integer, Double> getFlexResPWLBContribs(int[] conf) {
        int numPos = this.pf.getReducedSearchProblem().confSpace.numPos;
        HashMap<Integer, Double> ans = new HashMap<Integer, Double>(numPos);
        for (int pos = 0; pos < conf.length; ++pos) {
            double E = this.pf.getReducedSearchProblem().lowerBoundContribByRC(pos, conf, PFAbstract.getHotNumRes());
            ans.put(pos, E);
        }
        return ans;
    }

    protected class BoundErrorByPos {
        int pos;
        double boundError;

        public BoundErrorByPos(RCEnergyContribs this$0, int pos, double boundError) {
            this.pos = pos;
            this.boundError = boundError;
        }
    }

    protected class BoundErrorByPosComparator
    implements Comparator<BoundErrorByPos> {
        protected BoundErrorByPosComparator(RCEnergyContribs this$0) {
        }

        @Override
        public int compare(BoundErrorByPos o1, BoundErrorByPos o2) {
            if (o1.boundError < o2.boundError) {
                return -1;
            }
            return 1;
        }
    }
}

