/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.prep.Anchor;
import edu.duke.cs.osprey.gui.tools.UnsupportedClassException;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003456B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0015J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020$J\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0#J\u000e\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020$J:\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\b\b\u0002\u00100\u001a\u00020\u00032\b\b\u0002\u00101\u001a\u00020\u00032\u000e\b\u0002\u00102\u001a\b\u0012\u0004\u0012\u0002030#R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012\u00a8\u00067"}, d2={"Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "", "name", "", "type", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ljava/lang/String;Ljava/lang/String;Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "anchorGroups", "", "Ledu/duke/cs/osprey/gui/prep/Anchor;", "getAnchorGroups", "()Ljava/util/List;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "sourceAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getSourceAtoms", "()Ljava/util/Set;", "getType", "setType", "anchorDouble", "Ledu/duke/cs/osprey/gui/prep/Anchor$Double;", "a", "b", "c", "d", "anchorSingle", "Ledu/duke/cs/osprey/gui/prep/Anchor$Single;", "compatibleFragments", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "conflib", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "findAnchorMatch", "Ledu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch;", "frag", "getCurrentAnchorGroups", "isFragmentCompatible", "", "makeFragment", "fragId", "fragName", "confId", "confName", "motions", "Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion;", "AnchorMatch", "IllegalAnchorsException", "IncompatibleAnchorsException", "osprey3"})
@SourceDebugExtension(value={"SMAP\nDesignPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignPosition.kt\nedu/duke/cs/osprey/gui/prep/DesignPosition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,250:1\n766#2:251\n857#2,2:252\n288#2:254\n1726#2,3:255\n289#2:258\n766#2:259\n857#2:260\n1549#2:261\n1620#2,3:262\n858#2:265\n1045#2:266\n1271#2,2:267\n1285#2,4:269\n1045#2:273\n1045#2:274\n1360#2:275\n1446#2,2:276\n766#2:278\n857#2,2:279\n1603#2,9:281\n1855#2:290\n1856#2:292\n1612#2:293\n1448#2,3:294\n1179#2,2:297\n1253#2,4:299\n1179#2,2:307\n1253#2,4:309\n1549#2:313\n1620#2,3:314\n1#3:291\n125#4:303\n152#4,3:304\n*S KotlinDebug\n*F\n+ 1 DesignPosition.kt\nedu/duke/cs/osprey/gui/prep/DesignPosition\n*L\n41#1:251\n41#1:252,2\n107#1:254\n115#1:255,3\n107#1:258\n132#1:259\n132#1:260\n135#1:261\n135#1:262,3\n132#1:265\n179#1:266\n194#1:267,2\n194#1:269,4\n199#1:273\n202#1:274\n210#1:275\n210#1:276,2\n213#1:278\n213#1:279,2\n214#1:281,9\n214#1:290\n214#1:292\n214#1:293\n210#1:294,3\n231#1:297,2\n231#1:299,4\n238#1:307,2\n238#1:309,4\n242#1:313\n242#1:314,3\n214#1:291\n235#1:303\n235#1:304,3\n*E\n"})
public final class DesignPosition {
    @NotNull
    private String name;
    @NotNull
    private String type;
    @NotNull
    private final Molecule mol;
    @NotNull
    private final List<List<Anchor>> anchorGroups;
    @NotNull
    private final Set<Atom> sourceAtoms;

    public DesignPosition(@NotNull String name, @NotNull String type, @NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        this.name = name;
        this.type = type;
        this.mol = mol;
        this.anchorGroups = new ArrayList();
        this.sourceAtoms = Atom.Companion.identitySet();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @NotNull
    public final List<List<Anchor>> getAnchorGroups() {
        return this.anchorGroups;
    }

    @NotNull
    public final Set<Atom> getSourceAtoms() {
        return this.sourceAtoms;
    }

    public final boolean isFragmentCompatible(@NotNull ConfLib.Fragment frag) {
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        return this.findAnchorMatch(frag) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConfLib.Fragment> compatibleFragments(@NotNull ConfLib conflib) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
        Iterable $this$filter$iv = conflib.getFragments().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfLib.Fragment it = (ConfLib.Fragment)element$iv$iv;
            boolean bl = false;
            if (!this.isFragmentCompatible(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final AnchorMatch findAnchorMatch(@NotNull ConfLib.Fragment frag) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            $this$firstOrNull$iv = this.anchorGroups;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block8: {
                    posAnchors = (List)element$iv;
                    $i$a$-firstOrNull-DesignPosition$findAnchorMatch$1 = false;
                    if (posAnchors.size() != frag.getAnchors().size()) ** GOTO lbl-1000
                    var9_10 = CollectionsKt.zip((Iterable)posAnchors, (Iterable)frag.getAnchors());
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v0 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            var13_14 = (Pair)element$iv;
                            $i$a$-all-DesignPosition$findAnchorMatch$1$1 = false;
                            posAnchor = (Anchor)var13_14.component1();
                            if (posAnchor.isAnchorCompatible(fragAnchor = (ConfLib.Anchor)var13_14.component2())) continue;
                            v0 = false;
                            break block8;
                        }
                        v0 = true;
                    }
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        var2_18 = v2;
        if (var2_18 != null) {
            posAnchors = var2_18;
            $i$a$-let-DesignPosition$findAnchorMatch$2 = false;
            v3 = new AnchorMatch(posAnchors, frag.getAnchors());
        } else {
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<Anchor>> getCurrentAnchorGroups() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.anchorGroups;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block5: {
                void $this$mapTo$iv$iv;
                List anchors = (List)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv = anchors;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Anchor anchor = (Anchor)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(it.getConnectedAtoms(this.sourceAtoms));
                }
                List atoms = (List)destination$iv$iv2;
                int n = atoms.size();
                for (int i = 0; i < n; ++i) {
                    if (!((Anchor)anchors.get(i)).connectedAtomsIsSingleComponent(this.sourceAtoms)) {
                        bl = false;
                        break block5;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (!(!((Collection)MoleculeKt.intersection((Set)atoms.get(i), (Set)atoms.get(j))).isEmpty())) continue;
                        bl = false;
                        break block5;
                    }
                }
                bl = Intrinsics.areEqual(MoleculeKt.union(atoms), this.sourceAtoms);
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConfLib.Fragment makeFragment(@NotNull String fragId, @NotNull String fragName, @NotNull String confId, @NotNull String confName, @NotNull List<? extends ConfLib.ContinuousMotion> motions) {
        Object object;
        void $this$mapTo$iv$iv;
        Object object2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        void $this$associateTo$iv$iv;
        Object $this$associate$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Iterable $this$sortedBy$iv;
        void $this$sortedBy$iv2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)fragId, (String)"fragId");
        Intrinsics.checkNotNullParameter((Object)fragName, (String)"fragName");
        Intrinsics.checkNotNullParameter((Object)confId, (String)"confId");
        Intrinsics.checkNotNullParameter((Object)confName, (String)"confName");
        Intrinsics.checkNotNullParameter(motions, (String)"motions");
        List<List<Anchor>> groups = this.getCurrentAnchorGroups();
        boolean bl = false;
        if (groups.isEmpty()) {
            throw new IllegalAnchorsException("can't make fragment for this design position, no active anchors", this);
        }
        if (groups.size() > 1) {
            throw new IllegalAnchorsException("can't make fragment for this design position, multiple active anchors", this);
        }
        List<Anchor> posAnchors = groups.get(0);
        Iterable $this$sortedBy$iv3 = this.sourceAtoms;
        boolean $i$f$sortedBy = false;
        List sortedAtoms = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Atom it = (Atom)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Atom)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Map<Atom, ConfLib.AtomInfo> $this$makeFragment_u24lambda_u248 = $i$f$sortedBy = Atom.Companion.identityMap();
        boolean bl2 = false;
        Iterator iterator2 = sortedAtoms.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Atom atom = (Atom)iterator2.next();
            $this$makeFragment_u24lambda_u248.put(atom, new ConfLib.AtomInfo(i + 1, atom.getName(), atom.getElement()));
        }
        Map<Atom, ConfLib.AtomInfo> atomInfos = $i$f$sortedBy;
        int nextAnchorId = 0;
        nextAnchorId = 1;
        Iterable $this$associateWith$iv = posAnchors;
        boolean $i$f$associateWith232 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo232 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Iterator posAnchor;
            Anchor anchor = (Anchor)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl3 = false;
            int n2 = nextAnchorId;
            nextAnchorId = n2 + 1;
            object3 = ((Anchor)((Object)posAnchor)).makeLibraryAnchor(this.sourceAtoms, n2, (Function1<? super Atom, ConfLib.AtomInfo>)((Function1)new Function1<Atom, ConfLib.AtomInfo>(atomInfos){
                final /* synthetic */ Map<Atom, ConfLib.AtomInfo> $atomInfos;
                {
                    this.$atomInfos = $atomInfos;
                    super(1);
                }

                @NotNull
                public final ConfLib.AtomInfo invoke(@NotNull Atom atom) {
                    Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                    return DesignPosition.access$makeFragment$info(atom, this.$atomInfos);
                }
            }));
            map.put(t, object3);
        }
        Map anchorsFragByPos2 = result$iv;
        Iterable $i$f$associateWith232 = atomInfos.values();
        boolean $i$f$sortedBy232 = false;
        List atoms = CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfLib.AtomInfo it = (ConfLib.AtomInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getId());
                it = (ConfLib.AtomInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getId()));
            }
        }));
        Iterable $i$f$sortedBy232 = anchorsFragByPos2.values();
        boolean $i$f$sortedBy3 = false;
        List anchors = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfLib.Anchor it = (ConfLib.Anchor)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getId());
                it = (ConfLib.Anchor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getId()));
            }
        });
        $this$sortedBy$iv = sortedAtoms;
        List list = atoms;
        String string = this.type;
        String string2 = fragName;
        object3 = fragId;
        boolean $i$f$flatMap = false;
        void $i$f$associateWithTo232 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Atom atom = (Atom)t;
            boolean bl4 = false;
            ConfLib.AtomInfo atomInfo = DesignPosition.makeFragment$info(atom, atomInfos);
            Iterable iterable = this.mol.getBonds().bondedAtomsSorted(atom);
            boolean $i$f$filter = false;
            void var25_76 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Atom it = (Atom)element$iv$iv2;
                boolean bl5 = false;
                if (!this.sourceAtoms.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                ConfLib.Bond it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv3 = element$iv$iv$iv = iterator3.next();
                boolean bl6 = false;
                Atom bondedAtom = (Atom)element$iv$iv3;
                boolean bl7 = false;
                ConfLib.AtomInfo bondedInfo = DesignPosition.makeFragment$info(bondedAtom, atomInfos);
                if ((atomInfo.getId() < bondedInfo.getId() ? new ConfLib.Bond(atomInfo, bondedInfo) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$flatMap$iv = this.sourceAtoms;
        String string3 = null;
        String string4 = confName;
        String string5 = confId;
        Object object4 = confId;
        List list3 = anchors;
        boolean $i$f$associate = false;
        int capacity$iv232 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv232);
        boolean $i$f$associateTo22 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl4 = destination$iv$iv3;
            Atom atom = (Atom)element$iv$iv;
            boolean bl9 = false;
            atom = TuplesKt.to((Object)DesignPosition.makeFragment$info(atom, atomInfos), (Object)new Vector3d((Vector3dc)atom.getPos()));
            bl4.put(atom.getFirst(), atom.getSecond());
        }
        Map map = destination$iv$iv3;
        $this$associate$iv = anchorsFragByPos2;
        boolean $i$f$map = false;
        void capacity$iv232 = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator $i$f$associateTo22 = $this$mapTo$iv$iv2.entrySet().iterator();
        while ($i$f$associateTo22.hasNext()) {
            Map.Entry entry;
            Map.Entry element$iv$iv = entry = $i$f$associateTo22.next();
            object2 = destination$iv$iv;
            boolean bl10 = false;
            Anchor posAnchor = (Anchor)element$iv$iv.getKey();
            ConfLib.Anchor fragAnchor = (ConfLib.Anchor)element$iv$iv.getValue();
            object2.add(TuplesKt.to((Object)fragAnchor, (Object)posAnchor.makeLibraryCoords()));
        }
        object2 = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object2;
        $i$f$associate = false;
        int capacity$iv332 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv332);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map bl10 = destination$iv$iv4;
            Pair it = (Pair)element$iv$iv;
            boolean bl11 = false;
            Pair pair = it;
            bl10.put(pair.getFirst(), pair.getSecond());
        }
        Object object5 = object2 = destination$iv$iv4;
        Map map2 = map;
        String string6 = string3;
        String string7 = string4;
        String string8 = string5;
        $this$associate$iv = motions;
        object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)object4, (Object)new ConfLib.Conf(string8, string7, string6, map2, (Map<ConfLib.Anchor, ? extends ConfLib.AnchorCoords>)object5)));
        $i$f$map = false;
        Iterable capacity$iv332 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            ConfLib.ContinuousMotion element$iv$iv = (ConfLib.ContinuousMotion)t;
            object = destination$iv$iv;
            boolean bl12 = false;
            object.add(it.copyTo(atoms, anchors, it.getId()));
        }
        Object object6 = object = (List)destination$iv$iv;
        Object object7 = object4;
        List list4 = list3;
        List list5 = list2;
        List list6 = list;
        String string9 = string;
        String string10 = string2;
        Object object8 = object3;
        return new ConfLib.Fragment((String)object8, string10, string9, list6, list5, list4, (Map<String, ConfLib.Conf>)object7, (List<? extends ConfLib.ContinuousMotion>)object6);
    }

    public static /* synthetic */ ConfLib.Fragment makeFragment$default(DesignPosition designPosition, String string, String string2, String string3, String string4, List list, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = string;
        }
        if ((n & 8) != 0) {
            string4 = string2;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return designPosition.makeFragment(string, string2, string3, string4, list);
    }

    @NotNull
    public final Anchor.Single anchorSingle(@NotNull Atom a, @NotNull Atom b, @NotNull Atom c) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Anchor.Single(this.mol, a, b, c);
    }

    @NotNull
    public final Anchor.Double anchorDouble(@NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        return new Anchor.Double(this.mol, a, b, c, d);
    }

    private static final ConfLib.AtomInfo makeFragment$info(Atom $this$makeFragment_u24info, Map<Atom, ConfLib.AtomInfo> atomInfos) {
        ConfLib.AtomInfo atomInfo = atomInfos.get($this$makeFragment_u24info);
        if (atomInfo == null) {
            throw new NoSuchElementException("no atom info for " + $this$makeFragment_u24info.getName());
        }
        return atomInfo;
    }

    public static final /* synthetic */ ConfLib.AtomInfo access$makeFragment$info(Atom $receiver, Map atomInfos) {
        return DesignPosition.makeFragment$info($receiver, atomInfos);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0006J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\t\u0010%\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006&"}, d2={"Ledu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch;", "", "posAnchors", "", "Ledu/duke/cs/osprey/gui/prep/Anchor;", "fragAnchors", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "(Ljava/util/List;Ljava/util/List;)V", "getFragAnchors", "()Ljava/util/List;", "pairs", "Lkotlin/Pair;", "getPairs", "getPosAnchors", "component1", "component2", "copy", "copyToMol", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atomMap", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "equals", "", "other", "findPosAnchor", "fragAnchor", "hashCode", "", "resolveElement", "Ledu/duke/cs/osprey/molscope/molecule/Element;", "p", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer;", "resolveElementOrThrow", "resolveName", "", "resolveNameOrThrow", "toString", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nDesignPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignPosition.kt\nedu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1#2:251\n1549#3:252\n1620#3,3:253\n*S KotlinDebug\n*F\n+ 1 DesignPosition.kt\nedu/duke/cs/osprey/gui/prep/DesignPosition$AnchorMatch\n*L\n99#1:252\n99#1:253,3\n*E\n"})
    public static final class AnchorMatch {
        @NotNull
        private final List<Anchor> posAnchors;
        @NotNull
        private final List<ConfLib.Anchor> fragAnchors;
        @NotNull
        private final List<Pair<Anchor, ConfLib.Anchor>> pairs;

        public AnchorMatch(@NotNull List<? extends Anchor> posAnchors, @NotNull List<? extends ConfLib.Anchor> fragAnchors) {
            Intrinsics.checkNotNullParameter(posAnchors, (String)"posAnchors");
            Intrinsics.checkNotNullParameter(fragAnchors, (String)"fragAnchors");
            this.posAnchors = posAnchors;
            this.fragAnchors = fragAnchors;
            this.pairs = CollectionsKt.zip((Iterable)this.posAnchors, (Iterable)this.fragAnchors);
        }

        @NotNull
        public final List<Anchor> getPosAnchors() {
            return this.posAnchors;
        }

        @NotNull
        public final List<ConfLib.Anchor> getFragAnchors() {
            return this.fragAnchors;
        }

        @NotNull
        public final List<Pair<Anchor, ConfLib.Anchor>> getPairs() {
            return this.pairs;
        }

        @Nullable
        public final Anchor findPosAnchor(@NotNull ConfLib.Anchor fragAnchor) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)fragAnchor, (String)"fragAnchor");
                Iterable iterable = this.pairs;
                for (Object t : iterable) {
                    Pair it = (Pair)t;
                    boolean bl = false;
                    if (!(it.getSecond() == fragAnchor)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Pair pair = v0;
            return pair != null ? (Anchor)pair.getFirst() : null;
        }

        @Nullable
        public final String resolveName(@NotNull ConfLib.AtomPointer p) {
            String string;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            ConfLib.AtomPointer atomPointer = p;
            if (atomPointer instanceof ConfLib.AtomInfo) {
                string = ((ConfLib.AtomInfo)p).getName();
            } else if (atomPointer instanceof ConfLib.AnchorAtomPointer) {
                Anchor anchor = this.findPosAnchor(((ConfLib.AnchorAtomPointer)p).getAnchor());
                if (anchor == null) {
                    throw new RuntimeException("no matched anchor");
                }
                Anchor posAnchor = anchor;
                Atom atom = (Atom)CollectionsKt.getOrNull(posAnchor.getAnchorAtoms(), (int)((ConfLib.AnchorAtomPointer)p).getIndex());
                string = atom != null ? atom.getName() : null;
            } else {
                throw new UnsupportedClassException("unrecognized atom pointer type", this);
            }
            return string;
        }

        @NotNull
        public final String resolveNameOrThrow(@NotNull ConfLib.AtomPointer p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            String string = this.resolveName(p);
            if (string == null) {
                throw new NoSuchElementException("no atom found for pointer " + p);
            }
            return string;
        }

        @Nullable
        public final Element resolveElement(@NotNull ConfLib.AtomPointer p) {
            Element element;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            ConfLib.AtomPointer atomPointer = p;
            if (atomPointer instanceof ConfLib.AtomInfo) {
                element = ((ConfLib.AtomInfo)p).getElement();
            } else if (atomPointer instanceof ConfLib.AnchorAtomPointer) {
                Anchor anchor = this.findPosAnchor(((ConfLib.AnchorAtomPointer)p).getAnchor());
                if (anchor == null) {
                    throw new RuntimeException("no matched anchor");
                }
                Anchor posAnchor = anchor;
                Atom atom = (Atom)CollectionsKt.getOrNull(posAnchor.getAnchorAtoms(), (int)((ConfLib.AnchorAtomPointer)p).getIndex());
                element = atom != null ? atom.getElement() : null;
            } else {
                throw new UnsupportedClassException("unrecognized atom pointer type", this);
            }
            return element;
        }

        @NotNull
        public final Element resolveElementOrThrow(@NotNull ConfLib.AtomPointer p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Element element = this.resolveElement(p);
            if (element == null) {
                throw new NoSuchElementException("no atom found for pointer " + p);
            }
            return element;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AnchorMatch copyToMol(@NotNull Molecule mol, @NotNull AtomMap atomMap2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)atomMap2, (String)"atomMap");
            Iterable $this$map$iv = this.posAnchors;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Anchor anchor = (Anchor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.copyToMol(mol, atomMap2));
            }
            List<ConfLib.Anchor> list = this.fragAnchors;
            List list2 = (List)destination$iv$iv;
            return new AnchorMatch(list2, list);
        }

        @NotNull
        public final List<Anchor> component1() {
            return this.posAnchors;
        }

        @NotNull
        public final List<ConfLib.Anchor> component2() {
            return this.fragAnchors;
        }

        @NotNull
        public final AnchorMatch copy(@NotNull List<? extends Anchor> posAnchors, @NotNull List<? extends ConfLib.Anchor> fragAnchors) {
            Intrinsics.checkNotNullParameter(posAnchors, (String)"posAnchors");
            Intrinsics.checkNotNullParameter(fragAnchors, (String)"fragAnchors");
            return new AnchorMatch(posAnchors, fragAnchors);
        }

        public static /* synthetic */ AnchorMatch copy$default(AnchorMatch anchorMatch, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = anchorMatch.posAnchors;
            }
            if ((n & 2) != 0) {
                list2 = anchorMatch.fragAnchors;
            }
            return anchorMatch.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "AnchorMatch(posAnchors=" + this.posAnchors + ", fragAnchors=" + this.fragAnchors + ")";
        }

        public int hashCode() {
            int result = ((Object)this.posAnchors).hashCode();
            result = result * 31 + ((Object)this.fragAnchors).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnchorMatch)) {
                return false;
            }
            AnchorMatch anchorMatch = (AnchorMatch)other;
            if (!Intrinsics.areEqual(this.posAnchors, anchorMatch.posAnchors)) {
                return false;
            }
            return Intrinsics.areEqual(this.fragAnchors, anchorMatch.fragAnchors);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ledu/duke/cs/osprey/gui/prep/DesignPosition$IllegalAnchorsException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "msg", "", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "(Ljava/lang/String;Ledu/duke/cs/osprey/gui/prep/DesignPosition;)V", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "osprey3"})
    public static final class IllegalAnchorsException
    extends IllegalStateException {
        @NotNull
        private final DesignPosition pos;

        public IllegalAnchorsException(@NotNull String msg, @NotNull DesignPosition pos) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            super(msg);
            this.pos = pos;
        }

        @NotNull
        public final DesignPosition getPos() {
            return this.pos;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ledu/duke/cs/osprey/gui/prep/DesignPosition$IncompatibleAnchorsException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;)V", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "osprey3"})
    public static final class IncompatibleAnchorsException
    extends RuntimeException {
        @NotNull
        private final DesignPosition pos;
        @NotNull
        private final ConfLib.Fragment frag;

        public IncompatibleAnchorsException(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            super("design position " + pos.getName() + " anchors are not compatible with fragment " + frag.getId() + " anchors");
            this.pos = pos;
            this.frag = frag;
        }

        @NotNull
        public final DesignPosition getPos() {
            return this.pos;
        }

        @NotNull
        public final ConfLib.Fragment getFrag() {
            return this.frag;
        }
    }
}

