/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import cuchaz.kludge.tools.LangKt;
import edu.duke.cs.osprey.gui.prep.AtomTree;
import edu.duke.cs.osprey.gui.prep.AtomTreeKt;
import edu.duke.cs.osprey.gui.prep.BondGuesser;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\u0002\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u000e\u001a\u00020\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u000f\u001a\u00020\u0002*\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"covalentRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "a2", "guesser", "Ledu/duke/cs/osprey/gui/prep/BondGuesser;", "guessBonds", "", "Ledu/duke/cs/osprey/gui/prep/BondGuesser$Bond;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "searchDist", "inCovalentRange", "", "maxCovalentDist", "minCovalentDist", "osprey3"})
public final class BondGuesserKt {
    @NotNull
    public static final List<BondGuesser.Bond> guessBonds(@NotNull Molecule $this$guessBonds, @NotNull BondGuesser guesser, double searchDist) {
        Intrinsics.checkNotNullParameter((Object)$this$guessBonds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)guesser, (String)"guesser");
        double searchDistSq = LangKt.square((double)searchDist);
        AtomTree tree = AtomTreeKt.toTree($this$guessBonds.getAtoms());
        ArrayList<BondGuesser.Bond> guessedBonds = new ArrayList<BondGuesser.Bond>();
        block0: for (Atom atom1 : $this$guessBonds.getAtoms()) {
            BondGuesser.ElementProps props1 = BondGuesserKt.guessBonds$props(atom1, guesser);
            Iterator<Pair<Atom, Double>> nearbyAtoms2 = tree.nearest(atom1);
            while ($this$guessBonds.getBonds().bondedAtoms(atom1).size() < props1.getMaxValence() && nearbyAtoms2.hasNext()) {
                double covDistSq;
                Pair<Atom, Double> pair = nearbyAtoms2.next();
                Atom atom2 = (Atom)pair.component1();
                double distSq = ((Number)pair.component2()).doubleValue();
                BondGuesser.ElementProps props2 = BondGuesserKt.guessBonds$props(atom2, guesser);
                if (distSq > searchDistSq) continue block0;
                if (distSq < guesser.getMinDistSq() || distSq > (covDistSq = LangKt.square((double)(props1.getBondRadius() + props2.getBondRadius() + guesser.getTolerance())))) continue;
                guessedBonds.add(new BondGuesser.Bond(atom1, atom2));
            }
        }
        return guessedBonds;
    }

    public static /* synthetic */ List guessBonds$default(Molecule molecule, BondGuesser bondGuesser, double d, int n, Object object) {
        if ((n & 1) != 0) {
            bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        }
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return BondGuesserKt.guessBonds(molecule, bondGuesser, d);
    }

    public static final boolean inCovalentRange(@NotNull Atom $this$inCovalentRange, @NotNull Atom a2, @NotNull BondGuesser guesser) {
        Intrinsics.checkNotNullParameter((Object)$this$inCovalentRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        Intrinsics.checkNotNullParameter((Object)guesser, (String)"guesser");
        Atom a1 = $this$inCovalentRange;
        double distSq = a1.getPos().distanceSquared((Vector3dc)a2.getPos());
        if (distSq < guesser.getMinDistSq()) {
            return false;
        }
        return distSq <= LangKt.square((double)(BondGuesserKt.inCovalentRange$props$0(a1, guesser).getBondRadius() + BondGuesserKt.inCovalentRange$props$0(a2, guesser).getBondRadius() + guesser.getTolerance()));
    }

    public static /* synthetic */ boolean inCovalentRange$default(Atom atom, Atom atom2, BondGuesser bondGuesser, int n, Object object) {
        if ((n & 2) != 0) {
            bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        }
        return BondGuesserKt.inCovalentRange(atom, atom2, bondGuesser);
    }

    public static final double minCovalentDist(@NotNull Atom $this$minCovalentDist, @NotNull BondGuesser guesser) {
        Intrinsics.checkNotNullParameter((Object)$this$minCovalentDist, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)guesser, (String)"guesser");
        return guesser.getMinDist();
    }

    public static /* synthetic */ double minCovalentDist$default(Atom atom, BondGuesser bondGuesser, int n, Object object) {
        if ((n & 1) != 0) {
            bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        }
        return BondGuesserKt.minCovalentDist(atom, bondGuesser);
    }

    public static final double maxCovalentDist(@NotNull Atom $this$maxCovalentDist, @NotNull Atom a2, @NotNull BondGuesser guesser) {
        Intrinsics.checkNotNullParameter((Object)$this$maxCovalentDist, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        Intrinsics.checkNotNullParameter((Object)guesser, (String)"guesser");
        Atom a1 = $this$maxCovalentDist;
        return BondGuesserKt.maxCovalentDist$props$1(a1, guesser).getBondRadius() + BondGuesserKt.maxCovalentDist$props$1(a2, guesser).getBondRadius() + guesser.getTolerance();
    }

    public static /* synthetic */ double maxCovalentDist$default(Atom atom, Atom atom2, BondGuesser bondGuesser, int n, Object object) {
        if ((n & 2) != 0) {
            bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        }
        return BondGuesserKt.maxCovalentDist(atom, atom2, bondGuesser);
    }

    @NotNull
    public static final ClosedFloatingPointRange<Double> covalentRange(@NotNull Atom $this$covalentRange, @NotNull Atom a2, @NotNull BondGuesser guesser) {
        Intrinsics.checkNotNullParameter((Object)$this$covalentRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        Intrinsics.checkNotNullParameter((Object)guesser, (String)"guesser");
        return RangesKt.rangeTo((double)BondGuesserKt.minCovalentDist$default($this$covalentRange, null, 1, null), (double)BondGuesserKt.maxCovalentDist$default($this$covalentRange, a2, null, 2, null));
    }

    public static /* synthetic */ ClosedFloatingPointRange covalentRange$default(Atom atom, Atom atom2, BondGuesser bondGuesser, int n, Object object) {
        if ((n & 2) != 0) {
            bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        }
        return BondGuesserKt.covalentRange(atom, atom2, bondGuesser);
    }

    private static final BondGuesser.ElementProps guessBonds$props(Atom $this$guessBonds_u24props, BondGuesser $guesser) {
        return $guesser.getProps($this$guessBonds_u24props);
    }

    private static final BondGuesser.ElementProps inCovalentRange$props$0(Atom $this$inCovalentRange_u24props_u240, BondGuesser $guesser) {
        return $guesser.getProps($this$inCovalentRange_u24props_u240);
    }

    private static final BondGuesser.ElementProps maxCovalentDist$props$1(Atom $this$maxCovalentDist_u24props_u241, BondGuesser $guesser) {
        return $guesser.getProps($this$maxCovalentDist_u24props_u241);
    }
}

