/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import cuchaz.kludge.tools.MathKt;
import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.prep.Anchor;
import edu.duke.cs.osprey.gui.prep.IllegalAlignmentException;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u000201B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J0\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u001e\u0010\u0015\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\u0016H&J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH&J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH&J\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH&J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H&J2\u0010\"\u001a\u00020\u00142\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170&H&J\b\u0010'\u001a\u00020\u0011H&J0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070 *\u00020\u00072\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0004J\u001a\u0010\"\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u0010+\u001a\u00020,H\u0004J\u001a\u0010-\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u0010.\u001a\u00020/H\u0004R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u000223\u00a8\u00064"}, d2={"Ledu/duke/cs/osprey/gui/prep/Anchor;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "anchorAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getAnchorAtoms", "()Ljava/util/List;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "align", "", "atoms", "", "anchorCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "bondToAnchors", "anchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "bondFunc", "Lkotlin/Function2;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "connectedAtomsIsSingleComponent", "", "copyToMol", "oldToNew", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "findResidue", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "getConnectedAtoms", "", "isAnchorCompatible", "makeLibraryAnchor", "id", "", "getAtomInfo", "Lkotlin/Function1;", "makeLibraryCoords", "included", "blockers", "", "t", "Lorg/joml/Vector3d;", "rotate", "q", "Lorg/joml/Quaterniond;", "Double", "Single", "Ledu/duke/cs/osprey/gui/prep/Anchor$Double;", "Ledu/duke/cs/osprey/gui/prep/Anchor$Single;", "osprey3"})
@SourceDebugExtension(value={"SMAP\nanchors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n766#2:356\n857#2,2:357\n1360#2:359\n1446#2,2:360\n1549#2:362\n1620#2,3:363\n1448#2,3:366\n*S KotlinDebug\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor\n*L\n61#1:356\n61#1:357,2\n62#1:359\n62#1:360,2\n69#1:362\n69#1:363,3\n62#1:366,3\n*E\n"})
public abstract sealed class Anchor {
    @NotNull
    private final Molecule mol;

    private Anchor(Molecule mol) {
        this.mol = mol;
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @NotNull
    public abstract List<Atom> getAnchorAtoms();

    @NotNull
    public abstract Set<Atom> getConnectedAtoms(@NotNull Set<Atom> var1);

    public abstract boolean connectedAtomsIsSingleComponent(@NotNull Set<Atom> var1);

    public abstract boolean isAnchorCompatible(@NotNull ConfLib.Anchor var1);

    public abstract void bondToAnchors(@NotNull ConfLib.Anchor var1, @NotNull Function2<? super List<ConfLib.AtomInfo>, ? super Atom, Unit> var2);

    public abstract void align(@NotNull Set<Atom> var1, @NotNull ConfLib.AnchorCoords var2);

    @NotNull
    public abstract ConfLib.Anchor makeLibraryAnchor(@NotNull Set<Atom> var1, int var2, @NotNull Function1<? super Atom, ConfLib.AtomInfo> var3);

    @NotNull
    public abstract ConfLib.AnchorCoords makeLibraryCoords();

    @NotNull
    public abstract Anchor copyToMol(@NotNull Molecule var1, @NotNull AtomMap var2);

    @Nullable
    public final Polymer.Residue findResidue() {
        Molecule molecule = this.mol;
        Polymer polymer = molecule instanceof Polymer ? (Polymer)molecule : null;
        return polymer != null ? polymer.findResidue((Atom)CollectionsKt.first(this.getAnchorAtoms())) : null;
    }

    protected final void makeLibraryAnchor(@NotNull Iterable<Atom> $this$makeLibraryAnchor, @NotNull Vector3d t) {
        Intrinsics.checkNotNullParameter($this$makeLibraryAnchor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        for (Atom atom : $this$makeLibraryAnchor) {
            atom.getPos().add((Vector3dc)t);
        }
    }

    protected final void rotate(@NotNull Iterable<Atom> $this$rotate, @NotNull Quaterniond q) {
        Intrinsics.checkNotNullParameter($this$rotate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        for (Atom atom : $this$rotate) {
            atom.getPos().rotate((Quaterniondc)q);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Set<Atom> getConnectedAtoms(@NotNull Atom $this$getConnectedAtoms, @NotNull Set<Atom> included, @NotNull Set<Atom> blockers) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getConnectedAtoms, (String)"<this>");
        Intrinsics.checkNotNullParameter(included, (String)"included");
        Intrinsics.checkNotNullParameter(blockers, (String)"blockers");
        Iterable iterable = this.mol.getBonds().bondedAtoms($this$getConnectedAtoms);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Atom it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!included.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Atom sourceNeighbor = (Atom)element$iv$iv;
            boolean bl = false;
            Iterable<Molecule.Searched> iterable2 = this.mol.bfs(sourceNeighbor, true, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)((Function3)new Function3<Atom, Atom, Integer, Boolean>(included, blockers){
                final /* synthetic */ Set<Atom> $included;
                final /* synthetic */ Set<Atom> $blockers;
                {
                    this.$included = $included;
                    this.$blockers = $blockers;
                    super(3);
                }

                @NotNull
                public final Boolean invoke(@NotNull Atom atom, @NotNull Atom dst, int n) {
                    Intrinsics.checkNotNullParameter((Object)atom, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
                    return this.$included.contains(dst) && !this.$blockers.contains(dst);
                }
            }));
            boolean $i$f$map = false;
            void var15_15 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Molecule.Searched searched = (Molecule.Searched)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getAtom());
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MoleculeKt.toIdentitySet((List)destination$iv$iv);
    }

    public static /* synthetic */ Set getConnectedAtoms$default(Anchor anchor, Atom atom, Set set, Set set2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getConnectedAtoms");
        }
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        return anchor.getConnectedAtoms(atom, set, set2);
    }

    public /* synthetic */ Anchor(Molecule mol, DefaultConstructorMarker $constructor_marker) {
        this(mol);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J0\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u001e\u0010\u001c\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00140\u001dH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0016J8\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J2\u0010(\u001a\u00020)2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\f\u00100\u001a\u00020)*\u00020\u001bH\u0002J\f\u00100\u001a\u00020/*\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u00061"}, d2={"Ledu/duke/cs/osprey/gui/prep/Anchor$Double;", "Ledu/duke/cs/osprey/gui/prep/Anchor;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "a", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "b", "c", "d", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getA", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "anchorAtoms", "", "getAnchorAtoms", "()Ljava/util/List;", "getB", "getC", "getD", "align", "", "atoms", "", "anchorCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "bondToAnchors", "anchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "bondFunc", "Lkotlin/Function2;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "connectedAtomsIsSingleComponent", "", "copy", "copyToMol", "oldToNew", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "getConnectedAtoms", "", "isAnchorCompatible", "makeLibraryAnchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Double;", "id", "", "getAtomInfo", "Lkotlin/Function1;", "makeLibraryCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Double;", "cast", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nanchors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor$Double\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1#2:356\n766#3:357\n857#3,2:358\n1549#3:360\n1620#3,3:361\n766#3:364\n857#3,2:365\n1549#3:367\n1620#3,3:368\n*S KotlinDebug\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor$Double\n*L\n327#1:357\n327#1:358,2\n328#1:360\n328#1:361,3\n330#1:364\n330#1:365,2\n331#1:367\n331#1:368,3\n*E\n"})
    public static final class Double
    extends Anchor {
        @NotNull
        private final Atom a;
        @NotNull
        private final Atom b;
        @NotNull
        private final Atom c;
        @NotNull
        private final Atom d;
        @NotNull
        private final List<Atom> anchorAtoms;

        public Double(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            super(mol, null);
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            Object[] objectArray = new Atom[]{this.a, this.b, this.c, this.d};
            this.anchorAtoms = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final Atom getA() {
            return this.a;
        }

        @NotNull
        public final Atom getB() {
            return this.b;
        }

        @NotNull
        public final Atom getC() {
            return this.c;
        }

        @NotNull
        public final Atom getD() {
            return this.d;
        }

        @NotNull
        public final Double copy(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return new Double(mol, a, b, c, d);
        }

        public static /* synthetic */ Double copy$default(Double double_, Molecule molecule, Atom atom, Atom atom2, Atom atom3, Atom atom4, int n, Object object) {
            if ((n & 1) != 0) {
                molecule = double_.getMol();
            }
            if ((n & 2) != 0) {
                atom = double_.a;
            }
            if ((n & 4) != 0) {
                atom2 = double_.b;
            }
            if ((n & 8) != 0) {
                atom3 = double_.c;
            }
            if ((n & 0x10) != 0) {
                atom4 = double_.d;
            }
            return double_.copy(molecule, atom, atom2, atom3, atom4);
        }

        @Override
        @NotNull
        public List<Atom> getAnchorAtoms() {
            return this.anchorAtoms;
        }

        @Override
        @NotNull
        public Set<Atom> getConnectedAtoms(@NotNull Set<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Object[] objectArray = new Set[]{Anchor.getConnectedAtoms$default(this, this.a, atoms, null, 2, null), Anchor.getConnectedAtoms$default(this, this.b, atoms, null, 2, null)};
            return MoleculeKt.union(CollectionsKt.listOf((Object[])objectArray));
        }

        @Override
        public boolean connectedAtomsIsSingleComponent(@NotNull Set<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Object[] objectArray = new Set[]{Anchor.getConnectedAtoms$default(this, this.a, atoms, null, 2, null), Anchor.getConnectedAtoms$default(this, this.b, atoms, null, 2, null)};
            return !((Collection)MoleculeKt.intersection(CollectionsKt.listOf((Object[])objectArray))).isEmpty();
        }

        @Override
        public boolean isAnchorCompatible(@NotNull ConfLib.Anchor anchor) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            return anchor instanceof ConfLib.Anchor.Double;
        }

        private final ConfLib.Anchor.Double cast(ConfLib.Anchor $this$cast) {
            Intrinsics.checkNotNull((Object)$this$cast, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.io.ConfLib.Anchor.Double");
            return (ConfLib.Anchor.Double)$this$cast;
        }

        private final ConfLib.AnchorCoords.Double cast(ConfLib.AnchorCoords $this$cast) {
            Intrinsics.checkNotNull((Object)$this$cast, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.io.ConfLib.AnchorCoords.Double");
            return (ConfLib.AnchorCoords.Double)$this$cast;
        }

        @Override
        public void bondToAnchors(@NotNull ConfLib.Anchor anchor, @NotNull Function2<? super List<ConfLib.AtomInfo>, ? super Atom, Unit> bondFunc) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter(bondFunc, (String)"bondFunc");
            bondFunc.invoke(this.cast(anchor).getBondsa(), (Object)this.a);
            bondFunc.invoke(this.cast(anchor).getBondsb(), (Object)this.b);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void align(@NotNull Set<Atom> atoms, @NotNull ConfLib.AnchorCoords anchorCoords) {
            void c;
            void c2;
            Quaterniond quaterniond;
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter((Object)anchorCoords, (String)"anchorCoords");
            Set<Atom> connectedAtoms = this.getConnectedAtoms(atoms);
            ConfLib.AnchorCoords.Double coords = this.cast(anchorCoords);
            Vector3d coordsm = new Vector3d((Vector3dc)coords.getA()).add((Vector3dc)coords.getB()).mul(0.5);
            Vector3d mpos = new Vector3d((Vector3dc)this.a.getPos()).add((Vector3dc)this.b.getPos()).mul(0.5);
            Iterable iterable = connectedAtoms;
            Vector3d vector3d = new Vector3d((Vector3dc)coordsm).negate();
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"Vector3d(coordsm)\n\t\t\t\t\t.negate()");
            this.makeLibraryAnchor(iterable, vector3d);
            Quaterniond $this$align_u24lambda_u240 = quaterniond = new Quaterniond().lookAlong((Vector3dc)new Vector3d((Vector3dc)coords.getB()).sub((Vector3dc)coords.getA()), (Vector3dc)new Vector3d((Vector3dc)coords.getC()).sub((Vector3dc)coords.getA()));
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$align_u24lambda_u240, (String)"align$lambda$0");
            if (!MathKt.isFinite((Quaterniondc)((Quaterniondc)$this$align_u24lambda_u240))) {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)"a", (Object)coords.getA()), TuplesKt.to((Object)"b", (Object)coords.getB()), TuplesKt.to((Object)"c", (Object)coords.getC())};
                throw new IllegalAlignmentException("conformation anchors a,b,c must not be co-linear, or nearly co-linear:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)align.coordsQ.1.1.INSTANCE, (int)30, null));
            }
            Quaterniond coordsQ2 = quaterniond;
            Quaterniond $this$align_u24lambda_u241 = $this$align_u24lambda_u240 = new Quaterniond().lookAlong((Vector3dc)new Vector3d((Vector3dc)this.b.getPos()).sub((Vector3dc)this.a.getPos()), (Vector3dc)new Vector3d((Vector3dc)this.c.getPos()).sub((Vector3dc)this.a.getPos()));
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$align_u24lambda_u241, (String)"align$lambda$1");
            if (!MathKt.isFinite((Quaterniondc)((Quaterniondc)$this$align_u24lambda_u241))) {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)"a", (Object)this.a), TuplesKt.to((Object)"b", (Object)this.b), TuplesKt.to((Object)"c", (Object)this.c)};
                throw new IllegalAlignmentException("design position anchor atoms a,b,c must not be co-linear, or nearly co-linear:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)align.posQ.1.1.INSTANCE, (int)30, null));
            }
            Quaterniond posQ2 = $this$align_u24lambda_u240;
            Iterable iterable2 = connectedAtoms;
            Intrinsics.checkNotNullExpressionValue((Object)coordsQ2, (String)"coordsQ");
            this.rotate(iterable2, coordsQ2);
            Vector3d d = new Vector3d((Vector3dc)coords.getD()).sub((Vector3dc)coordsm).rotate((Quaterniondc)coordsQ2);
            boolean bl3 = false;
            d = new Vector3d((Vector3dc)coords.getC()).sub((Vector3dc)coordsm).rotate((Quaterniondc)coordsQ2);
            double d2 = Math.atan2(d.y, d.x);
            boolean bl4 = false;
            double d3 = Math.atan2(c2.y, c2.x);
            double coordsDihedralRadians = edu.duke.cs.osprey.molscope.tools.MathKt.normalizeZeroToTwoPI(Math.abs(d2 - d3));
            Vector3d d4 = new Vector3d((Vector3dc)this.d.getPos()).sub((Vector3dc)mpos).rotate((Quaterniondc)posQ2);
            boolean bl5 = false;
            d4 = new Vector3d((Vector3dc)this.c.getPos()).sub((Vector3dc)mpos).rotate((Quaterniondc)posQ2);
            d2 = Math.atan2(d4.y, d4.x);
            boolean bl6 = false;
            d3 = Math.atan2(c.y, c.x);
            double posDihedralRadians = edu.duke.cs.osprey.molscope.tools.MathKt.normalizeZeroToTwoPI(Math.abs(d2 - d3));
            Iterable iterable3 = connectedAtoms;
            Quaterniond quaterniond2 = new Quaterniond().rotationZ((posDihedralRadians - coordsDihedralRadians) / 2.0);
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond2, (String)"Quaterniond()\n\t\t\t\t\t.rota\u2026ordsDihedralRadians)/2.0)");
            this.rotate(iterable3, quaterniond2);
            Iterable iterable4 = connectedAtoms;
            Quaterniond quaterniond3 = new Quaterniond((Quaterniondc)posQ2).conjugate();
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond3, (String)"Quaterniond(posQ)\n\t\t\t\t\t.conjugate()");
            this.rotate(iterable4, quaterniond3);
            Iterable iterable5 = connectedAtoms;
            Intrinsics.checkNotNullExpressionValue((Object)mpos, (String)"mpos");
            this.makeLibraryAnchor(iterable5, mpos);
        }

        @Override
        @NotNull
        public ConfLib.Anchor.Double makeLibraryAnchor(@NotNull Set<Atom> atoms, int id, @NotNull Function1<? super Atom, ConfLib.AtomInfo> getAtomInfo) {
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Atom it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter(getAtomInfo, (String)"getAtomInfo");
            Iterable iterable = this.getMol().getBonds().bondedAtoms(this.a);
            int n = id;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                boolean bl = false;
                if (!atoms.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<ConfLib.AtomInfo> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Atom)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ConfLib.AtomInfo)getAtomInfo.invoke((Object)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = this.getMol().getBonds().bondedAtoms(this.b);
            $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                boolean bl = false;
                if (!atoms.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<ConfLib.AtomInfo> collection2 = (List)destination$iv$iv;
            $this$filter$iv = collection2;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Atom)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((ConfLib.AtomInfo)getAtomInfo.invoke((Object)it));
            }
            collection2 = (List)destination$iv$iv;
            List list = collection2;
            Collection<ConfLib.AtomInfo> collection3 = collection;
            int n2 = n;
            return new ConfLib.Anchor.Double(n2, (List<ConfLib.AtomInfo>)collection3, list);
        }

        @Override
        @NotNull
        public ConfLib.AnchorCoords.Double makeLibraryCoords() {
            return new ConfLib.AnchorCoords.Double(new Vector3d((Vector3dc)this.a.getPos()), new Vector3d((Vector3dc)this.b.getPos()), new Vector3d((Vector3dc)this.c.getPos()), new Vector3d((Vector3dc)this.d.getPos()));
        }

        @Override
        @NotNull
        public Double copyToMol(@NotNull Molecule mol, @NotNull AtomMap oldToNew) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)oldToNew, (String)"oldToNew");
            return new Double(mol, oldToNew.getBOrThrow(this.a), oldToNew.getBOrThrow(this.b), oldToNew.getBOrThrow(this.c), oldToNew.getBOrThrow(this.d));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J.\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005J\u0018\u0010 \u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J2\u0010&\u001a\u00020'2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\f\u0010.\u001a\u00020'*\u00020\u0019H\u0002J\f\u0010.\u001a\u00020-*\u00020\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006/"}, d2={"Ledu/duke/cs/osprey/gui/prep/Anchor$Single;", "Ledu/duke/cs/osprey/gui/prep/Anchor;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "a", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "b", "c", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getA", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "anchorAtoms", "", "getAnchorAtoms", "()Ljava/util/List;", "getB", "getC", "align", "", "atoms", "", "anchorCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords;", "bondToAnchors", "anchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor;", "bondFunc", "Lkotlin/Function2;", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomInfo;", "connectedAtomsIsSingleComponent", "", "copy", "copyToMol", "oldToNew", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "getConnectedAtoms", "", "isAnchorCompatible", "makeLibraryAnchor", "Ledu/duke/cs/osprey/gui/io/ConfLib$Anchor$Single;", "id", "", "getAtomInfo", "Lkotlin/Function1;", "makeLibraryCoords", "Ledu/duke/cs/osprey/gui/io/ConfLib$AnchorCoords$Single;", "cast", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nanchors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor$Single\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n766#2:356\n857#2,2:357\n1549#2:359\n1620#2,3:360\n*S KotlinDebug\n*F\n+ 1 anchors.kt\nedu/duke/cs/osprey/gui/prep/Anchor$Single\n*L\n159#1:356\n159#1:357,2\n160#1:359\n160#1:360,3\n*E\n"})
    public static final class Single
    extends Anchor {
        @NotNull
        private final Atom a;
        @NotNull
        private final Atom b;
        @NotNull
        private final Atom c;
        @NotNull
        private final List<Atom> anchorAtoms;

        public Single(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            super(mol, null);
            this.a = a;
            this.b = b;
            this.c = c;
            Object[] objectArray = new Atom[]{this.a, this.b, this.c};
            this.anchorAtoms = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final Atom getA() {
            return this.a;
        }

        @NotNull
        public final Atom getB() {
            return this.b;
        }

        @NotNull
        public final Atom getC() {
            return this.c;
        }

        @NotNull
        public final Single copy(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            return new Single(mol, a, b, c);
        }

        public static /* synthetic */ Single copy$default(Single single, Molecule molecule, Atom atom, Atom atom2, Atom atom3, int n, Object object) {
            if ((n & 1) != 0) {
                molecule = single.getMol();
            }
            if ((n & 2) != 0) {
                atom = single.a;
            }
            if ((n & 4) != 0) {
                atom2 = single.b;
            }
            if ((n & 8) != 0) {
                atom3 = single.c;
            }
            return single.copy(molecule, atom, atom2, atom3);
        }

        @Override
        @NotNull
        public List<Atom> getAnchorAtoms() {
            return this.anchorAtoms;
        }

        @Override
        @NotNull
        public Set<Atom> getConnectedAtoms(@NotNull Set<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            return Anchor.getConnectedAtoms$default(this, this.a, atoms, null, 2, null);
        }

        @Override
        public boolean connectedAtomsIsSingleComponent(@NotNull Set<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            return true;
        }

        @Override
        public boolean isAnchorCompatible(@NotNull ConfLib.Anchor anchor) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            return anchor instanceof ConfLib.Anchor.Single;
        }

        private final ConfLib.Anchor.Single cast(ConfLib.Anchor $this$cast) {
            Intrinsics.checkNotNull((Object)$this$cast, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.io.ConfLib.Anchor.Single");
            return (ConfLib.Anchor.Single)$this$cast;
        }

        private final ConfLib.AnchorCoords.Single cast(ConfLib.AnchorCoords $this$cast) {
            Intrinsics.checkNotNull((Object)$this$cast, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.io.ConfLib.AnchorCoords.Single");
            return (ConfLib.AnchorCoords.Single)$this$cast;
        }

        @Override
        public void bondToAnchors(@NotNull ConfLib.Anchor anchor, @NotNull Function2<? super List<ConfLib.AtomInfo>, ? super Atom, Unit> bondFunc) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter(bondFunc, (String)"bondFunc");
            bondFunc.invoke(this.cast(anchor).getBonds(), (Object)this.a);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void align(@NotNull Set<Atom> atoms, @NotNull ConfLib.AnchorCoords anchorCoords) {
            void $this$align_u24lambda_u241;
            Quaterniond $this$align_u24lambda_u240;
            Quaterniond quaterniond;
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter((Object)anchorCoords, (String)"anchorCoords");
            Set<Atom> connectedAtoms = this.getConnectedAtoms(atoms);
            ConfLib.AnchorCoords.Single coords = this.cast(anchorCoords);
            Iterable iterable = connectedAtoms;
            Vector3d vector3d = new Vector3d((Vector3dc)coords.getA()).negate();
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"Vector3d(coords.a)\n\t\t\t\t\t.negate()");
            this.makeLibraryAnchor(iterable, vector3d);
            Quaterniond quaterniond2 = quaterniond = new Quaterniond().lookAlong((Vector3dc)new Vector3d((Vector3dc)coords.getB()).sub((Vector3dc)coords.getA()), (Vector3dc)new Vector3d((Vector3dc)coords.getC()).sub((Vector3dc)coords.getA()));
            Iterable iterable2 = connectedAtoms;
            Single single = this;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$align_u24lambda_u240, (String)"align$lambda$0");
            if (!MathKt.isFinite((Quaterniondc)((Quaterniondc)$this$align_u24lambda_u240))) {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)"a", (Object)coords.getA()), TuplesKt.to((Object)"b", (Object)coords.getB()), TuplesKt.to((Object)"c", (Object)coords.getC())};
                throw new IllegalAlignmentException("conformation anchors a,b,c must not be co-linear, or nearly co-linear:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)align.1.1.INSTANCE, (int)30, null));
            }
            Unit unit = Unit.INSTANCE;
            Quaterniond quaterniond3 = quaterniond;
            $this$align_u24lambda_u240 = quaterniond = new Quaterniond().lookAlong((Vector3dc)new Vector3d((Vector3dc)this.b.getPos()).sub((Vector3dc)this.a.getPos()), (Vector3dc)new Vector3d((Vector3dc)this.c.getPos()).sub((Vector3dc)this.a.getPos()));
            unit = quaterniond3;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$align_u24lambda_u241, (String)"align$lambda$1");
            if (!MathKt.isFinite((Quaterniondc)((Quaterniondc)$this$align_u24lambda_u241))) {
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)"a", (Object)this.a), TuplesKt.to((Object)"b", (Object)this.b), TuplesKt.to((Object)"c", (Object)this.c)};
                throw new IllegalAlignmentException("design position anchor atoms a,b,c must not be co-linear, or nearly co-linear:\n\t" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n\t", null, null, (int)0, null, (Function1)align.2.1.INSTANCE, (int)30, null));
            }
            Unit unit2 = Unit.INSTANCE;
            Quaterniond quaterniond4 = unit.premul((Quaterniondc)quaterniond.conjugate());
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond4, (String)"Quaterniond()\n\t\t\t\t\t.look\u2026\t\t\t\t\t\t.conjugate()\n\t\t\t\t\t)");
            single.rotate(iterable2, quaterniond4);
            this.makeLibraryAnchor((Iterable<Atom>)connectedAtoms, this.a.getPos());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ConfLib.Anchor.Single makeLibraryAnchor(@NotNull Set<Atom> atoms, int id, @NotNull Function1<? super Atom, ConfLib.AtomInfo> getAtomInfo) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Atom it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            Intrinsics.checkNotNullParameter(getAtomInfo, (String)"getAtomInfo");
            Iterable iterable = this.getMol().getBonds().bondedAtomsSorted(this.a);
            int n = id;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                boolean bl = false;
                if (!atoms.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection<ConfLib.AtomInfo> collection = (List)destination$iv$iv;
            $this$filter$iv = collection;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Atom)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ConfLib.AtomInfo)getAtomInfo.invoke((Object)it));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            int n2 = n;
            return new ConfLib.Anchor.Single(n2, list);
        }

        @Override
        @NotNull
        public ConfLib.AnchorCoords.Single makeLibraryCoords() {
            return new ConfLib.AnchorCoords.Single(new Vector3d((Vector3dc)this.a.getPos()), new Vector3d((Vector3dc)this.b.getPos()), new Vector3d((Vector3dc)this.c.getPos()));
        }

        @Override
        @NotNull
        public Single copyToMol(@NotNull Molecule mol, @NotNull AtomMap oldToNew) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)oldToNew, (String)"oldToNew");
            return new Single(mol, oldToNew.getBOrThrow(this.a), oldToNew.getBOrThrow(this.b), oldToNew.getBOrThrow(this.c));
        }
    }
}

