/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.motions;

import cuchaz.kludge.tools.LangKt;
import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.motions.ConfMotion;
import edu.duke.cs.osprey.gui.motions.MolMotion;
import edu.duke.cs.osprey.gui.prep.ConfSpace;
import edu.duke.cs.osprey.gui.prep.DesignPosition;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.tools.MathKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0004\u001e\u001f !B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle;", "Ledu/duke/cs/osprey/gui/motions/ConfMotion;", "Ledu/duke/cs/osprey/gui/motions/MolMotion;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "a", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "b", "c", "d", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getA", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getB", "getC", "getD", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "rotatedAtoms", "", "getRotatedAtoms", "()Ljava/util/List;", "measureDegrees", "", "measureRadians", "setDegrees", "", "degrees", "setRadians", "radians", "Companion", "ConfDescription", "LibrarySettings", "MolDescription", "osprey3"})
@SourceDebugExtension(value={"SMAP\nDihedralAngle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1855#2,2:271\n1855#2,2:273\n1855#2,2:275\n1855#2,2:277\n1855#2,2:279\n*S KotlinDebug\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle\n*L\n190#1:271,2\n198#1:273,2\n204#1:275,2\n209#1:277,2\n213#1:279,2\n*E\n"})
public final class DihedralAngle
implements ConfMotion,
MolMotion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Molecule mol;
    @NotNull
    private final Atom a;
    @NotNull
    private final Atom b;
    @NotNull
    private final Atom c;
    @NotNull
    private final Atom d;
    @NotNull
    private final List<Atom> rotatedAtoms;

    public DihedralAngle(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.mol = mol;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.rotatedAtoms = Companion.findRotatedAtoms(this.mol, this.b, this.c);
    }

    @NotNull
    public final Molecule getMol() {
        return this.mol;
    }

    @NotNull
    public final Atom getA() {
        return this.a;
    }

    @NotNull
    public final Atom getB() {
        return this.b;
    }

    @NotNull
    public final Atom getC() {
        return this.c;
    }

    @NotNull
    public final Atom getD() {
        return this.d;
    }

    @NotNull
    public final List<Atom> getRotatedAtoms() {
        return this.rotatedAtoms;
    }

    public final double measureDegrees() {
        return LangKt.toDegrees((double)this.measureRadians());
    }

    public final double measureRadians() {
        return Companion.measureRadians((Vector3dc)this.a.getPos(), (Vector3dc)this.b.getPos(), (Vector3dc)this.c.getPos(), (Vector3dc)this.d.getPos());
    }

    public final void setDegrees(double degrees) {
        this.setRadians(LangKt.toRadians((double)degrees));
    }

    public final void setRadians(double radians) {
        Vector3d a = new Vector3d((Vector3dc)this.a.getPos());
        Vector3d c = new Vector3d((Vector3dc)this.c.getPos());
        Vector3d d = new Vector3d((Vector3dc)this.d.getPos());
        Vector3d t = this.b.getPos();
        boolean bl = false;
        a.sub((Vector3dc)t);
        c.sub((Vector3dc)t);
        d.sub((Vector3dc)t);
        Iterable $this$forEach$iv = this.rotatedAtoms;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Atom it = (Atom)element$iv;
            boolean bl2 = false;
            it.getPos().sub((Vector3dc)t);
        }
        Quaterniond rotation = new Quaterniond().lookAlong((Vector3dc)c, (Vector3dc)a);
        d.rotate((Quaterniondc)rotation);
        Iterable $this$forEach$iv2 = this.rotatedAtoms;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Atom it = (Atom)element$iv;
            boolean bl3 = false;
            it.getPos().rotate((Quaterniondc)rotation);
        }
        Quaterniond q = new Quaterniond().rotationZ(1.5707963267948966 - radians - Math.atan2(d.y, d.x));
        boolean bl4 = false;
        Iterable $this$forEach$iv3 = this.rotatedAtoms;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Atom it = (Atom)element$iv;
            boolean bl5 = false;
            it.getPos().rotate((Quaterniondc)q);
        }
        rotation.conjugate();
        $this$forEach$iv2 = this.rotatedAtoms;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Atom it = (Atom)element$iv;
            boolean bl6 = false;
            it.getPos().rotate((Quaterniondc)rotation);
        }
        Vector3d t2 = this.b.getPos();
        boolean bl7 = false;
        $this$forEach$iv3 = this.rotatedAtoms;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            Atom it = (Atom)element$iv;
            boolean bl8 = false;
            it.getPos().add((Vector3dc)t2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ&\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u00a8\u0006\u0010"}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$Companion;", "", "()V", "findRotatedAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "b", "c", "measureDegrees", "", "a", "Lorg/joml/Vector3dc;", "d", "measureRadians", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nDihedralAngle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1549#2:271\n1620#2,3:272\n*S KotlinDebug\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$Companion\n*L\n227#1:271\n227#1:272,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Atom> findRotatedAtoms(@NotNull Molecule mol, @NotNull Atom b, @NotNull Atom c) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Iterable<Molecule.Searched> iterable = mol.bfs(c, false, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)((Function3)new Function3<Atom, Atom, Integer, Boolean>(b){
                final /* synthetic */ Atom $b;
                {
                    this.$b = $b;
                    super(3);
                }

                @NotNull
                public final Boolean invoke(@NotNull Atom atom, @NotNull Atom to, int n) {
                    Intrinsics.checkNotNullParameter((Object)atom, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                    return to != this.$b;
                }
            }));
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Molecule.Searched searched = (Molecule.Searched)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAtom());
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        public final double measureDegrees(@NotNull Vector3dc a, @NotNull Vector3dc b, @NotNull Vector3dc c, @NotNull Vector3dc d) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            return LangKt.toDegrees((double)this.measureRadians(a, b, c, d));
        }

        public final double measureRadians(@NotNull Vector3dc a, @NotNull Vector3dc b, @NotNull Vector3dc c, @NotNull Vector3dc d) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            Vector3d a2 = new Vector3d(a);
            Vector3d c2 = new Vector3d(c);
            Vector3d d2 = new Vector3d(d);
            Vector3dc it = b;
            boolean bl = false;
            a2.sub(it);
            c2.sub(it);
            d2.sub(it);
            it = new Quaterniond().lookAlong((Vector3dc)c2, (Vector3dc)a2);
            boolean bl2 = false;
            d2.rotate((Quaterniondc)it);
            return MathKt.normalizeMinusPIToPI(1.5707963267948966 - Math.atan2(d2.y, d2.x));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription;", "Ledu/duke/cs/osprey/gui/motions/ConfMotion$Description;", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "motion", "Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;", "degrees", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;Lkotlin/ranges/ClosedFloatingPointRange;)V", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "radiusDegrees", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;D)V", "minDegrees", "maxDegrees", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;DD)V", "getMaxDegrees", "()D", "getMinDegrees", "getMotion", "()Ledu/duke/cs/osprey/gui/io/ConfLib$ContinuousMotion$DihedralAngle;", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "copyTo", "confConfSpace", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "make", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atomResolver", "Ledu/duke/cs/osprey/gui/io/ConfLib$AtomPointer$Resolver;", "Companion", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nDihedralAngle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    public static final class ConfDescription
    implements ConfMotion.Description {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DesignPosition pos;
        @NotNull
        private final ConfLib.ContinuousMotion.DihedralAngle motion;
        private final double minDegrees;
        private final double maxDegrees;

        public ConfDescription(@NotNull DesignPosition pos, @NotNull ConfLib.ContinuousMotion.DihedralAngle motion, double minDegrees, double maxDegrees) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
            this.pos = pos;
            this.motion = motion;
            this.minDegrees = minDegrees;
            this.maxDegrees = maxDegrees;
        }

        @NotNull
        public final DesignPosition getPos() {
            return this.pos;
        }

        @NotNull
        public final ConfLib.ContinuousMotion.DihedralAngle getMotion() {
            return this.motion;
        }

        public final double getMinDegrees() {
            return this.minDegrees;
        }

        public final double getMaxDegrees() {
            return this.maxDegrees;
        }

        public ConfDescription(@NotNull DesignPosition pos, @NotNull ConfLib.ContinuousMotion.DihedralAngle motion, @NotNull ClosedFloatingPointRange<Double> degrees) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
            Intrinsics.checkNotNullParameter(degrees, (String)"degrees");
            this(pos, motion, ((Number)((Object)degrees.getStart())).doubleValue(), ((Number)((Object)degrees.getEndInclusive())).doubleValue());
        }

        /*
         * WARNING - void declaration
         */
        public ConfDescription(@NotNull DesignPosition pos, @NotNull ConfLib.ContinuousMotion.DihedralAngle motion, @NotNull ConfLib.Conf conf, double radiusDegrees) {
            void it;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)motion, (String)"motion");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            double d = Companion.measureDegrees((Vector3dc)motion.getA().resolveCoordsOrThrow(conf), (Vector3dc)motion.getB().resolveCoordsOrThrow(conf), (Vector3dc)motion.getC().resolveCoordsOrThrow(conf), (Vector3dc)motion.getD().resolveCoordsOrThrow(conf));
            ConfLib.ContinuousMotion.DihedralAngle dihedralAngle = motion;
            DesignPosition designPosition = pos;
            ConfDescription confDescription = this;
            boolean bl = false;
            ClosedFloatingPointRange closedFloatingPointRange = RangesKt.rangeTo((double)(it - radiusDegrees), (double)(it + radiusDegrees));
            confDescription(designPosition, dihedralAngle, (ClosedFloatingPointRange<Double>)closedFloatingPointRange);
        }

        @Override
        @NotNull
        public ConfDescription copyTo(@NotNull ConfSpace.ConfConfSpace confConfSpace, @NotNull DesignPosition pos) {
            Object v0;
            DesignPosition designPosition;
            block2: {
                Intrinsics.checkNotNullParameter((Object)confConfSpace, (String)"confConfSpace");
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Iterable iterable = confConfSpace.getFrag().getMotions();
                designPosition = pos;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    ConfLib.ContinuousMotion it = (ConfLib.ContinuousMotion)t;
                    boolean bl = false;
                    if (!(it.getId() == this.motion.getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ConfLib.ContinuousMotion.DihedralAngle dihedralAngle = v0;
            if (dihedralAngle == null) {
                throw new NoSuchElementException("no motion with id=" + this.motion.getId() + " in motions for fragment " + confConfSpace.getFrag().getId());
            }
            double d = this.maxDegrees;
            double d2 = this.minDegrees;
            ConfLib.ContinuousMotion.DihedralAngle dihedralAngle2 = dihedralAngle;
            DesignPosition designPosition2 = designPosition;
            return new ConfDescription(designPosition2, dihedralAngle2, d2, d);
        }

        @Override
        @NotNull
        public DihedralAngle make(@NotNull Molecule mol, @NotNull ConfLib.AtomPointer.Resolver atomResolver) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)atomResolver, (String)"atomResolver");
            return new DihedralAngle(mol, atomResolver.resolveOrThrow(this.motion.getA()), atomResolver.resolveOrThrow(this.motion.getB()), atomResolver.resolveOrThrow(this.motion.getC()), atomResolver.resolveOrThrow(this.motion.getD()));
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription$Companion;", "", "()V", "makeFromLibrary", "", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription;", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "settings", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle$LibrarySettings;", "osprey3"})
        @SourceDebugExtension(value={"SMAP\nDihedralAngle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n800#2,11:271\n1603#2,9:282\n1855#2:291\n1726#2,3:292\n1856#2:296\n1612#2:297\n1#3:295\n*S KotlinDebug\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription$Companion\n*L\n82#1:271,11\n83#1:282,9\n83#1:291\n90#1:292,3\n83#1:296\n83#1:297\n83#1:295\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final List<ConfDescription> makeFromLibrary(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf, @NotNull LibrarySettings settings) {
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                var5_5 = frag.getMotions();
                $i$f$filterIsInstance = false;
                var7_7 = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ConfLib.ContinuousMotion.DihedralAngle)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var12_13 = $this$forEach$iv$iv$iv.iterator();
                while (var12_13.hasNext()) {
                    block8: {
                        element$iv$iv = element$iv$iv$iv = var12_13.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        motion = (ConfLib.ContinuousMotion.DihedralAngle)element$iv$iv;
                        $i$a$-mapNotNull-DihedralAngle$ConfDescription$Companion$makeFromLibrary$1 = false;
                        if (pos.findAnchorMatch(frag) == null) {
                            throw new RuntimeException("no anchor match");
                        }
                        rotatedAtoms = motion.affectedAtoms(frag);
                        if (!(((Collection)rotatedAtoms).isEmpty() == false)) ** GOTO lbl-1000
                        $this$all$iv = rotatedAtoms;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v0 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (ConfLib.AtomInfo)element$iv;
                                $i$a$-all-DihedralAngle$ConfDescription$Companion$makeFromLibrary$1$isHGroup$1 = false;
                                if (it.getElement() == Element.Hydrogen) continue;
                                v0 = false;
                                break block8;
                            }
                            v0 = true;
                        }
                    }
                    if (v0) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    isHGroup = v1;
                    isHydroxyl = isHGroup != false && rotatedAtoms.size() == 1 && match.resolveElementOrThrow(motion.getC()) == Element.Oxygen;
                    v2 = isNonHydroxylHGroup = isHGroup != false && isHydroxyl == false;
                    if ((isHydroxyl != false && settings.getIncludeHydroxyls() == false ? null : (isNonHydroxylHGroup != false && settings.getIncludeNonHydroxylHGroups() == false ? null : new ConfDescription(pos, motion, conf, settings.getRadiusDegrees()))) == null) continue;
                    it$iv$iv = it$iv$iv;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$LibrarySettings;", "", "radiusDegrees", "", "includeHydroxyls", "", "includeNonHydroxylHGroups", "(DZZ)V", "getIncludeHydroxyls", "()Z", "setIncludeHydroxyls", "(Z)V", "getIncludeNonHydroxylHGroups", "setIncludeNonHydroxylHGroups", "getRadiusDegrees", "()D", "setRadiusDegrees", "(D)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "osprey3"})
    public static final class LibrarySettings {
        private double radiusDegrees;
        private boolean includeHydroxyls;
        private boolean includeNonHydroxylHGroups;

        public LibrarySettings(double radiusDegrees, boolean includeHydroxyls, boolean includeNonHydroxylHGroups) {
            this.radiusDegrees = radiusDegrees;
            this.includeHydroxyls = includeHydroxyls;
            this.includeNonHydroxylHGroups = includeNonHydroxylHGroups;
        }

        public final double getRadiusDegrees() {
            return this.radiusDegrees;
        }

        public final void setRadiusDegrees(double d) {
            this.radiusDegrees = d;
        }

        public final boolean getIncludeHydroxyls() {
            return this.includeHydroxyls;
        }

        public final void setIncludeHydroxyls(boolean bl) {
            this.includeHydroxyls = bl;
        }

        public final boolean getIncludeNonHydroxylHGroups() {
            return this.includeNonHydroxylHGroups;
        }

        public final void setIncludeNonHydroxylHGroups(boolean bl) {
            this.includeNonHydroxylHGroups = bl;
        }

        public final double component1() {
            return this.radiusDegrees;
        }

        public final boolean component2() {
            return this.includeHydroxyls;
        }

        public final boolean component3() {
            return this.includeNonHydroxylHGroups;
        }

        @NotNull
        public final LibrarySettings copy(double radiusDegrees, boolean includeHydroxyls, boolean includeNonHydroxylHGroups) {
            return new LibrarySettings(radiusDegrees, includeHydroxyls, includeNonHydroxylHGroups);
        }

        public static /* synthetic */ LibrarySettings copy$default(LibrarySettings librarySettings, double d, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                d = librarySettings.radiusDegrees;
            }
            if ((n & 2) != 0) {
                bl = librarySettings.includeHydroxyls;
            }
            if ((n & 4) != 0) {
                bl2 = librarySettings.includeNonHydroxylHGroups;
            }
            return librarySettings.copy(d, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "LibrarySettings(radiusDegrees=" + this.radiusDegrees + ", includeHydroxyls=" + this.includeHydroxyls + ", includeNonHydroxylHGroups=" + this.includeNonHydroxylHGroups + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.radiusDegrees);
            int n = this.includeHydroxyls ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.includeNonHydroxylHGroups ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LibrarySettings)) {
                return false;
            }
            LibrarySettings librarySettings = (LibrarySettings)other;
            if (Double.compare(this.radiusDegrees, librarySettings.radiusDegrees) != 0) {
                return false;
            }
            if (this.includeHydroxyls != librarySettings.includeHydroxyls) {
                return false;
            }
            return this.includeNonHydroxylHGroups == librarySettings.includeNonHydroxylHGroups;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eH\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$MolDescription;", "Ledu/duke/cs/osprey/gui/motions/MolMotion$Description;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "a", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "b", "c", "d", "degrees", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Lkotlin/ranges/ClosedFloatingPointRange;)V", "radiusDegrees", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;D)V", "minDegrees", "maxDegrees", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/molscope/molecule/Atom;DD)V", "getA", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getB", "getC", "getD", "getMaxDegrees", "()D", "getMinDegrees", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getRadiusDegrees", "rotatedAtoms", "", "getRotatedAtoms", "()Ljava/util/List;", "copyTo", "atomMap", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "getAffectedAtoms", "make", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle;", "Companion", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nDihedralAngle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DihedralAngle.kt\nedu/duke/cs/osprey/gui/motions/DihedralAngle$MolDescription\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
    public static final class MolDescription
    implements MolMotion.Description {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Molecule mol;
        @NotNull
        private final Atom a;
        @NotNull
        private final Atom b;
        @NotNull
        private final Atom c;
        @NotNull
        private final Atom d;
        private final double minDegrees;
        private final double maxDegrees;
        @NotNull
        private final List<Atom> rotatedAtoms;

        public MolDescription(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d, double minDegrees, double maxDegrees) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            this.mol = mol;
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
            this.minDegrees = minDegrees;
            this.maxDegrees = maxDegrees;
            this.rotatedAtoms = Companion.findRotatedAtoms(this.getMol(), this.b, this.c);
        }

        @Override
        @NotNull
        public Molecule getMol() {
            return this.mol;
        }

        @NotNull
        public final Atom getA() {
            return this.a;
        }

        @NotNull
        public final Atom getB() {
            return this.b;
        }

        @NotNull
        public final Atom getC() {
            return this.c;
        }

        @NotNull
        public final Atom getD() {
            return this.d;
        }

        public final double getMinDegrees() {
            return this.minDegrees;
        }

        public final double getMaxDegrees() {
            return this.maxDegrees;
        }

        public MolDescription(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d, @NotNull ClosedFloatingPointRange<Double> degrees) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            Intrinsics.checkNotNullParameter(degrees, (String)"degrees");
            this(mol, a, b, c, d, ((Number)((Object)degrees.getStart())).doubleValue(), ((Number)((Object)degrees.getEndInclusive())).doubleValue());
        }

        /*
         * WARNING - void declaration
         */
        public MolDescription(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d, double radiusDegrees) {
            void it;
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            double d2 = Companion.measureDegrees((Vector3dc)a.getPos(), (Vector3dc)b.getPos(), (Vector3dc)c.getPos(), (Vector3dc)d.getPos());
            Atom atom = d;
            Atom atom2 = c;
            Atom atom3 = b;
            Atom atom4 = a;
            Molecule molecule = mol;
            MolDescription molDescription = this;
            boolean bl = false;
            ClosedFloatingPointRange closedFloatingPointRange = RangesKt.rangeTo((double)(it - radiusDegrees), (double)(it + radiusDegrees));
            molDescription(molecule, atom4, atom3, atom2, atom, (ClosedFloatingPointRange<Double>)closedFloatingPointRange);
        }

        @NotNull
        public final List<Atom> getRotatedAtoms() {
            return this.rotatedAtoms;
        }

        public final double getRadiusDegrees() {
            return (this.maxDegrees - this.minDegrees) / 2.0;
        }

        @Override
        @NotNull
        public MolDescription copyTo(@NotNull Molecule mol, @NotNull AtomMap atomMap2) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)atomMap2, (String)"atomMap");
            return new MolDescription(mol, atomMap2.getBOrThrow(this.a), atomMap2.getBOrThrow(this.b), atomMap2.getBOrThrow(this.c), atomMap2.getBOrThrow(this.d), this.minDegrees, this.maxDegrees);
        }

        @Override
        @NotNull
        public DihedralAngle make() {
            return new DihedralAngle(this.getMol(), this.a, this.b, this.c, this.d);
        }

        @Override
        @NotNull
        public List<Atom> getAffectedAtoms() {
            return this.rotatedAtoms;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/gui/motions/DihedralAngle$MolDescription$Companion;", "", "()V", "make", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle$MolDescription;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "a", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "b", "c", "d", "radiusDegrees", "", "osprey3"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MolDescription make(@NotNull Molecule mol, @NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d, double radiusDegrees) {
                Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                double initialDegrees = DihedralAngle.Companion.measureDegrees((Vector3dc)a.getPos(), (Vector3dc)b.getPos(), (Vector3dc)c.getPos(), (Vector3dc)d.getPos());
                return new MolDescription(mol, a, b, c, d, initialDegrees - radiusDegrees, initialDegrees + radiusDegrees);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

