/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.amber.AmberTopology;
import edu.duke.cs.osprey.gui.forcefield.amber.DoubleFormat;
import edu.duke.cs.osprey.gui.forcefield.amber.Flag;
import edu.duke.cs.osprey.gui.forcefield.amber.FlagInfo;
import edu.duke.cs.osprey.gui.forcefield.amber.IntFormat;
import edu.duke.cs.osprey.gui.forcefield.amber.ParseException;
import edu.duke.cs.osprey.gui.forcefield.amber.StringFormat;
import edu.duke.cs.osprey.tools.FileTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/TopIO;", "", "()V", "read", "Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology;", "content", "", "osprey3"})
@SourceDebugExtension(value={"SMAP\nTopIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopIO.kt\nedu/duke/cs/osprey/gui/forcefield/amber/TopIO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,683:1\n1#2:684\n*E\n"})
public final class TopIO {
    @NotNull
    public static final TopIO INSTANCE = new TopIO();

    private TopIO() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final AmberTopology read(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        FileTools.LineIterator lines = FileTools.parseLines(content);
        HashMap<Flag, FlagInfo> flags = new HashMap<Flag, FlagInfo>();
        while (lines.hasNext()) {
            Flag flag;
            Object object;
            String fmtspec;
            String line = lines.next();
            Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
            if (!StringsKt.startsWith$default((String)line, (String)"%FLAG ", (boolean)false, (int)2, null)) continue;
            String string = line.substring(6);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            if (Flag.Companion.get(((Object)StringsKt.trim((CharSequence)string)).toString()) == null) continue;
            String string2 = lines.next();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lines.next()");
            String fmtline = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (!StringsKt.startsWith$default((String)fmtline, (String)"%FORMAT(", (boolean)false, (int)2, null)) throw new ParseException("expected FORMAT on line " + lines.lineNumber() + ", but got: " + fmtline);
            Intrinsics.checkNotNullExpressionValue((Object)fmtline.substring(8, fmtline.length() - 1), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (StringsKt.contains$default((CharSequence)fmtspec, (char)'a', (boolean)false, (int)2, null)) {
                object = StringFormat.Companion.of(fmtspec);
            } else if (StringsKt.contains$default((CharSequence)fmtspec, (char)'E', (boolean)false, (int)2, null)) {
                object = DoubleFormat.Companion.of(fmtspec);
            } else {
                if (!StringsKt.contains$default((CharSequence)fmtspec, (char)'I', (boolean)false, (int)2, null)) throw new ParseException("unrecognized FORMAT: " + fmtspec);
                object = IntFormat.Companion.of(fmtspec);
            }
            StringFormat fmt = object;
            ArrayList<String> flagLines = new ArrayList<String>();
            while (lines.hasNext()) {
                String string3;
                String string4 = lines.peek();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"lines.peek()");
                if (StringsKt.startsWith$default((String)string4, (String)"%", (boolean)false, (int)2, null)) break;
                String it = string3 = lines.next();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string5 = !StringsKt.isBlank((CharSequence)it) ? string3 : null;
                if (string5 == null) continue;
                it = string5;
                boolean bl2 = false;
                flagLines.add(it);
            }
            ((Map)flags).put(flag, new FlagInfo((List<String>)flagLines, fmt));
        }
        return new AmberTopology((List<Integer>)TopIO.read$get(flags, Flag.POINTERS).readInts(), (List<String>)TopIO.read$get(flags, Flag.ATOM_NAME).readStrings(), (List<Integer>)TopIO.read$get(flags, Flag.ATOMIC_NUMBER).readInts(), (List<Integer>)TopIO.read$get(flags, Flag.RESIDUE_POINTER).readInts(), (List<String>)TopIO.read$get(flags, Flag.RESIDUE_LABEL).readStrings(), (List<Integer>)TopIO.read$get(flags, Flag.BONDS_INC_HYDROGEN).readInts(), (List<Integer>)TopIO.read$get(flags, Flag.BONDS_WITHOUT_HYDROGEN).readInts(), (List<Integer>)TopIO.read$get(flags, Flag.DIHEDRALS_INC_HYDROGEN).readInts(), (List<Integer>)TopIO.read$get(flags, Flag.DIHEDRALS_WITHOUT_HYDROGEN).readInts(), (List<Double>)TopIO.read$get(flags, Flag.CHARGE).readDoubles(), (List<Integer>)TopIO.read$get(flags, Flag.ATOM_TYPE_INDEX).readInts(), (List<Integer>)TopIO.read$get(flags, Flag.NONBONDED_PARM_INDEX).readInts(), (List<Double>)TopIO.read$get(flags, Flag.SCEE_SCALE_FACTOR).readDoubles(), (List<Double>)TopIO.read$get(flags, Flag.SCNB_SCALE_FACTOR).readDoubles(), (List<Double>)TopIO.read$get(flags, Flag.LENNARD_JONES_ACOEF).readDoubles(), (List<Double>)TopIO.read$get(flags, Flag.LENNARD_JONES_BCOEF).readDoubles(), (List<String>)TopIO.read$get(flags, Flag.AMBER_ATOM_TYPE).readStrings());
    }

    private static final FlagInfo read$get(HashMap<Flag, FlagInfo> flags, Flag flag) {
        FlagInfo flagInfo = flags.get((Object)flag);
        if (flagInfo == null) {
            throw new NoSuchElementException("missing flag: " + flag);
        }
        return flagInfo;
    }
}

