/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.amber.AmberTopology;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003BCDB\u00f3\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0017J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0004J\u000e\u00108\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004J\u001d\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004\u00a2\u0006\u0002\u0010<J\u000e\u0010=\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004J\u0018\u0010>\u001a\u00060?R\u00020\u00002\f\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u0003J\u000e\u0010/\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R-\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00040!j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u0004`#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0019R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0019R\u0011\u0010,\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0019R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0019R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0019R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0019\u00a8\u0006E"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology;", "", "pointers", "", "", "atomNames", "", "atomicNumbers", "residuePointers", "residueLabels", "bondsIncHydrogen", "bondsWithoutHydrogen", "dihedralsIncHydrogen", "dihedralsWithoutHydrogen", "charges", "", "atomTypeIndices", "nonbondedParmIndices", "esScaleFactors", "vdwScaleFactors", "lennardJonesACoeff", "lennardJonesBCoeff", "atomTypes", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAtomNames", "()Ljava/util/List;", "getAtomTypeIndices", "getAtomTypes", "getAtomicNumbers", "getBondsIncHydrogen", "getBondsWithoutHydrogen", "getCharges", "dihedralIndices", "Ljava/util/HashMap;", "Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$IndexPair;", "Lkotlin/collections/HashMap;", "getDihedralIndices", "()Ljava/util/HashMap;", "getDihedralsIncHydrogen", "getDihedralsWithoutHydrogen", "getEsScaleFactors", "getLennardJonesACoeff", "getLennardJonesBCoeff", "getNonbondedParmIndices", "numAtomTypes", "getNumAtomTypes", "()I", "numAtoms", "getNumAtoms", "getPointers", "getResidueLabels", "getResiduePointers", "getVdwScaleFactors", "atomIndices", "Lkotlin/ranges/IntRange;", "resIndex", "firstAtomIndex", "getDihedralIndex", "atomi1", "atomi2", "(II)Ljava/lang/Integer;", "lastAtomLimit", "mapTo", "Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$Mapped;", "mols", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "IndexPair", "Mapped", "MappedAtom", "osprey3"})
@SourceDebugExtension(value={"SMAP\nTopIO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TopIO.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTopology\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,683:1\n1#2:684\n766#3:685\n857#3,2:686\n1549#3:688\n1620#3,3:689\n766#3:692\n857#3,2:693\n*S KotlinDebug\n*F\n+ 1 TopIO.kt\nedu/duke/cs/osprey/gui/forcefield/amber/AmberTopology\n*L\n336#1:685\n336#1:686,2\n341#1:688\n341#1:689,3\n368#1:692\n368#1:693,2\n*E\n"})
public final class AmberTopology {
    @NotNull
    private final List<Integer> pointers;
    @NotNull
    private final List<String> atomNames;
    @NotNull
    private final List<Integer> atomicNumbers;
    @NotNull
    private final List<Integer> residuePointers;
    @NotNull
    private final List<String> residueLabels;
    @NotNull
    private final List<Integer> bondsIncHydrogen;
    @NotNull
    private final List<Integer> bondsWithoutHydrogen;
    @NotNull
    private final List<Integer> dihedralsIncHydrogen;
    @NotNull
    private final List<Integer> dihedralsWithoutHydrogen;
    @NotNull
    private final List<Double> charges;
    @NotNull
    private final List<Integer> atomTypeIndices;
    @NotNull
    private final List<Integer> nonbondedParmIndices;
    @NotNull
    private final List<Double> esScaleFactors;
    @NotNull
    private final List<Double> vdwScaleFactors;
    @NotNull
    private final List<Double> lennardJonesACoeff;
    @NotNull
    private final List<Double> lennardJonesBCoeff;
    @NotNull
    private final List<String> atomTypes;
    @NotNull
    private final HashMap<IndexPair, Integer> dihedralIndices;

    /*
     * WARNING - void declaration
     */
    public AmberTopology(@NotNull List<Integer> pointers, @NotNull List<String> atomNames2, @NotNull List<Integer> atomicNumbers, @NotNull List<Integer> residuePointers, @NotNull List<String> residueLabels, @NotNull List<Integer> bondsIncHydrogen, @NotNull List<Integer> bondsWithoutHydrogen, @NotNull List<Integer> dihedralsIncHydrogen, @NotNull List<Integer> dihedralsWithoutHydrogen, @NotNull List<Double> charges, @NotNull List<Integer> atomTypeIndices, @NotNull List<Integer> nonbondedParmIndices, @NotNull List<Double> esScaleFactors, @NotNull List<Double> vdwScaleFactors, @NotNull List<Double> lennardJonesACoeff, @NotNull List<Double> lennardJonesBCoeff, @NotNull List<String> atomTypes) {
        HashMap hashMap;
        Intrinsics.checkNotNullParameter(pointers, (String)"pointers");
        Intrinsics.checkNotNullParameter(atomNames2, (String)"atomNames");
        Intrinsics.checkNotNullParameter(atomicNumbers, (String)"atomicNumbers");
        Intrinsics.checkNotNullParameter(residuePointers, (String)"residuePointers");
        Intrinsics.checkNotNullParameter(residueLabels, (String)"residueLabels");
        Intrinsics.checkNotNullParameter(bondsIncHydrogen, (String)"bondsIncHydrogen");
        Intrinsics.checkNotNullParameter(bondsWithoutHydrogen, (String)"bondsWithoutHydrogen");
        Intrinsics.checkNotNullParameter(dihedralsIncHydrogen, (String)"dihedralsIncHydrogen");
        Intrinsics.checkNotNullParameter(dihedralsWithoutHydrogen, (String)"dihedralsWithoutHydrogen");
        Intrinsics.checkNotNullParameter(charges, (String)"charges");
        Intrinsics.checkNotNullParameter(atomTypeIndices, (String)"atomTypeIndices");
        Intrinsics.checkNotNullParameter(nonbondedParmIndices, (String)"nonbondedParmIndices");
        Intrinsics.checkNotNullParameter(esScaleFactors, (String)"esScaleFactors");
        Intrinsics.checkNotNullParameter(vdwScaleFactors, (String)"vdwScaleFactors");
        Intrinsics.checkNotNullParameter(lennardJonesACoeff, (String)"lennardJonesACoeff");
        Intrinsics.checkNotNullParameter(lennardJonesBCoeff, (String)"lennardJonesBCoeff");
        Intrinsics.checkNotNullParameter(atomTypes, (String)"atomTypes");
        this.pointers = pointers;
        this.atomNames = atomNames2;
        this.atomicNumbers = atomicNumbers;
        this.residuePointers = residuePointers;
        this.residueLabels = residueLabels;
        this.bondsIncHydrogen = bondsIncHydrogen;
        this.bondsWithoutHydrogen = bondsWithoutHydrogen;
        this.dihedralsIncHydrogen = dihedralsIncHydrogen;
        this.dihedralsWithoutHydrogen = dihedralsWithoutHydrogen;
        this.charges = charges;
        this.atomTypeIndices = atomTypeIndices;
        this.nonbondedParmIndices = nonbondedParmIndices;
        this.esScaleFactors = esScaleFactors;
        this.vdwScaleFactors = vdwScaleFactors;
        this.lennardJonesACoeff = lennardJonesACoeff;
        this.lennardJonesBCoeff = lennardJonesBCoeff;
        this.atomTypes = atomTypes;
        if (this.residuePointers.size() != this.residueLabels.size()) {
            throw new IllegalStateException("corrupted topology: inconsistent residue counts: " + this.residuePointers.size() + " : " + this.residueLabels.size());
        }
        HashMap hashMap2 = hashMap = new HashMap();
        AmberTopology amberTopology = this;
        boolean bl = false;
        Object[] objectArray = new List[]{this.dihedralsIncHydrogen, this.dihedralsWithoutHydrogen};
        for (List dihedrals : CollectionsKt.listOf((Object[])objectArray)) {
            int n = dihedrals.size() / 5;
            for (int i = 0; i < n; ++i) {
                void $this$dihedralIndices_u24lambda_u240;
                int atomi1 = ((Number)dihedrals.get(i * 5)).intValue();
                int atomi2 = ((Number)dihedrals.get(i * 5 + 3)).intValue();
                int dihedrali = ((Number)dihedrals.get(i * 5 + 4)).intValue();
                Integer n2 = dihedrali;
                ((Map)$this$dihedralIndices_u24lambda_u240).put(new IndexPair(atomi1, atomi2), n2);
            }
        }
        amberTopology.dihedralIndices = hashMap;
    }

    @NotNull
    public final List<Integer> getPointers() {
        return this.pointers;
    }

    @NotNull
    public final List<String> getAtomNames() {
        return this.atomNames;
    }

    @NotNull
    public final List<Integer> getAtomicNumbers() {
        return this.atomicNumbers;
    }

    @NotNull
    public final List<Integer> getResiduePointers() {
        return this.residuePointers;
    }

    @NotNull
    public final List<String> getResidueLabels() {
        return this.residueLabels;
    }

    @NotNull
    public final List<Integer> getBondsIncHydrogen() {
        return this.bondsIncHydrogen;
    }

    @NotNull
    public final List<Integer> getBondsWithoutHydrogen() {
        return this.bondsWithoutHydrogen;
    }

    @NotNull
    public final List<Integer> getDihedralsIncHydrogen() {
        return this.dihedralsIncHydrogen;
    }

    @NotNull
    public final List<Integer> getDihedralsWithoutHydrogen() {
        return this.dihedralsWithoutHydrogen;
    }

    @NotNull
    public final List<Double> getCharges() {
        return this.charges;
    }

    @NotNull
    public final List<Integer> getAtomTypeIndices() {
        return this.atomTypeIndices;
    }

    @NotNull
    public final List<Integer> getNonbondedParmIndices() {
        return this.nonbondedParmIndices;
    }

    @NotNull
    public final List<Double> getEsScaleFactors() {
        return this.esScaleFactors;
    }

    @NotNull
    public final List<Double> getVdwScaleFactors() {
        return this.vdwScaleFactors;
    }

    @NotNull
    public final List<Double> getLennardJonesACoeff() {
        return this.lennardJonesACoeff;
    }

    @NotNull
    public final List<Double> getLennardJonesBCoeff() {
        return this.lennardJonesBCoeff;
    }

    @NotNull
    public final List<String> getAtomTypes() {
        return this.atomTypes;
    }

    @NotNull
    public final HashMap<IndexPair, Integer> getDihedralIndices() {
        return this.dihedralIndices;
    }

    @Nullable
    public final Integer getDihedralIndex(int atomi1, int atomi2) {
        Integer n;
        Integer n2 = this.dihedralIndices.get(new IndexPair(atomi1, atomi2));
        if (n2 != null) {
            Integer it = n2;
            boolean bl = false;
            n = it - 1;
        } else {
            n = null;
        }
        return n;
    }

    public final int firstAtomIndex(int resIndex) {
        return ((Number)this.residuePointers.get(resIndex)).intValue() - 1;
    }

    public final int lastAtomLimit(int resIndex) {
        int n;
        Integer n2 = (Integer)CollectionsKt.getOrNull(this.residuePointers, (int)(resIndex + 1));
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = it - 1;
        } else {
            n = this.atomNames.size();
        }
        return n;
    }

    public final int numAtoms(int resIndex) {
        return this.lastAtomLimit(resIndex) - this.firstAtomIndex(resIndex);
    }

    @NotNull
    public final IntRange atomIndices(int resIndex) {
        return RangesKt.until((int)this.firstAtomIndex(resIndex), (int)this.lastAtomLimit(resIndex));
    }

    public final int getNumAtoms() {
        return ((Number)this.pointers.get(0)).intValue();
    }

    public final int getNumAtomTypes() {
        return ((Number)this.pointers.get(1)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mapped mapTo(@NotNull List<? extends Molecule> mols) {
        Intrinsics.checkNotNullParameter(mols, (String)"mols");
        IdentityHashMap<Atom, Integer> molToTop = new IdentityHashMap<Atom, Integer>();
        HashMap<Integer, MappedAtom> topToMol = new HashMap<Integer, MappedAtom>();
        int resi = 0;
        for (Molecule molecule : mols) {
            void $this$filterTo$iv$iv;
            Object atom;
            boolean bl;
            Atom it;
            int n;
            Object $this$mapTo$iv$iv;
            if (molecule instanceof Polymer) {
                for (Polymer.Chain chain : ((Polymer)molecule).getChains()) {
                    for (Polymer.Residue res : chain.getResidues()) {
                        void $this$filterTo$iv$iv2;
                        Object atom2;
                        boolean bl2;
                        Iterator iterator2;
                        int n2;
                        IntRange intRange = this.atomIndices(resi);
                        int i = intRange.getFirst();
                        if (i <= (n2 = intRange.getLast())) {
                            while (true) {
                                Object v0;
                                Object object;
                                block19: {
                                    object = res.getAtoms();
                                    iterator2 = object.iterator();
                                    while (iterator2.hasNext()) {
                                        Object t = iterator2.next();
                                        Atom it2 = (Atom)t;
                                        bl2 = false;
                                        if (!Intrinsics.areEqual((Object)it2.getName(), (Object)this.atomNames.get(i))) continue;
                                        v0 = t;
                                        break block19;
                                    }
                                    v0 = null;
                                }
                                atom2 = v0;
                                if (atom2 != null) {
                                    object = i;
                                    ((Map)molToTop).put(atom2, object);
                                    object = i;
                                    ((Map)topToMol).put(object, new MappedAtom(molecule, res, (Atom)atom2));
                                } else {
                                    object = i;
                                    ((Map)topToMol).put(object, new MappedAtom(molecule, null, (Atom)atom2));
                                }
                                if (i == n2) break;
                                ++i;
                            }
                        }
                        Iterable $this$filter$iv = res.getAtoms();
                        boolean $i$f$filter = false;
                        atom2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            Atom it3 = (Atom)element$iv$iv;
                            bl2 = false;
                            if (!(!molToTop.keySet().contains(it3))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List missingAtoms2 = (List)destination$iv$iv;
                        if (!((Collection)missingAtoms2).isEmpty()) {
                            Collection<String> collection;
                            void $this$map$iv;
                            $this$filter$iv = (Iterable)this.atomIndices(resi);
                            List list = missingAtoms2;
                            String string = res.getType();
                            String string2 = res.getId();
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv2 = $this$map$iv;
                            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            iterator2 = $this$mapTo$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                void it2;
                                int item$iv$iv;
                                int it3 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                                collection = destination$iv$iv;
                                bl2 = false;
                                collection.add(this.atomNames.get((int)it2));
                            }
                            collection = (List)destination$iv$iv;
                            String string3 = StringsKt.trimMargin$default((String)("\n\t\t\t\t\t\t\t\t|topology does not describe all atoms in residue " + string2 + " " + string + ":\n\t\t\t\t\t\t\t\t|\tnot found: " + list + "\n\t\t\t\t\t\t\t\t|\tamong atoms: " + (List)collection + "\n\t\t\t\t\t\t\t"), null, (int)1, null);
                            throw new IllegalArgumentException(string3);
                        }
                        ++resi;
                    }
                }
                continue;
            }
            IntRange intRange = this.atomIndices(resi);
            int i = intRange.getFirst();
            if (i <= (n = intRange.getLast())) {
                while (true) {
                    Object v1;
                    Object $this$map$iv;
                    block20: {
                        $this$map$iv = molecule.getAtoms();
                        Iterator iterator3 = $this$map$iv.iterator();
                        while (iterator3.hasNext()) {
                            $this$mapTo$iv$iv = iterator3.next();
                            it = (Atom)$this$mapTo$iv$iv;
                            bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.atomNames.get(i))) continue;
                            v1 = $this$mapTo$iv$iv;
                            break block20;
                        }
                        v1 = null;
                    }
                    atom = v1;
                    if (atom != null) {
                        $this$map$iv = i;
                        ((Map)molToTop).put(atom, $this$map$iv);
                        $this$map$iv = i;
                        ((Map)topToMol).put($this$map$iv, new MappedAtom(molecule, null, (Atom)atom));
                    } else {
                        $this$map$iv = i;
                        ((Map)topToMol).put($this$map$iv, new MappedAtom(molecule, null, null));
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            Iterable $this$filter$iv = molecule.getAtoms();
            boolean $i$f$filter = false;
            atom = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                bl = false;
                if (!(!molToTop.keySet().contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingAtoms3 = (List)destination$iv$iv;
            if (!((Collection)missingAtoms3).isEmpty()) {
                throw new IllegalArgumentException("topology does not describe all atoms in the molecule:\n" + missingAtoms3);
            }
            ++resi;
        }
        return new Mapped(mols, molToTop, topToMol);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\r"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$IndexPair;", "", "i1", "", "i2", "(II)V", "getI1", "()I", "getI2", "equals", "", "other", "hashCode", "osprey3"})
    public static final class IndexPair {
        private final int i1;
        private final int i2;

        public IndexPair(int i1, int i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        public final int getI1() {
            return this.i1;
        }

        public final int getI2() {
            return this.i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof IndexPair && (this.i1 == ((IndexPair)other).i1 && this.i2 == ((IndexPair)other).i2 || this.i1 == ((IndexPair)other).i2 && this.i2 == ((IndexPair)other).i1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001BM\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u0013\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00032\u001c\b\u0002\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u0017J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bJ\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0016\u0010&\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\u0016\u0010&\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u0006\u0010'\u001a\u00020\bJ\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0)2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0)2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$Mapped;", "", "mols", "", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "molToTop", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "", "topToMol", "Ljava/util/HashMap;", "Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$MappedAtom;", "Lkotlin/collections/HashMap;", "(Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology;Ljava/util/List;Ljava/util/IdentityHashMap;Ljava/util/HashMap;)V", "getMols", "()Ljava/util/List;", "numAtoms", "getNumAtoms", "()I", "addMissingAtoms", "coords", "Lorg/joml/Vector3d;", "filter", "Lkotlin/Function2;", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "", "atom", "i", "atomType", "", "charge", "", "index", "chargeDivisor14", "atoma", "atomb", "indexa", "indexb", "nonbondIndex", "setBonds", "vdw", "Lkotlin/Pair;", "vdwDivisor14", "osprey3"})
    public final class Mapped {
        @NotNull
        private final List<Molecule> mols;
        @NotNull
        private final IdentityHashMap<Atom, Integer> molToTop;
        @NotNull
        private final HashMap<Integer, MappedAtom> topToMol;

        public Mapped(@NotNull List<? extends Molecule> mols, @NotNull IdentityHashMap<Atom, Integer> molToTop, HashMap<Integer, MappedAtom> topToMol) {
            Intrinsics.checkNotNullParameter(mols, (String)"mols");
            Intrinsics.checkNotNullParameter(molToTop, (String)"molToTop");
            Intrinsics.checkNotNullParameter(topToMol, (String)"topToMol");
            this.mols = mols;
            this.molToTop = molToTop;
            this.topToMol = topToMol;
        }

        @NotNull
        public final List<Molecule> getMols() {
            return this.mols;
        }

        public final int addMissingAtoms(@NotNull List<? extends Vector3d> coords, @NotNull Function2<? super Atom, ? super Polymer.Residue, Boolean> filter) {
            Intrinsics.checkNotNullParameter(coords, (String)"coords");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            int numAtomsAdded = 0;
            for (Map.Entry entry : ((Map)this.topToMol).entrySet()) {
                Atom newAtom;
                int i = ((Number)entry.getKey()).intValue();
                MappedAtom mappedAtom = (MappedAtom)entry.getValue();
                Molecule mol = mappedAtom.component1();
                Polymer.Residue res = mappedAtom.component2();
                Atom atom = mappedAtom.component3();
                if (atom != null || !((Boolean)filter.invoke((Object)(newAtom = new Atom(Element.Companion.get(((Number)AmberTopology.this.getAtomicNumbers().get(i)).intValue()), AmberTopology.this.getAtomNames().get(i), new Vector3d((Vector3dc)coords.get(i)))), (Object)res)).booleanValue()) continue;
                mol.getAtoms().add(newAtom);
                Object object = res;
                if (object != null && (object = ((Polymer.Residue)object).getAtoms()) != null) {
                    object.add(newAtom);
                }
                Integer n = i;
                ((Map)this.molToTop).put(newAtom, n);
                n = i;
                ((Map)this.topToMol).put(n, new MappedAtom(mol, res, newAtom));
                ++numAtomsAdded;
            }
            return numAtomsAdded;
        }

        public static /* synthetic */ int addMissingAtoms$default(Mapped mapped, List list, Function2 function2, int n, Object object) {
            if ((n & 2) != 0) {
                function2 = addMissingAtoms.1.INSTANCE;
            }
            return mapped.addMissingAtoms(list, (Function2<? super Atom, ? super Polymer.Residue, Boolean>)function2);
        }

        public final int setBonds() {
            int numBondsAdded = 0;
            List bonds2 = CollectionsKt.plus((Collection)AmberTopology.this.getBondsIncHydrogen(), (Iterable)AmberTopology.this.getBondsWithoutHydrogen());
            if (bonds2.size() % 3 != 0) {
                throw new IllegalStateException("unexpected number of bond indices: " + bonds2.size() + ", should be a multiple of 3");
            }
            int numBonds = bonds2.size() / 3;
            for (int i = 0; i < numBonds; ++i) {
                MappedAtom mappedAtom;
                MappedAtom mappedAtom2;
                int i1 = ((Number)bonds2.get(i * 3)).intValue() / 3;
                int i2 = ((Number)bonds2.get(i * 3 + 1)).intValue() / 3;
                if (this.topToMol.get(i1) == null) continue;
                Molecule mol1 = mappedAtom2.component1();
                Atom a1 = mappedAtom2.component3();
                if (this.topToMol.get(i2) == null) continue;
                Molecule mol2 = mappedAtom.component1();
                Atom a2 = mappedAtom.component3();
                if (a1 == null || a2 == null) continue;
                boolean bl = Intrinsics.areEqual((Object)AmberTopology.this.getAtomNames().get(i1), (Object)a1.getName());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                bl = Intrinsics.areEqual((Object)AmberTopology.this.getAtomNames().get(i2), (Object)a2.getName());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (mol1 != mol2) {
                    throw new IllegalStateException("inter-molecular bonds not supported");
                }
                Molecule mol = mol1;
                boolean wasAdded = mol.getBonds().add(a1, a2);
                if (!wasAdded) continue;
                ++numBondsAdded;
            }
            return numBondsAdded;
        }

        private final int index(Atom atom) {
            Integer n = this.molToTop.get(atom);
            if (n == null) {
                throw new NoSuchElementException("atom " + atom + " is not in the topology");
            }
            return ((Number)n).intValue();
        }

        @Nullable
        public final Atom atom(int i) {
            MappedAtom mappedAtom = this.topToMol.get(i);
            return mappedAtom != null ? mappedAtom.getAtom() : null;
        }

        public final int getNumAtoms() {
            return AmberTopology.this.getNumAtoms();
        }

        @NotNull
        public final String atomType(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            return AmberTopology.this.getAtomTypes().get(this.index(atom));
        }

        public final double charge(int index) {
            return ((Number)AmberTopology.this.getCharges().get(index)).doubleValue();
        }

        public final double charge(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            return this.charge(this.index(atom));
        }

        public final double chargeDivisor14(int indexa, int indexb) {
            Integer n = AmberTopology.this.getDihedralIndex(indexa, indexb);
            if (n == null) {
                return 1.2;
            }
            int i = n;
            return ((Number)AmberTopology.this.getEsScaleFactors().get(i)).doubleValue();
        }

        public final double chargeDivisor14(@NotNull Atom atoma, @NotNull Atom atomb) {
            Intrinsics.checkNotNullParameter((Object)atoma, (String)"atoma");
            Intrinsics.checkNotNullParameter((Object)atomb, (String)"atomb");
            return this.chargeDivisor14(this.index(atoma), this.index(atomb));
        }

        public final int nonbondIndex(int indexa, int indexb) {
            int i = indexa;
            int j = indexb;
            if (i == j) {
                throw new IllegalArgumentException("must have different atoms to get nonbonded index");
            }
            if (i > j) {
                int swap = i;
                i = j;
                j = swap;
            }
            int iaci = ((Number)AmberTopology.this.getAtomTypeIndices().get(i)).intValue();
            int iacj = ((Number)AmberTopology.this.getAtomTypeIndices().get(j)).intValue();
            return ((Number)AmberTopology.this.getNonbondedParmIndices().get(AmberTopology.this.getNumAtomTypes() * (iaci - 1) + iacj - 1)).intValue() - 1;
        }

        public final int nonbondIndex(@NotNull Atom atoma, @NotNull Atom atomb) {
            Intrinsics.checkNotNullParameter((Object)atoma, (String)"atoma");
            Intrinsics.checkNotNullParameter((Object)atomb, (String)"atomb");
            return this.nonbondIndex(this.index(atoma), this.index(atomb));
        }

        @NotNull
        public final Pair<Double, Double> vdw(int indexa, int indexb) {
            int n = this.nonbondIndex(indexa, indexb);
            AmberTopology amberTopology = AmberTopology.this;
            int i = n;
            boolean bl = false;
            return TuplesKt.to((Object)amberTopology.getLennardJonesACoeff().get(i), (Object)amberTopology.getLennardJonesBCoeff().get(i));
        }

        @NotNull
        public final Pair<Double, Double> vdw(@NotNull Atom atoma, @NotNull Atom atomb) {
            Intrinsics.checkNotNullParameter((Object)atoma, (String)"atoma");
            Intrinsics.checkNotNullParameter((Object)atomb, (String)"atomb");
            return this.vdw(this.index(atoma), this.index(atomb));
        }

        public final double vdwDivisor14(int indexa, int indexb) {
            Integer n = AmberTopology.this.getDihedralIndex(indexa, indexb);
            if (n == null) {
                return 2.0;
            }
            int i = n;
            return ((Number)AmberTopology.this.getVdwScaleFactors().get(i)).doubleValue();
        }

        public final double vdwDivisor14(@NotNull Atom atoma, @NotNull Atom atomb) {
            Intrinsics.checkNotNullParameter((Object)atoma, (String)"atoma");
            Intrinsics.checkNotNullParameter((Object)atomb, (String)"atomb");
            return this.vdwDivisor14(this.index(atoma), this.index(atomb));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/amber/AmberTopology$MappedAtom;", "", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "res", "Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getAtom", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getRes", "()Ledu/duke/cs/osprey/molscope/molecule/Polymer$Residue;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "osprey3"})
    public static final class MappedAtom {
        @NotNull
        private final Molecule mol;
        @Nullable
        private final Polymer.Residue res;
        @Nullable
        private final Atom atom;

        public MappedAtom(@NotNull Molecule mol, @Nullable Polymer.Residue res, @Nullable Atom atom) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            this.mol = mol;
            this.res = res;
            this.atom = atom;
        }

        @NotNull
        public final Molecule getMol() {
            return this.mol;
        }

        @Nullable
        public final Polymer.Residue getRes() {
            return this.res;
        }

        @Nullable
        public final Atom getAtom() {
            return this.atom;
        }

        @NotNull
        public final Molecule component1() {
            return this.mol;
        }

        @Nullable
        public final Polymer.Residue component2() {
            return this.res;
        }

        @Nullable
        public final Atom component3() {
            return this.atom;
        }

        @NotNull
        public final MappedAtom copy(@NotNull Molecule mol, @Nullable Polymer.Residue res, @Nullable Atom atom) {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            return new MappedAtom(mol, res, atom);
        }

        public static /* synthetic */ MappedAtom copy$default(MappedAtom mappedAtom, Molecule molecule, Polymer.Residue residue, Atom atom, int n, Object object) {
            if ((n & 1) != 0) {
                molecule = mappedAtom.mol;
            }
            if ((n & 2) != 0) {
                residue = mappedAtom.res;
            }
            if ((n & 4) != 0) {
                atom = mappedAtom.atom;
            }
            return mappedAtom.copy(molecule, residue, atom);
        }

        @NotNull
        public String toString() {
            return "MappedAtom(mol=" + this.mol + ", res=" + this.res + ", atom=" + this.atom + ")";
        }

        public int hashCode() {
            int result = this.mol.hashCode();
            result = result * 31 + (this.res == null ? 0 : this.res.hashCode());
            result = result * 31 + (this.atom == null ? 0 : this.atom.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MappedAtom)) {
                return false;
            }
            MappedAtom mappedAtom = (MappedAtom)other;
            if (!Intrinsics.areEqual((Object)this.mol, (Object)mappedAtom.mol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.res, (Object)mappedAtom.res)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.atom, (Object)mappedAtom.atom);
        }
    }
}

