/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.features.slide;

import cuchaz.kludge.tools.LangKt;
import cuchaz.kludge.tools.Ref;
import edu.duke.cs.osprey.gui.prep.AtomTreeKt;
import edu.duke.cs.osprey.gui.prep.BondGuesser;
import edu.duke.cs.osprey.gui.prep.BondGuesserKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0017R\u00020\u00000\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/SelectedAtom;", "", "view", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "maxDistSq", "", "(Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;Ledu/duke/cs/osprey/molscope/molecule/Atom;D)V", "getAtom", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "bondGuesser", "Ledu/duke/cs/osprey/gui/prep/BondGuesser;", "getBondGuesser", "()Ledu/duke/cs/osprey/gui/prep/BondGuesser;", "getMaxDistSq", "()D", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "nearbyAtoms", "", "Ledu/duke/cs/osprey/gui/features/slide/SelectedAtom$AtomInfo;", "getNearbyAtoms", "()Ljava/util/List;", "getView", "()Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "AtomInfo", "osprey3"})
@SourceDebugExtension(value={"SMAP\nBondEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BondEditor.kt\nedu/duke/cs/osprey/gui/features/slide/SelectedAtom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,478:1\n1549#2:479\n1620#2,3:480\n1045#2:483\n*S KotlinDebug\n*F\n+ 1 BondEditor.kt\nedu/duke/cs/osprey/gui/features/slide/SelectedAtom\n*L\n347#1:479\n347#1:480,3\n349#1:483\n*E\n"})
final class SelectedAtom {
    @NotNull
    private final MoleculeRenderView view;
    @NotNull
    private final Atom atom;
    private final double maxDistSq;
    @NotNull
    private final BondGuesser bondGuesser;
    @NotNull
    private final List<AtomInfo> nearbyAtoms;

    /*
     * WARNING - void declaration
     */
    public SelectedAtom(@NotNull MoleculeRenderView view, @NotNull Atom atom, double maxDistSq) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        this.view = view;
        this.atom = atom;
        this.maxDistSq = maxDistSq;
        this.bondGuesser = new BondGuesser(0.0, 0.0, null, 7, null);
        List list = iterable = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.asSequence(AtomTreeKt.toTree(this.getMol().getAtoms()).nearest(this.atom)), (Function1)((Function1)new Function1<Pair<? extends Atom, ? extends Double>, Boolean>(this){
            final /* synthetic */ SelectedAtom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<Atom, Double> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                double distSq = ((Number)pair.component2()).doubleValue();
                return distSq <= this.this$0.getMaxDistSq();
            }
        })), (Function1)((Function1)new Function1<Pair<? extends Atom, ? extends Double>, Boolean>(this){
            final /* synthetic */ SelectedAtom this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<Atom, Double> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                Atom nearbyAtom = (Atom)pair.component1();
                return this.this$0.getAtom() != nearbyAtom;
            }
        })));
        SelectedAtom selectedAtom = this;
        boolean $i$a$-apply-SelectedAtom$nearbyAtoms$42 = false;
        for (Atom bondedAtom : this.getMol().getBonds().bondedAtoms(this.atom)) {
            void $this$nearbyAtoms_u24lambda_u240;
            $this$nearbyAtoms_u24lambda_u240.add(TuplesKt.to((Object)bondedAtom, (Object)this.atom.getPos().distanceSquared((Vector3dc)bondedAtom.getPos())));
        }
        iterable = iterable;
        boolean $i$f$map = false;
        void $i$a$-apply-SelectedAtom$nearbyAtoms$42 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Atom nearbyAtom = (Atom)pair.component1();
            double distSq = ((Number)pair.component2()).doubleValue();
            collection.add(new AtomInfo(this, nearbyAtom, LangKt.sqrt((double)distSq)));
        }
        $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        selectedAtom.nearbyAtoms = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AtomInfo it = (AtomInfo)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getDist());
                it = (AtomInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getDist()));
            }
        });
    }

    @NotNull
    public final MoleculeRenderView getView() {
        return this.view;
    }

    @NotNull
    public final Atom getAtom() {
        return this.atom;
    }

    public final double getMaxDistSq() {
        return this.maxDistSq;
    }

    @NotNull
    public final Molecule getMol() {
        return this.view.getMolStack().getOriginalMol();
    }

    @NotNull
    public final BondGuesser getBondGuesser() {
        return this.bondGuesser;
    }

    @NotNull
    public final List<AtomInfo> getNearbyAtoms() {
        return this.nearbyAtoms;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/SelectedAtom$AtomInfo;", "", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ledu/duke/cs/osprey/gui/features/slide/SelectedAtom;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "dist", "", "(Ledu/duke/cs/osprey/gui/features/slide/SelectedAtom;Ledu/duke/cs/osprey/molscope/molecule/Atom;D)V", "getAtom", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "covalentRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "getCovalentRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "getDist", "()D", "pBonded", "Lcuchaz/kludge/tools/Ref;", "", "getPBonded", "()Lcuchaz/kludge/tools/Ref;", "updateBond", "", "osprey3"})
    public final class AtomInfo {
        @NotNull
        private final Atom atom;
        private final double dist;
        @NotNull
        private final Ref<Boolean> pBonded;
        @NotNull
        private final ClosedFloatingPointRange<Double> covalentRange;
        final /* synthetic */ SelectedAtom this$0;

        public AtomInfo(@NotNull SelectedAtom this$0, Atom atom, double dist) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.this$0 = this$0;
            this.atom = atom;
            this.dist = dist;
            this.pBonded = Ref.Companion.of((Object)this.this$0.getMol().getBonds().isBonded(this.this$0.getAtom(), this.atom));
            this.covalentRange = BondGuesserKt.covalentRange(this.atom, this.this$0.getAtom(), this.this$0.getBondGuesser());
        }

        @NotNull
        public final Atom getAtom() {
            return this.atom;
        }

        public final double getDist() {
            return this.dist;
        }

        public AtomInfo(@NotNull SelectedAtom this$0, Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this(this$0, atom, this$0.getAtom().getPos().distance((Vector3dc)atom.getPos()));
        }

        @NotNull
        public final Ref<Boolean> getPBonded() {
            return this.pBonded;
        }

        @NotNull
        public final ClosedFloatingPointRange<Double> getCovalentRange() {
            return this.covalentRange;
        }

        public final void updateBond() {
            Atom a1 = this.this$0.getAtom();
            Atom a2 = this.atom;
            if (((Boolean)this.pBonded.getValue()).booleanValue()) {
                this.this$0.getMol().getBonds().add(a1, a2);
            } else {
                this.this$0.getMol().getBonds().remove(a1, a2);
            }
            this.this$0.getView().moleculeChanged();
        }
    }
}

