/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.compiler;

import edu.duke.cs.osprey.gui.compiler.FixedAtoms;
import edu.duke.cs.osprey.gui.forcefield.AtomIndex;
import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.prep.Assignments;
import edu.duke.cs.osprey.gui.prep.AssignmentsKt;
import edu.duke.cs.osprey.gui.prep.ConfSpace;
import edu.duke.cs.osprey.gui.prep.DesignPosition;
import edu.duke.cs.osprey.gui.prep.PosAssignment;
import edu.duke.cs.osprey.gui.tools.ArrayMap;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007*+,-./0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\bJ\u0015\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u0015\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0015J\u0015\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020\b2\u0006\u0010#\u001a\u00020$J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010(\u001a\u00020)R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001b\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0018R\u00020\u00000\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u00061"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;", "", "confSpace", "Ledu/duke/cs/osprey/gui/prep/ConfSpace;", "(Ledu/duke/cs/osprey/gui/prep/ConfSpace;)V", "atomIndexByKey", "Ljava/util/HashMap;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$AtomKey;", "", "Lkotlin/collections/HashMap;", "atomIndexWildTypeByMol", "Ledu/duke/cs/osprey/gui/tools/ArrayMap;", "Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "getConfSpace", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace;", "fixedAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getFixedAtoms", "()Ljava/util/List;", "mols", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getMols", "positions", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "getPositions", "addKey", "key", "atomIndexWildType", "moli", "findMoli", "mol", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;)Ljava/lang/Integer;", "findMoliOrThrow", "findPosi", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;)Ljava/lang/Integer;", "getPosi", "matchAtoms", "assignments", "Ledu/duke/cs/osprey/gui/prep/Assignments;", "AtomKey", "ConfInfo", "FragInfo", "PosInfo", "PosTuple", "PositionAtomKey", "WildTypeAtomKey", "osprey3"})
@SourceDebugExtension(value={"SMAP\nConfSpaceIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpaceIndex.kt\nedu/duke/cs/osprey/gui/compiler/ConfSpaceIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1549#2:284\n1620#2,3:285\n1045#2:288\n1603#2,9:289\n1855#2:298\n1603#2,9:299\n1855#2:308\n1856#2:311\n1612#2:312\n1856#2:314\n1612#2:315\n1559#2:316\n1590#2,4:317\n1549#2:321\n1620#2,3:322\n350#2,7:325\n350#2,7:332\n1549#2:339\n1620#2,3:340\n1#3:309\n1#3:310\n1#3:313\n*S KotlinDebug\n*F\n+ 1 ConfSpaceIndex.kt\nedu/duke/cs/osprey/gui/compiler/ConfSpaceIndex\n*L\n123#1:284\n123#1:285,3\n124#1:288\n139#1:289,9\n139#1:298\n141#1:299,9\n141#1:308\n141#1:311\n141#1:312\n139#1:314\n139#1:315\n146#1:316\n146#1:317,4\n160#1:321\n160#1:322,3\n127#1:325,7\n150#1:332,7\n234#1:339\n234#1:340,3\n141#1:310\n139#1:313\n*E\n"})
public final class ConfSpaceIndex {
    @NotNull
    private final ConfSpace confSpace;
    @NotNull
    private final List<Molecule> mols;
    @NotNull
    private final List<PosInfo> positions;
    @NotNull
    private final List<List<Atom>> fixedAtoms;
    @NotNull
    private final ArrayMap<AtomIndex> atomIndexWildTypeByMol;
    @NotNull
    private final HashMap<AtomKey, Integer> atomIndexByKey;

    /*
     * WARNING - void declaration
     */
    public ConfSpaceIndex(@NotNull ConfSpace confSpace) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        int n;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)confSpace, (String)"confSpace");
        this.confSpace = confSpace;
        Iterator<PosInfo> iterator2 = this.confSpace.getMols();
        ConfSpaceIndex confSpaceIndex = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Molecule mol = (Molecule)object.component2();
            collection.add(mol);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        confSpaceIndex.mols = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Molecule it = (Molecule)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Molecule)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        $this$sortedBy$iv = CollectionsKt.withIndex((Iterable)this.mols);
        confSpaceIndex = this;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            List list;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = object.next();
            n = 0;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int moli = indexedValue.component1();
            Molecule mol = (Molecule)indexedValue.component2();
            List<DesignPosition> list2 = this.confSpace.getDesignPositionsByMol().get(mol);
            if (list2 != null) {
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Iterable iterable = list2;
                boolean $i$f$mapNotNull2 = false;
                void var20_40 = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    PosTuple posTuple;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                    boolean bl2 = false;
                    DesignPosition pos = (DesignPosition)element$iv$iv2;
                    boolean bl3 = false;
                    if (this.confSpace.getPositionConfSpaces().get(pos) != null) {
                        ConfSpace.PositionConfSpace it;
                        boolean bl4 = false;
                        posTuple = new PosTuple(pos, moli, it);
                    } else {
                        posTuple = null;
                    }
                    if (posTuple == null) continue;
                    PosTuple it$iv$iv = posTuple;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$mapIndexed = false;
        $this$mapNotNullTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv2 = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void i;
            void t;
            int element$iv$iv$iv;
            if ((element$iv$iv$iv = index$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (PosTuple)item$iv$iv2;
            n = element$iv$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PosInfo(t.getPos(), t.getMoli(), t.getPosConfSpace(), (int)i));
        }
        confSpaceIndex.positions = (List)destination$iv$iv;
        $this$mapIndexed$iv = this.mols;
        confSpaceIndex = this;
        $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (Molecule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.confSpace.fixedAtoms((Molecule)it));
        }
        confSpaceIndex.fixedAtoms = (List)destination$iv$iv;
        this.atomIndexWildTypeByMol = new ArrayMap();
        this.atomIndexByKey = new HashMap();
        iterator2 = this.mols.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int moli = n2++;
            Molecule mol = (Molecule)((Object)iterator2.next());
            AtomIndex atomIndex = new AtomIndex();
            Integer n3 = moli;
            ((Map)this.atomIndexWildTypeByMol).put(n3, atomIndex);
            Iterator<Object> index$iv$iv2 = mol.getAtoms().iterator();
            int n4 = 0;
            while (index$iv$iv2.hasNext()) {
                int atomi = n4++;
                Atom atom = (Atom)index$iv$iv2.next();
                atomIndex.set(atom, this.addKey(new WildTypeAtomKey(moli, atomi)));
            }
        }
        iterator2 = this.positions.iterator();
        n2 = 0;
        while (iterator2.hasNext()) {
            int posi = n2++;
            PosInfo posInfo = iterator2.next();
            for (FragInfo fragInfo : posInfo.getFragments()) {
                for (ConfLib.AtomInfo atomInfo : fragInfo.getFrag().getAtoms()) {
                    this.addKey(new PositionAtomKey(posi, fragInfo.getFrag(), atomInfo.getId()));
                }
            }
        }
    }

    @NotNull
    public final ConfSpace getConfSpace() {
        return this.confSpace;
    }

    @NotNull
    public final List<Molecule> getMols() {
        return this.mols;
    }

    @Nullable
    public final Integer findMoli(@NotNull Molecule mol) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            List<Molecule> $this$indexOfFirst$iv = this.mols;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Molecule> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                Molecule item$iv;
                Molecule it = item$iv = iterator2.next();
                boolean bl = false;
                if (it == mol) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public final int findMoliOrThrow(@NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Integer n = this.findMoli(mol);
        if (n == null) {
            throw new NoSuchElementException("molecule " + mol + " not indexed");
        }
        return n;
    }

    @NotNull
    public final List<PosInfo> getPositions() {
        return this.positions;
    }

    @Nullable
    public final Integer findPosi(@NotNull DesignPosition pos) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            List<PosInfo> $this$indexOfFirst$iv = this.positions;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PosInfo> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                PosInfo item$iv;
                PosInfo it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getPos() == pos) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        return it >= 0 ? n2 : null;
    }

    public final int getPosi(@NotNull DesignPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Integer n = this.findPosi(pos);
        if (n == null) {
            throw new NoSuchElementException("design position not found in this conf space");
        }
        return n;
    }

    @NotNull
    public final List<List<Atom>> getFixedAtoms() {
        return this.fixedAtoms;
    }

    private final int addKey(AtomKey key) {
        int index = this.atomIndexByKey.size();
        Integer n = index;
        ((Map)this.atomIndexByKey).put(key, n);
        return index;
    }

    @NotNull
    public final AtomIndex atomIndexWildType(int moli) {
        AtomIndex atomIndex = this.atomIndexWildTypeByMol.get((Object)moli);
        if (atomIndex == null) {
            throw new NoSuchElementException("no atom index exists for molecule " + moli);
        }
        return atomIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AtomIndex> matchAtoms(@NotNull Assignments assignments) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)assignments, (String)"assignments");
        Iterable $this$map$iv = this.mols;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Molecule molecule = (Molecule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AtomIndex());
        }
        List atomIndices = (List)destination$iv$iv;
        int n = this.mols.size();
        for (int moli = 0; moli < n; ++moli) {
            Assignments.MolInfo molInfo = assignments.molInfoByConfSpaceMol(this.mols.get(moli));
            for (Atom atom : molInfo.getAssignedMol().getAtoms()) {
                Atom csAtom;
                if (molInfo.getConfSpaceAtom(atom) == null) continue;
                ((AtomIndex)atomIndices.get(moli)).set(atom, this.atomIndexWildType(moli).getOrThrow(csAtom));
            }
        }
        for (Map.Entry<PosAssignment, Assignments.AssignmentInfo> entry : assignments.getAssignmentInfos().entrySet()) {
            PosAssignment assignment = entry.getKey();
            Assignments.AssignmentInfo info2 = entry.getValue();
            int posi = this.getPosi(assignment.getPos());
            int moli = this.positions.get(posi).getMoli();
            for (ConfLib.AtomInfo atomInfo : assignment.getFrag().getAtoms()) {
                Atom atom = info2.getConfSwitcher().getAtomResolverOrThrow().resolveOrThrow(atomInfo);
                ((AtomIndex)atomIndices.get(moli)).set(atom, ((Number)MapsKt.getValue((Map)this.atomIndexByKey, (Object)new PositionAtomKey(posi, assignment.getFrag(), atomInfo.getId()))).intValue());
            }
        }
        return atomIndices;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$AtomKey;", "", "osprey3"})
    public static interface AtomKey {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$ConfInfo;", "", "posInfo", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;", "fragInfo", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$FragInfo;", "confConfSpace", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "index", "", "(Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$FragInfo;Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;I)V", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "getConf", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "getConfConfSpace", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "getFragInfo", "()Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$FragInfo;", "id", "", "getId", "()Ljava/lang/String;", "getIndex", "()I", "getPosInfo", "()Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "osprey3"})
    public final class ConfInfo {
        @NotNull
        private final PosInfo posInfo;
        @NotNull
        private final FragInfo fragInfo;
        @NotNull
        private final ConfSpace.ConfConfSpace confConfSpace;
        private final int index;
        @NotNull
        private final String id;

        public ConfInfo(@NotNull PosInfo posInfo, @NotNull FragInfo fragInfo, ConfSpace.ConfConfSpace confConfSpace, int index) {
            Intrinsics.checkNotNullParameter((Object)posInfo, (String)"posInfo");
            Intrinsics.checkNotNullParameter((Object)fragInfo, (String)"fragInfo");
            Intrinsics.checkNotNullParameter((Object)confConfSpace, (String)"confConfSpace");
            this.posInfo = posInfo;
            this.fragInfo = fragInfo;
            this.confConfSpace = confConfSpace;
            this.index = index;
            this.id = this.fragInfo.getFrag().getId() + ":" + this.getConf().getId();
        }

        @NotNull
        public final PosInfo getPosInfo() {
            return this.posInfo;
        }

        @NotNull
        public final FragInfo getFragInfo() {
            return this.fragInfo;
        }

        @NotNull
        public final ConfSpace.ConfConfSpace getConfConfSpace() {
            return this.confConfSpace;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final ConfLib.Conf getConf() {
            return this.confConfSpace.getConf();
        }

        @NotNull
        public final String getId() {
            return this.id;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$FragInfo;", "", "posInfo", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "index", "", "(Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;I)V", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getIndex", "()I", "getPosInfo", "()Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "orderAtoms", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "fixedAtoms", "Ledu/duke/cs/osprey/gui/compiler/FixedAtoms;", "assignmentInfo", "Ledu/duke/cs/osprey/gui/prep/Assignments$AssignmentInfo;", "osprey3"})
    public final class FragInfo {
        @NotNull
        private final PosInfo posInfo;
        @NotNull
        private final ConfLib.Fragment frag;
        private final int index;

        public FragInfo(@NotNull PosInfo posInfo, ConfLib.Fragment frag, int index) {
            Intrinsics.checkNotNullParameter((Object)posInfo, (String)"posInfo");
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            this.posInfo = posInfo;
            this.frag = frag;
            this.index = index;
        }

        @NotNull
        public final PosInfo getPosInfo() {
            return this.posInfo;
        }

        @NotNull
        public final ConfLib.Fragment getFrag() {
            return this.frag;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final List<Atom> orderAtoms(@NotNull FixedAtoms fixedAtoms, @NotNull Assignments.AssignmentInfo assignmentInfo) {
            ArrayList<Atom> arrayList;
            Intrinsics.checkNotNullParameter((Object)fixedAtoms, (String)"fixedAtoms");
            Intrinsics.checkNotNullParameter((Object)assignmentInfo, (String)"assignmentInfo");
            ArrayList<Atom> $this$orderAtoms_u24lambda_u240 = arrayList = new ArrayList<Atom>();
            boolean bl = false;
            for (FixedAtoms.DynamicInfo dynamicInfo : fixedAtoms.get(this.posInfo).getDynamics()) {
                $this$orderAtoms_u24lambda_u240.add(assignmentInfo.getMolInfo().getAssignedAtomOrThrow(dynamicInfo.getAtom()));
            }
            for (ConfLib.AtomInfo atomInfo : this.frag.getAtoms()) {
                $this$orderAtoms_u24lambda_u240.add(assignmentInfo.getConfSwitcher().getAtomResolverOrThrow().resolveOrThrow(atomInfo));
            }
            return arrayList;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ0\u0010\u001a\u001a\u00020\u001b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060\fR\u00020\r\u0012\u0004\u0012\u00020\u001b0\u001dH\u0086\b\u00f8\u0001\u0000J0\u0010 \u001a\u00020\u001b2\"\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060\fR\u00020\r\u0012\u0004\u0012\u00020\u001b0\u001dH\u0086\b\u00f8\u0001\u0000R\u001b\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\f\u0012\b\u0012\u00060\u0011R\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo;", "", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "moli", "", "posConfSpace", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "index", "(Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;Ledu/duke/cs/osprey/gui/prep/DesignPosition;ILedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;I)V", "confs", "", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$ConfInfo;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex;", "getConfs", "()Ljava/util/List;", "fragments", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$FragInfo;", "getFragments", "getIndex", "()I", "getMoli", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "getPosConfSpace", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "forEachConf", "", "block", "Lkotlin/Function3;", "Ledu/duke/cs/osprey/gui/prep/Assignments;", "Ledu/duke/cs/osprey/gui/prep/Assignments$AssignmentInfo;", "forEachFrag", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfSpaceIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpaceIndex.kt\nedu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1559#2:284\n1590#2,4:285\n1360#2:289\n1446#2,2:290\n1045#2:292\n1549#2:293\n1620#2,3:294\n1448#2,3:297\n1559#2:300\n1590#2,4:301\n223#2,2:305\n*S KotlinDebug\n*F\n+ 1 ConfSpaceIndex.kt\nedu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosInfo\n*L\n68#1:284\n68#1:285,4\n73#1:289\n73#1:290,2\n75#1:292\n76#1:293\n76#1:294,3\n73#1:297,3\n78#1:300\n78#1:301,4\n108#1:305,2\n*E\n"})
    public final class PosInfo {
        @NotNull
        private final DesignPosition pos;
        private final int moli;
        @NotNull
        private final ConfSpace.PositionConfSpace posConfSpace;
        private final int index;
        @NotNull
        private final List<FragInfo> fragments;
        @NotNull
        private final List<ConfInfo> confs;

        /*
         * WARNING - void declaration
         */
        public PosInfo(DesignPosition pos, @NotNull int moli, ConfSpace.PositionConfSpace posConfSpace, int index) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)posConfSpace, (String)"posConfSpace");
            this.pos = pos;
            this.moli = moli;
            this.posConfSpace = posConfSpace;
            this.index = index;
            Iterable iterable = this.posConfSpace.getConfs().fragments();
            ConfSpaceIndex confSpaceIndex = ConfSpaceIndex.this;
            PosInfo posInfo = this;
            boolean $i$f$mapIndexed22 = false;
            void var9_14 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void frag;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ConfLib.Fragment fragment = (ConfLib.Fragment)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)frag, (String)"frag");
                collection.add(confSpaceIndex.new FragInfo(this, (ConfLib.Fragment)frag, (int)i));
            }
            posInfo.fragments = (List)destination$iv$iv;
            $this$mapIndexed$iv = this.fragments;
            posInfo = this;
            boolean $i$f$flatMap = false;
            void $i$f$mapIndexed22 = $this$flatMap$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $this$sortedBy$iv;
                FragInfo fragInfo = (FragInfo)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.posConfSpace.getConfs().getByFragment(fragInfo.getFrag());
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ConfSpace.ConfConfSpace space = (ConfSpace.ConfConfSpace)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)space.getConf().getId());
                        space = (ConfSpace.ConfConfSpace)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)space.getConf().getId())));
                    }
                });
                boolean $i$f$map = false;
                void i = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void space;
                    ConfSpace.ConfConfSpace confConfSpace = (ConfSpace.ConfConfSpace)item$iv$iv;
                    Collection collection2 = destination$iv$iv3;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)fragInfo, (Object)space));
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            ConfSpaceIndex confSpaceIndex2 = ConfSpaceIndex.this;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv2 = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            $i$f$mapIndexedTo = false;
            index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv$iv;
                int $this$mapTo$iv$iv = n;
                collection = destination$iv$iv;
                boolean bl = false;
                FragInfo fragInfo = (FragInfo)pair.component1();
                ConfSpace.ConfConfSpace space = (ConfSpace.ConfConfSpace)pair.component2();
                collection.add(confSpaceIndex2.new ConfInfo(this, fragInfo, space, (int)i));
            }
            posInfo.confs = (List)destination$iv$iv;
        }

        @NotNull
        public final DesignPosition getPos() {
            return this.pos;
        }

        public final int getMoli() {
            return this.moli;
        }

        @NotNull
        public final ConfSpace.PositionConfSpace getPosConfSpace() {
            return this.posConfSpace;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final List<FragInfo> getFragments() {
            return this.fragments;
        }

        @NotNull
        public final List<ConfInfo> getConfs() {
            return this.confs;
        }

        public final void forEachConf(@NotNull Function3<? super Assignments, ? super Assignments.AssignmentInfo, ? super ConfInfo, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$forEachConf = false;
            for (ConfInfo confInfo : this.getConfs()) {
                PosAssignment assignment = new PosAssignment(this.getPos(), confInfo.getFragInfo().getFrag(), confInfo.getConf());
                PosAssignment[] posAssignmentArray = new PosAssignment[]{assignment};
                Assignments assignments = AssignmentsKt.assign(ConfSpaceIndex.this.getConfSpace(), posAssignmentArray);
                Assignments.AssignmentInfo assignmentInfo = (Assignments.AssignmentInfo)MapsKt.getValue(assignments.getAssignmentInfos(), (Object)assignment);
                block.invoke((Object)assignments, (Object)assignmentInfo, (Object)confInfo);
            }
        }

        public final void forEachFrag(@NotNull Function3<? super Assignments, ? super Assignments.AssignmentInfo, ? super ConfInfo, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$forEachFrag = false;
            for (FragInfo fragInfo : this.getFragments()) {
                Object element$iv2;
                block2: {
                    Iterable $this$first$iv = this.getConfs();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ConfInfo it = (ConfInfo)element$iv2;
                        boolean bl = false;
                        if (!(it.getFragInfo() == fragInfo)) continue;
                        break block2;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ConfInfo confInfo = (ConfInfo)element$iv2;
                PosAssignment assignment = new PosAssignment(this.getPos(), fragInfo.getFrag(), confInfo.getConf());
                PosAssignment[] posAssignmentArray = new PosAssignment[]{assignment};
                Assignments assignments = AssignmentsKt.assign(ConfSpaceIndex.this.getConfSpace(), posAssignmentArray);
                Assignments.AssignmentInfo assignmentInfo = (Assignments.AssignmentInfo)MapsKt.getValue(assignments.getAssignmentInfos(), (Object)assignment);
                block.invoke((Object)assignments, (Object)assignmentInfo, (Object)confInfo);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PosTuple;", "", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "moli", "", "posConfSpace", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;ILedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;)V", "getMoli", "()I", "getPos", "()Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "getPosConfSpace", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "osprey3"})
    private static final class PosTuple {
        @NotNull
        private final DesignPosition pos;
        private final int moli;
        @NotNull
        private final ConfSpace.PositionConfSpace posConfSpace;

        public PosTuple(@NotNull DesignPosition pos, int moli, @NotNull ConfSpace.PositionConfSpace posConfSpace) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)posConfSpace, (String)"posConfSpace");
            this.pos = pos;
            this.moli = moli;
            this.posConfSpace = posConfSpace;
        }

        @NotNull
        public final DesignPosition getPos() {
            return this.pos;
        }

        public final int getMoli() {
            return this.moli;
        }

        @NotNull
        public final ConfSpace.PositionConfSpace getPosConfSpace() {
            return this.posConfSpace;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0012"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$PositionAtomKey;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$AtomKey;", "posi", "", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "atomi", "(ILedu/duke/cs/osprey/gui/io/ConfLib$Fragment;I)V", "getAtomi", "()I", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getPosi", "equals", "", "other", "", "hashCode", "osprey3"})
    public static final class PositionAtomKey
    implements AtomKey {
        private final int posi;
        @Nullable
        private final ConfLib.Fragment frag;
        private final int atomi;

        public PositionAtomKey(int posi, @Nullable ConfLib.Fragment frag, int atomi) {
            this.posi = posi;
            this.frag = frag;
            this.atomi = atomi;
        }

        public final int getPosi() {
            return this.posi;
        }

        @Nullable
        public final ConfLib.Fragment getFrag() {
            return this.frag;
        }

        public final int getAtomi() {
            return this.atomi;
        }

        public int hashCode() {
            int[] nArray = new int[]{this.posi, System.identityHashCode(this.frag), this.atomi};
            return HashCalculator.combineHashes(nArray);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof PositionAtomKey && this.posi == ((PositionAtomKey)other).posi && this.frag == ((PositionAtomKey)other).frag && this.atomi == ((PositionAtomKey)other).atomi;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$WildTypeAtomKey;", "Ledu/duke/cs/osprey/gui/compiler/ConfSpaceIndex$AtomKey;", "moli", "", "atomi", "(II)V", "getAtomi", "()I", "getMoli", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "osprey3"})
    public static final class WildTypeAtomKey
    implements AtomKey {
        private final int moli;
        private final int atomi;

        public WildTypeAtomKey(int moli, int atomi) {
            this.moli = moli;
            this.atomi = atomi;
        }

        public final int getMoli() {
            return this.moli;
        }

        public final int getAtomi() {
            return this.atomi;
        }

        public final int component1() {
            return this.moli;
        }

        public final int component2() {
            return this.atomi;
        }

        @NotNull
        public final WildTypeAtomKey copy(int moli, int atomi) {
            return new WildTypeAtomKey(moli, atomi);
        }

        public static /* synthetic */ WildTypeAtomKey copy$default(WildTypeAtomKey wildTypeAtomKey, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = wildTypeAtomKey.moli;
            }
            if ((n3 & 2) != 0) {
                n2 = wildTypeAtomKey.atomi;
            }
            return wildTypeAtomKey.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "WildTypeAtomKey(moli=" + this.moli + ", atomi=" + this.atomi + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.moli);
            result = result * 31 + Integer.hashCode(this.atomi);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WildTypeAtomKey)) {
                return false;
            }
            WildTypeAtomKey wildTypeAtomKey = (WildTypeAtomKey)other;
            if (this.moli != wildTypeAtomKey.moli) {
                return false;
            }
            return this.atomi == wildTypeAtomKey.atomi;
        }
    }
}

