/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLDevice;
import edu.duke.cs.osprey.gpu.opencl.Gpu;

public class GpuQueue {
    private Gpu gpu;
    private CLCommandQueue queue;
    private CLContext separateContext;

    public GpuQueue(Gpu gpu) {
        this(gpu, false, false);
    }

    public GpuQueue(Gpu gpu, boolean useProfiling, boolean makeSeparateContext) {
        if (makeSeparateContext) {
            this.separateContext = CLContext.create((CLDevice[])new CLDevice[]{gpu.getDevice()});
            this.gpu = new Gpu(this.separateContext.getDevices()[0]);
        } else {
            this.separateContext = null;
            this.gpu = gpu;
        }
        CLDevice device = this.gpu.getDevice();
        this.queue = useProfiling ? device.createCommandQueue(CLCommandQueue.Mode.PROFILING_MODE) : device.createCommandQueue();
    }

    public Gpu getGpu() {
        return this.gpu;
    }

    public CLCommandQueue getCLQueue() {
        return this.queue;
    }

    public void cleanup() {
        if (this.queue != null) {
            this.queue.release();
            this.queue = null;
        }
        if (this.separateContext != null) {
            this.separateContext.release();
            this.separateContext = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.queue != null || this.separateContext != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isProfilingEnabled() {
        return this.queue.isProfilingEnabled();
    }

    public void flush() {
        this.queue.flush();
    }

    public void waitForGpu() {
        this.queue.finish();
    }
}

