/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import edu.duke.cs.osprey.gpu.cuda.Context;
import edu.duke.cs.osprey.gpu.cuda.Gpu;
import edu.duke.cs.osprey.gpu.cuda.GpuStream;
import edu.duke.cs.osprey.gpu.cuda.Gpus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class GpuStreamPool {
    public static boolean printPoolSize = true;
    private int numStreamsPerGpu;
    private List<Context> contexts;
    private List<List<GpuStream>> streamsByGpu;
    private List<GpuStream> streams;
    private boolean[] checkedOut;

    public GpuStreamPool() {
        this(1);
    }

    public GpuStreamPool(int queuesPerGpu) {
        this(Gpus.get().getGpus().size(), queuesPerGpu);
    }

    public GpuStreamPool(int numGpus, int queuesPerGpu) {
        this(numGpus, queuesPerGpu, false);
    }

    public GpuStreamPool(int numGpus, int numStreamsPerGpu, boolean useProfiling) {
        int i;
        this.numStreamsPerGpu = numStreamsPerGpu;
        ArrayList<Gpu> gpus = new ArrayList<Gpu>(Gpus.get().getGpus());
        gpus.sort(Comparator.comparing(gpu -> gpu.getFreeMemory()).reversed());
        numGpus = Math.min(numGpus, gpus.size());
        this.contexts = new ArrayList<Context>();
        for (Gpu gpu2 : gpus) {
            try {
                Context context = new Context(gpu2);
                this.contexts.add(context);
            }
            catch (Throwable context) {}
        }
        this.streamsByGpu = new ArrayList<List<GpuStream>>(numGpus);
        for (i = 0; i < numGpus; ++i) {
            Context context = this.contexts.get(i);
            context.attachCurrentThread();
            ArrayList<GpuStream> queuesAtGpu = new ArrayList<GpuStream>();
            for (int j = 0; j < numStreamsPerGpu; ++j) {
                queuesAtGpu.add(new GpuStream(context));
            }
            this.streamsByGpu.add(queuesAtGpu);
        }
        this.streams = new ArrayList<GpuStream>(numGpus * numStreamsPerGpu);
        for (i = 0; i < numStreamsPerGpu; ++i) {
            for (int j = 0; j < numGpus; ++j) {
                this.streams.add(this.streamsByGpu.get(j).get(i));
            }
        }
        this.checkedOut = new boolean[this.streams.size()];
        Arrays.fill(this.checkedOut, false);
        if (printPoolSize) {
            System.out.println(String.format("GpuStreamPool: using %d stream(s) across %d gpu(s)", this.streams.size(), numGpus));
        }
    }

    public int getNumGpus() {
        return this.streamsByGpu.size();
    }

    public int getNumStreamsPerGpu() {
        return this.numStreamsPerGpu;
    }

    public int getNumStreams() {
        return this.streams.size();
    }

    public int getNumStreamsAvailable() {
        int num = 0;
        for (int i = 0; i < this.streams.size(); ++i) {
            if (this.checkedOut[i]) continue;
            ++num;
        }
        return num;
    }

    public synchronized GpuStream checkout() {
        for (int i = 0; i < this.streams.size(); ++i) {
            if (this.checkedOut[i]) continue;
            this.checkedOut[i] = true;
            GpuStream stream = this.streams.get(i);
            stream.getContext().attachCurrentThread();
            return stream;
        }
        throw new IllegalStateException(String.format("no more streams to checkout, %d already used", this.streams.size()));
    }

    public synchronized void release(GpuStream stream) {
        if (this.streams == null) {
            stream.cleanup();
            return;
        }
        for (int i = 0; i < this.streams.size(); ++i) {
            if (this.streams.get(i) != stream) continue;
            this.checkedOut[i] = false;
        }
    }

    public void cleanup() {
        if (this.streams != null) {
            for (GpuStream stream : this.streams) {
                stream.cleanup();
            }
            this.streams = null;
            for (Context context : this.contexts) {
                context.cleanup();
            }
            this.contexts = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.streams != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }
}

