/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import edu.duke.cs.osprey.gpu.BufferTools;
import edu.duke.cs.osprey.gpu.cuda.BufferPool;
import edu.duke.cs.osprey.gpu.cuda.CUBuffer;
import edu.duke.cs.osprey.gpu.cuda.Context;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import jcuda.driver.CUstream;
import jcuda.driver.JCudaDriver;

public class GpuStream {
    public final BufferPool<ByteBuffer> byteBuffers;
    public final BufferPool<IntBuffer> intBuffers;
    public final BufferPool<LongBuffer> longBuffers;
    public final BufferPool<DoubleBuffer> doubleBuffers;
    private Context context;
    private CUstream stream;

    public GpuStream(Context context) {
        this.context = context;
        this.stream = new CUstream();
        JCudaDriver.cuStreamCreate((CUstream)this.stream, (int)0);
        this.byteBuffers = new BufferPool(size -> this.makeByteBuffer((int)size), (buf, size) -> this.makeOrExpandByteBuffer(buf, size));
        this.intBuffers = new BufferPool(size -> this.makeIntBuffer((int)size), (buf, size) -> this.makeOrExpandIntBuffer(buf, size));
        this.longBuffers = new BufferPool(size -> this.makeLongBuffer((int)size), (buf, size) -> this.makeOrExpandLongBuffer(buf, size));
        this.doubleBuffers = new BufferPool(size -> this.makeDoubleBuffer((int)size), (buf, size) -> this.makeOrExpandDoubleBuffer(buf, size));
    }

    public Context getContext() {
        return this.context;
    }

    public CUstream getStream() {
        return this.stream;
    }

    public <T extends Buffer> CUBuffer<T> makeBuffer(T buf) {
        return new CUBuffer<T>(this, buf);
    }

    public CUBuffer<ByteBuffer> makeByteBuffer(int size) {
        return new CUBuffer<ByteBuffer>(this, BufferTools.Type.Direct.makeByte(size));
    }

    public CUBuffer<IntBuffer> makeIntBuffer(int size) {
        return new CUBuffer<IntBuffer>(this, BufferTools.Type.Direct.makeInt(size));
    }

    public CUBuffer<DoubleBuffer> makeDoubleBuffer(int size) {
        return new CUBuffer<DoubleBuffer>(this, BufferTools.Type.Direct.makeDouble(size));
    }

    public CUBuffer<LongBuffer> makeLongBuffer(int size) {
        return new CUBuffer<LongBuffer>(this, BufferTools.Type.Direct.makeLong(size));
    }

    public CUBuffer<ByteBuffer> makeOrExpandByteBuffer(CUBuffer<ByteBuffer> buf, int size) {
        if ((buf = this.useOrCleanupBuffer(buf, size)) == null) {
            buf = this.makeByteBuffer(size);
        }
        return buf;
    }

    public CUBuffer<IntBuffer> makeOrExpandIntBuffer(CUBuffer<IntBuffer> buf, int size) {
        if ((buf = this.useOrCleanupBuffer(buf, size)) == null) {
            buf = this.makeIntBuffer(size);
        }
        return buf;
    }

    public CUBuffer<DoubleBuffer> makeOrExpandDoubleBuffer(CUBuffer<DoubleBuffer> buf, int size) {
        if ((buf = this.useOrCleanupBuffer(buf, size)) == null) {
            buf = this.makeDoubleBuffer(size);
        }
        return buf;
    }

    public CUBuffer<LongBuffer> makeOrExpandLongBuffer(CUBuffer<LongBuffer> buf, int size) {
        if ((buf = this.useOrCleanupBuffer(buf, size)) == null) {
            buf = this.makeLongBuffer(size);
        }
        return buf;
    }

    private <T extends Buffer> CUBuffer<T> useOrCleanupBuffer(CUBuffer<T> buf, int size) {
        if (buf == null) {
            return null;
        }
        if (buf.size() >= size) {
            return buf;
        }
        buf.cleanup();
        return null;
    }

    public <T extends Buffer> CUBuffer<T> makeOrExpandBuffer(CUBuffer<T> dest, T src) {
        if (dest == null) {
            return this.makeBuffer(src);
        }
        dest.expand(src);
        return dest;
    }

    public void waitForGpu() {
        JCudaDriver.cuStreamSynchronize((CUstream)this.stream);
    }

    public void cleanup() {
        if (this.stream != null) {
            this.byteBuffers.cleanup();
            this.intBuffers.cleanup();
            this.longBuffers.cleanup();
            this.doubleBuffers.cleanup();
            try {
                JCudaDriver.cuStreamDestroy((CUstream)this.stream);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
            this.stream = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.stream != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }
}

