/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import jcuda.driver.CUcontext;
import jcuda.driver.CUdevice;
import jcuda.driver.JCudaDriver;

public class Gpu {
    private CUdevice device;
    private String name;
    private int[] computeVersion;
    private int warpThreads;
    private int maxBlockThreads;
    private long totalMemory;
    private long freeMemory;

    public Gpu(CUdevice device) {
        this.device = device;
        byte[] bytes = new byte[1024];
        JCudaDriver.cuDeviceGetName((byte[])bytes, (int)bytes.length, (CUdevice)device);
        int len = 0;
        while (bytes[len++] != 0) {
        }
        this.name = new String(bytes).substring(0, len - 1);
        try {
            CUcontext cuCtx = new CUcontext();
            JCudaDriver.cuCtxCreate((CUcontext)cuCtx, (int)0, (CUdevice)device);
            long[][] longs = new long[2][1];
            JCudaDriver.cuMemGetInfo((long[])longs[0], (long[])longs[1]);
            this.freeMemory = longs[0][0];
            this.totalMemory = longs[1][0];
            JCudaDriver.cuCtxDestroy((CUcontext)cuCtx);
        }
        catch (Throwable t) {
            this.freeMemory = 0L;
            this.totalMemory = 0L;
        }
        this.computeVersion = new int[]{this.getAttribute(75), this.getAttribute(76)};
        this.warpThreads = this.getAttribute(10);
        this.maxBlockThreads = this.getAttribute(2);
    }

    public CUdevice getDevice() {
        return this.device;
    }

    public int getAttribute(int attr) {
        int[] ints = new int[1];
        JCudaDriver.cuDeviceGetAttribute((int[])ints, (int)attr, (CUdevice)this.device);
        return ints[0];
    }

    public String getName() {
        return this.name;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public int[] getComputeVersion() {
        return this.computeVersion;
    }

    public boolean isComputeVersionAtLeast(int major, int minor) {
        if (this.computeVersion[0] < major) {
            return false;
        }
        if (this.computeVersion[0] > major) {
            return true;
        }
        return this.computeVersion[1] >= minor;
    }

    public boolean supportsDoubles() {
        return this.isComputeVersionAtLeast(1, 3);
    }

    public boolean supportsDynamicParallelism() {
        return this.isComputeVersionAtLeast(3, 5);
    }

    public int getWarpThreads() {
        return this.warpThreads;
    }

    public int getMaxBlockThreads() {
        return this.maxBlockThreads;
    }

    public String toString() {
        return this.getName();
    }
}

