/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu;

import edu.duke.cs.osprey.gpu.Structs;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;

public class MemoryBuffer
implements AutoCloseable {
    private static final ValueLayout.OfInt hint = ValueLayout.JAVA_INT;
    private static final ValueLayout.OfLong hlong = ValueLayout.JAVA_LONG;
    private static final ValueLayout.OfFloat hfloat = ValueLayout.JAVA_FLOAT;
    private static final ValueLayout.OfDouble hdouble = ValueLayout.JAVA_DOUBLE;
    private static final ValueLayout.OfByte hbyte = ValueLayout.JAVA_BYTE;
    private static final long sizeInt = 4L;
    private static final long sizeLong = 8L;
    private static final long sizeFloat = 4L;
    private static final long sizeDouble = 8L;
    private final MemorySegment base;
    private final MemorySession sharedScope = MemorySession.openShared();
    private long pos = 0L;

    private MemoryBuffer(MemorySegment mem) {
        this.base = mem;
    }

    public MemoryBuffer(long size) {
        this.base = MemorySegment.allocateNative((long)size, (MemorySession)this.sharedScope);
    }

    public static MemoryBuffer ofByteBuffer(ByteBuffer buf) {
        return new MemoryBuffer(MemorySegment.ofBuffer(buf));
    }

    public MemoryBuffer sliceFrom(long offset) {
        return new MemoryBuffer(this.base.asSlice(offset));
    }

    public ByteBuffer asByteBuffer() {
        return this.base.asByteBuffer();
    }

    public long getPos() {
        return this.pos;
    }

    public void int32(long pos, int value2) {
        this.base.set(hint, pos, value2);
    }

    public void int32(int value2) {
        this.int32(this.pos, value2);
        this.pos += 4L;
    }

    public long int32skip() {
        return this.skip(4L);
    }

    public void uint32(long pos, long value2) {
        this.base.set(hint, pos, (int)(value2 & 0xFFFFFFFFL));
    }

    public void uint32(long value2) {
        this.uint32(this.pos, value2);
        this.pos += 4L;
    }

    public void uint32(long pos, int value2) {
        this.base.set(hint, pos, value2);
    }

    public void uint32(int value2) {
        this.uint32(this.pos, value2);
        this.pos += 4L;
    }

    public long uint32skip() {
        return this.skip(4L);
    }

    public void int64(long pos, long value2) {
        this.base.set(hlong, pos, value2);
    }

    public void int64(long value2) {
        this.int64(this.pos, value2);
        this.pos += 8L;
    }

    public long int64skip() {
        return this.skip(8L);
    }

    public void float32(long pos, float value2) {
        this.base.set(hfloat, pos, value2);
    }

    public void float32(float value2) {
        this.float32(this.pos, value2);
        this.pos += 4L;
    }

    public long float32skip() {
        return this.skip(4L);
    }

    public void float64(long pos, double value2) {
        this.base.set(hdouble, pos, value2);
    }

    public void float64(double value2) {
        this.float64(this.pos, value2);
        this.pos += 8L;
    }

    public long float64skip() {
        return this.skip(8L);
    }

    public long skip(long bytes) {
        long pos = this.pos;
        this.pos += bytes;
        return pos;
    }

    public boolean isAligned(long alignment) {
        return this.pos % alignment == 0L;
    }

    public void skipToAlignment(long alignment) {
        this.pos = MemoryBuffer.padToAlignment(this.pos, alignment);
    }

    public static long padToAlignment(long size, long alignment) {
        while (size % alignment != 0L) {
            ++size;
        }
        return size;
    }

    public MemoryBuffer place(Structs.Struct struct) {
        MemorySegment slice = this.base.asSlice(this.pos);
        this.skip(struct.bytes());
        return new MemoryBuffer(slice);
    }

    public MemoryBuffer place(Structs.Array array, long size) {
        MemorySegment slice = this.base.asSlice(this.pos);
        this.skip(array.bytes(size));
        return new MemoryBuffer(slice);
    }

    public MemoryBuffer place(Structs.Array array, long size, long align2) {
        MemorySegment slice = this.base.asSlice(this.pos);
        this.skip(array.bytes(size));
        this.skipToAlignment(align2);
        return new MemoryBuffer(slice);
    }

    public void putInt(Structs.Field f, int value2) {
        this.base.set(hint, f.offset, value2);
    }

    public void putInt(Structs.Array f, long i, int value2) {
        this.base.set(hint, i * f.itemBytes, value2);
    }

    public int getInt(Structs.Field f) {
        return this.base.get(hint, f.offset);
    }

    public int getInt(Structs.Array f, long i) {
        return this.base.get(hint, i * f.itemBytes);
    }

    public void putLong(Structs.Field f, long value2) {
        this.base.set(hlong, f.offset, value2);
    }

    public void putLong(Structs.Array f, long i, long value2) {
        this.base.set(hlong, i * f.itemBytes, value2);
    }

    public long getLong(long offset) {
        return this.base.get(hlong, offset);
    }

    public long getLong(Structs.Field f) {
        return this.base.get(hlong, f.offset);
    }

    public long getLong(Structs.Array f, long i) {
        return this.base.get(hlong, i * f.itemBytes);
    }

    public void putFloat(Structs.Field f, float value2) {
        this.base.set(hfloat, f.offset, value2);
    }

    public void putFloat(Structs.Array f, long i, float value2) {
        this.base.set(hfloat, i * f.itemBytes, value2);
    }

    public float getFloat(Structs.Field f) {
        return this.base.get(hfloat, f.offset);
    }

    public float getFloat(Structs.Array f, long i) {
        return this.base.get(hfloat, i * f.itemBytes);
    }

    public void putDouble(Structs.Field f, double value2) {
        this.base.set(hdouble, f.offset, value2);
    }

    public void putDouble(Structs.Array f, long i, double value2) {
        this.base.set(hdouble, i * f.itemBytes, value2);
    }

    public double getDouble(Structs.Field f) {
        return this.base.get(hdouble, f.offset);
    }

    public double getDouble(Structs.Array f, long i) {
        return this.base.get(hdouble, i * f.itemBytes);
    }

    public void putBoolean(Structs.Field f, boolean value2) {
        this.base.set(hbyte, f.offset, value2 ? (byte)1 : 0);
    }

    public void putBoolean(Structs.Array f, long i, boolean value2) {
        this.base.set(hbyte, i * f.itemBytes, value2 ? (byte)1 : 0);
    }

    public boolean getBoolean(Structs.Field f) {
        return this.base.get(hbyte, f.offset) != 0;
    }

    public boolean getBoolean(Structs.Array f, long i) {
        return this.base.get(hbyte, i * f.itemBytes) != 0;
    }

    public void putChar(Structs.Field f, char value2) {
        this.base.set(hbyte, f.offset, (byte)value2);
    }

    public void putChar(Structs.Array f, long i, char value2) {
        this.base.set(hbyte, i * f.itemBytes, (byte)value2);
    }

    public char getChar(Structs.Field f) {
        return (char)this.base.get(hbyte, f.offset);
    }

    public char getChar(Structs.Array f, long i) {
        return (char)this.base.get(hbyte, i * f.itemBytes);
    }

    public void putByte(Structs.Field f, byte value2) {
        this.base.set(hbyte, f.offset, value2);
    }

    public void putByte(Structs.Array f, long i, byte value2) {
        this.base.set(hbyte, i * f.itemBytes, value2);
    }

    public byte getByte(Structs.Field f) {
        return this.base.get(hbyte, f.offset);
    }

    public byte getByte(Structs.Array f, long i) {
        return this.base.get(hbyte, i * f.itemBytes);
    }

    @Override
    public void close() throws IllegalStateException {
        this.sharedScope.close();
    }
}

