/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.Queue;
import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.gmec.ConfPrinter;
import edu.duke.cs.osprey.gmec.ConsoleConfPrinter;
import edu.duke.cs.osprey.gmec.EnergyRange;
import edu.duke.cs.osprey.gmec.GMECFinder;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.Progress;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public class SimpleGMECFinder {
    public static final String ConfDBTableName = "GMEC";
    public ConfSearch search;
    public final ConfEnergyCalculator confEcalc;
    public final GMECFinder.ConfPruner pruner;
    public final ConfPrinter logPrinter;
    public final ConfPrinter consolePrinter;
    public final boolean printIntermediateConfsToConsole;
    public final boolean printToConsole;
    private final Queue.Factory.FIFO<ConfSearch.ScoredConf> scoredFifoFactory;
    private final Queue.Factory.FIFO<ConfSearch.EnergiedConf> energiedFifoFactory;
    private final Queue.Factory<ConfSearch.EnergiedConf> energiedPriorityFactory;
    private final File confDBFile;

    protected SimpleGMECFinder(ConfSearch search2, ConfEnergyCalculator confEcalc, GMECFinder.ConfPruner pruner, ConfPrinter logPrinter, ConfPrinter consolePrinter, boolean printIntermediateConfsToConsole, boolean printToConsole, File confDBFile) {
        this.search = search2;
        this.confEcalc = confEcalc;
        this.pruner = pruner;
        this.logPrinter = logPrinter;
        this.consolePrinter = consolePrinter;
        this.printIntermediateConfsToConsole = printIntermediateConfsToConsole;
        this.printToConsole = printToConsole;
        this.confDBFile = confDBFile;
        this.scoredFifoFactory = new Queue.FIFOFactory<ConfSearch.ScoredConf>();
        this.energiedFifoFactory = new Queue.FIFOFactory<ConfSearch.EnergiedConf>();
        this.energiedPriorityFactory = new Queue.PriorityFactory<ConfSearch.EnergiedConf>((a, b) -> Double.compare(a.getEnergy(), b.getEnergy()));
    }

    private void log(String msg, Object ... args) {
        if (this.printToConsole) {
            Log.log(msg, args);
        }
    }

    public ConfSearch.EnergiedConf find() {
        return (ConfSearch.EnergiedConf)this.find(0.0).poll();
    }

    public Queue.FIFO<ConfSearch.EnergiedConf> find(double energyWindowSize) {
        this.log("Searching for min score conformation...", new Object[0]);
        Stopwatch minScoreStopwatch = new Stopwatch().start();
        try {
            this.log("\t(among %s possibilities)", Log.formatBig(this.search.getNumConformations()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ConfSearch.ScoredConf minScoreConf = this.search.nextConf();
        if (minScoreConf == null) {
            this.log("No conformations found with finite energies (possibly all confs have been pruned)", new Object[0]);
            return Queue.FIFOFactory.of(new ConfSearch.EnergiedConf[0]);
        }
        this.log("Found min score conformation in %s", minScoreStopwatch.getTime(1));
        try (ConfDB confdb = ConfDB.makeIfNeeded(this.confEcalc.confSpace, this.confDBFile);){
            ConfDB.ConfTable confTable = null;
            if (confdb != null) {
                ConfDB confDB = confdb;
                Objects.requireNonNull(confDB);
                confTable = new ConfDB.ConfTable(confDB, ConfDBTableName);
            }
            this.log("Computing energy of min score conf...", new Object[0]);
            ConfSearch.EnergiedConf eMinScoreConf = this.confEcalc.calcEnergy(minScoreConf, confTable);
            this.logPrinter.print(eMinScoreConf, this.confEcalc.confSpace);
            ConfSearch.MultiSplitter splitter = new ConfSearch.MultiSplitter(this.search);
            ConfSearch.MultiSplitter.Stream unpeekedConfs = splitter.makeStream();
            ConfSearch.MultiSplitter.Stream peekedConfs = splitter.makeStream();
            ConfSearch.ScoredConf peekedConf = peekedConfs.nextConf();
            peekedConfs.close();
            if (peekedConf == null) {
                this.log("Found GMEC! (it's actually the only conformation allowed by the conf space!)", new Object[0]);
                if (this.printToConsole) {
                    this.consolePrinter.print(eMinScoreConf, this.confEcalc.confSpace);
                }
                Queue.FIFO<ConfSearch.EnergiedConf> fIFO = Queue.FIFOFactory.of(eMinScoreConf);
                return fIFO;
            }
            if (peekedConf.getScore() > eMinScoreConf.getEnergy() && energyWindowSize <= 0.0) {
                this.log("Found GMEC! (it's actually the min score conformation too!)", new Object[0]);
                if (this.printToConsole) {
                    this.consolePrinter.print(eMinScoreConf, this.confEcalc.confSpace);
                }
                Queue.FIFO<ConfSearch.EnergiedConf> fIFO = Queue.FIFOFactory.of(eMinScoreConf);
                return fIFO;
            }
            if (this.printToConsole) {
                this.consolePrinter.print(eMinScoreConf, this.confEcalc.confSpace);
            }
            EnergyRange erange = new EnergyRange(eMinScoreConf.getEnergy(), energyWindowSize);
            Queue<ConfSearch.EnergiedConf> econfs = this.energiedPriorityFactory.make();
            econfs.push(eMinScoreConf);
            this.checkMoreConfs(unpeekedConfs, erange, econfs, confTable);
            this.log("checked %d conformations", econfs.size());
            ConfSearch.EnergiedConf gmec = econfs.peek();
            this.log("\nFound GMEC!", new Object[0]);
            if (this.printToConsole) {
                this.consolePrinter.print(gmec, this.confEcalc.confSpace);
            }
            Queue.FIFO<ConfSearch.EnergiedConf> econfsInRange = econfs.filterTo(this.energiedFifoFactory.make(), conf -> erange.contains(conf.getEnergy()));
            this.log("Found %d total conformations in energy window", econfsInRange.size());
            Queue.FIFO<ConfSearch.EnergiedConf> fIFO = econfsInRange;
            return fIFO;
        }
    }

    private void checkMoreConfs(ConfSearch search2, EnergyRange erange, Queue<ConfSearch.EnergiedConf> econfs, ConfDB.ConfTable confTable) {
        ConfSearch.ScoredConf conf;
        this.setErangeProgress(search2, erange);
        this.log("Enumerating other low-scoring conformations...", new Object[0]);
        Queue.FIFO<ConfSearch.ScoredConf> otherLowEnergyConfs = this.scoredFifoFactory.make();
        Stopwatch timingStopwatch = new Stopwatch().start();
        Stopwatch speculativeMinimizationStopwatch = new Stopwatch().start();
        while ((conf = search2.nextConf()) != null && !(conf.getScore() > erange.getMax())) {
            otherLowEnergyConfs.push(conf);
            if (conf.getScore() == erange.getMax()) break;
            if (!(speculativeMinimizationStopwatch.getTimeS() >= 10.0)) continue;
            speculativeMinimizationStopwatch.stop();
            ConfSearch.EnergiedConf econf = this.confEcalc.calcEnergy((ConfSearch.ScoredConf)otherLowEnergyConfs.poll(), confTable);
            this.handleEnergiedConf(econf, econfs, erange);
            boolean changed = erange.updateMin(econf.getEnergy());
            if (changed) {
                this.log("Lower conformation energy updated energy window! remaining: %14.8f", erange.getMax() - conf.getScore());
                this.setErangeProgress(search2, erange);
            }
            speculativeMinimizationStopwatch.start();
        }
        this.log("\tFound %d more in %s", otherLowEnergyConfs.size(), timingStopwatch.getTime(1));
        if (!otherLowEnergyConfs.isEmpty()) {
            this.minimizeLowEnergyConfs(otherLowEnergyConfs, erange, econfs, confTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void minimizeLowEnergyConfs(Queue.FIFO<ConfSearch.ScoredConf> lowEnergyConfs, EnergyRange erange, Queue<ConfSearch.EnergiedConf> econfs, ConfDB.ConfTable confTable) {
        Progress progress2 = this.printToConsole ? new Progress(lowEnergyConfs.size()) : null;
        TaskExecutor.TaskListener<ConfSearch.EnergiedConf> ecalcListener = econf -> {
            this.handleEnergiedConf((ConfSearch.EnergiedConf)econf, econfs, erange);
            boolean changed = erange.updateMin(econf.getEnergy());
            if (changed) {
                this.log("\nNew lowest energy: %.6f", erange.getMin());
                Queue.FIFO fIFO = lowEnergyConfs;
                synchronized (fIFO) {
                    long numLowEnergyConfsBefore = lowEnergyConfs.size();
                    lowEnergyConfs.filter(conf -> erange.containsOrBelow(conf.getScore()));
                    if (lowEnergyConfs.size() < numLowEnergyConfsBefore) {
                        this.log("\tReduced to %d low-energy conformations", lowEnergyConfs.size());
                    }
                    if (progress2 != null) {
                        progress2.setTotalWork(lowEnergyConfs.size());
                    }
                }
            }
            if (progress2 != null) {
                progress2.incrementProgress();
            }
        };
        this.log("\nComputing energies for %d conformations...", lowEnergyConfs.size());
        while (true) {
            ConfSearch.ScoredConf conf;
            Queue.FIFO<ConfSearch.ScoredConf> fIFO = lowEnergyConfs;
            synchronized (fIFO) {
                if (lowEnergyConfs.isEmpty()) {
                    break;
                }
                conf = (ConfSearch.ScoredConf)lowEnergyConfs.poll();
            }
            this.confEcalc.calcEnergyAsync(conf, confTable, ecalcListener);
        }
        this.confEcalc.tasks.waitForFinish();
    }

    private void setErangeProgress(ConfSearch confSearch, EnergyRange erange) {
        if (confSearch instanceof ConfAStarTree) {
            ConfAStarTree tree = (ConfAStarTree)confSearch;
            if (tree.getProgress() != null) {
                tree.getProgress().setGoalScore(erange.getMax());
            }
        } else if (confSearch instanceof ConfSearch.MultiSplitter.Stream) {
            this.setErangeProgress(((ConfSearch.MultiSplitter.Stream)confSearch).getSource(), erange);
        }
    }

    private void handleEnergiedConf(ConfSearch.EnergiedConf econf, Queue<ConfSearch.EnergiedConf> econfs, EnergyRange erange) {
        if (econf.getScore() > econf.getEnergy() + 0.1) {
            this.log("WARNING: Conformation score (%f) is not a lower bound on the energy (%f).\n\tThis is evidence that OSPREY is unable to guarantee finding exactly the GMEC for this design, but we'll probably get it anyway, or at least get really close.\n\tAssignments: %s", econf.getScore(), econf.getEnergy(), Arrays.toString(econf.getAssignments()));
        }
        econfs.push(econf);
        this.logPrinter.print(econf, this.confEcalc.confSpace);
        if (this.printToConsole && this.printIntermediateConfsToConsole) {
            this.log("", new Object[0]);
            this.consolePrinter.print(econf, this.confEcalc.confSpace, erange);
        }
    }

    public static class Builder {
        protected ConfSearch search;
        protected ConfEnergyCalculator confEcalc;
        protected GMECFinder.ConfPruner pruner;
        protected ConfPrinter logPrinter;
        protected ConfPrinter consolePrinter;
        protected boolean printIntermediateConfsToConsole = false;
        protected boolean printToConsole = true;
        protected File confDB = null;

        public Builder(ConfSearch search2, ConfEnergyCalculator confEcalc) {
            this.search = search2;
            this.confEcalc = confEcalc;
            this.pruner = null;
            this.logPrinter = new ConfPrinter.Nop();
            this.consolePrinter = new ConsoleConfPrinter();
        }

        public Builder setLogPrinter(ConfPrinter val) {
            this.logPrinter = val;
            return this;
        }

        public Builder setConsolePrinter(ConfPrinter val) {
            this.consolePrinter = val;
            return this;
        }

        public Builder setPrintIntermediateConfsToConsole(boolean val) {
            this.printIntermediateConfsToConsole = val;
            return this;
        }

        public Builder setPrintToConsole(boolean val) {
            this.printToConsole = val;
            return this;
        }

        public Builder setConfDB(File val) {
            this.confDB = val;
            return this;
        }

        public SimpleGMECFinder build() {
            return new SimpleGMECFinder(this.search, this.confEcalc, this.pruner, this.logPrinter, this.consolePrinter, this.printIntermediateConfsToConsole, this.printToConsole, this.confDB);
        }
    }
}

