/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gmec;

import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.gmec.GMECFinder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class SeqGMECFinder {
    ConfigFileParser cfp;
    File mutFile;

    public SeqGMECFinder(ConfigFileParser cfp) {
        this.cfp = cfp;
        this.mutFile = cfp.params.getFile("MutFile");
    }

    public void calcAllSeqGMECs() {
        try {
            FileInputStream is = new FileInputStream(this.mutFile);
            BufferedReader bufread = new BufferedReader(new InputStreamReader(is));
            int seqNum = 0;
            String curLine = bufread.readLine();
            while (curLine != null) {
                StringTokenizer st = new StringTokenizer(curLine);
                int numPos = st.countTokens();
                String[] seq = new String[numPos];
                for (int pos = 0; pos < numPos; ++pos) {
                    seq[pos] = st.nextToken().substring(0, 3);
                }
                this.calcSeqGMEC(seq, seqNum);
                ++seqNum;
                curLine = bufread.readLine();
            }
            bufread.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private double calcSeqGMEC(String[] AATypes, int seqNum) {
        System.out.println();
        System.out.print("CALCULATING GMEC FOR SEQUENCE " + seqNum + ":");
        for (String aaType : AATypes) {
            System.out.print(" " + aaType);
        }
        System.out.println();
        System.out.println();
        ConfigFileParser cfp = new ConfigFileParser(this.cfp);
        cfp.loadData();
        if (cfp.getFlexRes().size() != AATypes.length) {
            throw new RuntimeException("ERROR: Wrong number of residues in sequence, " + AATypes.length + " instead of " + cfp.getFlexRes().size());
        }
        String panSeqRunName = cfp.params.getValue("RUNNAME");
        cfp.params.setValue("RUNNAME", panSeqRunName + "_SEQ" + seqNum);
        cfp.params.setValue("ADDWT", "false");
        int posCount = 0;
        for (int str = 0; str < 10; ++str) {
            ArrayList<String> resAllowedRecords = cfp.params.searchParams("RESALLOWED" + str);
            int numRecordsInStrand = resAllowedRecords.size();
            for (int recNum = 0; recNum < numRecordsInStrand; ++recNum) {
                String param = "RESALLOWED" + str + "_" + recNum;
                cfp.params.setValue(param, AATypes[posCount]);
                ++posCount;
            }
        }
        GMECFinder gf = new GMECFinder();
        gf.init(cfp);
        double E = gf.calcGMEC().get(0).getEnergy();
        System.out.print("DONE CALCULATING GMEC FOR SEQUENCE " + seqNum);
        return E;
    }
}

