/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ewakstar;

import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ewakstar.EWAKStarScore;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public interface EWAKStarScoreWriter {
    public void writeHeader();

    public void writeScore(ScoreInfo var1);

    public static interface Formatter {
        default public String header() {
            return null;
        }

        public String format(ScoreInfo var1);

        public static class Log
        implements Formatter {
            private final long startNs = System.nanoTime();

            @Override
            public String header() {
                return String.join((CharSequence)"\t", "Seq ID", "Sequence", "K* Score (Log10)", "K* Lower Bound", "K* Upper Bound", "Total # Confs.", "Complex Partition Function", "Complex Epsilon", "Complex # Confs.", "Protein Partition Function", "Protein Epsilon", "Protein # Confs.", "Ligand Partition Function", "Ligand Epsilon", "Ligand # Confs.", "Time (sec)");
            }

            @Override
            public String format(ScoreInfo info2) {
                return String.join((CharSequence)"\t", Integer.toString(info2.sequenceNumber), info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize()), info2.kstarScore.scoreLog10String(), info2.kstarScore.lowerBoundLog10String(), info2.kstarScore.upperBoundLog10String(), Integer.toString(info2.kstarScore.protein.numConfs + info2.kstarScore.ligand.numConfs + info2.kstarScore.complex.numConfs), String.format("%e", info2.kstarScore.complex.values.qstar.doubleValue()), Double.toString(info2.kstarScore.complex.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.complex.numConfs), String.format("%e", info2.kstarScore.protein.values.qstar.doubleValue()), Double.toString(info2.kstarScore.protein.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.protein.numConfs), String.format("%e", info2.kstarScore.ligand.values.qstar.doubleValue()), Double.toString(info2.kstarScore.ligand.values.getEffectiveEpsilon()), Integer.toString(info2.kstarScore.ligand.numConfs), Long.toString((info2.timeNs - this.startNs) / 1000000000L));
            }
        }

        public static class SequenceKStarPfuncs
        implements Formatter {
            @Override
            public String format(ScoreInfo info2) {
                return String.format("sequence %4d   %s   K*(log10): %-34s   protein: %-18s, numConfs: %d, epsilon: %01.3f,   ligand: %-18s, numConfs: %d, epsilon: %01.3f,   complex: %-18s, numConfs: %d, epsilon: %01.3f,", info2.sequenceNumber + 1, info2.sequence.toString(Sequence.Renderer.AssignmentMutations, info2.sequence.calcCellSize()), info2.kstarScore.toString(), info2.kstarScore.protein.toString(), info2.kstarScore.protein.numConfs, info2.kstarScore.protein.values.getEffectiveEpsilon(), info2.kstarScore.ligand.toString(), info2.kstarScore.ligand.numConfs, info2.kstarScore.ligand.values.getEffectiveEpsilon(), info2.kstarScore.complex.toString(), info2.kstarScore.complex.numConfs, info2.kstarScore.complex.values.getEffectiveEpsilon());
            }
        }
    }

    public static class ToConsole
    extends Formatted {
        public ToConsole(Formatter formatter) {
            super(formatter);
        }

        @Override
        protected void write(String line) {
            System.out.println(line);
        }
    }

    public static class ToFile
    extends Formatted {
        public final File file;
        private boolean started = false;

        public ToFile(File file, Formatter formatter) {
            super(formatter);
            this.file = file;
        }

        @Override
        protected void write(String line) {
            boolean append = true;
            if (!this.started) {
                this.started = true;
                append = false;
            }
            try (FileWriter out = new FileWriter(this.file, append);){
                out.write(line);
                out.write("\n");
            }
            catch (IOException ex) {
                System.err.println("writing to file failed: " + String.valueOf(this.file));
                ex.printStackTrace(System.err);
                System.err.println(line);
            }
        }
    }

    public static abstract class Formatted
    implements EWAKStarScoreWriter {
        public final Formatter formatter;

        protected Formatted(Formatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writeHeader() {
            String header = this.formatter.header();
            if (header != null) {
                this.write(header);
            }
        }

        @Override
        public void writeScore(ScoreInfo info2) {
            this.write(this.formatter.format(info2));
        }

        protected abstract void write(String var1);
    }

    public static class Nop
    implements EWAKStarScoreWriter {
        @Override
        public void writeHeader() {
        }

        @Override
        public void writeScore(ScoreInfo info2) {
        }
    }

    public static class Writers
    extends ArrayList<EWAKStarScoreWriter> {
        private static final long serialVersionUID = 1239885431627352405L;

        public void writeHeader() {
            for (EWAKStarScoreWriter writer : this) {
                writer.writeHeader();
            }
        }

        public void writeScore(ScoreInfo info2) {
            for (EWAKStarScoreWriter writer : this) {
                writer.writeScore(info2);
            }
        }
    }

    public static class ScoreInfo {
        public final int sequenceNumber;
        public final int numSequences;
        public final Sequence sequence;
        public final SimpleConfSpace complexConfSpace;
        public final EWAKStarScore kstarScore;
        public final long timeNs;

        public ScoreInfo(int sequenceNumber, int numSequences, Sequence sequence, SimpleConfSpace complexConfSpace, EWAKStarScore kstarScore) {
            this.sequenceNumber = sequenceNumber;
            this.numSequences = numSequences;
            this.sequence = sequence;
            this.complexConfSpace = complexConfSpace;
            this.kstarScore = kstarScore;
            this.timeNs = System.nanoTime();
        }
    }
}

