/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield.amber;

import com.beust.jcommander.internal.Lists;
import edu.duke.cs.osprey.energy.forcefield.amber.AtomSymbolAndMass;
import edu.duke.cs.osprey.energy.forcefield.amber.BondAngleParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.BondLengthParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.DihederalParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.EquivalencingAtom;
import edu.duke.cs.osprey.energy.forcefield.amber.HBond10_12PotentialParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.HasAtoms;
import edu.duke.cs.osprey.energy.forcefield.amber.ImproperDihederalParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.Six12PotentialCoefficient;
import edu.duke.cs.osprey.energy.forcefield.amber.SlaterKirkwoodParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.VanDerWaalsRadius;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;

public class ForcefieldFileParser {
    private final InputStream parmFile;
    public static final AtomSymbolAndMass WildcardAtom = new AtomSymbolAndMass("X", 0.0f);
    public static final AtomSymbolAndMass UnmatchedAtom = new AtomSymbolAndMass("?", 0.0f);
    private final Path frcmod;
    private String title;
    private final List<AtomSymbolAndMass> atomSymbolsAndMasses = Lists.newArrayList();
    private final List<AtomSymbolAndMass> hydrophilicAtoms = Lists.newArrayList();
    private final List<BondLengthParameter> bondLengthParameters = Lists.newArrayList();
    private final List<BondAngleParameter> bondAngleParameters = Lists.newArrayList();
    private final List<DihederalParameter> dihederalParameters = Lists.newArrayList();
    private final List<ImproperDihederalParameter> improperDihederalParameters = Lists.newArrayList();
    private final List<HBond10_12PotentialParameter> hbond10_12PotentialParameters = Lists.newArrayList();
    private final List<EquivalencingAtom> equivalencingAtomsForNonBonded6_12PotentialParameters = Lists.newArrayList();
    private final List<SlaterKirkwoodParameter> slaterKirkwoodParameters = Lists.newArrayList();
    private final List<VanDerWaalsRadius> vanDerWaalsRadii = Lists.newArrayList();
    private final List<Six12PotentialCoefficient> six12PotentialCoefficients = Lists.newArrayList();

    public ForcefieldFileParser(InputStream parmFile) {
        this(parmFile, null);
    }

    public ForcefieldFileParser(InputStream parmFile, Path frcmod) {
        this.parmFile = parmFile;
        this.frcmod = frcmod;
    }

    public List<AtomSymbolAndMass> atomSymbolsAndMasses() {
        return new ArrayList<AtomSymbolAndMass>(this.atomSymbolsAndMasses);
    }

    private static <T extends HasAtoms> List<T> filterOutUnmatchedAtom(List<T> lst) {
        return ((StreamEx)StreamEx.of(lst).filter(x -> !x.atoms().contains(UnmatchedAtom))).toList();
    }

    public List<AtomSymbolAndMass> hydrophilicAtoms() {
        return ((StreamEx)StreamEx.of(this.hydrophilicAtoms).filter(x -> x != UnmatchedAtom)).toList();
    }

    public List<BondLengthParameter> bondLengthParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.bondLengthParameters);
    }

    public List<BondAngleParameter> bondAngleParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.bondAngleParameters);
    }

    public List<DihederalParameter> dihederalParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.dihederalParameters);
    }

    public List<ImproperDihederalParameter> improperDihederalParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.improperDihederalParameters);
    }

    public List<HBond10_12PotentialParameter> hbond10_12PotentialParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.hbond10_12PotentialParameters);
    }

    public List<EquivalencingAtom> equivalencingAtomsForNonBonded6_12PotentialParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.equivalencingAtomsForNonBonded6_12PotentialParameters);
    }

    public List<SlaterKirkwoodParameter> slaterKirkwoodParameters() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.slaterKirkwoodParameters);
    }

    public List<VanDerWaalsRadius> vanDerWaalsRadii() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.vanDerWaalsRadii);
    }

    public List<Six12PotentialCoefficient> six12PotentialCoefficients() {
        return ForcefieldFileParser.filterOutUnmatchedAtom(this.six12PotentialCoefficients);
    }

    public void read() throws IOException {
        String six12ParameterType;
        List<String> parmLines = new BufferedReader(new InputStreamReader(this.parmFile, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
        this.title = (String)parmLines.get(0);
        parmLines = parmLines.subList(1, parmLines.size());
        TwoTuple<List<String>> secondBlock = ForcefieldFileParser.takeUntilBlankLine(parmLines);
        List atomSymbolsAndMassesLines = (List)secondBlock.head;
        Optional<List<String>> frcmodAtomSymbols = this.getFromFrcmod("MASS");
        this.atomSymbolsAndMasses.addAll(this.concatWithReplacement(this.parseAtomSymbolsAndMasses(atomSymbolsAndMassesLines), this.parseAtomSymbolsAndMasses(frcmodAtomSymbols.orElse(List.of())), (a, b) -> a.KNDSYM().equals(b.KNDSYM())));
        List thirdBlock = (List)secondBlock.tail;
        String hydrophilicAtomLines = (String)thirdBlock.get(0);
        this.hydrophilicAtoms.addAll(this.parseHydrophilicAtoms(hydrophilicAtomLines));
        TwoTuple<List<String>> fourthBlock = ForcefieldFileParser.takeUntilBlankLine(((List)secondBlock.tail).subList(1, ((List)secondBlock.tail).size()));
        List bondLengthLines = (List)fourthBlock.head;
        Optional<List<String>> frcmodBondLengthLines = this.getFromFrcmod("BOND");
        this.bondLengthParameters.addAll(this.concatWithReplacement(this.parseBondLengthParameters(bondLengthLines), this.parseBondLengthParameters(frcmodBondLengthLines.orElse(List.of())), (a, b) -> this.pairwiseEquals(List.of(a.IBT(), a.JBT()), List.of(b.IBT(), b.JBT()))));
        TwoTuple<List<String>> fifthBlock = ForcefieldFileParser.takeUntilBlankLine((List)fourthBlock.tail);
        List bondAngleLines = (List)fifthBlock.head;
        Optional<List<String>> frcmodBondAngleLines = this.getFromFrcmod("ANGL");
        this.bondAngleParameters.addAll(this.concatWithReplacement(this.parseBondAngleParameters(bondAngleLines), this.parseBondAngleParameters(frcmodBondAngleLines.orElse(List.of())), (a, b) -> this.pairwiseEquals(List.of(a.ITT(), a.JTT(), a.KTT()), List.of(b.ITT(), b.JTT(), b.KTT()))));
        TwoTuple<List<String>> sixthBlock = ForcefieldFileParser.takeUntilBlankLine((List)fifthBlock.tail);
        List dihedralLines = (List)sixthBlock.head;
        Optional<List<String>> frcmodDihedralLines = this.getFromFrcmod("DIHE");
        this.dihederalParameters.addAll(this.concatWithReplacement(this.parseDihedralParameters(dihedralLines), this.parseDihedralParameters(frcmodDihedralLines.orElse(List.of())), (a, b) -> this.pairwiseEquals(List.of(a.IPT(), a.JPT(), a.KPT(), a.LPT()), List.of(b.IPT(), b.JPT(), b.KPT(), b.LPT()))));
        TwoTuple<List<String>> seventhBlock = ForcefieldFileParser.takeUntilBlankLine((List)sixthBlock.tail);
        List improperDihedralLines = (List)seventhBlock.head;
        Optional<List<String>> frcmodImproperDihedralLines = this.getFromFrcmod("IMPR");
        this.improperDihederalParameters.addAll(this.concatWithReplacement(this.parseImproperDihedralParameters(improperDihedralLines), this.parseImproperDihedralParameters(frcmodImproperDihedralLines.orElse(List.of())), (a, b) -> this.pairwiseEquals(List.of(a.IPT(), a.JPT(), a.KPT(), a.LPT()), List.of(b.IPT(), b.JPT(), b.KPT(), b.LPT()))));
        TwoTuple<List<String>> eighthBlock = ForcefieldFileParser.takeUntilBlankLine((List)seventhBlock.tail);
        List hBond10_12PotentialLines = (List)eighthBlock.head;
        Optional<List<String>> frcmodHBond10_12Lines = this.getFromFrcmod("HBON");
        this.hbond10_12PotentialParameters.addAll(this.concatWithReplacement(this.parseHBond10_12PotentialParameters(hBond10_12PotentialLines), this.parseHBond10_12PotentialParameters(frcmodHBond10_12Lines.orElse(List.of())), (a, b) -> this.pairwiseEquals(List.of(a.KT1(), a.KT2()), List.of(b.KT1(), b.KT2()))));
        TwoTuple<List<String>> ninthBlock = ForcefieldFileParser.takeUntilBlankLine((List)eighthBlock.tail);
        List equivalencingAtomsForNonBonded6_12PotentialParametersLines = (List)ninthBlock.head;
        this.equivalencingAtomsForNonBonded6_12PotentialParameters.addAll(this.parseEquivalencingAtomfForNonBonded6_12PotentialParameters(equivalencingAtomsForNonBonded6_12PotentialParametersLines));
        List tenthBlock = (List)ninthBlock.tail;
        String labelKindLine = (String)tenthBlock.get(0);
        TwoTuple<List<String>> six12ParameterLines = ForcefieldFileParser.takeUntilBlankLine(tenthBlock.subList(1, tenthBlock.size()));
        List<String> frcmod6_12ParameterLines = this.getFromFrcmod("NONB").orElse(List.of());
        switch (six12ParameterType = labelKindLine.substring(10, 12)) {
            case "SK": {
                this.slaterKirkwoodParameters.addAll(this.concatWithReplacement(this.parseSlaterKirkwoodParameters((List)six12ParameterLines.head), this.parseSlaterKirkwoodParameters(frcmod6_12ParameterLines), (a, b) -> a.LTYNB().equals(b.LTYNB())));
                break;
            }
            case "RE": {
                this.vanDerWaalsRadii.addAll(this.concatWithReplacement(this.parseVanDerWaalsRadiiParameters((List)six12ParameterLines.head), this.parseVanDerWaalsRadiiParameters(frcmod6_12ParameterLines), (a, b) -> a.LTYNB().equals(b.LTYNB())));
                break;
            }
            case "AC": {
                this.six12PotentialCoefficients.addAll(this.concatWithReplacement(this.parse6_12PotentialCoefficientParameters((List)six12ParameterLines.head), this.parse6_12PotentialCoefficientParameters(frcmod6_12ParameterLines), (a, b) -> a.LTYNB().equals(b.LTYNB())));
                break;
            }
            default: {
                throw new RuntimeException(String.format("The 6-12 potential parameter kind %s is not known", six12ParameterType));
            }
        }
    }

    private static String eolSubstring(String orig, int start, int end) {
        int len = Math.min(orig.length(), end);
        return orig.substring(start, len);
    }

    private Optional<List<String>> getFromFrcmod(String kind) throws IOException {
        if (this.frcmod == null) {
            return Optional.empty();
        }
        List frcmodLines = ((StreamEx)StreamEx.of(Files.readAllLines(this.frcmod)).skip(1L)).toList();
        if (frcmodLines.isEmpty()) {
            return Optional.empty();
        }
        return this.findBlock(ForcefieldFileParser.takeUntilBlankLine(frcmodLines), kind);
    }

    private Optional<List<String>> findBlock(TwoTuple<List<String>> block, String targetKind) {
        String foundKind = ((String)((List)block.head).get(0)).substring(0, 4);
        if (foundKind.equals(targetKind)) {
            return Optional.of(((List)block.head).subList(1, ((List)block.head).size()));
        }
        if (((List)block.tail).stream().anyMatch(l -> !l.isBlank())) {
            block = ForcefieldFileParser.takeUntilBlankLine((List)block.tail);
            return this.findBlock(block, targetKind);
        }
        return Optional.empty();
    }

    private <T> List<T> concatWithReplacement(List<T> head, List<T> tail, AreSame<T> determiner) {
        return ((StreamEx)StreamEx.of(head.stream().filter(headEl -> tail.stream().noneMatch(tailEl -> determiner.check(headEl, tailEl)))).append(tail.stream())).toList();
    }

    private <T> boolean pairwiseEquals(List<T> a, List<T> b) {
        return StreamEx.zip(a, b, Object::equals).allMatch(j -> j);
    }

    private Six12PotentialCoefficient parse6_12PotentialCoefficientParameter(String line) {
        return new Six12PotentialCoefficient(this.findAtomSymbolFromName(line.substring(2, 4)), Float.parseFloat(line.substring(10, 20)), Float.parseFloat(line.substring(20, 30)));
    }

    private List<Six12PotentialCoefficient> parse6_12PotentialCoefficientParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parse6_12PotentialCoefficientParameter).toList();
    }

    private VanDerWaalsRadius parseVanDerWaalsRadiusParameter(String line) {
        return new VanDerWaalsRadius(this.findAtomSymbolFromName(line.substring(2, 4)), Float.parseFloat(line.substring(10, 20)), Float.parseFloat(ForcefieldFileParser.eolSubstring(line, 20, 30)));
    }

    private List<VanDerWaalsRadius> parseVanDerWaalsRadiiParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseVanDerWaalsRadiusParameter).toList();
    }

    private SlaterKirkwoodParameter parseSlaterKirkwoodParamter(String line) {
        return new SlaterKirkwoodParameter(this.findAtomSymbolFromName(line.substring(2, 4)), Float.parseFloat(line.substring(10, 20)), Float.parseFloat(line.substring(20, 30)), Float.parseFloat(line.substring(30, 40)));
    }

    private List<SlaterKirkwoodParameter> parseSlaterKirkwoodParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseSlaterKirkwoodParamter).toList();
    }

    private List<EquivalencingAtom> parseEquivalencingAtomfForNonBonded6_12PotentialParameters(List<String> lines) {
        return ((StreamEx)((StreamEx)StreamEx.of(lines).flatMap(l -> Arrays.stream(l.substring(4).split(" {2}")).map(rest -> new EquivalencingAtom(this.findAtomSymbolFromName(l.substring(0, 2)), this.findAtomSymbolFromName((String)rest)))).filter(x -> x.IEQV() != UnmatchedAtom && x.IORG() != UnmatchedAtom)).distinct(EquivalencingAtom::IEQV)).toList();
    }

    private HBond10_12PotentialParameter parseHBond10_12PotentialParameter(String line) {
        return new HBond10_12PotentialParameter(this.findAtomSymbolFromName(line.substring(2, 4)), this.findAtomSymbolFromName(line.substring(6, 8)), Float.parseFloat(line.substring(8, 18)), Float.parseFloat(line.substring(18, 28)));
    }

    private List<HBond10_12PotentialParameter> parseHBond10_12PotentialParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseHBond10_12PotentialParameter).toList();
    }

    private ImproperDihederalParameter parseImproperDihedralParameter(String line) {
        return new ImproperDihederalParameter(this.findAtomSymbolOrWildcardFromName(line.substring(0, 2)), this.findAtomSymbolOrWildcardFromName(line.substring(3, 5)), this.findAtomSymbolOrWildcardFromName(line.substring(6, 8)), this.findAtomSymbolOrWildcardFromName(line.substring(9, 11)), Float.parseFloat(line.substring(11, 26)), Float.parseFloat(line.substring(26, 41)), Float.parseFloat(line.substring(41, Math.min(56, line.length()))));
    }

    private List<ImproperDihederalParameter> parseImproperDihedralParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseImproperDihedralParameter).toList();
    }

    private DihederalParameter parseDihedralParameter(String line) {
        return new DihederalParameter(this.findAtomSymbolOrWildcardFromName(line.substring(0, 2)), this.findAtomSymbolOrWildcardFromName(line.substring(3, 5)), this.findAtomSymbolOrWildcardFromName(line.substring(6, 8)), this.findAtomSymbolOrWildcardFromName(line.substring(9, 11)), Integer.parseInt(line.substring(11, 15).trim()), Float.parseFloat(line.substring(15, 30)), Float.parseFloat(line.substring(30, 45)), Float.parseFloat(line.substring(45, Math.min(60, line.length()))));
    }

    private List<DihederalParameter> parseDihedralParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseDihedralParameter).toList();
    }

    private BondAngleParameter parseBondAngleParameter(String line) {
        return new BondAngleParameter(this.findAtomSymbolFromName(line.substring(0, 2)), this.findAtomSymbolFromName(line.substring(3, 5)), this.findAtomSymbolFromName(line.substring(6, 8)), Float.parseFloat(line.substring(8, 18)), Float.parseFloat(line.substring(18, 28)));
    }

    private List<BondAngleParameter> parseBondAngleParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseBondAngleParameter).toList();
    }

    private BondLengthParameter parseBondLengthParameter(String line) {
        return new BondLengthParameter(this.findAtomSymbolFromName(line.substring(0, 2)), this.findAtomSymbolFromName(line.substring(3, 5)), Float.parseFloat(line.substring(5, 15)), Float.parseFloat(ForcefieldFileParser.eolSubstring(line, 15, 25)));
    }

    private List<BondLengthParameter> parseBondLengthParameters(List<String> lines) {
        return StreamEx.of(lines).map(this::parseBondLengthParameter).toList();
    }

    private AtomSymbolAndMass findAtomSymbolOrWildcardFromName(String s) {
        return s.trim().equals("X") ? WildcardAtom : this.findAtomSymbolFromName(s);
    }

    private AtomSymbolAndMass findAtomSymbolFromName(String s) {
        return ((StreamEx)StreamEx.of(this.atomSymbolsAndMasses).filter(a -> a.KNDSYM().equals(s.trim()))).findFirst().orElse(UnmatchedAtom);
    }

    private static TwoTuple<List<String>> takeUntilBlankLine(List<String> lines) {
        List beforeBreak = ((StreamEx)StreamEx.of(lines).takeWhile(l -> !l.trim().isEmpty())).toList();
        List afterBreak = ((StreamEx)StreamEx.of(lines).skip((long)(beforeBreak.size() + 1))).toList();
        return new TwoTuple<List<String>>(beforeBreak, afterBreak);
    }

    private List<AtomSymbolAndMass> parseHydrophilicAtoms(String line) {
        return ((StreamEx)StreamEx.of((Object[])line.split(" {2}")).map(this::findAtomSymbolFromName).filter(x -> x != UnmatchedAtom)).toList();
    }

    private static AtomSymbolAndMass parseAtomSymbolAndMass(String line) {
        return new AtomSymbolAndMass(line.substring(0, 2).trim(), Float.parseFloat(line.substring(3, 13)));
    }

    private List<AtomSymbolAndMass> parseAtomSymbolsAndMasses(List<String> lines) {
        return StreamEx.of(lines).map(ForcefieldFileParser::parseAtomSymbolAndMass).toList();
    }

    private record TwoTuple<T>(T head, T tail) {
    }

    private static interface AreSame<T> {
        public boolean check(T var1, T var2);
    }
}

