/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.forcefield.AtomPairElectrostaticContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairEnergyContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairSolvationContribution;
import edu.duke.cs.osprey.energy.forcefield.AtomPairVanDerWaalsContribution;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.ResPairCache;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergyContribution;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.Streams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResidueForcefieldEnergy
implements EnergyFunction.DecomposableByDof {
    private static final long serialVersionUID = -4768384219061898745L;
    public final ResPairCache resPairCache;
    public final ResidueInteractions inters;
    public final Residues residues;
    public final ResPairCache.ResPair[] resPairs;
    public final boolean isBroken;
    public static final List<ResPairEnergyContribution> brokenList = ImmutableList.of((Object)ResPairEnergyContribution.BrokenConformation);
    private double coulombFactor;
    private double scaledCoulombFactor;

    public ResidueForcefieldEnergy(ResPairCache resPairCache, ResidueInteractions inters, Molecule mol) {
        this(resPairCache, inters, mol.residues);
    }

    public ResidueForcefieldEnergy(ResPairCache resPairCache, ResidueInteractions inters, Residues residues) {
        this.resPairCache = resPairCache;
        this.inters = inters;
        this.residues = residues;
        ForcefieldParams.SolvationForcefield.ResiduesInfo solvInfo = null;
        if (resPairCache.ffparams.solvationForcefield != null) {
            solvInfo = resPairCache.ffparams.solvationForcefield.makeInfo(resPairCache.ffparams, this.residues);
        }
        this.resPairs = new ResPairCache.ResPair[inters.size()];
        int index = 0;
        for (ResidueInteractions.Pair pair : inters) {
            this.resPairs[index++] = resPairCache.get(this.residues, pair, solvInfo);
        }
        for (ResPairCache.ResPair pair : this.resPairs) {
            if (pair.res1.confProblems.size() + pair.res2.confProblems.size() <= 0) continue;
            this.isBroken = true;
            return;
        }
        this.isBroken = false;
        this.coulombFactor = 332.0 / resPairCache.ffparams.dielectric;
        this.scaledCoulombFactor = this.coulombFactor * resPairCache.ffparams.forcefld.coulombScaling;
    }

    public ResidueForcefieldEnergy makeSubset(ResidueInteractions.Pair pair) {
        return this.makeSubset(new ResidueInteractions(pair));
    }

    public ResidueForcefieldEnergy makeSubset(ResidueInteractions inters) {
        return new ResidueForcefieldEnergy(this.resPairCache, inters, this.residues);
    }

    @Override
    public double getEnergy() {
        return this.getEnergy(this.resPairs);
    }

    public List<ResPairEnergyContribution> getEnergyContributions(ResPairCache.ResPair[] resPairs) {
        List<ResPairEnergyContribution> electrostaticContributions = this.getElectrostaticsEnergyContributions(resPairs);
        List<ResPairEnergyContribution> vdwContributions = this.getVanDerWaalsEnergyContributions(resPairs);
        List<ResPairEnergyContribution> solvationContributions = this.getSolvationEnergyContributions(resPairs);
        Map a = Streams.of(Iterables.concat(electrostaticContributions, vdwContributions, solvationContributions)).collect(Collectors.groupingBy(ResPairEnergyContribution::getResPair, Collectors.reducing((x, y) -> new ResPairEnergyContribution(x.getResPair(), Stream.concat(x.getAtomPairEnergyContributions().stream(), y.getAtomPairEnergyContributions().stream()).collect(Collectors.toList())))));
        return a.values().stream().map(Optional::get).collect(Collectors.toList());
    }

    private double getEnergy(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return Double.POSITIVE_INFINITY;
        }
        boolean useHEs = this.resPairCache.ffparams.hElect;
        boolean useHvdW = this.resPairCache.ffparams.hVDW;
        double coulombFactor = this.coulombFactor;
        double scaledCoulombFactor = this.scaledCoulombFactor;
        boolean distDepDielect = this.resPairCache.ffparams.distDepDielect;
        boolean useEEF1 = this.resPairCache.ffparams.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1;
        double energy = 0.0;
        for (int i = 0; i < resPairs.length; ++i) {
            ResPairCache.ResPair pair = resPairs[i];
            double[] coords1 = pair.res1.coords;
            double[] coords2 = pair.res2.coords;
            int numAtomPairs = pair.info.numAtomPairs;
            long[] flags = pair.info.flags;
            double[] precomputed = pair.info.precomputed;
            double resPairEnergy = 0.0;
            int pos = 0;
            for (int j = 0; j < numAtomPairs; ++j) {
                long atomPairFlags = flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                boolean is14Bonded = ((atomPairFlags >>= 1) & 1L) == 1L;
                double x1 = coords1[atomOffset1];
                double y1 = coords1[atomOffset1 + 1];
                double z1 = coords1[atomOffset1 + 2];
                double x2 = coords2[atomOffset2];
                double y2 = coords2[atomOffset2 + 1];
                double z2 = coords2[atomOffset2 + 2];
                double d = x1 - x2;
                double r2 = d * d;
                d = y1 - y2;
                r2 += d * d;
                d = z1 - z2;
                double r = Math.sqrt(r2 += d * d);
                if (isHeavyPair || useHEs) {
                    double charge = precomputed[pos++];
                    resPairEnergy = is14Bonded ? (distDepDielect ? (resPairEnergy += scaledCoulombFactor * charge / r2) : (resPairEnergy += scaledCoulombFactor * charge / r)) : (distDepDielect ? (resPairEnergy += coulombFactor * charge / r2) : (resPairEnergy += coulombFactor * charge / r));
                } else {
                    ++pos;
                }
                if (isHeavyPair || useHvdW) {
                    double Aij = precomputed[pos++];
                    double Bij = precomputed[pos++];
                    double r6 = r2 * r2 * r2;
                    double r12 = r6 * r6;
                    double increment = Aij / r12 - Bij / r6;
                    resPairEnergy += increment;
                } else {
                    pos += 2;
                }
                if (!useEEF1) continue;
                if (isHeavyPair && r2 < 81.0) {
                    double radius1 = precomputed[pos++];
                    double lambda1 = precomputed[pos++];
                    double alpha1 = precomputed[pos++];
                    double radius2 = precomputed[pos++];
                    double lambda2 = precomputed[pos++];
                    double alpha2 = precomputed[pos++];
                    double Xij = (r - radius1) / lambda1;
                    double Xji = (r - radius2) / lambda2;
                    resPairEnergy -= (alpha1 * Math.exp(-Xij * Xij) + alpha2 * Math.exp(-Xji * Xji)) / r2;
                    continue;
                }
                pos += 6;
            }
            energy += (resPairEnergy + pair.offset + pair.solvEnergy) * pair.weight;
        }
        return energy;
    }

    public double getElectrostaticsEnergy() {
        return this.getElectrostaticsEnergy(this.resPairs);
    }

    public List<ResPairEnergyContribution> getElectrostaticsEnergyContributions(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return brokenList;
        }
        LinkedList<ResPairEnergyContribution> resPairContributions = new LinkedList<ResPairEnergyContribution>();
        for (ResPairCache.ResPair pair : resPairs) {
            int pos = 0;
            LinkedList<AtomPairEnergyContribution> energyContributions = new LinkedList<AtomPairEnergyContribution>();
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                double energy = 0.0;
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                boolean is14Bonded = ((atomPairFlags >>= 1) & 1L) == 1L;
                double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                double r = Math.sqrt(r2);
                double charge = 0.0;
                if (isHeavyPair || this.resPairCache.ffparams.hElect) {
                    charge = pair.info.precomputed[pos++];
                    energy = is14Bonded ? (this.resPairCache.ffparams.distDepDielect ? this.scaledCoulombFactor * charge / r2 : this.scaledCoulombFactor * charge / r) : (this.resPairCache.ffparams.distDepDielect ? this.coulombFactor * charge / r2 : this.coulombFactor * charge / r);
                } else {
                    ++pos;
                }
                pos += 2;
                if (this.resPairCache.ffparams.solvationForcefield == ForcefieldParams.SolvationForcefield.EEF1) {
                    pos += 6;
                }
                energyContributions.add(new AtomPairElectrostaticContribution(pair, atomOffset1 / 3, atomOffset2 / 3, energy, r, charge, is14Bonded, isHeavyPair, this.resPairCache.ffparams.distDepDielect));
            }
            resPairContributions.add(new ResPairEnergyContribution(pair, energyContributions));
        }
        return resPairContributions;
    }

    public double getElectrostaticsEnergy(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return Double.POSITIVE_INFINITY;
        }
        double energy = 0.0;
        for (ResPairCache.ResPair pair : resPairs) {
            double resPairEnergy = 0.0;
            int pos = 0;
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                boolean is14Bonded = ((atomPairFlags >>= 1) & 1L) == 1L;
                double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                double r = Math.sqrt(r2);
                if (isHeavyPair || this.resPairCache.ffparams.hElect) {
                    double charge = pair.info.precomputed[pos++];
                    resPairEnergy = is14Bonded ? (this.resPairCache.ffparams.distDepDielect ? (resPairEnergy += this.scaledCoulombFactor * charge / r2) : (resPairEnergy += this.scaledCoulombFactor * charge / r)) : (this.resPairCache.ffparams.distDepDielect ? (resPairEnergy += this.coulombFactor * charge / r2) : (resPairEnergy += this.coulombFactor * charge / r));
                } else {
                    ++pos;
                }
                pos += 2;
                if (this.resPairCache.ffparams.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) continue;
                pos += 6;
            }
            energy += resPairEnergy * pair.weight;
        }
        return energy;
    }

    public double getVanDerWaalsEnergy() {
        return this.getVanDerWaalsEnergy(this.resPairs);
    }

    public List<ResPairEnergyContribution> getVanDerWaalsEnergyContributions(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return brokenList;
        }
        LinkedList<ResPairEnergyContribution> resPairContributions = new LinkedList<ResPairEnergyContribution>();
        for (ResPairCache.ResPair pair : resPairs) {
            LinkedList<AtomPairEnergyContribution> vanDerWaalsContributions = new LinkedList<AtomPairEnergyContribution>();
            double energy = 0.0;
            int pos = 0;
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                ++pos;
                if (isHeavyPair || this.resPairCache.ffparams.hVDW) {
                    double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                    double Aij = pair.info.precomputed[pos++];
                    double Bij = pair.info.precomputed[pos++];
                    double r6 = r2 * r2 * r2;
                    double r12 = r6 * r6;
                    energy = Aij / r12 - Bij / r6;
                    vanDerWaalsContributions.add(new AtomPairVanDerWaalsContribution(pair, atomOffset1 / 3, atomOffset2 / 3, energy, Aij, Bij, r2));
                } else {
                    pos += 2;
                }
                if (this.resPairCache.ffparams.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) continue;
                pos += 6;
            }
            resPairContributions.add(new ResPairEnergyContribution(pair, vanDerWaalsContributions));
        }
        return resPairContributions;
    }

    public double getVanDerWaalsEnergy(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return Double.POSITIVE_INFINITY;
        }
        double energy = 0.0;
        for (ResPairCache.ResPair pair : resPairs) {
            double resPairEnergy = 0.0;
            int pos = 0;
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                ++pos;
                if (isHeavyPair || this.resPairCache.ffparams.hVDW) {
                    double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                    double Aij = pair.info.precomputed[pos++];
                    double Bij = pair.info.precomputed[pos++];
                    double r6 = r2 * r2 * r2;
                    double r12 = r6 * r6;
                    resPairEnergy += Aij / r12 - Bij / r6;
                } else {
                    pos += 2;
                }
                if (this.resPairCache.ffparams.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) continue;
                pos += 6;
            }
            energy += resPairEnergy * pair.weight;
        }
        return energy;
    }

    public double getSolvationEnergy() {
        return this.getSolvationEnergy(this.resPairs);
    }

    public List<ResPairEnergyContribution> getSolvationEnergyContributions(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return brokenList;
        }
        LinkedList<ResPairEnergyContribution> resPairContributions = new LinkedList<ResPairEnergyContribution>();
        for (ResPairCache.ResPair pair : resPairs) {
            double resPairEnergy = 0.0;
            int pos = 0;
            LinkedList<AtomPairEnergyContribution> atomPairContributions = new LinkedList<AtomPairEnergyContribution>();
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                boolean is14Bonded = ((atomPairFlags >>= 1) & 1L) == 1L;
                double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                double r = Math.sqrt(r2);
                pos += 3;
                if (this.resPairCache.ffparams.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) continue;
                if (isHeavyPair && r2 < 81.0) {
                    double radius1 = pair.info.precomputed[pos++];
                    double lambda1 = pair.info.precomputed[pos++];
                    double alpha1 = pair.info.precomputed[pos++];
                    double radius2 = pair.info.precomputed[pos++];
                    double lambda2 = pair.info.precomputed[pos++];
                    double alpha2 = pair.info.precomputed[pos++];
                    double Xij = (r - radius1) / lambda1;
                    double Xji = (r - radius2) / lambda2;
                    double energy = -(alpha1 * Math.exp(-Xij * Xij) + alpha2 * Math.exp(-Xji * Xji)) / r2;
                    atomPairContributions.add(new AtomPairSolvationContribution(pair, atomOffset1 / 3, atomOffset2 / 3, energy));
                    continue;
                }
                pos += 6;
            }
            resPairContributions.add(new ResPairEnergyContribution(pair, atomPairContributions));
        }
        return resPairContributions;
    }

    public double getSolvationEnergy(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return Double.POSITIVE_INFINITY;
        }
        double energy = 0.0;
        for (ResPairCache.ResPair pair : resPairs) {
            double resPairEnergy = 0.0;
            int pos = 0;
            for (int j = 0; j < pair.info.numAtomPairs; ++j) {
                long atomPairFlags = pair.info.flags[j];
                int atomOffset2 = (int)(atomPairFlags & 0xFFFFL);
                int atomOffset1 = (int)((atomPairFlags >>= 16) & 0xFFFFL);
                boolean isHeavyPair = ((atomPairFlags >>= 46) & 1L) == 1L;
                boolean is14Bonded = ((atomPairFlags >>= 1) & 1L) == 1L;
                double r2 = this.getR2(pair, atomOffset1, atomOffset2);
                double r = Math.sqrt(r2);
                pos += 3;
                if (this.resPairCache.ffparams.solvationForcefield != ForcefieldParams.SolvationForcefield.EEF1) continue;
                if (isHeavyPair && r2 < 81.0) {
                    double radius1 = pair.info.precomputed[pos++];
                    double lambda1 = pair.info.precomputed[pos++];
                    double alpha1 = pair.info.precomputed[pos++];
                    double radius2 = pair.info.precomputed[pos++];
                    double lambda2 = pair.info.precomputed[pos++];
                    double alpha2 = pair.info.precomputed[pos++];
                    double Xij = (r - radius1) / lambda1;
                    double Xji = (r - radius2) / lambda2;
                    resPairEnergy -= (alpha1 * Math.exp(-Xij * Xij) + alpha2 * Math.exp(-Xji * Xji)) / r2;
                    continue;
                }
                pos += 6;
            }
            energy += (resPairEnergy + pair.solvEnergy) * pair.weight;
        }
        return energy;
    }

    public double getOffsetsEnergy() {
        return this.getOffsetsEnergy(this.resPairs);
    }

    public double getOffsetsEnergy(ResPairCache.ResPair[] resPairs) {
        if (this.isBroken) {
            return Double.POSITIVE_INFINITY;
        }
        double energy = 0.0;
        for (ResPairCache.ResPair pair : resPairs) {
            energy += pair.offset * pair.weight;
        }
        return energy;
    }

    private ResPairCache.ResPair findResPair(ResidueInteractions.Pair interPair) {
        for (ResPairCache.ResPair resPair : this.resPairs) {
            if (!interPair.resNum1.equalsIgnoreCase(resPair.res1.getPDBResNumber()) || !interPair.resNum2.equalsIgnoreCase(resPair.res2.getPDBResNumber())) continue;
            return resPair;
        }
        return null;
    }

    private double getR2(ResPairCache.ResPair pair, int atomOffset1, int atomOffset2) {
        double x1 = pair.res1.coords[atomOffset1];
        double y1 = pair.res1.coords[atomOffset1 + 1];
        double z1 = pair.res1.coords[atomOffset1 + 2];
        double x2 = pair.res2.coords[atomOffset2];
        double y2 = pair.res2.coords[atomOffset2 + 1];
        double z2 = pair.res2.coords[atomOffset2 + 2];
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public ResPairCache.ResPair[] makeResPairsSubset(Residue res) {
        int num = 0;
        for (ResPairCache.ResPair resPair : this.resPairs) {
            if (resPair.res1 != res && resPair.res2 != res) continue;
            ++num;
        }
        ResPairCache.ResPair[] pairs = new ResPairCache.ResPair[num];
        num = 0;
        for (ResPairCache.ResPair resPair : this.resPairs) {
            if (resPair.res1 != res && resPair.res2 != res) continue;
            pairs[num++] = resPair;
        }
        return pairs;
    }

    public int[] makeResPairIndicesSubset(Residue res) {
        int num = 0;
        for (ResPairCache.ResPair resPair : this.resPairs) {
            if (resPair.res1 != res && resPair.res2 != res) continue;
            ++num;
        }
        int[] indices = new int[num];
        num = 0;
        for (int i = 0; i < this.resPairs.length; ++i) {
            if (this.resPairs[i].res1 != res && this.resPairs[i].res2 != res) continue;
            indices[num++] = i;
        }
        return indices;
    }

    @Override
    public List<EnergyFunction> decomposeByDof(Molecule mol, List<DegreeOfFreedom> dofs) {
        class Subset
        implements EnergyFunction {
            private static final long serialVersionUID = 4664215035458391734L;
            private ResPairCache.ResPair[] resPairs;

            Subset() {
            }

            @Override
            public double getEnergy() {
                return ResidueForcefieldEnergy.this.getEnergy(this.resPairs);
            }
        }
        HashMap<Residue, Subset> cache = new HashMap<Residue, Subset>();
        ArrayList<EnergyFunction> efuncs = new ArrayList<EnergyFunction>();
        for (DegreeOfFreedom dof : dofs) {
            Residue res = dof.getResidue();
            if (res == null) {
                efuncs.add(this);
                continue;
            }
            Subset subset = (Subset)cache.get(res);
            if (subset == null) {
                subset = new Subset();
                subset.resPairs = this.makeResPairsSubset(res);
                cache.put(res, subset);
            }
            efuncs.add(subset);
        }
        return efuncs;
    }

    public static class Vdw
    extends ResidueForcefieldEnergy {
        public Vdw(ResPairCache resPairCache, ResidueInteractions inters, Molecule mol) {
            super(resPairCache, inters, mol);
        }

        public Vdw(ResPairCache resPairCache, ResidueInteractions inters, Residues residues) {
            super(resPairCache, inters, residues);
        }

        public Vdw(ResidueForcefieldEnergy efunc) {
            this(efunc.resPairCache, efunc.inters, efunc.residues);
        }

        @Override
        public double getEnergy() {
            return super.getVanDerWaalsEnergy();
        }

        @Override
        public List<EnergyFunction> decomposeByDof(Molecule mol, List<DegreeOfFreedom> dofs) {
            class Subset
            implements EnergyFunction {
                private static final long serialVersionUID = 4664215035458391734L;
                private ResPairCache.ResPair[] resPairs;

                Subset() {
                }

                @Override
                public double getEnergy() {
                    return Vdw.this.getVanDerWaalsEnergy(this.resPairs);
                }
            }
            HashMap<Residue, Subset> cache = new HashMap<Residue, Subset>();
            ArrayList<EnergyFunction> efuncs = new ArrayList<EnergyFunction>();
            for (DegreeOfFreedom dof : dofs) {
                Residue res = dof.getResidue();
                if (res == null) {
                    efuncs.add(this);
                    continue;
                }
                Subset subset = (Subset)cache.get(res);
                if (subset == null) {
                    subset = new Subset();
                    subset.resPairs = this.makeResPairsSubset(res);
                    cache.put(res, subset);
                }
                efuncs.add(subset);
            }
            return efuncs;
        }
    }
}

