/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.forcefield.EEF1;
import edu.duke.cs.osprey.energy.forcefield.amber.AtomSymbolAndMass;
import edu.duke.cs.osprey.energy.forcefield.amber.BondAngleParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.BondLengthParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.DihederalParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.EquivalencingAtom;
import edu.duke.cs.osprey.energy.forcefield.amber.ForcefieldFileParser;
import edu.duke.cs.osprey.energy.forcefield.amber.ImproperDihederalParameter;
import edu.duke.cs.osprey.energy.forcefield.amber.VanDerWaalsRadius;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

public class ForcefieldParams
implements Serializable {
    private static final long serialVersionUID = 3124964506851762586L;
    public static final double coulombConstant = 332.0;
    public static final double solvCutoff = 9.0;
    public static final double solvCutoff2 = 81.0;
    public static boolean printWarnings = true;
    final int atomTypeX = -2;
    private final int noMatchInt = 9999;
    private final ForcefieldFileParser parameters;
    String[] atomTypeNames = null;
    double[] atomAtomicMasses = null;
    int[] bondAtomType1 = null;
    int[] bondAtomType2 = null;
    double[] bondHFC = null;
    double[] bondEBL = null;
    int[] angleAtomType1 = null;
    int[] angleAtomType2 = null;
    int[] angleAtomType3 = null;
    double[] angleHFC = null;
    double[] angleEBA = null;
    int numGeneralDihedParams = 0;
    int[] dihedAtomType1 = null;
    int[] dihedAtomType2 = null;
    int[] dihedAtomType3 = null;
    int[] dihedAtomType4 = null;
    double[] dihedTerm1 = null;
    double[] dihedPN = null;
    double[] dihedPhase = null;
    int[] impDihedAtomType1 = null;
    int[] impDihedAtomType2 = null;
    int[] impDihedAtomType3 = null;
    int[] impDihedAtomType4 = null;
    double[] impDihedTerm1 = null;
    double[] impDihedPN = null;
    double[] impDihedPhase = null;
    int[] vdwAtomType1 = null;
    double[] vdwR = null;
    double[] vdwE = null;
    int[][] equivAtoms = null;
    public Forcefield forcefld;
    public EEF1 eef1parms = null;
    public double vdwMultiplier = 0.95;
    public double solvScale = 0.5;
    public double dielectric = 6.0;
    public boolean distDepDielect = true;
    public boolean hElect = true;
    public boolean hVDW = true;
    @Deprecated
    public double shellDistCutoff = Double.POSITIVE_INFINITY;
    public SolvationForcefield solvationForcefield = SolvationForcefield.EEF1;
    private Map<String, VanDerWaalsRadius> vanDerWaalsMap;
    private Map<String, BondLengthParameter> bondLengthByName;
    private Map<String, AtomSymbolAndMass> atomNamesMap;

    public ForcefieldParams() {
        this(Forcefield.AMBER);
    }

    public ForcefieldParams(String frcefld) {
        this(Forcefield.valueOf(frcefld.toUpperCase()));
    }

    public ForcefieldParams(Forcefield frcefld) {
        this(frcefld, new ForcefieldFileParser(ForcefieldParams.class.getResourceAsStream(frcefld.paramsPath)));
    }

    public ForcefieldParams(Forcefield ffChoice, ForcefieldFileParser parameterFile) {
        this.forcefld = ffChoice;
        this.parameters = parameterFile;
        try {
            parameterFile.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.assignFromForcefieldParamFile();
        this.readEEF();
    }

    public ForcefieldParams(ForcefieldParams other) {
        this(other.forcefld);
        this.vdwMultiplier = other.vdwMultiplier;
        this.solvScale = other.solvScale;
        this.dielectric = other.dielectric;
        this.distDepDielect = other.distDepDielect;
        this.hElect = other.hElect;
        this.hVDW = other.hVDW;
        this.shellDistCutoff = other.shellDistCutoff;
        this.solvationForcefield = other.solvationForcefield;
    }

    private void readEEF() {
        try {
            this.eef1parms = new EEF1();
            this.eef1parms.readEEF1parm();
        }
        catch (Exception ex) {
            throw new Error("can't read solvation params", ex);
        }
    }

    private static String bondLengthKey(AtomSymbolAndMass atom1, AtomSymbolAndMass atom2) {
        return String.format("%s-%s", atom1.KNDSYM(), atom2.KNDSYM());
    }

    private static String bondLengthKey(Atom first, Atom second) {
        return String.format("%s-%s", first.forceFieldType, second.forceFieldType);
    }

    private void assignFromForcefieldParamFile() {
        this.atomTypeNames = (String[])StreamEx.of(this.parameters.atomSymbolsAndMasses()).map(AtomSymbolAndMass::KNDSYM).toArray(String[]::new);
        this.atomNamesMap = StreamEx.of(this.parameters.atomSymbolsAndMasses()).toMap(AtomSymbolAndMass::KNDSYM, a -> a);
        this.atomAtomicMasses = StreamEx.of(this.parameters.atomSymbolsAndMasses()).mapToDouble(AtomSymbolAndMass::AMASS).toArray();
        this.bondAtomType1 = StreamEx.of(this.parameters.bondLengthParameters()).mapToInt(x -> this.atomTypeToInt(x.IBT().KNDSYM())).toArray();
        this.bondAtomType2 = StreamEx.of(this.parameters.bondLengthParameters()).mapToInt(x -> this.atomTypeToInt(x.JBT().KNDSYM())).toArray();
        this.bondHFC = StreamEx.of(this.parameters.bondLengthParameters()).mapToDouble(BondLengthParameter::RK).toArray();
        this.bondEBL = StreamEx.of(this.parameters.bondLengthParameters()).mapToDouble(BondLengthParameter::REQ).toArray();
        this.bondLengthByName = StreamEx.of(this.parameters.bondLengthParameters()).toMap(a -> ForcefieldParams.bondLengthKey(a.IBT(), a.JBT()), a -> a);
        this.angleAtomType1 = StreamEx.of(this.parameters.bondAngleParameters()).mapToInt(x -> this.atomTypeToInt(x.ITT().KNDSYM())).toArray();
        this.angleAtomType2 = StreamEx.of(this.parameters.bondAngleParameters()).mapToInt(x -> this.atomTypeToInt(x.JTT().KNDSYM())).toArray();
        this.angleAtomType3 = StreamEx.of(this.parameters.bondAngleParameters()).mapToInt(x -> this.atomTypeToInt(x.KTT().KNDSYM())).toArray();
        this.angleHFC = StreamEx.of(this.parameters.bondAngleParameters()).mapToDouble(BondAngleParameter::TK).toArray();
        this.angleEBA = StreamEx.of(this.parameters.bondAngleParameters()).mapToDouble(BondAngleParameter::TEQ).toArray();
        this.dihedAtomType1 = StreamEx.of(this.parameters.dihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.IPT().KNDSYM())).toArray();
        this.dihedAtomType2 = StreamEx.of(this.parameters.dihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.JPT().KNDSYM())).toArray();
        this.dihedAtomType3 = StreamEx.of(this.parameters.dihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.KPT().KNDSYM())).toArray();
        this.dihedAtomType4 = StreamEx.of(this.parameters.dihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.LPT().KNDSYM())).toArray();
        this.dihedTerm1 = StreamEx.of(this.parameters.dihederalParameters()).mapToDouble(x -> x.PK() / (float)x.IDIVF()).toArray();
        this.dihedPhase = StreamEx.of(this.parameters.dihederalParameters()).mapToDouble(DihederalParameter::PHASE).toArray();
        this.dihedPN = StreamEx.of(this.parameters.dihederalParameters()).mapToDouble(x -> Math.abs(x.PN())).toArray();
        this.numGeneralDihedParams = StreamEx.of(this.parameters.dihederalParameters()).mapToInt(dihedral -> List.of(dihedral.IPT(), dihedral.JPT(), dihedral.KPT(), dihedral.LPT()).contains(ForcefieldFileParser.WildcardAtom) ? 1 : 0).sum();
        this.impDihedAtomType1 = StreamEx.of(this.parameters.improperDihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.IPT().KNDSYM())).toArray();
        this.impDihedAtomType2 = StreamEx.of(this.parameters.improperDihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.JPT().KNDSYM())).toArray();
        this.impDihedAtomType3 = StreamEx.of(this.parameters.improperDihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.KPT().KNDSYM())).toArray();
        this.impDihedAtomType4 = StreamEx.of(this.parameters.improperDihederalParameters()).mapToInt(x -> this.atomTypeToInt(x.LPT().KNDSYM())).toArray();
        this.impDihedTerm1 = StreamEx.of(this.parameters.improperDihederalParameters()).mapToDouble(ImproperDihederalParameter::PK).toArray();
        this.impDihedPhase = StreamEx.of(this.parameters.improperDihederalParameters()).mapToDouble(ImproperDihederalParameter::PHASE).toArray();
        this.impDihedPN = StreamEx.of(this.parameters.improperDihederalParameters()).mapToDouble(ImproperDihederalParameter::PN).toArray();
        Map map = StreamEx.of(this.parameters.equivalencingAtomsForNonBonded6_12PotentialParameters()).groupingBy(EquivalencingAtom::IORG);
        this.equivAtoms = (int[][])StreamEx.of((Stream)EntryStream.of((Map)map).map(entry -> IntStreamEx.of((int)this.atomTypeToInt(((AtomSymbolAndMass)entry.getKey()).KNDSYM())).append(((List)entry.getValue()).stream().mapToInt(x -> this.atomTypeToInt(x.IEQV().KNDSYM()))).toArray())).toArray(x$0 -> new int[x$0][]);
        this.vdwAtomType1 = StreamEx.of(this.parameters.vanDerWaalsRadii()).mapToInt(x -> this.atomTypeToInt(x.LTYNB().KNDSYM())).toArray();
        this.vdwR = StreamEx.of(this.parameters.vanDerWaalsRadii()).mapToDouble(VanDerWaalsRadius::R).toArray();
        this.vdwE = StreamEx.of(this.parameters.vanDerWaalsRadii()).mapToDouble(VanDerWaalsRadius::EDEP).toArray();
        Map vdwRadii = StreamEx.of(this.parameters.vanDerWaalsRadii()).toMap(a -> a.LTYNB().KNDSYM(), a -> a);
        this.vanDerWaalsMap = StreamEx.of(this.parameters.equivalencingAtomsForNonBonded6_12PotentialParameters()).mapToEntry(a -> a.IEQV().KNDSYM(), a -> (VanDerWaalsRadius)vdwRadii.get(a.IORG().KNDSYM())).filterKeys(a -> !vdwRadii.containsKey(a)).append(vdwRadii).toMap();
    }

    public int atomTypeToInt(String s) {
        if ((s = s.trim()).equalsIgnoreCase("x")) {
            return -2;
        }
        for (int q = 0; q < this.atomTypeNames.length; ++q) {
            if (!this.atomTypeNames[q].equalsIgnoreCase(s)) continue;
            return q;
        }
        return -1;
    }

    private int getEquivalentType(int atomType) {
        for (int i = 0; i < this.equivAtoms.length; ++i) {
            for (int j = 1; j < this.equivAtoms[i].length; ++j) {
                if (atomType != this.equivAtoms[i][j]) continue;
                return this.equivAtoms[i][0];
            }
        }
        return -1;
    }

    public boolean getNonBondedParameters(Atom atom, NBParams out) {
        if (this.vanDerWaalsMap.containsKey(atom.forceFieldType)) {
            VanDerWaalsRadius vdwRadii = this.vanDerWaalsMap.get(atom.forceFieldType);
            out.epsilon = vdwRadii.EDEP();
            out.r = vdwRadii.R();
            return true;
        }
        return false;
    }

    public boolean getNonBondedParameters(Atom atom, AtomNeighbors.Type neighborType, NBParams out) {
        boolean success = this.getNonBondedParameters(atom, out);
        if (!success) {
            return false;
        }
        this.forcefld.modifyNBParams(atom, neighborType, out);
        return true;
    }

    public void getNonBondedParametersOrThrow(Atom atom, AtomNeighbors.Type neighborType, NBParams out) {
        boolean success = this.getNonBondedParameters(atom, neighborType, out);
        if (!success) {
            throw new Error("couldn't find non-bonded parameters for atom type: " + atom.forceFieldType);
        }
    }

    public VdwParams getVdwParams(Atom atom1, Atom atom2, AtomNeighbors.Type neighborType) {
        NBParams nbparams1 = new NBParams();
        NBParams nbparams2 = new NBParams();
        this.getNonBondedParametersOrThrow(atom1, neighborType, nbparams1);
        this.getNonBondedParametersOrThrow(atom2, neighborType, nbparams2);
        double epsilon = Math.sqrt(nbparams1.epsilon * nbparams2.epsilon);
        double radiusSum = nbparams1.r + nbparams2.r;
        double Bij = radiusSum * radiusSum * this.vdwMultiplier * this.vdwMultiplier;
        Bij = Bij * Bij * Bij;
        double Aij = Bij * Bij;
        Aij *= epsilon;
        Bij *= epsilon;
        switch (neighborType) {
            case BONDED14: {
                Aij *= this.forcefld.Aij14Factor;
                Bij *= this.forcefld.Bij14Factor;
                break;
            }
            case NONBONDED: {
                Bij *= 2.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("no van der Waals params for closely bonded atoms");
            }
        }
        return new VdwParams(Aij, Bij);
    }

    private double getBondEquilibriumLength(AtomSymbolAndMass atom1, AtomSymbolAndMass atom2) {
        String forwardKey = ForcefieldParams.bondLengthKey(atom1, atom2);
        String reverseKey = ForcefieldParams.bondLengthKey(atom2, atom1);
        if (this.bondLengthByName.containsKey(forwardKey)) {
            return this.bondLengthByName.get(forwardKey).REQ();
        }
        if (this.bondLengthByName.containsKey(reverseKey)) {
            return this.bondLengthByName.get(reverseKey).REQ();
        }
        if (printWarnings) {
            System.out.println("Warning: No equilibrium bond length listed for atom types " + String.valueOf(atom1) + " and " + String.valueOf(atom2));
        }
        return Double.NaN;
    }

    public double getBondEquilibriumLength(Atom atom1, Atom atom2) {
        AtomSymbolAndMass atomSymbolAndMass1 = this.atomNamesMap.get(atom1.forceFieldType);
        AtomSymbolAndMass atomSymbolAndMass2 = this.atomNamesMap.get(atom2.forceFieldType);
        return this.getBondEquilibriumLength(atomSymbolAndMass1, atomSymbolAndMass2);
    }

    public double estBondEBL(Atom atom1, Atom atom2) {
        float mass1 = this.atomNamesMap.get(atom1.forceFieldType).AMASS();
        float mass2 = this.atomNamesMap.get(atom2.forceFieldType).AMASS();
        for (AtomSymbolAndMass firstAtom : this.parameters.atomSymbolsAndMasses()) {
            if (firstAtom.AMASS() != mass1) continue;
            for (AtomSymbolAndMass secondAtom : this.parameters.atomSymbolsAndMasses()) {
                double bondEBL;
                if (secondAtom.AMASS() != mass2 || Double.isNaN(bondEBL = this.getBondEquilibriumLength(firstAtom, secondAtom))) continue;
                return bondEBL;
            }
        }
        throw new RuntimeException("ERROR: Couldn't find any equilibrium bond length for atoms with masses " + mass1 + " and " + mass2);
    }

    public static enum Forcefield {
        AMBER("/config/parm96.dat", "/config/all_amino94.in", "/config/all_aminont94.in", "/config/all_aminoct94.in", "/config/all_nuc94_and_gr.in", 0.5, 1.0, 0.8333333333333334),
        CHARMM22("/config/parmcharm22.dat", "/config/all_amino_charmm22.txt", "/config/all_amino_charmm22_nt.txt", "/config/all_amino_charmm22_ct.txt", "/config/all_nuc_and_gr_charmm.in", Double.NaN, Double.NaN, Double.NaN),
        CHARMM19NEUTRAL("/config/parmcharm19.dat", "/config/all_amino_charmm19_neutral.in", "/config/all_amino_charmm19_neutral_nt.in", "/config/all_amino_charmm19_neutral_ct.in", "/config/all_nuc_and_gr_charmm.in", 1.0, 2.0, 0.4){

            @Override
            public void modifyNBParams(Atom atom, AtomNeighbors.Type neighborType, NBParams nbparams) {
                CHARMM19.modifyNBParams(atom, neighborType, nbparams);
            }
        }
        ,
        CHARMM19("/config/parmcharm19.dat", "/config/all_amino_charmm19.in", "/config/all_amino_charmm19_nt.in", "/config/all_amino_charmm19_ct.in", "/config/all_nuc_and_gr_charmm.in", 1.0, 2.0, 0.4){

            @Override
            public void modifyNBParams(Atom atom, AtomNeighbors.Type neighborType, NBParams nbparams) {
                if (atom.isCarbon() && neighborType == AtomNeighbors.Type.BONDED14) {
                    nbparams.epsilon = 0.1;
                    nbparams.r = 1.9;
                }
            }
        };

        public final String paramsPath;
        public final String aaPath;
        public final String aaNTPath;
        public final String aaCTPath;
        public final String grPath;
        public final double Aij14Factor;
        public final double Bij14Factor;
        public final double coulombScaling;

        private Forcefield(String paramsPath, String aaPath, String aaNTPath, String aaCTPath, String grPath, double Aij14Factor, double Bij14Factor, double coulombScaling) {
            this.paramsPath = paramsPath;
            this.aaPath = aaPath;
            this.aaNTPath = aaNTPath;
            this.aaCTPath = aaCTPath;
            this.grPath = grPath;
            this.Aij14Factor = Aij14Factor;
            this.Bij14Factor = Bij14Factor;
            this.coulombScaling = coulombScaling;
        }

        public static Forcefield get(String name) {
            return Forcefield.valueOf(name.toUpperCase());
        }

        public void modifyNBParams(Atom atom, AtomNeighbors.Type neighborType, NBParams nbparams) {
        }
    }

    public static enum SolvationForcefield {
        EEF1{

            @Override
            public ResiduesInfo makeInfo(ForcefieldParams ffparams, Residues residues) {
                EEF1 eEF1 = ffparams.eef1parms;
                Objects.requireNonNull(eEF1);
                return eEF1.new EEF1.ResiduesInfo(residues);
            }
        }
        ,
        PoissonBoltzmann{

            @Override
            public ResiduesInfo makeInfo(ForcefieldParams ffparams, Residues residues) {
                return null;
            }
        };


        public abstract ResiduesInfo makeInfo(ForcefieldParams var1, Residues var2);

        public static interface ResiduesInfo {
            public int getNumPrecomputedPerAtomPair();

            public double getResPairEnergy(Residue var1, Residue var2);

            public void putPrecomputed(double[] var1, int var2, Residue var3, int var4, Residue var5, int var6, double var7);
        }
    }

    public static class NBParams {
        public double r;
        public double epsilon;
    }

    public static class VdwParams {
        public final double Aij;
        public final double Bij;

        VdwParams(double aij, double bij) {
            this.Aij = aij;
            this.Bij = bij;
        }
    }
}

