/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.approximation;

import edu.duke.cs.osprey.dof.DofInfo;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.approximation.ApproximatedObjectiveFunction;
import edu.duke.cs.osprey.energy.approximation.NOPApproximator;

public class ResidueInteractionsApproximator {
    public final ApproximatedObjectiveFunction.Approximator approximator;
    public final ResidueInteractions ffInters;
    public final ResidueInteractions approxInters;

    public ResidueInteractionsApproximator(ApproximatedObjectiveFunction.Approximator approximator, ResidueInteractions ffInters, ResidueInteractions approxInters) {
        this.approximator = approximator;
        this.ffInters = ffInters;
        this.approxInters = approxInters;
    }

    public static class Builder {
        public final DofInfo dofInfo;
        private ApproximatedObjectiveFunction.Approximator.Addable approximator = null;
        private ResidueInteractions approxInters = new ResidueInteractions();
        private ResidueInteractions ffInters = new ResidueInteractions();

        public Builder(DofInfo dofInfo) {
            this.dofInfo = dofInfo;
        }

        public boolean isEmpty() {
            return this.approximator == null;
        }

        public double error() {
            if (this.approximator == null) {
                return 0.0;
            }
            return this.approximator.error();
        }

        public void approximate(ResidueInteractions.Pair inter, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
            this.init(approximator);
            this.approximator.add(approximator, inter.weight, inter.offset);
            this.approxInters.add(inter);
        }

        public void dontApproximate(ResidueInteractions.Pair inter) {
            this.ffInters.add(inter);
        }

        private void init(ApproximatedObjectiveFunction.Approximator.Addable approximator) {
            if (this.approximator == null) {
                this.approximator = approximator.makeIdentity(this.dofInfo.ids, this.dofInfo.counts);
            }
        }

        public ResidueInteractionsApproximator build() {
            if (this.approximator != null) {
                return new ResidueInteractionsApproximator(this.approximator, this.ffInters, this.approxInters);
            }
            return new ResidueInteractionsApproximator(new NOPApproximator(this.dofInfo.numDofs()), this.ffInters, new ResidueInteractions());
        }
    }
}

