/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.approximation;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleMatrixGeneric;
import edu.duke.cs.osprey.dof.DofInfo;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.approximation.ApproximatedObjectiveFunction;
import edu.duke.cs.osprey.energy.approximation.QuadraticApproximator;
import edu.duke.cs.osprey.energy.approximation.ResidueInteractionsApproximator;
import edu.duke.cs.osprey.tools.IOable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApproximatorMatrix
implements IOable {
    public final SimpleConfSpace confSpace;
    private final int[] offsets;
    private final List<Map<String, ApproximatedObjectiveFunction.Approximator.Addable>> fixedApproximators;
    private final TupleMatrixGeneric<ApproximatedObjectiveFunction.Approximator.Addable> tupleApproximators;

    public ApproximatorMatrix(SimpleConfSpace confSpace) {
        this.confSpace = confSpace;
        int offset = 0;
        this.offsets = new int[confSpace.positions.size()];
        for (SimpleConfSpace.Position pos : confSpace.positions) {
            this.offsets[pos.index] = offset;
            offset += pos.resConfs.size();
        }
        this.fixedApproximators = new ArrayList<Map<String, ApproximatedObjectiveFunction.Approximator.Addable>>(offset);
        for (int i = 0; i < offset; ++i) {
            this.fixedApproximators.add(new HashMap());
        }
        this.tupleApproximators = new TupleMatrixGeneric(confSpace);
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(int pos1, int rc1) {
        return this.tupleApproximators.getOneBody(pos1, rc1);
    }

    public void set(int pos1, int rc1, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.tupleApproximators.setOneBody(pos1, rc1, approximator);
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1) {
        return (ApproximatedObjectiveFunction.Approximator.Addable)this.tupleApproximators.getOneBody(pos1, rc1);
    }

    public void set(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.tupleApproximators.setOneBody(pos1, rc1, approximator);
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(int pos1, int rc1, int pos2, int rc2) {
        return this.tupleApproximators.getPairwise(pos1, rc1, pos2, rc2);
    }

    public void set(int pos1, int rc1, int pos2, int rc2, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.tupleApproximators.setPairwise(pos1, rc1, pos2, rc2, approximator);
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, SimpleConfSpace.Position pos2, SimpleConfSpace.ResidueConf rc2) {
        return (ApproximatedObjectiveFunction.Approximator.Addable)this.tupleApproximators.getPairwise(pos1, rc1, pos2, rc2);
    }

    public void set(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, SimpleConfSpace.Position pos2, SimpleConfSpace.ResidueConf rc2, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.tupleApproximators.setPairwise(pos1, rc1, pos2, rc2, approximator);
    }

    private int getIndex(int pos, int rc) {
        return this.offsets[pos] + rc;
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(int pos1, int rc1, String fixedResNum) {
        return this.fixedApproximators.get(this.getIndex(pos1, rc1)).get(fixedResNum);
    }

    public void set(int pos1, int rc1, String fixedResNum, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.fixedApproximators.get(this.getIndex(pos1, rc1)).put(fixedResNum, approximator);
    }

    public ApproximatedObjectiveFunction.Approximator.Addable get(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, String fixedResNum) {
        return this.get(pos1.index, rc1.index, fixedResNum);
    }

    public void set(SimpleConfSpace.Position pos1, SimpleConfSpace.ResidueConf rc1, String fixedResNum, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
        this.set(pos1.index, rc1.index, fixedResNum, approximator);
    }

    public ResidueInteractionsApproximator get(RCTuple tuple, ResidueInteractions inters, double errorBudget) {
        DofInfo dofInfo = this.confSpace.makeDofInfo(tuple);
        double errorBudgetPerInter = errorBudget / (double)inters.size();
        ResidueInteractionsApproximator.Builder builder = new ResidueInteractionsApproximator.Builder(dofInfo);
        ArrayList<InteractionApproximator> leftovers = new ArrayList<InteractionApproximator>();
        for (ResidueInteractions.Pair inter : inters) {
            Integer blockIndex1 = dofInfo.getBlockIndex(inter.resNum1);
            Integer blockIndex2 = dofInfo.getBlockIndex(inter.resNum2);
            ApproximatedObjectiveFunction.Approximator approximator = null;
            if (blockIndex1 != null && blockIndex2 != null) {
                if (blockIndex1.equals(blockIndex2)) {
                    SimpleConfSpace.Position pos = dofInfo.positions.get(blockIndex1);
                    SimpleConfSpace.ResidueConf rc = dofInfo.resConfs.get(blockIndex1);
                    approximator = this.get(pos, rc);
                } else {
                    SimpleConfSpace.Position pos1 = dofInfo.positions.get(blockIndex1);
                    SimpleConfSpace.ResidueConf rc1 = dofInfo.resConfs.get(blockIndex1);
                    SimpleConfSpace.Position pos2 = dofInfo.positions.get(blockIndex2);
                    SimpleConfSpace.ResidueConf rc2 = dofInfo.resConfs.get(blockIndex2);
                    approximator = this.get(pos1, rc1, pos2, rc2);
                }
            } else if (blockIndex1 != null || blockIndex2 != null) {
                int blockIndex = blockIndex1 != null ? blockIndex1 : blockIndex2;
                String fixedResNum = blockIndex1 != null ? inter.resNum2 : inter.resNum1;
                SimpleConfSpace.Position pos = dofInfo.positions.get(blockIndex);
                SimpleConfSpace.ResidueConf rc = dofInfo.resConfs.get(blockIndex);
                approximator = this.get(pos, rc, fixedResNum);
            } else assert (false) : String.format("residue interaction %s:%s appears unrelated to tuple %s", inter.resNum1, inter.resNum2, tuple);
            if (approximator == null) {
                builder.dontApproximate(inter);
                continue;
            }
            if (approximator.error() <= errorBudgetPerInter) {
                builder.approximate(inter, (ApproximatedObjectiveFunction.Approximator.Addable)approximator);
                continue;
            }
            leftovers.add(new InteractionApproximator(inter, (ApproximatedObjectiveFunction.Approximator.Addable)approximator));
        }
        assert (builder.error() <= errorBudget);
        if (!leftovers.isEmpty()) {
            leftovers.sort(Comparator.comparing(interApproximator -> interApproximator.approximator.error()));
            for (InteractionApproximator interApproximator2 : leftovers) {
                if (builder.error() + interApproximator2.approximator.error() <= errorBudget) {
                    builder.approximate(interApproximator2.inter, interApproximator2.approximator);
                    continue;
                }
                builder.dontApproximate(interApproximator2.inter);
            }
        }
        return builder.build();
    }

    private byte getType(ApproximatedObjectiveFunction.Approximator approximator) {
        if (approximator == null) {
            return 0;
        }
        if (approximator instanceof QuadraticApproximator) {
            return 1;
        }
        throw new IllegalArgumentException("unrecognized approximator type: " + approximator.getClass().getName());
    }

    private ApproximatedObjectiveFunction.Approximator.Addable alloc(byte type, RCTuple tuple) {
        DofInfo dofInfo = this.confSpace.makeDofInfo(tuple);
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return new QuadraticApproximator(dofInfo.ids, dofInfo.counts);
            }
        }
        throw new IllegalArgumentException("unrecognized approximator type: " + type);
    }

    private void write(ApproximatedObjectiveFunction.Approximator.Addable approximator, DataOutput out) throws IOException {
        out.writeByte(this.getType(approximator));
        if (approximator != null) {
            IOable.of(approximator).writeTo(out);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                this.write(this.get(pos1, rc1), out);
            }
        }
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                for (SimpleConfSpace.Position pos2 : this.confSpace.positions.subList(0, pos1.index)) {
                    for (SimpleConfSpace.ResidueConf rc2 : pos2.resConfs) {
                        this.write(this.get(pos1, rc1, pos2, rc2), out);
                    }
                }
            }
        }
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                for (String resNum : this.confSpace.shellResNumbers) {
                    this.write(this.get(pos1, rc1, resNum), out);
                }
            }
        }
    }

    private ApproximatedObjectiveFunction.Approximator.Addable read(DataInput in, RCTuple tuple) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        ApproximatedObjectiveFunction.Approximator.Addable approximator = this.alloc(type, tuple);
        IOable.of(approximator).readFrom(in);
        return approximator;
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                this.set(pos1, rc1, this.read(in, new RCTuple(pos1.index, rc1.index)));
            }
        }
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                for (SimpleConfSpace.Position pos2 : this.confSpace.positions.subList(0, pos1.index)) {
                    for (SimpleConfSpace.ResidueConf rc2 : pos2.resConfs) {
                        this.set(pos1, rc1, pos2, rc2, this.read(in, new RCTuple(pos1.index, rc1.index, pos2.index, rc2.index)));
                    }
                }
            }
        }
        for (SimpleConfSpace.Position pos1 : this.confSpace.positions) {
            for (SimpleConfSpace.ResidueConf rc1 : pos1.resConfs) {
                for (String resNum : this.confSpace.shellResNumbers) {
                    this.set(pos1, rc1, resNum, this.read(in, new RCTuple(pos1.index, rc1.index)));
                }
            }
        }
    }

    private static class InteractionApproximator {
        final ResidueInteractions.Pair inter;
        final ApproximatedObjectiveFunction.Approximator.Addable approximator;

        InteractionApproximator(ResidueInteractions.Pair inter, ApproximatedObjectiveFunction.Approximator.Addable approximator) {
            this.inter = inter;
            this.approximator = approximator;
        }
    }
}

