/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.approximation;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.minimization.Minimizer;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import java.util.ArrayList;
import java.util.List;

public class ApproximatedObjectiveFunction
implements ObjectiveFunction {
    public final Approximator approximator;
    public final ObjectiveFunction f;
    private final DoubleMatrix1D x;

    public ApproximatedObjectiveFunction(ObjectiveFunction f, Approximator approximator) {
        if (f.getNumDOFs() != approximator.numDofs()) {
            throw new IllegalArgumentException("number of degrees of freedom don't match!");
        }
        this.f = f;
        this.approximator = approximator;
        this.x = DoubleFactory1D.dense.make(f.getNumDOFs());
    }

    @Override
    public int getNumDOFs() {
        return this.f.getNumDOFs();
    }

    @Override
    public DoubleMatrix1D[] getConstraints() {
        return this.f.getConstraints();
    }

    @Override
    public void setDOFs(DoubleMatrix1D x) {
        this.x.assign(x);
        this.f.setDOFs(x);
    }

    @Override
    public void setDOF(int dof, double val) {
        this.x.set(dof, val);
        this.f.setDOF(dof, val);
    }

    @Override
    public double getValue(DoubleMatrix1D x) {
        this.x.assign(x);
        return this.f.getValue(x) + this.approximator.getValue(x);
    }

    @Override
    public double getValForDOF(int dof, double val) {
        this.x.set(dof, val);
        return this.f.getValForDOF(dof, val) + this.approximator.getValForDOF(dof, val, this.x);
    }

    @Override
    public double getInitStepSize(int dof) {
        return this.f.getInitStepSize(dof);
    }

    @Override
    public boolean isDOFAngle(int dof) {
        return this.f.isDOFAngle(dof);
    }

    @Override
    public ArrayList<Integer> getInitFixableDOFs() {
        return this.f.getInitFixableDOFs();
    }

    public static interface Approximator {
        public int numDofs();

        public double getValue(DoubleMatrix1D var1);

        public double getValForDOF(int var1, double var2, DoubleMatrix1D var4);

        public double error();

        public static interface Addable
        extends Approximator {
            public List<Integer> dofBlockIds();

            public List<Integer> dofCounts();

            public int numParams();

            public double train(List<Minimizer.Result> var1, List<Minimizer.Result> var2);

            public void train(double var1);

            public Addable makeIdentity(List<Integer> var1, List<Integer> var2);

            public void add(Addable var1, double var2, double var4);
        }
    }
}

