/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResidueInteractions
implements Iterable<Pair> {
    private Set<String> resNums = new LinkedHashSet<String>();
    private Map<String, Pair> pairs = new LinkedHashMap<String, Pair>();

    private static String makeId(String resNum1, String resNum2) {
        if (resNum1.compareTo(resNum2) > 0) {
            String swap = resNum1;
            resNum1 = resNum2;
            resNum2 = swap;
        }
        return resNum1 + " " + resNum2;
    }

    public ResidueInteractions() {
    }

    public ResidueInteractions(Pair ... pairs) {
        this();
        for (Pair pair : pairs) {
            this.addPair(pair.resNum1, pair.resNum2, pair.weight, pair.offset);
        }
    }

    public boolean contains(Pair pair) {
        return this.pairs.containsKey(pair.id);
    }

    public Pair get(String resNum1, String resNum2) {
        return this.pairs.get(ResidueInteractions.makeId(resNum1, resNum2));
    }

    public void add(Pair pair) {
        this.resNums.add(pair.resNum1);
        this.resNums.add(pair.resNum2);
        this.pairs.put(pair.id, pair);
    }

    public void addAll(ResidueInteractions other) {
        this.pairs.putAll(other.pairs);
    }

    public void addSingle(String resNum) {
        this.addSingle(resNum, 1.0, 0.0);
    }

    public void addSingle(String resNum, double weight, double offset) {
        this.resNums.add(resNum);
        this.add(new Pair(resNum, resNum, weight, offset));
    }

    public void addPair(String resNum1, String resNum2) {
        this.addPair(resNum1, resNum2, 1.0, 0.0);
    }

    public void addPair(String resNum1, String resNum2, double weight, double offset) {
        this.resNums.add(resNum1);
        this.resNums.add(resNum2);
        this.add(new Pair(resNum1, resNum2, weight, offset));
    }

    public void addComplete(Residues residues) {
        this.addComplete(residues, 1.0, 0.0);
    }

    public void addComplete(Residues residues, double weight, double offset) {
        for (int i = 0; i < residues.size(); ++i) {
            Residue res1 = (Residue)residues.get(i);
            this.addSingle(res1.getPDBResNumber(), weight, offset);
            for (int j = 0; j < i; ++j) {
                Residue res2 = (Residue)residues.get(j);
                this.addPair(res1.getPDBResNumber(), res2.getPDBResNumber(), weight, offset);
            }
        }
    }

    public Set<String> getResidueNumbers() {
        return this.resNums;
    }

    @Override
    public Iterator<Pair> iterator() {
        return this.pairs.values().iterator();
    }

    public int size() {
        return this.pairs.size();
    }

    public Residues filter(Residues residues) {
        Residues filtered = new Residues();
        for (String resNum : this.resNums) {
            filtered.add(residues.getOrThrow(resNum));
        }
        return filtered;
    }

    public static ResidueInteractions subtract(ResidueInteractions a, ResidueInteractions b) {
        ResidueInteractions out = new ResidueInteractions();
        for (Pair pair : a) {
            if (b.contains(pair)) continue;
            out.add(pair);
        }
        return out;
    }

    public static class Pair {
        public static final double IdentityWeight = 1.0;
        public static final double IdentityOffset = 0.0;
        public final String resNum1;
        public final String resNum2;
        public final double weight;
        public final double offset;
        public final String id;

        public Pair(String resNum1, String resNum2, double weight, double offset) {
            if (resNum1.compareTo(resNum2) > 0) {
                String swap = resNum1;
                resNum1 = resNum2;
                resNum2 = swap;
            }
            this.resNum1 = resNum1;
            this.resNum2 = resNum2;
            this.weight = weight;
            this.offset = offset;
            this.id = ResidueInteractions.makeId(resNum1, resNum2);
        }

        public int hashCode() {
            return HashCalculator.combineHashes(this.resNum1.hashCode(), this.resNum2.hashCode());
        }

        public boolean equals(Object other) {
            if (other instanceof Pair) {
                return this.equals((Pair)other);
            }
            return false;
        }

        public boolean equals(Pair other) {
            return this.resNum1.equals(other.resNum1) && this.resNum2.equals(other.resNum2);
        }

        public String getOtherResNum(String resNum) {
            if (resNum.equals(this.resNum1)) {
                return this.resNum2;
            }
            if (resNum.equals(this.resNum2)) {
                return this.resNum1;
            }
            return null;
        }
    }
}

