/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.forcefield.ResidueForcefieldEnergy;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ResidueForcefieldBreakdown {

    public static class ByPosition {
        public final ConfEnergyCalculator confEcalc;
        public final int[] assignments;
        public final EnergyCalculator.EnergiedParametricMolecule epmol;
        public final ResidueForcefieldEnergy efunc;

        public ByPosition(ConfEnergyCalculator confEcalc, int[] assignments) {
            this(confEcalc, assignments, confEcalc.calcEnergy(new RCTuple(assignments)));
        }

        public ByPosition(ConfEnergyCalculator confEcalc, int[] assignments, EnergyCalculator.EnergiedParametricMolecule epmol) {
            this.confEcalc = confEcalc;
            this.assignments = assignments;
            this.epmol = epmol;
            this.efunc = (ResidueForcefieldEnergy)confEcalc.ecalc.makeEnergyFunction(epmol);
        }

        public EnergyMatrix makeEmat() {
            int[] numRCsAtPos = new int[this.confEcalc.confSpace.positions.size()];
            Arrays.fill(numRCsAtPos, 1);
            return new EnergyMatrix(this.confEcalc.confSpace.positions.size(), numRCsAtPos, 0.0);
        }

        public EnergyMatrix breakdownForcefield(Type type) {
            EnergyMatrix breakdown = this.makeEmat();
            for (SimpleConfSpace.Position pos1 : this.confEcalc.confSpace.positions) {
                int rc1 = this.assignments[pos1.index];
                ResidueInteractions inters = this.confEcalc.makeSingleInters(pos1.index, rc1);
                double energy = type.getEnergy(this.efunc.makeSubset(inters));
                breakdown.setOneBody(pos1.index, 0, energy);
                for (SimpleConfSpace.Position pos2 : this.confEcalc.confSpace.positions) {
                    if (pos2.index >= pos1.index) continue;
                    int rc2 = this.assignments[pos2.index];
                    ResidueInteractions inters2 = this.confEcalc.makePairInters(pos1.index, rc1, pos2.index, rc2);
                    double energy2 = type.getEnergy(this.efunc.makeSubset(inters2));
                    breakdown.setPairwise(pos1.index, 0, pos2.index, 0, energy2);
                }
            }
            return breakdown;
        }

        public EnergyMatrix breakdownScore(EnergyMatrix emat) {
            EnergyMatrix breakdown = this.makeEmat();
            for (SimpleConfSpace.Position pos1 : this.confEcalc.confSpace.positions) {
                int rc1 = this.assignments[pos1.index];
                double energy = emat.getOneBody(pos1.index, rc1);
                breakdown.setOneBody(pos1.index, 0, energy);
                for (SimpleConfSpace.Position pos2 : this.confEcalc.confSpace.positions) {
                    if (pos2.index >= pos1.index) continue;
                    int rc2 = this.assignments[pos2.index];
                    double energy2 = emat.getPairwise(pos1.index, rc1, pos2.index, rc2);
                    breakdown.setPairwise(pos1.index, 0, pos2.index, 0, energy2);
                }
            }
            return breakdown;
        }
    }

    public static class ByResidue {
        public final ResidueForcefieldEnergy efunc;

        public ByResidue(ResidueForcefieldEnergy efunc) {
            this.efunc = efunc;
        }

        public ByResidue(ConfEnergyCalculator confEcalc, int[] assignments) {
            this(confEcalc, confEcalc.calcEnergy(new RCTuple(assignments)));
        }

        public ByResidue(ConfEnergyCalculator confEcalc, EnergyCalculator.EnergiedParametricMolecule epmol) {
            this.efunc = (ResidueForcefieldEnergy)confEcalc.ecalc.makeEnergyFunction(epmol);
        }

        public EnergyMatrix makeEmat() {
            int[] numRCsAtPos = new int[this.efunc.residues.size()];
            Arrays.fill(numRCsAtPos, 1);
            return new EnergyMatrix(this.efunc.residues.size(), numRCsAtPos, 0.0);
        }

        public EnergyMatrix breakdownForcefield(Type type) {
            EnergyMatrix breakdown = this.makeEmat();
            for (ResidueInteractions.Pair pair : this.efunc.inters) {
                int i1 = this.efunc.residues.findIndexOrThrow(pair.resNum1);
                int i2 = this.efunc.residues.findIndexOrThrow(pair.resNum2);
                double energy = type.getEnergy(this.efunc.makeSubset(pair));
                if (i1 == i2) {
                    breakdown.setOneBody(i1, 0, energy);
                    continue;
                }
                breakdown.setPairwise(i1, 0, i2, 0, energy);
            }
            return breakdown;
        }
    }

    public static enum Type {
        Electrostatics(true){

            @Override
            public double getEnergy(ResidueForcefieldEnergy efunc) {
                return efunc.getElectrostaticsEnergy();
            }
        }
        ,
        VanDerWaals(true){

            @Override
            public double getEnergy(ResidueForcefieldEnergy efunc) {
                return efunc.getVanDerWaalsEnergy();
            }
        }
        ,
        Solvation(true){

            @Override
            public double getEnergy(ResidueForcefieldEnergy efunc) {
                return efunc.getSolvationEnergy();
            }
        }
        ,
        Offsets(true){

            @Override
            public double getEnergy(ResidueForcefieldEnergy efunc) {
                return efunc.getOffsetsEnergy();
            }
        }
        ,
        All(false){

            @Override
            public double getEnergy(ResidueForcefieldEnergy efunc) {
                return efunc.getElectrostaticsEnergy() + efunc.getVanDerWaalsEnergy() + efunc.getSolvationEnergy() + efunc.getOffsetsEnergy();
            }
        };

        public final boolean isAtomic;

        private Type(boolean isAtomic) {
            this.isAtomic = isAtomic;
        }

        public abstract double getEnergy(ResidueForcefieldEnergy var1);

        public static List<Type> atomics() {
            return Arrays.stream(Type.values()).filter(val -> val.isAtomic).collect(Collectors.toList());
        }
    }
}

