/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.energy.EnergyFunctionGenerator;
import edu.duke.cs.osprey.energy.FFInterGen;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.GpuForcefieldEnergy;
import edu.duke.cs.osprey.gpu.cuda.GpuStreamPool;
import edu.duke.cs.osprey.gpu.opencl.GpuQueuePool;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import java.util.List;

public class GpuEnergyFunctionGenerator
extends EnergyFunctionGenerator {
    private GpuQueuePool openclQueues = null;
    private GpuStreamPool cudaStreams = null;

    private GpuEnergyFunctionGenerator(ForcefieldParams ffParams) {
        super(ffParams);
    }

    public GpuEnergyFunctionGenerator(ForcefieldParams ffParams, GpuQueuePool openclQueues) {
        this(ffParams);
        this.openclQueues = openclQueues;
    }

    public GpuEnergyFunctionGenerator(ForcefieldParams ffParams, GpuStreamPool cudaContexts) {
        this(ffParams);
        this.cudaStreams = cudaContexts;
    }

    public GpuQueuePool getOpenclQueuePool() {
        return this.openclQueues;
    }

    public GpuStreamPool getCudaContexts() {
        return this.cudaStreams;
    }

    private GpuForcefieldEnergy makeGpuForcefield(ForcefieldInteractions interactions) {
        if (this.openclQueues != null) {
            return new GpuForcefieldEnergy(this.ffParams, interactions, this.openclQueues);
        }
        if (this.cudaStreams != null) {
            return new GpuForcefieldEnergy(this.ffParams, interactions, this.cudaStreams);
        }
        throw new Error("bad gpu queue/context config, this is a bug");
    }

    @Override
    public GpuForcefieldEnergy singleResEnergy(Residue res) {
        return this.makeGpuForcefield(FFInterGen.makeSingleRes(res));
    }

    @Override
    public GpuForcefieldEnergy resPairEnergy(Residue res1, Residue res2) {
        return this.makeGpuForcefield(FFInterGen.makeResPair(res1, res2));
    }

    @Override
    public GpuForcefieldEnergy intraAndShellEnergy(Residue res, List<Residue> shellResidues) {
        return this.makeGpuForcefield(FFInterGen.makeIntraAndShell(res, shellResidues));
    }

    @Override
    public GpuForcefieldEnergy intraAndDistributedShellEnergy(Residue res, List<Residue> shellResidues, int numPos, double singleWeight) {
        throw new UnsupportedOperationException("shell distributions are not supported by GPU energy functions");
    }

    @Override
    public GpuForcefieldEnergy resPairAndDistributedShellEnergy(Residue res1, Residue res2, List<Residue> shellResidues, int numPos, double singleWeight) {
        throw new UnsupportedOperationException("shell distributions are not supported by GPU energy functions");
    }

    @Override
    public GpuForcefieldEnergy fullConfEnergy(ConfSpace confSpace, List<Residue> shellResidues) {
        return this.makeGpuForcefield(FFInterGen.makeFullConf(confSpace, shellResidues));
    }

    @Override
    public GpuForcefieldEnergy fullConfEnergy(ConfSpace confSpace, List<Residue> shellResidues, Molecule mol) {
        return this.makeGpuForcefield(FFInterGen.makeFullConf(confSpace, shellResidues, mol));
    }

    @Override
    public GpuForcefieldEnergy fullMolecEnergy(Molecule mol) {
        return this.makeGpuForcefield(FFInterGen.makeFullMol(mol));
    }

    public void cleanup() {
        if (this.openclQueues != null) {
            this.openclQueues.cleanup();
        }
        if (this.cudaStreams != null) {
            this.cudaStreams.cleanup();
        }
    }
}

