/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import cern.jet.math.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;

public class SeriesFitter {
    static boolean useLineSearch = false;

    public static double[] fitSeries(DoubleMatrix1D[] samp, double[] trueVals, double[] weights, double lambda, boolean includeConst, int order) {
        return SeriesFitter.fitSeries(samp, trueVals, weights, lambda, includeConst, order, order, null, false, null, null);
    }

    static double[] fitSeries(DoubleMatrix1D[] samp, double[] trueVals, double[] weights, double lambda, boolean includeConst, int order, int PCOrder, boolean[] isPC, boolean update2, DoubleMatrix1D c, DoubleMatrix2D M) {
        long startTime = System.currentTimeMillis();
        int nd = samp[0].size();
        int numParams = SeriesFitter.getNumParams(nd, includeConst, order);
        if (PCOrder > order) {
            int numPCs = SeriesFitter.countTrue(isPC);
            for (int n = order + 1; n <= PCOrder; ++n) {
                numParams += SeriesFitter.getNumParamsForOrder(numPCs, n);
            }
        }
        int numSamples = samp.length;
        System.out.println("Fit has " + numSamples + " samples for " + numParams + " parameters");
        if (c == null) {
            c = DoubleFactory1D.dense.make(numParams);
        }
        if (M == null) {
            M = DoubleFactory2D.dense.make(numParams, numParams);
        }
        DoubleMatrix1D cScratch = DoubleFactory1D.dense.make(numParams);
        DoubleMatrix2D MScratch = DoubleFactory2D.dense.make(numParams, numParams);
        if (!update2) {
            for (int p = 0; p < numParams; ++p) {
                M.set(p, p, lambda);
            }
        }
        for (int s = 0; s < numSamples; ++s) {
            if (update2 && weights[s] == 0.0) continue;
            double weight = 1.0;
            if (weights != null) {
                weight = weights[s];
            }
            SeriesFitter.calcSampParamCoeffs(cScratch, samp[s], nd, includeConst, order, PCOrder, isPC);
            Algebra.DEFAULT.multOuter(cScratch, cScratch, MScratch);
            MScratch.assign(Functions.mult((double)weight));
            M.assign(MScratch, Functions.plus);
            cScratch.assign(Functions.mult((double)(trueVals[s] * weight)));
            c.assign(cScratch, Functions.plus);
        }
        DoubleMatrix2D C = DoubleFactory2D.dense.make(c.toArray(), numParams);
        double[] v = null;
        try {
            v = Algebra.DEFAULT.solve(M, C).viewColumn(0).toArray();
        }
        catch (IllegalArgumentException e) {
            SingularValueDecomposition svd = new SingularValueDecomposition(M);
            DoubleMatrix2D invS = svd.getS().copy();
            double eps = Math.pow(2.0, -52.0);
            double tol = (double)invS.rows() * invS.get(0, 0) * eps;
            for (int i = 0; i < invS.rows(); ++i) {
                double singVal = invS.get(i, i);
                if (singVal > tol) {
                    invS.set(i, i, 1.0 / singVal);
                    continue;
                }
                invS.set(i, i, 0.0);
            }
            DoubleMatrix2D ansCol = Algebra.DEFAULT.mult(Algebra.DEFAULT.mult(Algebra.DEFAULT.mult(svd.getV(), invS), Algebra.DEFAULT.transpose(svd.getU())), C);
            v = ansCol.viewColumn(0).toArray();
        }
        if (!update2) {
            double meanResidual = 0.0;
            double weightSum = 0.0;
            for (int s = 0; s < numSamples; ++s) {
                double residTerm;
                double bv = SeriesFitter.evalSeries(v, samp[s], nd, includeConst, order, PCOrder, isPC);
                double weight = 1.0;
                if (weights != null) {
                    weight = weights[s];
                }
                if (Double.isInfinite(residTerm = (trueVals[s] - bv) * (trueVals[s] - bv)) || Double.isNaN(residTerm)) {
                    System.err.println("ERROR: SeriesFitter.fitSeries gives infinite residual term: " + residTerm);
                    System.out.print("Sample: ");
                    for (int dof = 0; dof < nd; ++dof) {
                        System.err.print(samp[s].get(dof) + " ");
                    }
                    System.out.println();
                    System.err.println(" TRUEVAL=" + trueVals[s] + " BV=" + bv);
                    System.err.println("params:");
                    for (double param : v) {
                        System.out.println(param);
                    }
                    throw new RuntimeException("Infinite or nan residual");
                }
                meanResidual += weight * residTerm;
                weightSum += weight;
            }
            System.out.println("TRAINING SET MEAN RESIDUAL:" + (meanResidual /= weightSum));
        }
        long doneTime = System.currentTimeMillis();
        System.out.println("fitSeries time (ms): " + (doneTime - startTime));
        return v;
    }

    static double[] fitSeriesIterative(DoubleMatrix1D[] samp, double[] trueVals, double[] weights, double lambda, boolean includeConst, int order, double[] bCutoffs, double[] bCutoffs2, int PCOrder, boolean[] isPC) {
        long startTime = System.currentTimeMillis();
        System.out.println("Starting fitSeriesIterative...");
        int numSamples = samp.length;
        int nd = samp[0].size();
        if (bCutoffs.length == 1) {
            double bCutoff = bCutoffs[0];
            bCutoffs = new double[numSamples];
            Arrays.fill(bCutoffs, bCutoff);
        }
        int numParams = SeriesFitter.getNumParams(nd, includeConst, order);
        if (PCOrder > order) {
            int numPCs = SeriesFitter.countTrue(isPC);
            for (int n = order + 1; n <= PCOrder; ++n) {
                numParams += SeriesFitter.getNumParamsForOrder(numPCs, n);
            }
        }
        ArrayList<Integer> secondEntries = new ArrayList<Integer>();
        HashMap<Integer, Integer> revSecondEntries = new HashMap<Integer, Integer>();
        for (int s = 0; s < numSamples; ++s) {
            if (!(trueVals[s] >= bCutoffs[s]) || !(trueVals[s] < bCutoffs2[s])) continue;
            revSecondEntries.put(s, secondEntries.size());
            secondEntries.add(s);
        }
        int numRestraints = numSamples + secondEntries.size();
        DoubleMatrix1D[] fitSamp = new DoubleMatrix1D[numRestraints];
        double[] fitTrueVals = new double[numRestraints];
        double[] fitWeights = new double[numRestraints];
        for (int s = 0; s < numSamples; ++s) {
            fitSamp[s] = samp[s];
            if (trueVals[s] >= bCutoffs[s]) {
                fitWeights[s] = 0.0;
                fitTrueVals[s] = bCutoffs[s];
                continue;
            }
            fitWeights[s] = weights[s];
            fitTrueVals[s] = trueVals[s];
        }
        for (int s2 = 0; s2 < secondEntries.size(); ++s2) {
            fitSamp[numSamples + s2] = samp[(Integer)secondEntries.get(s2)];
            fitWeights[numSamples + s2] = 0.0;
            fitTrueVals[numSamples + s2] = trueVals[(Integer)secondEntries.get(s2)];
        }
        boolean done = false;
        double[] coeffs = null;
        double meanResidual = 0.0;
        double weightSum = 0.0;
        double prevResid = Double.POSITIVE_INFINITY;
        double[] oldCoeffs = null;
        double[] oldSerVals = new double[numSamples];
        Arrays.fill(oldSerVals, Double.POSITIVE_INFINITY);
        boolean firstFit = true;
        DoubleMatrix1D c = DoubleFactory1D.dense.make(numParams);
        DoubleMatrix2D M = DoubleFactory2D.dense.make(numParams, numParams);
        double[] oldFitWeights = null;
        while (!done) {
            int s;
            if (firstFit) {
                coeffs = SeriesFitter.fitSeries(fitSamp, fitTrueVals, fitWeights, lambda, includeConst, order, PCOrder, isPC, false, c, M);
                firstFit = false;
            } else {
                double[] weightDiffs = (double[])fitWeights.clone();
                for (int s2 = 0; s2 < numRestraints; ++s2) {
                    int n = s2;
                    weightDiffs[n] = weightDiffs[n] - oldFitWeights[s2];
                }
                coeffs = SeriesFitter.fitSeries(fitSamp, fitTrueVals, weightDiffs, lambda, includeConst, order, PCOrder, isPC, true, c, M);
            }
            oldFitWeights = (double[])fitWeights.clone();
            done = true;
            ArrayList<SampleCutoffCrossing> scc = new ArrayList<SampleCutoffCrossing>();
            meanResidual = 0.0;
            weightSum = 0.0;
            double[] serVals = new double[numSamples];
            for (s = 0; s < numSamples; ++s) {
                serVals[s] = SeriesFitter.evalSeries(coeffs, samp[s], nd, includeConst, order, PCOrder, isPC);
                if (trueVals[s] >= bCutoffs[s]) {
                    if (fitWeights[s] > 0.0) {
                        if (!SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], false, -1.0E-6)) {
                            done = false;
                        }
                    } else {
                        boolean secondRestraintOn = revSecondEntries.containsKey(s);
                        if (secondRestraintOn) {
                            boolean bl = secondRestraintOn = fitWeights[numSamples + (Integer)revSecondEntries.get(s)] > 0.0;
                        }
                        if (secondRestraintOn) {
                            if (!SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], true, -1.0E-6)) {
                                done = false;
                            }
                        } else if (SeriesFitter.isRestraintActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], 1.0E-6)) {
                            done = false;
                        }
                    }
                }
                double residTerm = 0.0;
                if (trueVals[s] >= bCutoffs[s]) {
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], false)) {
                        fitWeights[s] = weights[s];
                        if (revSecondEntries.containsKey(s)) {
                            fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s))).intValue()] = 0.0;
                        }
                        residTerm = (serVals[s] - bCutoffs[s]) * (serVals[s] - bCutoffs[s]);
                    } else if (SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], true)) {
                        fitWeights[s] = 0.0;
                        if (!revSecondEntries.containsKey(s)) {
                            throw new RuntimeException("ERROR: should have second entry for restraint but don't!!");
                        }
                        fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s))).intValue()] = weights[s];
                        residTerm = (serVals[s] - trueVals[s]) * (serVals[s] - trueVals[s]);
                    } else {
                        fitWeights[s] = 0.0;
                        if (revSecondEntries.containsKey(s)) {
                            fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s))).intValue()] = 0.0;
                        }
                    }
                } else {
                    residTerm = (serVals[s] - trueVals[s]) * (serVals[s] - trueVals[s]);
                }
                meanResidual += weights[s] * residTerm;
                weightSum += weights[s];
            }
            if ((meanResidual /= weightSum) == prevResid) {
                System.out.println();
            }
            if (!done && meanResidual >= prevResid) {
                if (!useLineSearch) {
                    System.out.println("Skipping line search, returning with residual " + prevResid);
                    return oldCoeffs;
                }
                System.out.println("LINE SEARCH");
                for (s = 0; s < numSamples; ++s) {
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s], oldSerVals[s], bCutoffs[s], bCutoffs2[s], false) != SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], false)) {
                        double crossingPoint = (bCutoffs[s] - oldSerVals[s]) / (serVals[s] - oldSerVals[s]);
                        scc.add(new SampleCutoffCrossing(s, crossingPoint, false));
                    }
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s], oldSerVals[s], bCutoffs[s], bCutoffs2[s], true) == SeriesFitter.isRestraintTypeActive(trueVals[s], serVals[s], bCutoffs[s], bCutoffs2[s], true)) continue;
                    double crossingPoint2 = (trueVals[s] - oldSerVals[s]) / (serVals[s] - oldSerVals[s]);
                    scc.add(new SampleCutoffCrossing(s, crossingPoint2, true));
                }
                int changeCount = scc.size();
                Collections.sort(scc);
                TreeSet<Integer> crossingIndices = new TreeSet<Integer>();
                for (SampleCutoffCrossing cr : scc) {
                    int s3 = cr.sampleIndex;
                    crossingIndices.add(s3);
                    if (cr.upperRestraint) {
                        cr.quadTerm = weights[s3] * (serVals[s3] - oldSerVals[s3]) * (serVals[s3] - oldSerVals[s3]);
                        cr.linTerm = 2.0 * weights[s3] * (serVals[s3] - oldSerVals[s3]) * (oldSerVals[s3] - trueVals[s3]);
                        cr.constTerm = weights[s3] * (oldSerVals[s3] - trueVals[s3]) * (oldSerVals[s3] - trueVals[s3]);
                        continue;
                    }
                    cr.quadTerm = weights[s3] * (serVals[s3] - oldSerVals[s3]) * (serVals[s3] - oldSerVals[s3]);
                    double baseVal = Math.min(trueVals[s3], bCutoffs[s3]);
                    cr.linTerm = 2.0 * weights[s3] * (serVals[s3] - oldSerVals[s3]) * (oldSerVals[s3] - baseVal);
                    cr.constTerm = weights[s3] * (oldSerVals[s3] - baseVal) * (oldSerVals[s3] - baseVal);
                }
                double quadTerm = 0.0;
                double linTerm = 0.0;
                double constTerm = 0.0;
                for (int s4 = 0; s4 < numSamples; ++s4) {
                    if (crossingIndices.contains(s4)) continue;
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s4], oldSerVals[s4], bCutoffs[s4], bCutoffs2[s4], false)) {
                        quadTerm += weights[s4] * (serVals[s4] - oldSerVals[s4]) * (serVals[s4] - oldSerVals[s4]);
                        double baseVal = Math.min(trueVals[s4], bCutoffs[s4]);
                        linTerm += 2.0 * weights[s4] * (serVals[s4] - oldSerVals[s4]) * (oldSerVals[s4] - baseVal);
                        constTerm += weights[s4] * (oldSerVals[s4] - baseVal) * (oldSerVals[s4] - baseVal);
                        continue;
                    }
                    if (!SeriesFitter.isRestraintTypeActive(trueVals[s4], oldSerVals[s4], bCutoffs[s4], bCutoffs2[s4], true)) continue;
                    quadTerm += weights[s4] * (serVals[s4] - oldSerVals[s4]) * (serVals[s4] - oldSerVals[s4]);
                    linTerm += 2.0 * weights[s4] * (serVals[s4] - oldSerVals[s4]) * (oldSerVals[s4] - trueVals[s4]);
                    constTerm += weights[s4] * (oldSerVals[s4] - trueVals[s4]) * (oldSerVals[s4] - trueVals[s4]);
                }
                for (SampleCutoffCrossing cr : scc) {
                    int s5 = cr.sampleIndex;
                    if (!SeriesFitter.isRestraintTypeActive(trueVals[s5], serVals[s5], bCutoffs[s5], bCutoffs2[s5], cr.upperRestraint)) continue;
                    quadTerm += cr.quadTerm;
                    linTerm += cr.linTerm;
                    constTerm += cr.constTerm;
                }
                double prevNodeResid = Double.POSITIVE_INFINITY;
                int lowestNodeIndex = 0;
                for (int curChangeIndex = changeCount - 1; curChangeIndex >= 0; --curChangeIndex) {
                    SampleCutoffCrossing cr = (SampleCutoffCrossing)scc.get(curChangeIndex);
                    double a = cr.crossingPoint;
                    double curNodeResid = (a * a * quadTerm + a * linTerm + constTerm) / weightSum;
                    int s6 = cr.sampleIndex;
                    if (curNodeResid > prevNodeResid) {
                        lowestNodeIndex = curChangeIndex + 1;
                        break;
                    }
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s6], serVals[s6], bCutoffs[s6], bCutoffs2[s6], cr.upperRestraint)) {
                        quadTerm -= cr.quadTerm;
                        linTerm -= cr.linTerm;
                        constTerm -= cr.constTerm;
                    } else {
                        quadTerm += cr.quadTerm;
                        linTerm += cr.linTerm;
                        constTerm += cr.constTerm;
                    }
                    prevNodeResid = curNodeResid;
                }
                double a_min = -linTerm / (2.0 * quadTerm);
                SampleCutoffCrossing cr = (SampleCutoffCrossing)scc.get(lowestNodeIndex);
                if (a_min > cr.crossingPoint) {
                    int s7 = cr.sampleIndex;
                    if (SeriesFitter.isRestraintTypeActive(trueVals[s7], serVals[s7], bCutoffs[s7], bCutoffs2[s7], cr.upperRestraint)) {
                        quadTerm += cr.quadTerm;
                        linTerm += cr.linTerm;
                        constTerm += cr.constTerm;
                    } else {
                        quadTerm -= cr.quadTerm;
                        linTerm -= cr.linTerm;
                        constTerm -= cr.constTerm;
                    }
                    a_min = -linTerm / (2.0 * quadTerm);
                }
                for (int p = 0; p < numParams; ++p) {
                    coeffs[p] = coeffs[p] * a_min + (1.0 - a_min) * oldCoeffs[p];
                }
                double minResid = 0.0;
                for (int s8 = 0; s8 < numSamples; ++s8) {
                    serVals[s8] = SeriesFitter.evalSeries(coeffs, samp[s8], nd, includeConst, order, PCOrder, isPC);
                    if (trueVals[s8] >= bCutoffs[s8]) {
                        if (SeriesFitter.isRestraintTypeActive(trueVals[s8], serVals[s8], bCutoffs[s8], bCutoffs2[s8], false)) {
                            fitWeights[s8] = weights[s8];
                            if (revSecondEntries.containsKey(s8)) {
                                fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s8))).intValue()] = 0.0;
                            }
                            minResid += weights[s8] * (serVals[s8] - bCutoffs[s8]) * (serVals[s8] - bCutoffs[s8]);
                            continue;
                        }
                        if (SeriesFitter.isRestraintTypeActive(trueVals[s8], serVals[s8], bCutoffs[s8], bCutoffs2[s8], true)) {
                            minResid += weights[s8] * (serVals[s8] - trueVals[s8]) * (serVals[s8] - trueVals[s8]);
                            fitWeights[s8] = 0.0;
                            fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s8))).intValue()] = weights[s8];
                            continue;
                        }
                        fitWeights[s8] = 0.0;
                        if (!revSecondEntries.containsKey(s8)) continue;
                        fitWeights[numSamples + ((Integer)revSecondEntries.get((Object)Integer.valueOf((int)s8))).intValue()] = 0.0;
                        continue;
                    }
                    minResid += weights[s8] * (serVals[s8] - trueVals[s8]) * (serVals[s8] - trueVals[s8]);
                }
                if ((minResid /= weightSum) >= prevResid) {
                    System.out.println("TRAINING SET MEAN RESIDUAL:" + prevResid);
                    System.out.println("CONVERGED IN LINE SEARCH, line search min: " + minResid);
                    System.out.println("fitSeriesIterative time (ms): " + (System.currentTimeMillis() - startTime));
                    return oldCoeffs;
                }
                meanResidual = minResid;
            }
            oldCoeffs = coeffs;
            System.out.println("STEP RESIDUAL: " + meanResidual);
            prevResid = meanResidual;
            oldSerVals = serVals;
        }
        System.out.println("TRAINING SET MEAN RESIDUAL:" + meanResidual);
        System.out.println("fitSeriesIterative time (ms): " + (System.currentTimeMillis() - startTime));
        return coeffs;
    }

    static boolean isRestraintActive(double trueVal, double serVal, double bCutoff, double bCutoff2, double tol) {
        if (trueVal < bCutoff || serVal < bCutoff - tol) {
            return true;
        }
        return !(trueVal >= bCutoff2) && !(serVal < trueVal + tol);
    }

    static boolean isRestraintTypeActive(double trueVal, double serVal, double bCutoff, double bCutoff2, boolean type, double tol) {
        if (type) {
            return trueVal >= bCutoff && trueVal < bCutoff2 && serVal > trueVal + tol;
        }
        return trueVal < bCutoff || serVal < bCutoff - tol;
    }

    static boolean isRestraintTypeActive(double trueVal, double serVal, double bCutoff, double bCutoff2, boolean type) {
        return SeriesFitter.isRestraintTypeActive(trueVal, serVal, bCutoff, bCutoff2, type, 0.0);
    }

    public static double evalSeries(double[] coeffs, DoubleMatrix1D x, int nd, boolean includeConst, int order) {
        return SeriesFitter.evalSeries(coeffs, x, nd, includeConst, order, order, null);
    }

    static double evalSeries(double[] coeffs, DoubleMatrix1D x, int nd, boolean includeConst, int order, int PCOrder, boolean[] isPC) {
        double ans;
        block53: {
            int dof5;
            int dof4;
            int dof3;
            int dof2;
            int dof;
            int count;
            block52: {
                if (order < 1 || order > 6 || PCOrder > 6) {
                    throw new RuntimeException("ERROR: SeriesFitter.evalSeries does not support order " + order + " and/or PCOrder " + PCOrder);
                }
                if (order == 1 && PCOrder == 2) {
                    throw new RuntimeException("ERROR: Order 1 and PCOrder 2 not supported");
                }
                count = 0;
                ans = 0.0;
                if (includeConst) {
                    ans += coeffs[0];
                    ++count;
                }
                for (dof = 0; dof < nd; ++dof) {
                    ans += coeffs[count] * x.get(dof);
                    ++count;
                }
                if (order >= 2) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 < dof; ++dof2) {
                            ans += coeffs[count] * x.get(dof) * x.get(dof2);
                            ++count;
                        }
                        ans += coeffs[count] * x.get(dof) * x.get(dof);
                        ++count;
                    }
                }
                if (order >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3);
                                ++count;
                            }
                        }
                    }
                } else if (PCOrder >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3);
                                ++count;
                            }
                        }
                    }
                }
                if (order >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4);
                                    ++count;
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4);
                                    ++count;
                                }
                            }
                        }
                    }
                }
                if (order >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        if (!isPC[dof5]) continue;
                                        ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                if (order < 6) break block52;
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (dof3 = 0; dof3 <= dof2; ++dof3) {
                            for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                    for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                        ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                break block53;
            }
            if (PCOrder < 6) break block53;
            for (dof = 0; dof < nd; ++dof) {
                if (!isPC[dof]) continue;
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    if (!isPC[dof2]) continue;
                    for (dof3 = 0; dof3 <= dof2; ++dof3) {
                        if (!isPC[dof3]) continue;
                        for (dof4 = 0; dof4 <= dof3; ++dof4) {
                            if (!isPC[dof4]) continue;
                            for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                if (!isPC[dof5]) continue;
                                for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                    if (!isPC[dof6]) continue;
                                    ans += coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6);
                                    ++count;
                                }
                            }
                        }
                    }
                }
            }
        }
        return ans;
    }

    static double[] evalSeriesByDegree(double[] coeffs, DoubleMatrix1D x, int nd, boolean includeConst, int order) {
        int dof3;
        int dof2;
        int dof;
        if (order > 4) {
            throw new Error("SeriesFitter.evalSeriesByDegree doesn't support order " + order);
        }
        int count = 0;
        int topDegree = order;
        double[] ans = new double[topDegree + 1];
        if (includeConst) {
            ans[0] = coeffs[0];
            ++count;
        }
        for (dof = 0; dof < nd; ++dof) {
            ans[1] = ans[1] + coeffs[count] * x.get(dof);
            ++count;
        }
        for (dof = 0; dof < nd; ++dof) {
            for (dof2 = 0; dof2 < dof; ++dof2) {
                ans[2] = ans[2] + coeffs[count] * x.get(dof) * x.get(dof2);
                ++count;
            }
            ans[2] = ans[2] + coeffs[count] * x.get(dof) * x.get(dof);
            ++count;
        }
        if (order >= 3) {
            for (dof = 0; dof < nd; ++dof) {
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    for (dof3 = 0; dof3 <= dof2; ++dof3) {
                        ans[3] = ans[3] + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3);
                        ++count;
                    }
                }
            }
        }
        if (order >= 4) {
            for (dof = 0; dof < nd; ++dof) {
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    for (dof3 = 0; dof3 <= dof2; ++dof3) {
                        for (int dof4 = 0; dof4 <= dof3; ++dof4) {
                            ans[4] = ans[4] + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4);
                            ++count;
                        }
                    }
                }
            }
        }
        return ans;
    }

    static int factorial(int a) {
        if (a <= 1) {
            return 1;
        }
        return a * SeriesFitter.factorial(a - 1);
    }

    static void calcSampParamCoeffs(DoubleMatrix1D v, DoubleMatrix1D sample, int nd, boolean includeConst, int order, int PCOrder, boolean[] isPC) {
        block53: {
            int dof5;
            int dof4;
            int dof2;
            int dof;
            int count;
            block52: {
                if (order < 1 || order > 6 || PCOrder > 6) {
                    throw new Error("SeriesFitter.calcSampParamCoeffs does not support order " + order + " and/or PCOrder " + PCOrder);
                }
                if (order == 1 && PCOrder == 2) {
                    throw new RuntimeException("ERROR: Order 1 and PCOrder 2 not supported");
                }
                count = 0;
                if (includeConst) {
                    v.set(count, 1.0);
                    ++count;
                }
                for (int i = 0; i < nd; ++i) {
                    v.set(count, sample.get(i));
                    ++count;
                }
                if (order >= 2) {
                    for (int a = 0; a < nd; ++a) {
                        for (int b = 0; b <= a; ++b) {
                            double term = sample.get(a) * sample.get(b);
                            v.set(count, term);
                            ++count;
                        }
                    }
                }
                if (order >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3));
                                ++count;
                            }
                        }
                    }
                } else if (PCOrder >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3));
                                ++count;
                            }
                        }
                    }
                }
                if (order >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4));
                                    ++count;
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4));
                                    ++count;
                                }
                            }
                        }
                    }
                }
                if (order >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4) * sample.get(dof5));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        if (!isPC[dof5]) continue;
                                        v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4) * sample.get(dof5));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                if (order < 6) break block52;
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                            for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                    for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                        v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4) * sample.get(dof5) * sample.get(dof6));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                break block53;
            }
            if (PCOrder < 6) break block53;
            for (dof = 0; dof < nd; ++dof) {
                if (!isPC[dof]) continue;
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    if (!isPC[dof2]) continue;
                    for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                        if (!isPC[dof3]) continue;
                        for (dof4 = 0; dof4 <= dof3; ++dof4) {
                            if (!isPC[dof4]) continue;
                            for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                if (!isPC[dof5]) continue;
                                for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                    if (!isPC[dof6]) continue;
                                    v.set(count, sample.get(dof) * sample.get(dof2) * sample.get(dof3) * sample.get(dof4) * sample.get(dof5) * sample.get(dof6));
                                    ++count;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static int getNumParamsForOrder(int nd, int order) {
        if (order == 0) {
            return 1;
        }
        if (order == 1) {
            return nd;
        }
        if (order == 2) {
            return nd * (nd + 1) / 2;
        }
        if (order == 3) {
            return nd + nd * (nd - 1) + nd * (nd - 1) * (nd - 2) / 6;
        }
        if (order == 4) {
            return nd + 3 * nd * (nd - 1) / 2 + nd * (nd - 1) * (nd - 2) / 2 + nd * (nd - 1) * (nd - 2) * (nd - 3) / 24;
        }
        if (order == 5 || order == 6) {
            int count = 0;
            for (int dof = 0; dof < nd; ++dof) {
                for (int dof2 = 0; dof2 <= dof; ++dof2) {
                    for (int dof3 = 0; dof3 <= dof2; ++dof3) {
                        for (int dof4 = 0; dof4 <= dof3; ++dof4) {
                            for (int dof5 = 0; dof5 <= dof4; ++dof5) {
                                if (order == 6) {
                                    for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                        ++count;
                                    }
                                    continue;
                                }
                                ++count;
                            }
                        }
                    }
                }
            }
            return count;
        }
        throw new Error("ORDER NOT SUPPORTED IN SeriesFitter.getNumParamsForOrder: " + order);
    }

    public static int getNumParams(int nd, boolean includeConst, int order) {
        int ans = 0;
        if (includeConst) {
            ++ans;
        }
        for (int ord = 1; ord <= order; ++ord) {
            ans += SeriesFitter.getNumParamsForOrder(nd, ord);
        }
        return ans;
    }

    static int countTrue(boolean[] a) {
        int count = 0;
        for (boolean b : a) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    static DoubleMatrix2D getHessian(double[] coeffs, int numDOFs, boolean includeConst) {
        int count = numDOFs;
        if (includeConst) {
            ++count;
        }
        DoubleMatrix2D hess = DoubleFactory2D.dense.make(numDOFs, numDOFs);
        for (int a = 0; a < numDOFs; ++a) {
            for (int b = 0; b <= a; ++b) {
                double hessVal = coeffs[count];
                if (b == a) {
                    hessVal *= 2.0;
                }
                hess.set(a, b, hessVal);
                hess.set(b, a, hessVal);
                ++count;
            }
        }
        return hess;
    }

    static DoubleMatrix1D evalSeriesGradient(double[] coeffs, DoubleMatrix1D x, int nd, boolean includeConst, int order, int PCOrder, boolean[] isPC) {
        DoubleMatrix1D ans;
        block50: {
            int dof5;
            int dof4;
            int dof3;
            int dof2;
            int dof;
            int count;
            block49: {
                count = 0;
                if (includeConst) {
                    ++count;
                }
                ans = DoubleFactory1D.dense.make(nd);
                for (dof = 0; dof < nd; ++dof) {
                    ans.set(dof, coeffs[count]);
                    ++count;
                }
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 < dof; ++dof2) {
                        ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2));
                        ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof));
                        ++count;
                    }
                    ans.set(dof, ans.get(dof) + 2.0 * coeffs[count] * x.get(dof));
                    ++count;
                }
                if (order >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3));
                                ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3));
                                ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2));
                                ++count;
                            }
                        }
                    }
                } else if (PCOrder >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3));
                                ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3));
                                ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2));
                                ++count;
                            }
                        }
                    }
                }
                if (order >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4));
                                    ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4));
                                    ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4));
                                    ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3));
                                    ++count;
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4));
                                    ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4));
                                    ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4));
                                    ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3));
                                    ++count;
                                }
                            }
                        }
                    }
                }
                if (order >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof5));
                                        ans.set(dof5, ans.get(dof5) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        if (!isPC[dof5]) continue;
                                        ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4) * x.get(dof5));
                                        ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof5));
                                        ans.set(dof5, ans.get(dof5) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                if (order < 6) break block49;
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (dof3 = 0; dof3 <= dof2; ++dof3) {
                            for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                    for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                        ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                        ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                        ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                        ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof5) * x.get(dof6));
                                        ans.set(dof5, ans.get(dof5) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof6));
                                        ans.set(dof6, ans.get(dof6) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                break block50;
            }
            if (PCOrder < 6) break block50;
            for (dof = 0; dof < nd; ++dof) {
                if (!isPC[dof]) continue;
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    if (!isPC[dof2]) continue;
                    for (dof3 = 0; dof3 <= dof2; ++dof3) {
                        if (!isPC[dof3]) continue;
                        for (dof4 = 0; dof4 <= dof3; ++dof4) {
                            if (!isPC[dof4]) continue;
                            for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                if (!isPC[dof5]) continue;
                                for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                    if (!isPC[dof6]) continue;
                                    ans.set(dof, ans.get(dof) + coeffs[count] * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                    ans.set(dof2, ans.get(dof2) + coeffs[count] * x.get(dof) * x.get(dof3) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                    ans.set(dof3, ans.get(dof3) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof4) * x.get(dof5) * x.get(dof6));
                                    ans.set(dof4, ans.get(dof4) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof5) * x.get(dof6));
                                    ans.set(dof5, ans.get(dof5) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof6));
                                    ans.set(dof6, ans.get(dof6) + coeffs[count] * x.get(dof) * x.get(dof2) * x.get(dof3) * x.get(dof4) * x.get(dof5));
                                    ++count;
                                }
                            }
                        }
                    }
                }
            }
        }
        return ans;
    }

    static DoubleMatrix2D evalSeriesHessian(double[] coeffs, DoubleMatrix1D x, int nd, boolean includeConst, int order, int PCOrder, boolean[] isPC) {
        DoubleMatrix2D ans;
        block49: {
            int dof5;
            int dof4;
            int dof3;
            int dof2;
            int dof;
            int count;
            block48: {
                count = nd;
                if (includeConst) {
                    ++count;
                }
                ans = DoubleFactory2D.dense.make(nd, nd);
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 < dof; ++dof2) {
                        ans.set(dof, dof2, coeffs[count]);
                        ans.set(dof2, dof, coeffs[count]);
                        ++count;
                    }
                    ans.set(dof, dof, 2.0 * coeffs[count]);
                    ++count;
                }
                if (order >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            dof3 = 0;
                            while (dof3 <= dof2) {
                                SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3++);
                                ++count;
                            }
                        }
                    }
                } else if (PCOrder >= 3) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3);
                                ++count;
                            }
                        }
                    }
                }
                if (order >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                dof4 = 0;
                                while (dof4 <= dof3) {
                                    SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4++);
                                    ++count;
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 4) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4);
                                    ++count;
                                }
                            }
                        }
                    }
                }
                if (order >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    dof5 = 0;
                                    while (dof5 <= dof4) {
                                        SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4, dof5++);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                } else if (PCOrder >= 5) {
                    for (dof = 0; dof < nd; ++dof) {
                        if (!isPC[dof]) continue;
                        for (dof2 = 0; dof2 <= dof; ++dof2) {
                            if (!isPC[dof2]) continue;
                            for (dof3 = 0; dof3 <= dof2; ++dof3) {
                                if (!isPC[dof3]) continue;
                                for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                    if (!isPC[dof4]) continue;
                                    for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                        if (!isPC[dof5]) continue;
                                        SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4, dof5);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                if (order < 6) break block48;
                for (dof = 0; dof < nd; ++dof) {
                    for (dof2 = 0; dof2 <= dof; ++dof2) {
                        for (dof3 = 0; dof3 <= dof2; ++dof3) {
                            for (dof4 = 0; dof4 <= dof3; ++dof4) {
                                for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                    int dof6 = 0;
                                    while (dof6 <= dof5) {
                                        SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4, dof5, dof6++);
                                        ++count;
                                    }
                                }
                            }
                        }
                    }
                }
                break block49;
            }
            if (PCOrder < 6) break block49;
            for (dof = 0; dof < nd; ++dof) {
                if (!isPC[dof]) continue;
                for (dof2 = 0; dof2 <= dof; ++dof2) {
                    if (!isPC[dof2]) continue;
                    for (dof3 = 0; dof3 <= dof2; ++dof3) {
                        if (!isPC[dof3]) continue;
                        for (dof4 = 0; dof4 <= dof3; ++dof4) {
                            if (!isPC[dof4]) continue;
                            for (dof5 = 0; dof5 <= dof4; ++dof5) {
                                if (!isPC[dof5]) continue;
                                for (int dof6 = 0; dof6 <= dof5; ++dof6) {
                                    if (!isPC[dof6]) continue;
                                    SeriesFitter.updateSeriesHessian(ans, x, coeffs[count], dof, dof2, dof3, dof4, dof5, dof6);
                                    ++count;
                                }
                            }
                        }
                    }
                }
            }
        }
        return ans;
    }

    static void updateSeriesHessian(DoubleMatrix2D hess, DoubleMatrix1D x, double coeff, int ... dofs) {
        int deg = dofs.length;
        for (int d1 = 0; d1 < deg; ++d1) {
            for (int d2 = 0; d2 < d1; ++d2) {
                double dhess = coeff;
                for (int d3 = 0; d3 < deg; ++d3) {
                    if (d3 == d1 || d3 == d2) continue;
                    dhess *= x.get(dofs[d3]);
                }
                hess.set(dofs[d1], dofs[d2], hess.get(dofs[d1], dofs[d2]) + dhess);
                hess.set(dofs[d2], dofs[d1], hess.get(dofs[d2], dofs[d1]) + dhess);
            }
        }
    }

    private static class SampleCutoffCrossing
    implements Comparable {
        int sampleIndex;
        double crossingPoint;
        double quadTerm;
        double linTerm;
        double constTerm;
        boolean upperRestraint = false;

        public SampleCutoffCrossing(int sampleIndex, double crossingPoint, boolean upperRestraint) {
            this.sampleIndex = sampleIndex;
            this.crossingPoint = crossingPoint;
            this.upperRestraint = upperRestraint;
        }

        public int compareTo(Object o) {
            return Double.valueOf(this.crossingPoint).compareTo(((SampleCutoffCrossing)o).crossingPoint);
        }
    }
}

