/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.energy.forcefield.ResPairCache;
import edu.duke.cs.osprey.energy.forcefield.ResPairEnergy;
import edu.duke.cs.osprey.energy.forcefield.ResidueForcefieldEnergy;
import edu.duke.cs.osprey.energy.forcefield.SingleResEnergy;
import edu.duke.cs.osprey.energy.forcefield.SparseFFEnergy;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;
import java.util.ArrayList;

public class SAPE
implements Serializable {
    MoleculeModifierAndScorer mofStandalone;
    ForcefieldParams ffParams;
    ArrayList<int[]> interactingRes;
    ArrayList<ArrayList<int[]>> atomPairList;
    EnergyFunction sharedMolecEnergyFunction = null;

    public SAPE(MoleculeModifierAndScorer objFcn, double distCutoff, DoubleMatrix1D[] sampAbs) {
        EnergyFunction mainEF = objFcn.getEfunc();
        objFcn.setEfunc(null);
        this.mofStandalone = (MoleculeModifierAndScorer)ObjectIO.deepCopy(objFcn);
        objFcn.setEfunc(mainEF);
        Molecule standaloneMolec = this.mofStandalone.getMolec();
        this.ffParams = null;
        this.findFFParams(mainEF);
        if (this.ffParams == null) {
            throw new RuntimeException("ERROR: Trying to approximate energy function with SAPE but can't find any forcefield-type energies");
        }
        this.pickAtomPairs(mainEF, distCutoff, sampAbs);
        EnergyFunction standaloneEFcn = this.makeSparseEFcn(standaloneMolec);
        this.mofStandalone.setEfunc(standaloneEFcn);
    }

    private void pickAtomPairs(EnergyFunction EFToApprox, double distCutoff, DoubleMatrix1D[] sampAbs) {
        this.interactingRes = new ArrayList();
        this.addInteractingRes(EFToApprox);
        if (this.interactingRes.isEmpty()) {
            throw new RuntimeException("ERROR: Trying to get SAPE approximation of energy function with no electrostatic/VDW interactions");
        }
        Molecule molec = this.mofStandalone.getMolec();
        ArrayList<boolean[][]> atomPairsCloseEnough = new ArrayList<boolean[][]>();
        for (int[] resPair : this.interactingRes) {
            Residue res1 = (Residue)molec.residues.get(resPair[0]);
            Residue res2 = (Residue)molec.residues.get(resPair[1]);
            atomPairsCloseEnough.add(new boolean[res1.atoms.size()][res2.atoms.size()]);
        }
        for (DoubleMatrix1D samp : sampAbs) {
            this.mofStandalone.setDOFs(samp);
            for (int resPairNum = 0; resPairNum < this.interactingRes.size(); ++resPairNum) {
                Residue res1 = (Residue)molec.residues.get(this.interactingRes.get(resPairNum)[0]);
                Residue res2 = (Residue)molec.residues.get(this.interactingRes.get(resPairNum)[1]);
                for (int at1 = 0; at1 < res1.atoms.size(); ++at1) {
                    for (int at2 = 0; at2 < res2.atoms.size() && (res1 != res2 || at2 < at1); ++at2) {
                        double dist = VectorAlgebra.distance(res1.coords, at1, res2.coords, at2);
                        if (!(dist < distCutoff)) continue;
                        ((boolean[][])atomPairsCloseEnough.get((int)resPairNum))[at1][at2] = true;
                    }
                }
            }
        }
        this.atomPairList = new ArrayList();
        for (boolean[][] closenessMatrix : atomPairsCloseEnough) {
            ArrayList<int[]> atomPairsAtResPair = new ArrayList<int[]>();
            for (int at1 = 0; at1 < closenessMatrix.length; ++at1) {
                for (int at2 = 0; at2 < closenessMatrix[at1].length; ++at2) {
                    if (!closenessMatrix[at1][at2]) continue;
                    atomPairsAtResPair.add(new int[]{at1, at2});
                }
            }
            this.atomPairList.add(atomPairsAtResPair);
        }
        for (int resPairNum = this.interactingRes.size() - 1; resPairNum >= 0; --resPairNum) {
            if (!this.atomPairList.get(resPairNum).isEmpty()) continue;
            this.atomPairList.remove(resPairNum);
            this.interactingRes.remove(resPairNum);
        }
    }

    private void addInteractingRes(EnergyFunction EFToApprox) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(EFToApprox instanceof MultiTermEnergyFunction)) break block2;
                        for (EnergyFunction term : ((MultiTermEnergyFunction)EFToApprox).getTerms()) {
                            this.addInteractingRes(term);
                        }
                        break block3;
                    }
                    if (!(EFToApprox instanceof SingleResEnergy)) break block4;
                    Residue res = ((SingleResEnergy)EFToApprox).getRes();
                    this.interactingRes.add(new int[]{res.indexInMolecule, res.indexInMolecule});
                    break block3;
                }
                if (!(EFToApprox instanceof ResPairEnergy)) break block5;
                Residue res1 = ((ResPairEnergy)EFToApprox).getRes1();
                Residue res2 = ((ResPairEnergy)EFToApprox).getRes2();
                this.interactingRes.add(new int[]{res1.indexInMolecule, res2.indexInMolecule});
                break block3;
            }
            if (!(EFToApprox instanceof ResidueForcefieldEnergy)) break block3;
            for (ResPairCache.ResPair rp : ((ResidueForcefieldEnergy)EFToApprox).resPairs) {
                this.interactingRes.add(new int[]{rp.resIndex1, rp.resIndex2});
            }
        }
    }

    private void findFFParams(EnergyFunction EFToApprox) {
        if (EFToApprox instanceof ResidueForcefieldEnergy) {
            this.ffParams = ((ResidueForcefieldEnergy)EFToApprox).resPairCache.ffparams;
            return;
        }
        if (EFToApprox instanceof MultiTermEnergyFunction) {
            for (EnergyFunction term : ((MultiTermEnergyFunction)EFToApprox).getTerms()) {
                this.findFFParams(term);
                if (this.ffParams == null) continue;
                return;
            }
        } else if (EFToApprox instanceof SingleResEnergy) {
            this.ffParams = ((SingleResEnergy)EFToApprox).getFFParams();
        } else if (EFToApprox instanceof ResPairEnergy) {
            this.ffParams = ((ResPairEnergy)EFToApprox).getFFParams();
        }
    }

    EnergyFunction makeSparseEFcn(Molecule m) {
        MultiTermEnergyFunction ans = new MultiTermEnergyFunction();
        for (int resPairNum = 0; resPairNum < this.interactingRes.size(); ++resPairNum) {
            int[] resPair = this.interactingRes.get(resPairNum);
            Residue res1 = (Residue)m.residues.get(resPair[0]);
            Residue res2 = (Residue)m.residues.get(resPair[1]);
            ArrayList<Atom[]> interactingAtomPairs = new ArrayList<Atom[]>();
            for (int[] atNumPair : this.atomPairList.get(resPairNum)) {
                Atom atom1 = res1.atoms.get(atNumPair[0]);
                Atom atom2 = res2.atoms.get(atNumPair[1]);
                interactingAtomPairs.add(new Atom[]{atom1, atom2});
            }
            SparseFFEnergy sparseE = new SparseFFEnergy(interactingAtomPairs, this.ffParams);
            ans.addTerm(sparseE);
        }
        return ans;
    }

    public void assignSharedMolecule(Molecule m) {
        this.sharedMolecEnergyFunction = this.makeSparseEFcn(m);
    }

    public double getEnergyStandalone(DoubleMatrix1D coordVals) {
        return this.mofStandalone.getValue(coordVals);
    }

    public double getEnergySharedMolec() {
        if (this.sharedMolecEnergyFunction == null) {
            throw new RuntimeException("ERROR: Haven't initialized shared-molecule energy function for SAPE");
        }
        return this.sharedMolecEnergyFunction.getEnergy();
    }
}

