/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix.epic;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.minimization.ObjectiveFunction;
import java.util.Random;
import org.apache.commons.math3.special.Erf;

public class GaussianLowEnergySampler {
    double EPICThresh1;
    ObjectiveFunction of;
    DoubleMatrix1D DOFmin;
    DoubleMatrix1D DOFmax;
    int numDOFs;
    DoubleMatrix1D center;
    DoubleMatrix1D sigmas;
    Random random = new Random();

    public GaussianLowEnergySampler(double thresh, ObjectiveFunction of, DoubleMatrix1D DOFmin, DoubleMatrix1D DOFmax, DoubleMatrix1D center) {
        this.EPICThresh1 = thresh;
        this.of = of;
        this.DOFmin = DOFmin;
        this.DOFmax = DOFmax;
        this.center = center;
        this.numDOFs = DOFmin.size();
        double sigmaVal = this.chooseNumSigmas();
        this.sigmas = DoubleFactory1D.dense.make(this.numDOFs);
        for (int dofNum = 0; dofNum < this.numDOFs; ++dofNum) {
            double goodRegionLB = this.bisectForGoodRegionEnd(dofNum, DOFmin.get(dofNum));
            double goodRegionUB = this.bisectForGoodRegionEnd(dofNum, DOFmax.get(dofNum));
            double sigma = goodRegionUB - center.get(dofNum) >= center.get(dofNum) - goodRegionLB ? (goodRegionUB - center.get(dofNum)) / sigmaVal : (center.get(dofNum) - goodRegionLB) / sigmaVal;
            this.sigmas.set(dofNum, sigma);
        }
    }

    private double chooseNumSigmas() {
        double insideTarget = 0.25;
        double fullInteg = 1.0;
        if (this.numDOFs % 2 == 1) {
            fullInteg = Math.sqrt(1.5707963267948966);
        }
        for (int k = this.numDOFs - 2; k > 0; k -= 2) {
            fullInteg *= (double)k;
        }
        double target = fullInteg * insideTarget;
        double epsilon = 0.02;
        double lo = 0.0;
        double hi = 1.0;
        while (this.radialIntegral(hi, this.numDOFs - 1) < target) {
            hi *= 2.0;
        }
        do {
            double mid;
            double midVal;
            if ((midVal = this.radialIntegral(mid = (hi + lo) / 2.0, this.numDOFs - 1)) < target) {
                lo = mid;
                continue;
            }
            hi = mid;
        } while (Math.abs(hi - lo) > epsilon * Math.abs(hi));
        double numSigmas = (hi + lo) / 2.0;
        return numSigmas;
    }

    private double radialIntegral(double a, int k) {
        if (k > 1) {
            return (double)(k - 1) * this.radialIntegral(a, k - 2) - Math.pow(a, k - 1) * Math.exp(-a * a / 2.0);
        }
        if (k == 1) {
            return 1.0 - Math.exp(-a * a / 2.0);
        }
        if (k == 0) {
            return Math.sqrt(1.5707963267948966) * Erf.erf((double)(a / Math.sqrt(2.0)));
        }
        throw new RuntimeException("ERROR: Negative k not supported here: " + k);
    }

    private double bisectForGoodRegionEnd(int dofNum, double voxEnd) {
        this.of.setDOFs(this.center);
        double centerE = this.of.getValForDOF(dofNum, this.center.get(dofNum));
        if (this.of.getValForDOF(dofNum, voxEnd) <= centerE + this.EPICThresh1) {
            return voxEnd;
        }
        double hi = voxEnd;
        double lo = this.center.get(dofNum);
        double epsilon = 0.1;
        do {
            double mid;
            double midVal;
            if ((midVal = this.of.getValForDOF(dofNum, mid = (hi + lo) / 2.0)) <= centerE + this.EPICThresh1) {
                lo = mid;
                continue;
            }
            hi = mid;
        } while (Math.abs(hi - lo) > epsilon * Math.abs(hi - this.center.get(dofNum)));
        return hi;
    }

    DoubleMatrix1D nextSample() {
        DoubleMatrix1D ans = DoubleFactory1D.dense.make(this.numDOFs);
        for (int dofNum = 0; dofNum < this.numDOFs; ++dofNum) {
            do {
                double x = this.center.get(dofNum) + this.sigmas.get(dofNum) * this.random.nextGaussian();
                ans.set(dofNum, x);
            } while (ans.get(dofNum) < this.DOFmin.get(dofNum) || ans.get(dofNum) > this.DOFmax.get(dofNum));
        }
        return ans;
    }
}

