/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.TermECalculator;
import edu.duke.cs.osprey.structure.Residue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;

public class ReferenceEnergies
implements Serializable {
    ConfSpace cSpace;
    ArrayList<TreeMap<String, Double>> eRefMatrix = new ArrayList();

    public ReferenceEnergies(ConfSpace cs) {
        this.cSpace = cs;
        this.computeERef();
    }

    private void computeERef() {
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            System.out.println("Starting intra energy calculations for position " + pos);
            TermECalculator intraECalc = new TermECalculator(this.cSpace, new ArrayList<Residue>(), false, true, null, null, false, pos);
            ArrayList intraEList = (ArrayList)intraECalc.doCalculation();
            TreeMap<String, Double> posERef = new TreeMap<String, Double>();
            ArrayList<RC> RCList = this.cSpace.posFlex.get((int)pos).RCs;
            for (int rcNum = 0; rcNum < RCList.size(); ++rcNum) {
                String AAType = RCList.get((int)rcNum).AAType;
                double intraE = (Double)intraEList.get(rcNum);
                if (posERef.containsKey(AAType)) {
                    posERef.put(AAType, Math.min(intraE, (Double)posERef.get(AAType)));
                    continue;
                }
                posERef.put(AAType, intraE);
            }
            this.eRefMatrix.add(posERef);
        }
    }

    void correctEnergyMatrix(EnergyMatrix emat) {
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            ArrayList<RC> RCList = this.cSpace.posFlex.get((int)pos).RCs;
            for (int rcNum = 0; rcNum < RCList.size(); ++rcNum) {
                String AAType = RCList.get((int)rcNum).AAType;
                double eRef = this.eRefMatrix.get(pos).get(AAType);
                if (eRef == Double.POSITIVE_INFINITY) {
                    eRef = 0.0;
                }
                double Euncorr = emat.getOneBody(pos, rcNum);
                double Ecorr = Euncorr - eRef;
                emat.setOneBody(pos, rcNum, Ecorr);
            }
        }
    }

    public double confERef(int[] conf) {
        double totERef = 0.0;
        for (int pos = 0; pos < this.cSpace.numPos; ++pos) {
            totERef += this.posERef(pos, conf[pos]);
        }
        return totERef;
    }

    public double posERef(int pos, int rc) {
        return this.eRefMatrix.get(pos).get(this.cSpace.posFlex.get((int)pos).RCs.get((int)rc).AAType);
    }
}

