/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ematrix;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleEnergyCalculator;

public class LazyEnergyMatrix
extends EnergyMatrix {
    private static final long serialVersionUID = -6363593602037378135L;
    private static final double DefaultNullVal = Double.NaN;
    private SimpleEnergyCalculator ecalc;
    private double nullVal;

    public LazyEnergyMatrix(LazyEnergyMatrix other) {
        super(other);
        this.init(other.ecalc, other.nullVal);
    }

    public LazyEnergyMatrix(EnergyMatrix emat, SimpleEnergyCalculator ecalc) {
        this(emat, ecalc, Double.NaN);
    }

    public LazyEnergyMatrix(EnergyMatrix emat, SimpleEnergyCalculator ecalc, double nullVal) {
        super(emat);
        this.init(ecalc, nullVal);
    }

    public LazyEnergyMatrix(ConfSpace confSpace, double pruningInterval, SimpleEnergyCalculator ecalc) {
        this(confSpace, pruningInterval, ecalc, Double.NaN);
    }

    public LazyEnergyMatrix(ConfSpace confSpace, double pruningInterval, SimpleEnergyCalculator ecalc, double nullVal) {
        super(confSpace, pruningInterval);
        this.init(ecalc, nullVal);
        this.clear();
    }

    private void init(SimpleEnergyCalculator ecalc, double nullVal) {
        this.ecalc = ecalc;
        this.nullVal = nullVal;
    }

    @Override
    public Double getOneBody(int res, int conf) {
        double val = super.getOneBody(res, conf);
        if (this.hasVal(val)) {
            return val;
        }
        val = this.ecalc.calcSingle((int)res, (int)conf).energy;
        super.setOneBody(res, conf, val);
        return val;
    }

    @Override
    public Double getPairwise(int res1, int conf1, int res2, int conf2) {
        double val = super.getPairwise(res1, conf1, res2, conf2);
        if (this.hasVal(val)) {
            return val;
        }
        val = this.ecalc.calcPair((int)res1, (int)conf1, (int)res2, (int)conf2).energy;
        super.setPairwise(res1, conf1, res2, conf2, val);
        return val;
    }

    public boolean hasOneBody(int res, int conf) {
        return this.hasVal(super.getOneBody(res, conf));
    }

    public boolean hasPairwise(int res1, int conf1, int res2, int conf2) {
        return this.hasVal(super.getPairwise(res1, conf1, res2, conf2));
    }

    public void clear() {
        for (int res1 = 0; res1 < this.getNumPos(); ++res1) {
            for (int conf1 = 0; conf1 < this.getNumConfAtPos(res1); ++conf1) {
                this.clearOneBody(res1, conf1);
                for (int res2 = 0; res2 < res1; ++res2) {
                    for (int conf2 = 0; conf2 < this.getNumConfAtPos(res2); ++conf2) {
                        this.clearPairwise(res1, conf1, res2, conf2);
                    }
                }
            }
        }
    }

    public void clearOneBody(int res, int conf) {
        super.setOneBody(res, conf, this.nullVal);
    }

    public void clearPairwise(int res1, int conf1, int res2, int conf2) {
        super.setPairwise(res1, conf1, res2, conf2, this.nullVal);
    }

    private boolean hasVal(double val) {
        if (Double.isNaN(this.nullVal)) {
            return !Double.isNaN(val);
        }
        return val != this.nullVal;
    }
}

