/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.dof.deeper.perts.SturmSolver;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;
import edu.duke.cs.osprey.tools.RotationMatrix;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.io.Serializable;
import java.util.List;

public class TripeptideClosure
implements Serializable {
    double pi = Math.PI;
    double two_pi = 2.0 * this.pi;
    double deg2rad = this.pi / 180.0;
    double rad2deg = 180.0 / this.pi;
    int max_soln = 16;
    int deg_pol = 16;
    int print_level = 0;
    double[] len0 = new double[6];
    double[] b_ang0 = new double[7];
    double[] t_ang0 = new double[2];
    double aa13_min_sqr;
    double aa13_max_sqr;
    double[] delta = new double[4];
    double[] xi = new double[3];
    double[] eta = new double[3];
    double[] alpha = new double[3];
    double[] theta = new double[3];
    double[] cos_alpha = new double[3];
    double[] sin_alpha = new double[3];
    double[] cos_theta = new double[3];
    double[] sin_theta = new double[3];
    double[] cos_delta = new double[4];
    double[] sin_delta = new double[4];
    double[] cos_xi = new double[3];
    double[] cos_eta = new double[3];
    double[] sin_xi = new double[3];
    double[] sin_eta = new double[3];
    double[] r_a1a3 = new double[3];
    double[] r_a1n1 = new double[3];
    double[] r_a3c3 = new double[3];
    double[] b_a1a3 = new double[3];
    double[] b_a1n1 = new double[3];
    double[] b_a3c3 = new double[3];
    double[] len_na = new double[3];
    double[] len_ac = new double[3];
    double[] len_aa = new double[3];
    double[][] C0 = new double[3][3];
    double[][] C1 = new double[3][3];
    double[][] C2 = new double[3][3];
    double[][] Q = new double[5][17];
    double[][] R = new double[3][17];
    int n_soln;
    SturmSolver sturm;

    public TripeptideClosure(List<Residue> tripepRes) {
        int a;
        double[] b_len = new double[6];
        double[] b_ang = new double[7];
        double[] t_ang = new double[2];
        double[][] NCoord = new double[3][3];
        double[][] CACoord = new double[3][3];
        double[][] CCoord = new double[3][3];
        for (int a2 = 0; a2 < 3; ++a2) {
            NCoord[a2] = tripepRes.get(a2).getCoordsByAtomName("N");
            CACoord[a2] = tripepRes.get(a2).getCoordsByAtomName("CA");
            CCoord[a2] = tripepRes.get(a2).getCoordsByAtomName("C");
        }
        double[][] vec = new double[][]{VectorAlgebra.subtract(CACoord[0], NCoord[0]), VectorAlgebra.subtract(CCoord[0], CACoord[0]), VectorAlgebra.subtract(NCoord[1], CCoord[0]), VectorAlgebra.subtract(CACoord[1], NCoord[1]), VectorAlgebra.subtract(CCoord[1], CACoord[1]), VectorAlgebra.subtract(NCoord[2], CCoord[1]), VectorAlgebra.subtract(CACoord[2], NCoord[2]), VectorAlgebra.subtract(CCoord[2], CACoord[2])};
        for (a = 0; a < 6; ++a) {
            b_len[a] = VectorAlgebra.norm(vec[a + 1]);
        }
        for (a = 0; a < 7; ++a) {
            b_ang[a] = Protractor.getAngleRadians(VectorAlgebra.scale(vec[a], -1.0), vec[a + 1]);
        }
        t_ang[0] = this.calc_dih_ang(vec[1], vec[2], vec[3]);
        t_ang[1] = this.calc_dih_ang(vec[4], vec[5], vec[6]);
        this.initialize_loop_closure(b_len, b_ang, t_ang);
    }

    public void initialize_loop_closure(double[] b_len, double[] b_ang, double[] t_ang) {
        int i;
        double[] rr_a1 = new double[3];
        double[] rr_c1 = new double[3];
        double[] rr_n2 = new double[3];
        double[] rr_a2 = new double[3];
        double[] rr_n2a2_ref = new double[3];
        double[] rr_c1a1 = new double[3];
        double[] rr_a1a2 = new double[3];
        double[] dr = new double[3];
        double[] bb_c1a1 = new double[3];
        double[] bb_a1a2 = new double[3];
        double[] bb_a2n2 = new double[3];
        double[] p = new double[4];
        double[] mulpro = new double[3];
        double[] tmp_val = new double[3];
        double tol_secant = 1.0E-15;
        int max_iter_sturm = 100;
        int max_iter_secant = 20;
        this.sturm = new SturmSolver(tol_secant, max_iter_sturm, max_iter_secant);
        for (i = 0; i < 6; ++i) {
            this.len0[i] = b_len[i];
        }
        for (i = 0; i < 7; ++i) {
            this.b_ang0[i] = b_ang[i];
        }
        for (i = 0; i < 2; ++i) {
            this.t_ang0[i] = t_ang[i];
        }
        for (i = 0; i < 3; ++i) {
            rr_c1[i] = 0.0;
        }
        for (i = 0; i < 2; ++i) {
            double len1;
            int j;
            rr_a1[0] = Math.cos(this.b_ang0[3 * i + 1]) * this.len0[3 * i];
            rr_a1[1] = Math.sin(this.b_ang0[3 * i + 1]) * this.len0[3 * i];
            rr_a1[2] = 0.0;
            rr_n2[0] = this.len0[3 * i + 1];
            rr_n2[1] = 0.0;
            rr_n2[2] = 0.0;
            for (j = 0; j < 3; ++j) {
                rr_c1a1[j] = rr_a1[j] - rr_c1[j];
            }
            rr_n2a2_ref[0] = -Math.cos(this.b_ang0[3 * i + 2]) * this.len0[3 * i + 2];
            rr_n2a2_ref[1] = Math.sin(this.b_ang0[3 * i + 2]) * this.len0[3 * i + 2];
            rr_n2a2_ref[2] = 0.0;
            RotationMatrix Us = new RotationMatrix(1.0, 0.0, 0.0, this.t_ang0[i], true);
            mulpro = Us.rotateVector(rr_n2a2_ref);
            for (j = 0; j < 3; ++j) {
                rr_a2[j] = mulpro[j] + rr_n2[j];
                rr_a1a2[j] = rr_a2[j] - rr_a1[j];
                dr[j] = rr_a1a2[j];
            }
            double len2 = VectorAlgebra.dot(dr, dr);
            this.len_aa[i + 1] = len1 = Math.sqrt(len2);
            for (j = 0; j < 3; ++j) {
                bb_c1a1[j] = rr_c1a1[j] / this.len0[3 * i];
                bb_a1a2[j] = rr_a1a2[j] / len1;
                bb_a2n2[j] = (rr_n2[j] - rr_a2[j]) / this.len0[3 * i + 2];
            }
            for (j = 0; j < 3; ++j) {
                tmp_val[j] = -bb_a1a2[j];
            }
            this.xi[i + 1] = Protractor.getAngleRadians(tmp_val, bb_a2n2);
            for (j = 0; j < 3; ++j) {
                tmp_val[j] = -bb_c1a1[j];
            }
            this.eta[i] = Protractor.getAngleRadians(bb_a1a2, tmp_val);
            this.delta[i + 1] = this.calc_dih_ang(bb_c1a1, bb_a1a2, bb_a2n2);
            this.delta[i + 1] = this.pi - this.delta[i + 1];
        }
        double a_min = b_ang[3] - (this.xi[1] + this.eta[1]);
        double a_max = Math.min(b_ang[3] + (this.xi[1] + this.eta[1]), this.pi);
        this.aa13_min_sqr = Math.pow(this.len_aa[1], 2.0) + Math.pow(this.len_aa[2], 2.0) - 2.0 * this.len_aa[1] * this.len_aa[2] * Math.cos(a_min);
        this.aa13_max_sqr = Math.pow(this.len_aa[1], 2.0) + Math.pow(this.len_aa[2], 2.0) - 2.0 * this.len_aa[1] * this.len_aa[2] * Math.cos(a_max);
    }

    public int solve_3pep_poly(double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3, double[][][] r_soln_n, double[][][] r_soln_a, double[][][] r_soln_c) {
        double[] poly_coeff = new double[this.deg_pol + 1];
        double[] roots = new double[this.max_soln];
        this.get_input_angles(r_n1, r_a1, r_a3, r_c3);
        if (this.n_soln == 0) {
            return 0;
        }
        this.get_poly_coeff(poly_coeff);
        this.n_soln = this.sturm.solve_sturm(this.deg_pol, poly_coeff, roots);
        if (this.n_soln == 0) {
            return 0;
        }
        this.coord_from_poly_roots(roots, r_n1, r_a1, r_a3, r_c3, r_soln_n, r_soln_a, r_soln_c);
        return this.n_soln;
    }

    public void get_input_angles(double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3) {
        int i;
        double[] tmp_val = new double[3];
        char[] cone_type = new char[2];
        this.n_soln = this.max_soln;
        for (i = 0; i < 3; ++i) {
            this.r_a1a3[i] = r_a3[i] - r_a1[i];
        }
        double dr_sqr = VectorAlgebra.dot(this.r_a1a3, this.r_a1a3);
        this.len_aa[0] = Math.sqrt(dr_sqr);
        if (dr_sqr < this.aa13_min_sqr || dr_sqr > this.aa13_max_sqr) {
            this.n_soln = 0;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.r_a1n1[i] = r_n1[i] - r_a1[i];
        }
        this.len_na[0] = Math.sqrt(VectorAlgebra.dot(this.r_a1n1, this.r_a1n1));
        this.len_na[1] = this.len0[2];
        this.len_na[2] = this.len0[5];
        for (i = 0; i < 3; ++i) {
            this.r_a3c3[i] = r_c3[i] - r_a3[i];
        }
        this.len_ac[0] = this.len0[0];
        this.len_ac[1] = this.len0[3];
        this.len_ac[2] = Math.sqrt(VectorAlgebra.dot(this.r_a3c3, this.r_a3c3));
        for (i = 0; i < 3; ++i) {
            this.b_a1n1[i] = this.r_a1n1[i] / this.len_na[0];
            this.b_a3c3[i] = this.r_a3c3[i] / this.len_ac[2];
            this.b_a1a3[i] = this.r_a1a3[i] / this.len_aa[0];
        }
        for (i = 0; i < 3; ++i) {
            tmp_val[i] = -this.b_a1n1[i];
        }
        this.delta[3] = this.calc_dih_ang(tmp_val, this.b_a1a3, this.b_a3c3);
        this.delta[0] = this.delta[3];
        for (i = 0; i < 3; ++i) {
            tmp_val[i] = -this.b_a1a3[i];
        }
        this.xi[0] = Protractor.getAngleRadians(tmp_val, this.b_a1n1);
        this.eta[2] = Protractor.getAngleRadians(this.b_a1a3, this.b_a3c3);
        for (i = 0; i < 3; ++i) {
            this.cos_delta[i + 1] = Math.cos(this.delta[i + 1]);
            this.sin_delta[i + 1] = Math.sin(this.delta[i + 1]);
            this.cos_xi[i] = Math.cos(this.xi[i]);
            this.sin_xi[i] = Math.sin(this.xi[i]);
            this.cos_eta[i] = Math.cos(this.eta[i]);
            this.sin_eta[i] = Math.sin(this.eta[i]);
        }
        this.cos_delta[0] = this.cos_delta[3];
        this.sin_delta[0] = this.sin_delta[3];
        this.theta[0] = this.b_ang0[0];
        this.theta[1] = this.b_ang0[3];
        this.theta[2] = this.b_ang0[6];
        for (i = 0; i < 3; ++i) {
            this.cos_theta[i] = Math.cos(this.theta[i]);
        }
        this.cos_alpha[0] = -(Math.pow(this.len_aa[0], 2.0) + Math.pow(this.len_aa[1], 2.0) - Math.pow(this.len_aa[2], 2.0)) / (2.0 * this.len_aa[0] * this.len_aa[1]);
        this.alpha[0] = Math.acos(this.cos_alpha[0]);
        this.sin_alpha[0] = Math.sin(this.alpha[0]);
        this.cos_alpha[1] = (Math.pow(this.len_aa[1], 2.0) + Math.pow(this.len_aa[2], 2.0) - Math.pow(this.len_aa[0], 2.0)) / (2.0 * this.len_aa[1] * this.len_aa[2]);
        this.alpha[1] = Math.acos(this.cos_alpha[1]);
        this.sin_alpha[1] = Math.sin(this.alpha[1]);
        this.alpha[2] = this.pi - this.alpha[0] + this.alpha[1];
        this.cos_alpha[2] = Math.cos(this.alpha[2]);
        this.sin_alpha[2] = Math.sin(this.alpha[2]);
        if (this.print_level > 0) {
            System.out.printf("xi = %9.4f%9.4f%9.4f\n", this.xi[0] * this.rad2deg, this.xi[1] * this.rad2deg, this.xi[2] * this.rad2deg);
            System.out.printf("eta = %9.4f%9.4f%9.4f\n", this.eta[0] * this.rad2deg, this.eta[1] * this.rad2deg, this.eta[2] * this.rad2deg);
            System.out.printf("delta = %9.4f%9.4f%9.4f\n", this.delta[1] * this.rad2deg, this.delta[2] * this.rad2deg, this.delta[3] * this.rad2deg);
            System.out.printf("theta = %9.4f%9.4f%9.4f\n", this.theta[0] * this.rad2deg, this.theta[1] * this.rad2deg, this.theta[2] * this.rad2deg);
            System.out.printf("alpha = %9.4f%9.4f%9.4f\n", this.alpha[0] * this.rad2deg, this.alpha[1] * this.rad2deg, this.alpha[2] * this.rad2deg);
        }
        for (i = 0; i < 3; ++i) {
            this.test_two_cone_existence_soln(this.theta[i], this.xi[i], this.eta[i], this.alpha[i], cone_type);
            if (this.n_soln != 0) continue;
            return;
        }
    }

    public void test_two_cone_existence_soln(double tt, double kx, double et, double ap, char[] cone_type) {
        boolean complicated = false;
        this.n_soln = this.max_soln;
        double ap1 = ap;
        double kx1 = kx;
        double et1 = et;
        double at = ap1 - tt;
        double ex = kx1 + et1;
        double abs_at = Math.abs(at);
        if (abs_at > ex) {
            this.n_soln = 0;
            return;
        }
        if (complicated) {
            double cos_tx1 = Math.cos(tt + kx1);
            double cos_tx2 = Math.cos(tt - kx1);
            double cos_te1 = Math.cos(tt + et1);
            double cos_te2 = Math.cos(tt - et1);
            double cos_ea1 = Math.cos(et1 + ap1);
            double cos_ea2 = Math.cos(et1 - ap1);
            double cos_xa1 = Math.cos(kx1 + ap1);
            double cos_xa2 = Math.cos(kx1 - ap1);
            boolean s1 = false;
            boolean s2 = false;
            boolean t1 = false;
            boolean t2 = false;
            if ((cos_te1 - cos_xa2) * (cos_te1 - cos_xa1) <= 0.0) {
                s1 = false;
            }
            if ((cos_te2 - cos_xa2) * (cos_te2 - cos_xa1) <= 0.0) {
                s2 = false;
            }
            if ((cos_tx1 - cos_ea2) * (cos_tx1 - cos_ea1) <= 0.0) {
                t1 = false;
            }
            if ((cos_tx2 - cos_ea2) * (cos_tx2 - cos_ea1) <= 0.0) {
                t2 = false;
            }
        }
    }

    public void get_poly_coeff(double[] poly_coeff) {
        int p_f21;
        int p_f22;
        int j;
        int i;
        double[] B0 = new double[3];
        double[] B1 = new double[3];
        double[] B2 = new double[3];
        double[] B3 = new double[3];
        double[] B4 = new double[3];
        double[] B5 = new double[3];
        double[] B6 = new double[3];
        double[] B7 = new double[3];
        double[] B8 = new double[3];
        double[][] u11 = new double[5][5];
        double[][] u12 = new double[5][5];
        double[][] u13 = new double[5][5];
        double[][] u31 = new double[5][5];
        double[][] u32 = new double[5][5];
        double[][] u33 = new double[5][5];
        double[][] um1 = new double[5][5];
        double[][] um2 = new double[5][5];
        double[][] um3 = new double[5][5];
        double[][] um4 = new double[5][5];
        double[][] um5 = new double[5][5];
        double[][] um6 = new double[5][5];
        double[][] q_tmp = new double[5][5];
        int[] p1 = new int[2];
        int[] p3 = new int[2];
        int[] p_um1 = new int[2];
        int[] p_um2 = new int[2];
        int[] p_um3 = new int[2];
        int[] p_um4 = new int[2];
        int[] p_um5 = new int[2];
        int[] p_um6 = new int[2];
        int[] p_Q = new int[2];
        double[] f1 = new double[17];
        double[] f2 = new double[17];
        double[] f3 = new double[17];
        double[] f4 = new double[17];
        double[] f5 = new double[17];
        double[] f6 = new double[17];
        double[] f7 = new double[17];
        double[] f8 = new double[17];
        double[] f9 = new double[17];
        double[] f10 = new double[17];
        double[] f11 = new double[17];
        double[] f12 = new double[17];
        double[] f13 = new double[17];
        double[] f14 = new double[17];
        double[] f15 = new double[17];
        double[] f16 = new double[17];
        double[] f17 = new double[17];
        double[] f18 = new double[17];
        double[] f19 = new double[17];
        double[] f20 = new double[17];
        double[] f21 = new double[17];
        double[] f22 = new double[17];
        double[] f23 = new double[17];
        double[] f24 = new double[17];
        double[] f25 = new double[17];
        double[] f26 = new double[17];
        for (i = 0; i < 3; ++i) {
            double A0 = this.cos_alpha[i] * this.cos_xi[i] * this.cos_eta[i] - this.cos_theta[i];
            double A1 = -this.sin_alpha[i] * this.cos_xi[i] * this.sin_eta[i];
            double A2 = this.sin_alpha[i] * this.sin_xi[i] * this.cos_eta[i];
            double A3 = this.sin_xi[i] * this.sin_eta[i];
            double A4 = A3 * this.cos_alpha[i];
            j = i;
            double A21 = A2 * this.cos_delta[j];
            double A22 = A2 * this.sin_delta[j];
            double A31 = A3 * this.cos_delta[j];
            double A32 = A3 * this.sin_delta[j];
            double A41 = A4 * this.cos_delta[j];
            double A42 = A4 * this.sin_delta[j];
            B0[i] = A0 + A22 + A31;
            B1[i] = 2.0 * (A1 + A42);
            B2[i] = 2.0 * (A32 - A21);
            B3[i] = -4.0 * A41;
            B4[i] = A0 + A22 - A31;
            B5[i] = A0 - A22 - A31;
            B6[i] = -2.0 * (A21 + A32);
            B7[i] = 2.0 * (A1 - A42);
            B8[i] = A0 - A22 + A31;
        }
        i = 0;
        this.C0[i][0] = B0[i];
        this.C0[i][1] = B2[i];
        this.C0[i][2] = B5[i];
        this.C1[i][0] = B1[i];
        this.C1[i][1] = B3[i];
        this.C1[i][2] = B7[i];
        this.C2[i][0] = B4[i];
        this.C2[i][1] = B6[i];
        this.C2[i][2] = B8[i];
        for (i = 1; i < 3; ++i) {
            this.C0[i][0] = B0[i];
            this.C0[i][1] = B1[i];
            this.C0[i][2] = B4[i];
            this.C1[i][0] = B2[i];
            this.C1[i][1] = B3[i];
            this.C1[i][2] = B6[i];
            this.C2[i][0] = B5[i];
            this.C2[i][1] = B7[i];
            this.C2[i][2] = B8[i];
        }
        for (i = 0; i < 3; ++i) {
            u11[0][i] = this.C0[0][i];
            u12[0][i] = this.C1[0][i];
            u13[0][i] = this.C2[0][i];
            u31[i][0] = this.C0[1][i];
            u32[i][0] = this.C1[1][i];
            u33[i][0] = this.C2[1][i];
        }
        p1[0] = 2;
        p1[1] = 0;
        p3[0] = 0;
        p3[1] = 2;
        this.poly_mul_sub2(u32, u32, u31, u33, p3, p3, p3, p3, um1, p_um1);
        this.poly_mul_sub2(u12, u32, u11, u33, p1, p3, p1, p3, um2, p_um2);
        this.poly_mul_sub2(u12, u33, u13, u32, p1, p3, p1, p3, um3, p_um3);
        this.poly_mul_sub2(u11, u33, u31, u13, p1, p3, p3, p1, um4, p_um4);
        this.poly_mul_sub2(u13, um1, u33, um2, p1, p_um1, p3, p_um2, um5, p_um5);
        this.poly_mul_sub2(u13, um4, u12, um3, p1, p_um4, p1, p_um3, um6, p_um6);
        this.poly_mul_sub2(u11, um5, u31, um6, p1, p_um5, p3, p_um6, q_tmp, p_Q);
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 5; ++j) {
                this.Q[i][j] = q_tmp[i][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 17; ++j) {
                this.R[i][j] = 0.0;
            }
        }
        for (i = 0; i < 3; ++i) {
            this.R[0][i] = this.C0[2][i];
            this.R[1][i] = this.C1[2][i];
            this.R[2][i] = this.C2[2][i];
        }
        int p2 = 2;
        int p4 = 4;
        int p_f1 = this.poly_mul_sub1(this.R[1], this.R[1], this.R[0], this.R[2], p2, p2, p2, p2, f1);
        int p_f2 = this.poly_mul1(this.R[1], this.R[2], p2, p2, f2);
        int p_f3 = this.poly_mul_sub1(this.R[1], f1, this.R[0], f2, p2, p_f1, p2, p_f2, f3);
        int p_f4 = this.poly_mul1(this.R[2], f1, p2, p_f1, f4);
        int p_f5 = this.poly_mul_sub1(this.R[1], f3, this.R[0], f4, p2, p_f3, p2, p_f4, f5);
        int p_f6 = this.poly_mul_sub1(this.Q[1], this.R[1], this.Q[0], this.R[2], p4, p2, p4, p2, f6);
        int p_f7 = this.poly_mul_sub1(this.Q[2], f1, this.R[2], f6, p4, p_f1, p2, p_f6, f7);
        int p_f8 = this.poly_mul_sub1(this.Q[3], f3, this.R[2], f7, p4, p_f3, p2, p_f7, f8);
        int p_f9 = this.poly_mul_sub1(this.Q[4], f5, this.R[2], f8, p4, p_f5, p2, p_f8, f9);
        int p_f10 = this.poly_mul_sub1(this.Q[3], this.R[1], this.Q[4], this.R[0], p4, p2, p4, p2, f10);
        int p_f11 = this.poly_mul_sub1(this.Q[2], f1, this.R[0], f10, p4, p_f1, p2, p_f10, f11);
        int p_f12 = this.poly_mul_sub1(this.Q[1], f3, this.R[0], f11, p4, p_f3, p2, p_f11, f12);
        int p_f13 = this.poly_mul_sub1(this.Q[2], this.R[1], this.Q[1], this.R[2], p4, p2, p4, p2, f13);
        int p_f14 = this.poly_mul_sub1(this.Q[3], f1, this.R[2], f13, p4, p_f1, p2, p_f13, f14);
        int p_f15 = this.poly_mul_sub1(this.Q[3], this.R[1], this.Q[2], this.R[2], p4, p2, p4, p2, f15);
        int p_f16 = this.poly_mul_sub1(this.Q[4], f1, this.R[2], f15, p4, p_f1, p2, p_f15, f16);
        int p_f17 = this.poly_mul_sub1(this.Q[1], f14, this.Q[0], f16, p4, p_f14, p4, p_f16, f17);
        int p_f18 = this.poly_mul_sub1(this.Q[2], this.R[2], this.Q[3], this.R[1], p4, p2, p4, p2, f18);
        int p_f19 = this.poly_mul_sub1(this.Q[1], this.R[2], this.Q[3], this.R[0], p4, p2, p4, p2, f19);
        int p_f20 = this.poly_mul_sub1(this.Q[3], f19, this.Q[2], f18, p4, p_f19, p4, p_f18, f20);
        int p_f23 = this.poly_sub1(f20, f22, p_f20, p_f22 = this.poly_mul1(this.Q[4], f21, p4, p_f21 = this.poly_mul_sub1(this.Q[1], this.R[1], this.Q[2], this.R[0], p4, p2, p4, p2, f21), f22), f23);
        int p_f24 = this.poly_mul1(this.R[0], f23, p2, p_f23, f24);
        int p_f25 = this.poly_sub1(f17, f24, p_f17, p_f24, f25);
        int p_f26 = this.poly_mul_sub1(this.Q[4], f12, this.R[2], f25, p4, p_f12, p2, p_f25, f26);
        int p_final = this.poly_mul_sub1(this.Q[0], f9, this.R[0], f26, p4, p_f9, p2, p_f26, poly_coeff);
        if (p_final != 16) {
            throw new Error("Degree of polynomial is not 16!");
        }
        if (poly_coeff[16] < 0.0) {
            i = 0;
            while (i < 17) {
                int n = i++;
                poly_coeff[n] = poly_coeff[n] * -1.0;
            }
        }
        if (this.print_level > 0) {
            System.out.printf("poly_coeff\n", new Object[0]);
            for (i = 0; i < 17; ++i) {
                System.out.printf("%5d%15.6f\n", i, poly_coeff[i]);
            }
        }
    }

    void poly_mul_sub2(double[][] u1, double[][] u2, double[][] u3, double[][] u4, int[] p1, int[] p2, int[] p3, int[] p4, double[][] u5, int[] p5) {
        double[][] d1 = new double[5][5];
        double[][] d2 = new double[5][5];
        int[] pd1 = new int[2];
        int[] pd2 = new int[2];
        this.poly_mul2(u1, u2, p1, p2, d1, pd1);
        this.poly_mul2(u3, u4, p3, p4, d2, pd2);
        this.poly_sub2(d1, d2, pd1, pd2, u5, p5);
    }

    void poly_mul2(double[][] u1, double[][] u2, int[] p1, int[] p2, double[][] u3, int[] p3) {
        int i;
        for (i = 0; i < 2; ++i) {
            p3[i] = p1[i] + p2[i];
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                u3[i][j] = 0.0;
            }
        }
        int p11 = p1[0];
        int p12 = p1[1];
        int p21 = p2[0];
        int p22 = p2[1];
        for (int i1 = 0; i1 <= p12; ++i1) {
            for (int j1 = 0; j1 <= p11; ++j1) {
                double u1ij = u1[i1][j1];
                for (int i2 = 0; i2 <= p22; ++i2) {
                    int i3 = i1 + i2;
                    for (int j2 = 0; j2 <= p21; ++j2) {
                        int j3 = j1 + j2;
                        u3[i3][j3] = u3[i3][j3] + u1ij * u2[i2][j2];
                    }
                }
            }
        }
    }

    void poly_sub2(double[][] u1, double[][] u2, int[] p1, int[] p2, double[][] u3, int[] p3) {
        int p11 = p1[0];
        int p12 = p1[1];
        int p21 = p2[0];
        int p22 = p2[1];
        p3[0] = Math.max(p11, p21);
        p3[1] = Math.max(p12, p22);
        for (int i = 0; i <= p3[1]; ++i) {
            boolean i1_ok = i > p12;
            boolean i2_ok = i > p22;
            for (int j = 0; j <= p3[0]; ++j) {
                u3[i][j] = i2_ok || j > p21 ? u1[i][j] : (i1_ok || j > p11 ? -u2[i][j] : u1[i][j] - u2[i][j]);
            }
        }
    }

    public int poly_mul_sub1(double[] u1, double[] u2, double[] u3, double[] u4, int p1, int p2, int p3, int p4, double[] u5) {
        double[] d1 = new double[17];
        double[] d2 = new double[17];
        int pd1 = this.poly_mul1(u1, u2, p1, p2, d1);
        int pd2 = this.poly_mul1(u3, u4, p3, p4, d2);
        int p5 = this.poly_sub1(d1, d2, pd1, pd2, u5);
        return p5;
    }

    public int poly_mul1(double[] u1, double[] u2, int p1, int p2, double[] u3) {
        int p3 = p1 + p2;
        for (int i = 0; i < 17; ++i) {
            u3[i] = 0.0;
        }
        for (int i1 = 0; i1 <= p1; ++i1) {
            double u1i = u1[i1];
            for (int i2 = 0; i2 <= p2; ++i2) {
                int i3 = i1 + i2;
                u3[i3] = u3[i3] + u1i * u2[i2];
            }
        }
        return p3;
    }

    public int poly_sub1(double[] u1, double[] u2, int p1, int p2, double[] u3) {
        int p3 = Math.max(p1, p2);
        for (int i = 0; i <= p3; ++i) {
            u3[i] = i > p2 ? u1[i] : (i > p1 ? -u2[i] : u1[i] - u2[i]);
        }
        return p3;
    }

    void coord_from_poly_roots(double[] roots, double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3, double[][][] r_soln_n, double[][][] r_soln_a, double[][][] r_soln_c) {
        int j;
        int i;
        double[] ex = new double[3];
        double[] ey = new double[3];
        double[] ez = new double[3];
        double[] b_a1a2 = new double[3];
        double[] b_a3a2 = new double[3];
        double[] r_tmp = new double[3];
        double[][] p_s = new double[3][3];
        double[][] s1 = new double[3][3];
        double[][] s2 = new double[3][3];
        double[][] p_t = new double[3][3];
        double[][] t1 = new double[3][3];
        double[][] t2 = new double[3][3];
        double[][] p_s_c = new double[3][3];
        double[][] s1_s = new double[3][3];
        double[][] s2_s = new double[3][3];
        double[][] p_t_c = new double[3][3];
        double[][] t1_s = new double[3][3];
        double[][] t2_s = new double[3][3];
        double[] half_tan = new double[3];
        double[] cos_tau = new double[4];
        double[] sin_tau = new double[4];
        double[] cos_sig = new double[3];
        double[] sin_sig = new double[3];
        double[] r_s = new double[3];
        double[] r_t = new double[3];
        double[] r0 = new double[3];
        double[][] r_n = new double[3][3];
        double[][] r_a = new double[3][3];
        double[][] r_c = new double[3][3];
        double[] p = new double[4];
        double[] rr_a1c1 = new double[3];
        double[] rr_c1n2 = new double[3];
        double[] rr_n2a2 = new double[3];
        double[] rr_a2c2 = new double[3];
        double[] rr_c2n3 = new double[3];
        double[] rr_n3a3 = new double[3];
        double[] rr_a1a2 = new double[3];
        double[] rr_a2a3 = new double[3];
        double[] ex_tmp = new double[3];
        double[] tmp_array = new double[3];
        double[] tmp_array1 = new double[3];
        double[] tmp_array2 = new double[3];
        double[] tmp_array3 = new double[3];
        double[] mat1 = new double[3];
        double[] mat2 = new double[3];
        double[] mat3 = new double[3];
        double[] mat4 = new double[3];
        double[] mat5 = new double[3];
        double[] mat11 = new double[3];
        double[] mat22 = new double[3];
        double[] mat33 = new double[3];
        double[] mat44 = new double[3];
        double[] mat55 = new double[3];
        if (this.n_soln == 0) {
            return;
        }
        for (i = 0; i < 3; ++i) {
            ex[i] = this.b_a1a3[i];
        }
        ez = VectorAlgebra.cross(this.r_a1n1, ex);
        double tmp_value = Math.sqrt(VectorAlgebra.dot(ez, ez));
        for (i = 0; i < 3; ++i) {
            ez[i] = ez[i] / tmp_value;
        }
        ey = VectorAlgebra.cross(ez, ex);
        for (i = 0; i < 3; ++i) {
            b_a1a2[i] = -this.cos_alpha[0] * ex[i] + this.sin_alpha[0] * ey[i];
            b_a3a2[i] = this.cos_alpha[2] * ex[i] + this.sin_alpha[2] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[0][i] = -ex[i];
            s1[0][i] = ez[i];
            s2[0][i] = ey[i];
            p_t[0][i] = b_a1a2[i];
            t1[0][i] = ez[i];
            t2[0][i] = this.sin_alpha[0] * ex[i] + this.cos_alpha[0] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[1][i] = -b_a1a2[i];
            s1[1][i] = -ez[i];
            s2[1][i] = t2[0][i];
            p_t[1][i] = -b_a3a2[i];
            t1[1][i] = -ez[i];
            t2[1][i] = this.sin_alpha[2] * ex[i] - this.cos_alpha[2] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[2][i] = b_a3a2[i];
            s2[2][i] = t2[1][i];
            s1[2][i] = ez[i];
            p_t[2][i] = ex[i];
            t1[2][i] = ez[i];
            t2[2][i] = -ey[i];
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                p_s_c[i][j] = p_s[i][j] * this.cos_xi[i];
                s1_s[i][j] = s1[i][j] * this.sin_xi[i];
                s2_s[i][j] = s2[i][j] * this.sin_xi[i];
                p_t_c[i][j] = p_t[i][j] * this.cos_eta[i];
                t1_s[i][j] = t1[i][j] * this.sin_eta[i];
                t2_s[i][j] = t2[i][j] * this.sin_eta[i];
            }
        }
        for (i = 0; i < 3; ++i) {
            r_tmp[i] = (this.r_a1n1[i] / this.len_na[0] - p_s_c[0][i]) / this.sin_xi[0];
        }
        double angle = Protractor.getAngleRadians(s1[0], r_tmp);
        double sig1_init = Math.copySign(angle, VectorAlgebra.dot(r_tmp, s2[0]));
        for (i = 0; i < 3; ++i) {
            r_a[0][i] = r_a1[i];
            r_a[1][i] = r_a1[i] + this.len_aa[1] * b_a1a2[i];
            r_a[2][i] = r_a3[i];
            r0[i] = r_a1[i];
        }
        for (int i_soln = 0; i_soln < this.n_soln; ++i_soln) {
            half_tan[2] = roots[i_soln];
            half_tan[1] = this.calc_t2(half_tan[2]);
            half_tan[0] = this.calc_t1(half_tan[2], half_tan[1]);
            for (i = 1; i <= 3; ++i) {
                double ht = half_tan[i - 1];
                double tmp = 1.0 + ht * ht;
                cos_tau[i] = (1.0 - ht * ht) / tmp;
                sin_tau[i] = 2.0 * ht / tmp;
            }
            cos_tau[0] = cos_tau[3];
            sin_tau[0] = sin_tau[3];
            for (i = 0; i < 3; ++i) {
                cos_sig[i] = this.cos_delta[i] * cos_tau[i] + this.sin_delta[i] * sin_tau[i];
                sin_sig[i] = this.sin_delta[i] * cos_tau[i] - this.cos_delta[i] * sin_tau[i];
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    r_s[j] = p_s_c[i][j] + cos_sig[i] * s1_s[i][j] + sin_sig[i] * s2_s[i][j];
                    r_t[j] = p_t_c[i][j] + cos_tau[i + 1] * t1_s[i][j] + sin_tau[i + 1] * t2_s[i][j];
                    r_n[i][j] = r_s[j] * this.len_na[i] + r_a[i][j];
                    r_c[i][j] = r_t[j] * this.len_ac[i] + r_a[i][j];
                }
            }
            double sig1 = Math.atan2(sin_sig[0], cos_sig[0]);
            ex_tmp[0] = -ex[0];
            ex_tmp[1] = -ex[1];
            ex_tmp[2] = -ex[2];
            tmp_value = -(sig1 - sig1_init);
            RotationMatrix Us = new RotationMatrix(-ex[0], -ex[1], -ex[2], tmp_value, true);
            for (i = 0; i < 3; ++i) {
                mat11[i] = r_c[0][i] - r0[i];
                mat22[i] = r_n[1][i] - r0[i];
                mat33[i] = r_a[1][i] - r0[i];
                mat44[i] = r_c[1][i] - r0[i];
                mat55[i] = r_n[2][i] - r0[i];
            }
            mat1 = Us.rotateVector(mat11);
            mat2 = Us.rotateVector(mat22);
            mat3 = Us.rotateVector(mat33);
            mat4 = Us.rotateVector(mat44);
            mat5 = Us.rotateVector(mat55);
            for (i = 0; i < 3; ++i) {
                r_soln_n[i_soln][0][i] = r_n1[i];
                r_soln_a[i_soln][0][i] = r_a1[i];
                r_soln_c[i_soln][0][i] = mat1[i] + r0[i];
                r_soln_n[i_soln][1][i] = mat2[i] + r0[i];
                r_soln_a[i_soln][1][i] = mat3[i] + r0[i];
                r_soln_c[i_soln][1][i] = mat4[i] + r0[i];
                r_soln_n[i_soln][2][i] = mat5[i] + r0[i];
                r_soln_a[i_soln][2][i] = r_a3[i];
                r_soln_c[i_soln][2][i] = r_c3[i];
            }
            if (this.print_level <= 0) continue;
            System.out.printf("roots: t0, t2, t1 %d\n", i_soln);
            System.out.printf("%15.6f %15.6f %15.6f\n", half_tan[2], half_tan[1], half_tan[0]);
            for (i = 0; i < 3; ++i) {
                rr_a1c1[i] = r_soln_c[i_soln][0][i] - r_soln_a[i_soln][0][i];
                rr_c1n2[i] = r_soln_n[i_soln][1][i] - r_soln_c[i_soln][0][i];
                rr_n2a2[i] = r_soln_a[i_soln][1][i] - r_soln_n[i_soln][1][i];
                rr_a2c2[i] = r_soln_c[i_soln][1][i] - r_soln_a[i_soln][1][i];
                rr_c2n3[i] = r_soln_n[i_soln][2][i] - r_soln_c[i_soln][1][i];
                rr_n3a3[i] = r_soln_a[i_soln][2][i] - r_soln_n[i_soln][2][i];
                rr_a1a2[i] = r_soln_a[i_soln][1][i] - r_soln_a[i_soln][0][i];
                rr_a2a3[i] = r_soln_a[i_soln][2][i] - r_soln_a[i_soln][1][i];
            }
            double a1c1 = Math.sqrt(VectorAlgebra.dot(rr_a1c1, rr_a1c1));
            double c1n2 = Math.sqrt(VectorAlgebra.dot(rr_c1n2, rr_c1n2));
            double n2a2 = Math.sqrt(VectorAlgebra.dot(rr_n2a2, rr_n2a2));
            double a2c2 = Math.sqrt(VectorAlgebra.dot(rr_a2c2, rr_a2c2));
            double c2n3 = Math.sqrt(VectorAlgebra.dot(rr_c2n3, rr_c2n3));
            double n3a3 = Math.sqrt(VectorAlgebra.dot(rr_n3a3, rr_n3a3));
            double a1a2 = Math.sqrt(VectorAlgebra.dot(rr_a1a2, rr_a1a2));
            double a2a3 = Math.sqrt(VectorAlgebra.dot(rr_a2a3, rr_a2a3));
            System.out.printf("na: n2a2, n3a3 = %9.3f%9.3f%9.3f%9.3f\n", this.len0[2], n2a2, this.len0[5], n3a3);
            System.out.printf("ac: a1c1, a2c2 = %9.3f%9.3f%9.3f%9.3f\n", this.len0[0], a1c1, this.len0[3], a2c2);
            System.out.printf("cn: c1n2, c2n3 = %9.3f%9.3f%9.3f%9.3f\n", this.len0[1], c1n2, this.len0[4], c2n3);
            System.out.printf("aa: a1a2, a2a3 = %9.3f%9.3f%9.3f%9.3f\n", this.len_aa[1], a1a2, this.len_aa[2], a2a3);
            for (i = 0; i < 3; ++i) {
                tmp_array[i] = rr_a1a2[i] / a1a2;
            }
            double a3a1a2 = Protractor.getAngleRadians(this.b_a1a3, tmp_array);
            for (i = 0; i < 3; ++i) {
                tmp_array[i] = rr_a2a3[i] / a2a3;
            }
            double a2a3a1 = Protractor.getAngleRadians(tmp_array, this.b_a1a3);
            System.out.printf("alpha1, alpha3 = %9.3f%9.3f\n", (this.pi - a3a1a2) * this.rad2deg, (this.pi - a2a3a1) * this.rad2deg);
            for (i = 0; i < 3; ++i) {
                tmp_array[i] = rr_a1c1[i] / a1c1;
            }
            double n1a1c1 = Protractor.getAngleRadians(this.b_a1n1, tmp_array);
            for (i = 0; i < 3; ++i) {
                tmp_array[i] = -rr_n3a3[i] / n3a3;
            }
            double n3a3c3 = Protractor.getAngleRadians(this.b_a3c3, tmp_array);
            for (i = 0; i < 3; ++i) {
                tmp_array1[i] = rr_a2c2[i] / a2c2;
                tmp_array2[i] = -rr_n2a2[i] / n2a2;
            }
            double n2a2c2 = Protractor.getAngleRadians(tmp_array1, tmp_array2);
            System.out.printf("ang_nac = %9.3f%9.3f\n", this.b_ang0[0] * this.rad2deg, n1a1c1 * this.rad2deg);
            System.out.printf("ang_nac = %9.3f%9.3f\n", this.b_ang0[3] * this.rad2deg, n2a2c2 * this.rad2deg);
            System.out.printf("ang_nac = %9.3f%9.3f\n", this.b_ang0[6] * this.rad2deg, n3a3c3 * this.rad2deg);
            for (i = 0; i < 3; ++i) {
                tmp_array1[i] = rr_a1c1[i] / a1c1;
                tmp_array2[i] = rr_c1n2[i] / c1n2;
                tmp_array3[i] = rr_n2a2[i] / n2a2;
            }
            double a1c1n2a2 = this.calc_dih_ang(tmp_array1, tmp_array2, tmp_array3);
            for (i = 0; i < 3; ++i) {
                tmp_array1[i] = rr_a2c2[i] / a2c2;
                tmp_array2[i] = rr_c2n3[i] / c2n3;
                tmp_array3[i] = rr_n3a3[i] / n3a3;
            }
            double a2c2n3a3 = this.calc_dih_ang(tmp_array1, tmp_array2, tmp_array3);
            System.out.printf("t_ang1 = %9.3f%9.3f\n", this.t_ang0[0] * this.rad2deg, a1c1n2a2 * this.rad2deg);
            System.out.printf("t_ang2 = %9.3f%9.3f\n", this.t_ang0[1] * this.rad2deg, a2c2n3a3 * this.rad2deg);
        }
    }

    double calc_t2(double t0) {
        double t0_2 = t0 * t0;
        double t0_3 = t0_2 * t0;
        double t0_4 = t0_3 * t0;
        double A0 = this.Q[0][0] + this.Q[0][1] * t0 + this.Q[0][2] * t0_2 + this.Q[0][3] * t0_3 + this.Q[0][4] * t0_4;
        double A1 = this.Q[1][0] + this.Q[1][1] * t0 + this.Q[1][2] * t0_2 + this.Q[1][3] * t0_3 + this.Q[1][4] * t0_4;
        double A2 = this.Q[2][0] + this.Q[2][1] * t0 + this.Q[2][2] * t0_2 + this.Q[2][3] * t0_3 + this.Q[2][4] * t0_4;
        double A3 = this.Q[3][0] + this.Q[3][1] * t0 + this.Q[3][2] * t0_2 + this.Q[3][3] * t0_3 + this.Q[3][4] * t0_4;
        double A4 = this.Q[4][0] + this.Q[4][1] * t0 + this.Q[4][2] * t0_2 + this.Q[4][3] * t0_3 + this.Q[4][4] * t0_4;
        double B0 = this.R[0][0] + this.R[0][1] * t0 + this.R[0][2] * t0_2;
        double B1 = this.R[1][0] + this.R[1][1] * t0 + this.R[1][2] * t0_2;
        double B2 = this.R[2][0] + this.R[2][1] * t0 + this.R[2][2] * t0_2;
        double B2_2 = B2 * B2;
        double B2_3 = B2_2 * B2;
        double K0 = A2 * B2 - A4 * B0;
        double K1 = A3 * B2 - A4 * B1;
        double K2 = A1 * B2_2 - K1 * B0;
        double K3 = K0 * B2 - K1 * B1;
        double tmp_value = (K3 * B0 - A0 * B2_3) / (K2 * B2 - K3 * B1);
        return tmp_value;
    }

    double calc_t1(double t0, double t2) {
        double t0_2 = t0 * t0;
        double t2_2 = t2 * t2;
        double U11 = this.C0[0][0] + this.C0[0][1] * t0 + this.C0[0][2] * t0_2;
        double U12 = this.C1[0][0] + this.C1[0][1] * t0 + this.C1[0][2] * t0_2;
        double U13 = this.C2[0][0] + this.C2[0][1] * t0 + this.C2[0][2] * t0_2;
        double U31 = this.C0[1][0] + this.C0[1][1] * t2 + this.C0[1][2] * t2_2;
        double U32 = this.C1[1][0] + this.C1[1][1] * t2 + this.C1[1][2] * t2_2;
        double U33 = this.C2[1][0] + this.C2[1][1] * t2 + this.C2[1][2] * t2_2;
        double tmp_value = (U31 * U13 - U11 * U33) / (U12 * U33 - U13 * U32);
        return tmp_value;
    }

    public double calc_dih_ang(double[] r1, double[] r2, double[] r3) {
        double[] p = new double[3];
        double[] q = new double[3];
        double[] s = new double[3];
        p = VectorAlgebra.cross(r1, r2);
        q = VectorAlgebra.cross(r2, r3);
        s = VectorAlgebra.cross(r3, r1);
        double arg = VectorAlgebra.dot(p, q) / Math.sqrt(VectorAlgebra.dot(p, p) * VectorAlgebra.dot(q, q));
        arg = Math.copySign(Math.min(Math.abs(arg), 1.0), arg);
        return Math.copySign(Math.acos(arg), VectorAlgebra.dot(s, r2));
    }
}

