/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof.deeper.perts;

import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.dof.deeper.ResBBState;
import edu.duke.cs.osprey.dof.deeper.perts.Perturbation;
import edu.duke.cs.osprey.dof.deeper.perts.PerturbationBlock;
import edu.duke.cs.osprey.restypes.HardCodedResidueInfo;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import java.util.ArrayList;

public class PartialStructureSwitch
extends Perturbation {
    ArrayList<ArrayList<ResBBState>> altResConfs = new ArrayList();

    public PartialStructureSwitch(ArrayList<Residue> resDirectlyAffected, ArrayList<String> altConfPDBFiles) {
        super(resDirectlyAffected);
        this.altResConfs.add(null);
        for (String altPDB : altConfPDBFiles) {
            Molecule altMolec = new Strand.Builder((Molecule)PDBIO.readFile((String)altPDB)).build().mol;
            ArrayList<ResBBState> altConf = new ArrayList<ResBBState>();
            for (Residue origRes : resDirectlyAffected) {
                Residue altRes = altMolec.getResByPDBResNumber(origRes.getPDBResNumber());
                altConf.add(new ResBBState(altRes));
            }
            this.altResConfs.add(altConf);
        }
    }

    public PartialStructureSwitch(ArrayList<Residue> resDirectlyAffected, double curParamVal, int indexInBlock, PerturbationBlock block, ArrayList<ArrayList<ResBBState>> oldAltResConfs) {
        super(resDirectlyAffected);
        this.curParamVal = curParamVal;
        this.indexInBlock = indexInBlock;
        this.block = block;
        for (ArrayList<ResBBState> arcOld : oldAltResConfs) {
            ArrayList<ResBBState> arc = new ArrayList<ResBBState>();
            if (arcOld == null) {
                arc = null;
            } else {
                for (ResBBState rbs : arcOld) {
                    arc.add(new ResBBState(rbs));
                }
            }
            this.altResConfs.add(arc);
        }
    }

    @Override
    public boolean doPerturbationMotion(double paramVal) {
        int structNum = (int)paramVal;
        if (structNum > 0) {
            for (int resNum = 0; resNum < this.resDirectlyAffected.size(); ++resNum) {
                Residue res = (Residue)this.resDirectlyAffected.get(resNum);
                ResBBState altConf = this.altResConfs.get(structNum).get(resNum);
                altConf.putInState(res);
            }
        }
        return true;
    }

    private static boolean isBBAtom(Residue res, String atomName) {
        if (res.template.name.equalsIgnoreCase("PRO") && atomName.equalsIgnoreCase("CD")) {
            return true;
        }
        for (String BBName : HardCodedResidueInfo.possibleBBAtoms) {
            if (!atomName.equalsIgnoreCase(BBName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Perturbation copyForNewMolecule(Molecule mol, PerturbationBlock block) {
        return new PartialStructureSwitch(Residue.equivalentInMolec(this.resDirectlyAffected, mol), this.curParamVal, this.indexInBlock, block, this.altResConfs);
    }
}

