/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.DihedralRotation;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.Protractor;

public class FreeDihedral
extends DegreeOfFreedom {
    private static final long serialVersionUID = 8005789766951509654L;
    Residue res;
    int dihedralNum;
    double curVal;
    double[][] dihedralCoords = new double[4][3];

    public FreeDihedral(Residue res, int dihedralNum) {
        this.res = res;
        this.dihedralNum = dihedralNum;
        this.curVal = this.isValid() ? this.measureDihedralDegrees() : Double.NaN;
    }

    public boolean isValid() {
        return this.res.template.numDihedrals > 0 && this.dihedralNum >= 0 && this.dihedralNum < this.res.template.numDihedrals;
    }

    public void checkValid() {
        if (this.res.template.numDihedrals <= 0) {
            throw new IllegalArgumentException(String.format("residue " + this.res.fullName + " doesn't have any dihedral angles", new Object[0]));
        }
        if (this.dihedralNum < 0 || this.dihedralNum >= this.res.template.numDihedrals) {
            throw new IllegalArgumentException(String.format("invalid dihedral number %d, expected in [0,%d]", this.dihedralNum, this.res.template.numDihedrals - 1));
        }
    }

    @Override
    public double getCurVal() {
        return this.curVal;
    }

    public double[][] updateDihedralCoords() {
        this.checkValid();
        int[] dihAtomIndices = this.res.template.getDihedralDefiningAtoms(this.dihedralNum);
        for (int a = 0; a < 4; ++a) {
            System.arraycopy(this.res.coords, 3 * dihAtomIndices[a], this.dihedralCoords[a], 0, 3);
        }
        return this.dihedralCoords;
    }

    public double measureDihedralDegrees() {
        this.updateDihedralCoords();
        return Protractor.measureDihedral(this.dihedralCoords);
    }

    @Override
    public void apply(double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double sin = Math.sin(angleRadians);
        double cos = Math.cos(angleRadians);
        this.updateDihedralCoords();
        double[] measuredSinCos = Protractor.measureDihedralSinCos(this.dihedralCoords);
        double dsin = sin * measuredSinCos[1] - cos * measuredSinCos[0];
        double dcos = cos * measuredSinCos[1] + sin * measuredSinCos[0];
        DihedralRotation dihRotation = new DihedralRotation(this.dihedralCoords[1], this.dihedralCoords[2], dsin, dcos);
        for (int index : this.res.template.getDihedralRotatedAtoms(this.dihedralNum)) {
            dihRotation.transform(this.res.coords, index);
        }
        this.curVal = angleDegrees;
    }

    @Override
    public Residue getResidue() {
        return this.res;
    }

    public int getDihedralNumber() {
        return this.dihedralNum;
    }

    @Override
    public DegreeOfFreedom copy() {
        return new FreeDihedral(this.res, this.dihedralNum);
    }

    @Override
    public void setMolecule(Molecule val) {
        this.res = val.getResByPDBResNumber(this.res.getPDBResNumber());
    }

    @Override
    public DOFBlock getBlock() {
        return null;
    }

    @Override
    public String getName() {
        return "DIH" + this.res.getPDBResNumber() + "." + this.dihedralNum;
    }
}

