/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.dof;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import edu.duke.cs.osprey.dof.DOFBlock;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.tools.EllipseTransform;
import java.util.ArrayList;

public class EllipseCoordDOF
extends DegreeOfFreedom {
    boolean isRadius;
    int index;
    double curVal;
    ArrayList<DegreeOfFreedom> dihedrals;
    DoubleMatrix2D A;
    DoubleMatrix1D c;
    double[] initVals;
    boolean initSet = false;
    EllipseTransform et;

    public EllipseCoordDOF(boolean r, int a, double val, DoubleMatrix2D mat, ArrayList<DegreeOfFreedom> arrayList, double[] inits) {
        this.isRadius = r;
        this.index = a;
        this.curVal = val;
        this.A = mat;
        this.dihedrals = arrayList;
        this.initVals = inits;
    }

    @Override
    public void apply(double paramVal) {
        int i;
        if (!this.initSet) {
            for (int i2 = 0; i2 < this.initVals.length; ++i2) {
                this.dihedrals.get(i2).apply(this.initVals[i2]);
            }
            double[] vals = new double[this.dihedrals.size()];
            for (int i3 = 0; i3 < this.dihedrals.size(); ++i3) {
                vals[i3] = this.dihedrals.get(i3).getCurVal();
            }
            this.c = DoubleFactory1D.dense.make(vals);
            this.initSet = true;
        }
        int dim = this.dihedrals.size();
        double[] o = new double[dim];
        for (int i4 = 0; i4 < dim; ++i4) {
            o[i4] = this.dihedrals.get(i4).getCurVal();
        }
        this.et = new EllipseTransform(this.A, this.c);
        double[] phi = this.et.getEllipsoidalCoords(o);
        phi[this.index] = paramVal;
        double[] u = this.et.getCartesianCoords(phi);
        for (i = 0; i < u.length; ++i) {
            if (!Double.isNaN(u[i])) continue;
            u[i] = 0.0;
        }
        for (i = 0; i < this.dihedrals.size(); ++i) {
            this.dihedrals.get(i).apply(u[i]);
        }
        this.curVal = paramVal;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public double getCurVal() {
        return this.curVal;
    }

    @Override
    public DOFBlock getBlock() {
        return null;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

